/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.ValueOuterClass;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.Value;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DamlEnum
extends Value {
    private final Optional<Identifier> enumId;
    private final String constructor;

    public DamlEnum(@NonNull Identifier enumId, @NonNull String constructor) {
        this.enumId = Optional.of(enumId);
        this.constructor = constructor;
    }

    public DamlEnum(@NonNull String constructor) {
        this.enumId = Optional.empty();
        this.constructor = constructor;
    }

    public static DamlEnum fromProto(ValueOuterClass.Enum value) {
        String constructor = value.getConstructor();
        if (value.hasEnumId()) {
            Identifier variantId = Identifier.fromProto(value.getEnumId());
            return new DamlEnum(variantId, constructor);
        }
        return new DamlEnum(constructor);
    }

    public @NonNull Optional<Identifier> getEnumId() {
        return this.enumId;
    }

    public @NonNull String getConstructor() {
        return this.constructor;
    }

    @Override
    public ValueOuterClass.Value toProto() {
        return ValueOuterClass.Value.newBuilder().setEnum(this.toProtoEnum()).build();
    }

    public ValueOuterClass.Enum toProtoEnum() {
        ValueOuterClass.Enum.Builder builder = ValueOuterClass.Enum.newBuilder();
        builder.setConstructor(this.getConstructor());
        this.getEnumId().ifPresent(identifier -> builder.setEnumId(identifier.toProto()));
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DamlEnum value = (DamlEnum)o;
        return Objects.equals(this.enumId, value.enumId) && Objects.equals(this.constructor, value.constructor);
    }

    public int hashCode() {
        return Objects.hash(this.enumId, this.constructor);
    }

    public String toString() {
        return "Enum{variantId=" + this.enumId + ", constructor='" + this.constructor + "'}";
    }
}

