/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.ValueOuterClass;
import com.daml.ledger.javaapi.data.DamlCollectors;
import com.daml.ledger.javaapi.data.Value;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DamlTextMap
extends Value {
    private final Map<String, Value> map;
    private static @NonNull DamlTextMap EMPTY = DamlTextMap.fromPrivateMap(Collections.emptyMap());

    DamlTextMap(Map<String, Value> textMap) {
        this.map = textMap;
    }

    static @NonNull DamlTextMap fromPrivateMap(Map<@NonNull String, @NonNull Value> value) {
        return new DamlTextMap(Collections.unmodifiableMap(value));
    }

    public static DamlTextMap of(@NonNull Map<@NonNull String, @NonNull Value> value) {
        return DamlTextMap.fromPrivateMap(new HashMap<String, Value>(value));
    }

    public Stream<Map.Entry<String, Value>> stream() {
        return this.map.entrySet().stream();
    }

    public final <K, V> @NonNull Map<K, V> toMap(@NonNull Function<@NonNull String, @NonNull K> keyMapper, @NonNull Function<@NonNull Value, @NonNull V> valueMapper) {
        return this.stream().collect(Collectors.toMap(e -> keyMapper.apply((String)e.getKey()), e -> valueMapper.apply((Value)e.getValue())));
    }

    public final <V> @NonNull Map<@NonNull String, @NonNull V> toMap(@NonNull Function<@NonNull Value, @NonNull V> valueMapper) {
        return this.toMap(Function.identity(), valueMapper);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DamlTextMap other = (DamlTextMap)o;
        return Objects.equals(this.map, other.map);
    }

    public final int hashCode() {
        return this.map.hashCode();
    }

    public final @NonNull String toString() {
        StringJoiner sj = new StringJoiner(", ", "TextMap{", "}");
        this.map.forEach((key, value) -> sj.add(key + "->" + value.toString()));
        return sj.toString();
    }

    @Override
    public final ValueOuterClass.Value toProto() {
        ValueOuterClass.TextMap.Builder mb = ValueOuterClass.TextMap.newBuilder();
        this.map.forEach((k, v) -> mb.addEntries(ValueOuterClass.TextMap.Entry.newBuilder().setKey((String)k).setValue(v.toProto())));
        return ValueOuterClass.Value.newBuilder().setTextMap(mb).build();
    }

    public static @NonNull DamlTextMap fromProto(ValueOuterClass.TextMap textMap) {
        return textMap.getEntriesList().stream().collect(DamlCollectors.toDamlTextMap(ValueOuterClass.TextMap.Entry::getKey, entry -> DamlTextMap.fromProto(entry.getValue())));
    }
}

