/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.CommandsOuterClass;
import com.daml.ledger.javaapi.data.Identifier;
import com.google.protobuf.ByteString;
import java.util.Objects;
import java.util.Optional;

public final class DisclosedContract {
    public final Optional<Identifier> templateId;
    public final Optional<String> contractId;
    public final ByteString createdEventBlob;
    public final Optional<String> synchronizerId;

    @Deprecated
    public DisclosedContract(Identifier templateId, String contractId, ByteString createdEventBlob) {
        this.templateId = Optional.of(templateId);
        this.contractId = Optional.of(contractId);
        this.createdEventBlob = createdEventBlob;
        this.synchronizerId = Optional.empty();
    }

    @Deprecated
    public DisclosedContract(Identifier templateId, String contractId, ByteString createdEventBlob, String synchronizerId) {
        this.templateId = Optional.of(templateId);
        this.contractId = Optional.of(contractId);
        this.createdEventBlob = createdEventBlob;
        this.synchronizerId = Optional.of(synchronizerId);
    }

    public DisclosedContract(ByteString createdEventBlob, String synchronizerId, Optional<Identifier> templateId, Optional<String> contractId) {
        this.templateId = templateId;
        this.contractId = contractId;
        this.createdEventBlob = createdEventBlob;
        this.synchronizerId = Optional.of(synchronizerId);
    }

    public CommandsOuterClass.DisclosedContract toProto() {
        CommandsOuterClass.DisclosedContract.Builder builder = CommandsOuterClass.DisclosedContract.newBuilder().setCreatedEventBlob(this.createdEventBlob);
        this.contractId.ifPresent(builder::setContractId);
        this.templateId.ifPresent(id -> builder.setTemplateId(id.toProto()));
        this.synchronizerId.ifPresent(builder::setSynchronizerId);
        return builder.build();
    }

    public static DisclosedContract fromProto(CommandsOuterClass.DisclosedContract disclosedContract) {
        Identifier templateId = Identifier.fromProto(disclosedContract.getTemplateId());
        String contractId = disclosedContract.getContractId();
        ByteString createdEventBlob = disclosedContract.getCreatedEventBlob();
        return Optional.of(disclosedContract.getSynchronizerId()).filter(synchronizerIdO -> !synchronizerIdO.isEmpty()).map(synchronizerId -> new DisclosedContract(templateId, contractId, createdEventBlob, (String)synchronizerId)).orElseGet(() -> new DisclosedContract(templateId, contractId, createdEventBlob));
    }

    public String toString() {
        return "DisclosedContract{templateId=" + this.templateId + ", contractId='" + this.contractId + "', createdEventBlob='" + this.createdEventBlob + "', synchronizerId=" + this.synchronizerId + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisclosedContract that = (DisclosedContract)o;
        return Objects.equals(this.templateId, that.templateId) && Objects.equals(this.contractId, that.contractId) && Objects.equals(this.createdEventBlob, that.createdEventBlob) && Objects.equals(this.synchronizerId, that.synchronizerId);
    }

    public int hashCode() {
        return Objects.hash(this.templateId, this.contractId, this.createdEventBlob, this.synchronizerId);
    }
}

