/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.TransactionFilterOuterClass;
import com.daml.ledger.javaapi.data.CumulativeFilter;
import com.daml.ledger.javaapi.data.Filter;
import com.daml.ledger.javaapi.data.NoFilter;
import com.daml.ledger.javaapi.data.codegen.ContractCompanion;
import com.daml.ledger.javaapi.data.codegen.ContractTypeCompanion;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class EventFormat {
    private final Map<String, Filter> partyToFilters;
    private final Optional<Filter> anyPartyFilterO;
    private final boolean verbose;

    public static EventFormat fromProto(TransactionFilterOuterClass.EventFormat eventFormat) {
        Map<String, TransactionFilterOuterClass.Filters> partyToFilters = eventFormat.getFiltersByPartyMap();
        HashMap<String, Filter> converted = new HashMap<String, Filter>(partyToFilters.size());
        for (Map.Entry<String, TransactionFilterOuterClass.Filters> entry : partyToFilters.entrySet()) {
            converted.put(entry.getKey(), Filter.fromProto(entry.getValue()));
        }
        TransactionFilterOuterClass.Filters anyPartyFilters = eventFormat.getFiltersForAnyParty();
        Filter convertedAnyPartyFilter = Filter.fromProto(anyPartyFilters);
        Optional<Filter> anyPartyFilterO = convertedAnyPartyFilter instanceof NoFilter ? Optional.empty() : Optional.of(convertedAnyPartyFilter);
        return new EventFormat(converted, anyPartyFilterO, eventFormat.getVerbose());
    }

    public TransactionFilterOuterClass.EventFormat toProto() {
        HashMap<String, TransactionFilterOuterClass.Filters> partyToFilters = new HashMap<String, TransactionFilterOuterClass.Filters>(this.partyToFilters.size());
        for (Map.Entry<String, Filter> entry : this.partyToFilters.entrySet()) {
            partyToFilters.put(entry.getKey(), entry.getValue().toProto());
        }
        TransactionFilterOuterClass.EventFormat.Builder builder = TransactionFilterOuterClass.EventFormat.newBuilder().putAllFiltersByParty(partyToFilters);
        this.anyPartyFilterO.ifPresent(value -> builder.setFiltersForAnyParty(value.toProto()));
        builder.setVerbose(this.verbose);
        return builder.build();
    }

    public Set<String> getParties() {
        return this.partyToFilters.keySet();
    }

    public Map<String, Filter> getPartyToFilters() {
        return this.partyToFilters;
    }

    public Optional<Filter> getAnyPartyFilter() {
        return this.anyPartyFilterO;
    }

    public EventFormat(@NonNull Map<@NonNull String, @NonNull Filter> partyToFilters, @NonNull Optional<@NonNull Filter> anyPartyFilterO, boolean verbose) {
        this.partyToFilters = partyToFilters;
        this.anyPartyFilterO = anyPartyFilterO;
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public static EventFormat eventFormat(ContractTypeCompanion<?, ?, ?, ?> contractCompanion, Optional<Set<String>> partiesO, boolean verbose) {
        CumulativeFilter filter = contractCompanion instanceof ContractCompanion ? new CumulativeFilter(Collections.emptyMap(), Collections.singletonMap(contractCompanion.TEMPLATE_ID, Filter.Template.HIDE_CREATED_EVENT_BLOB), Optional.empty()) : new CumulativeFilter(Map.of(contractCompanion.TEMPLATE_ID, Filter.Interface.INCLUDE_VIEW_HIDE_CREATED_EVENT_BLOB), Collections.emptyMap(), Optional.empty());
        Map<String, Filter> partyToFilters = partiesO.map(parties -> parties.stream().collect(Collectors.toMap(Function.identity(), x -> filter))).orElse(Map.of());
        Optional<Filter> anyPartyFilterO = partiesO.isEmpty() ? Optional.of(filter) : Optional.empty();
        return new EventFormat(partyToFilters, anyPartyFilterO, verbose);
    }

    public String toString() {
        return "EventFormat{partyToFilters=" + this.partyToFilters + ", anyPartyFilterO=" + this.anyPartyFilterO + ", verbose=" + this.verbose + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventFormat that = (EventFormat)o;
        return this.verbose == that.verbose && Objects.equals(this.partyToFilters, that.partyToFilters) && Objects.equals(this.anyPartyFilterO, that.anyPartyFilterO);
    }

    public int hashCode() {
        return Objects.hash(this.partyToFilters, this.anyPartyFilterO, this.verbose);
    }
}

