/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.EventOuterClass;
import com.daml.ledger.javaapi.data.Event;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.Value;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ExercisedEvent
implements Event {
    private final List<String> witnessParties;
    private final Long offset;
    private final Integer nodeId;
    private final Identifier templateId;
    private final String packageName;
    private final Optional<Identifier> interfaceId;
    private final String contractId;
    private final String choice;
    private final Value choiceArgument;
    private final List<String> actingParties;
    private final boolean consuming;
    private final Integer lastDescendantNodeId;
    private final Value exerciseResult;
    private final List<Identifier> implementedInterfaces;
    private final @NonNull Boolean acsDelta;

    public ExercisedEvent(@NonNull List<@NonNull String> witnessParties, @NonNull Long offset, @NonNull Integer nodeId, @NonNull Identifier templateId, @NonNull String packageName, @NonNull Optional<Identifier> interfaceId, @NonNull String contractId, @NonNull String choice, @NonNull Value choiceArgument, @NonNull List<@NonNull String> actingParties, boolean consuming, @NonNull Integer lastDescendantNodeId, @NonNull Value exerciseResult, @NonNull List<@NonNull Identifier> implementedInterfaces, @NonNull Boolean acsDelta) {
        this.witnessParties = witnessParties;
        this.offset = offset;
        this.nodeId = nodeId;
        this.templateId = templateId;
        this.packageName = packageName;
        this.interfaceId = interfaceId;
        this.contractId = contractId;
        this.choice = choice;
        this.choiceArgument = choiceArgument;
        this.actingParties = actingParties;
        this.consuming = consuming;
        this.lastDescendantNodeId = lastDescendantNodeId;
        this.exerciseResult = exerciseResult;
        this.implementedInterfaces = implementedInterfaces;
        this.acsDelta = acsDelta;
    }

    @Override
    public @NonNull List<@NonNull String> getWitnessParties() {
        return this.witnessParties;
    }

    @Override
    public @NonNull Long getOffset() {
        return this.offset;
    }

    @Override
    public @NonNull Integer getNodeId() {
        return this.nodeId;
    }

    @Override
    public @NonNull Identifier getTemplateId() {
        return this.templateId;
    }

    @Override
    public @NonNull String getPackageName() {
        return this.packageName;
    }

    public @NonNull Optional<Identifier> getInterfaceId() {
        return this.interfaceId;
    }

    @Override
    public @NonNull String getContractId() {
        return this.contractId;
    }

    public @NonNull String getChoice() {
        return this.choice;
    }

    public @NonNull Integer getLastDescendantNodeId() {
        return this.lastDescendantNodeId;
    }

    public @NonNull Value getChoiceArgument() {
        return this.choiceArgument;
    }

    public @NonNull List<@NonNull String> getActingParties() {
        return this.actingParties;
    }

    public boolean isConsuming() {
        return this.consuming;
    }

    public @NonNull Value getExerciseResult() {
        return this.exerciseResult;
    }

    public @NonNull List<Identifier> getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public boolean isAcsDelta() {
        return this.acsDelta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExercisedEvent that = (ExercisedEvent)o;
        return this.consuming == that.consuming && Objects.equals(this.witnessParties, that.witnessParties) && Objects.equals(this.offset, that.offset) && Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.templateId, that.templateId) && Objects.equals(this.packageName, that.packageName) && Objects.equals(this.interfaceId, that.interfaceId) && Objects.equals(this.contractId, that.contractId) && Objects.equals(this.choice, that.choice) && Objects.equals(this.choiceArgument, that.choiceArgument) && Objects.equals(this.actingParties, that.actingParties) && Objects.equals(this.lastDescendantNodeId, that.lastDescendantNodeId) && Objects.equals(this.exerciseResult, that.exerciseResult) && Objects.equals(this.implementedInterfaces, that.implementedInterfaces) && Objects.equals(this.acsDelta, that.acsDelta);
    }

    public int hashCode() {
        return Objects.hash(this.witnessParties, this.offset, this.nodeId, this.templateId, this.packageName, this.interfaceId, this.contractId, this.choice, this.choiceArgument, this.actingParties, this.lastDescendantNodeId, this.consuming, this.exerciseResult, this.implementedInterfaces, this.acsDelta);
    }

    public String toString() {
        return "ExercisedEvent{witnessParties=" + this.witnessParties + ", offset=" + this.offset + ", nodeId=" + this.nodeId + ", templateId=" + this.templateId + ", packageName=" + this.packageName + ", interfaceId=" + this.interfaceId + ", contractId='" + this.contractId + "', choice='" + this.choice + "', choiceArgument=" + this.choiceArgument + ", actingParties=" + this.actingParties + ", consuming=" + this.consuming + ", lastDescendantNodeId=" + this.lastDescendantNodeId + ", exerciseResult=" + this.exerciseResult + ", implementedInterfaces='" + this.implementedInterfaces + ", acsDelta='" + this.acsDelta + "}";
    }

    public @NonNull EventOuterClass.ExercisedEvent toProto() {
        EventOuterClass.ExercisedEvent.Builder builder = EventOuterClass.ExercisedEvent.newBuilder().setOffset(this.getOffset()).setNodeId(this.getNodeId()).setChoice(this.getChoice()).setChoiceArgument(this.getChoiceArgument().toProto()).setConsuming(this.isConsuming()).setContractId(this.getContractId()).setTemplateId(this.getTemplateId().toProto()).setPackageName(this.getPackageName()).addAllActingParties(this.getActingParties()).addAllWitnessParties(this.getWitnessParties()).setLastDescendantNodeId(this.getLastDescendantNodeId()).setExerciseResult(this.getExerciseResult().toProto()).addAllImplementedInterfaces(this.getImplementedInterfaces().stream().map(Identifier::toProto).toList()).setAcsDelta(this.isAcsDelta());
        this.interfaceId.ifPresent(i -> builder.setInterfaceId(i.toProto()));
        return builder.build();
    }

    public static ExercisedEvent fromProto(EventOuterClass.ExercisedEvent exercisedEvent) {
        return new ExercisedEvent((List<String>)exercisedEvent.getWitnessPartiesList(), exercisedEvent.getOffset(), exercisedEvent.getNodeId(), Identifier.fromProto(exercisedEvent.getTemplateId()), exercisedEvent.getPackageName(), exercisedEvent.hasInterfaceId() ? Optional.of(Identifier.fromProto(exercisedEvent.getInterfaceId())) : Optional.empty(), exercisedEvent.getContractId(), exercisedEvent.getChoice(), Value.fromProto(exercisedEvent.getChoiceArgument()), (List<String>)exercisedEvent.getActingPartiesList(), exercisedEvent.getConsuming(), exercisedEvent.getLastDescendantNodeId(), Value.fromProto(exercisedEvent.getExerciseResult()), exercisedEvent.getImplementedInterfacesList().stream().map(Identifier::fromProto).toList(), exercisedEvent.getAcsDelta());
    }
}

