/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.StateServiceOuterClass;
import com.daml.ledger.javaapi.data.ActiveContract;
import com.daml.ledger.javaapi.data.ContractEntry;
import com.daml.ledger.javaapi.data.IncompleteAssigned;
import com.daml.ledger.javaapi.data.IncompleteUnassigned;
import com.daml.ledger.javaapi.data.ProtoContractEntryUnknown;
import com.daml.ledger.javaapi.data.WorkflowEvent;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class GetActiveContractsResponse
implements WorkflowEvent {
    private final Optional<ContractEntry> contractEntry;
    private final String workflowId;

    public GetActiveContractsResponse(@NonNull Optional<ContractEntry> contractEntry, String workflowId) {
        this.contractEntry = contractEntry;
        this.workflowId = workflowId;
    }

    public static GetActiveContractsResponse fromProto(StateServiceOuterClass.GetActiveContractsResponse response) {
        switch (response.getContractEntryCase()) {
            case ACTIVE_CONTRACT: {
                return new GetActiveContractsResponse(Optional.of(ActiveContract.fromProto(response.getActiveContract())), response.getWorkflowId());
            }
            case INCOMPLETE_UNASSIGNED: {
                return new GetActiveContractsResponse(Optional.of(IncompleteUnassigned.fromProto(response.getIncompleteUnassigned())), response.getWorkflowId());
            }
            case INCOMPLETE_ASSIGNED: {
                return new GetActiveContractsResponse(Optional.of(IncompleteAssigned.fromProto(response.getIncompleteAssigned())), response.getWorkflowId());
            }
            case CONTRACTENTRY_NOT_SET: {
                return new GetActiveContractsResponse(Optional.empty(), response.getWorkflowId());
            }
        }
        throw new ProtoContractEntryUnknown(response);
    }

    public StateServiceOuterClass.GetActiveContractsResponse toProto() {
        StateServiceOuterClass.GetActiveContractsResponse.Builder builder = StateServiceOuterClass.GetActiveContractsResponse.newBuilder().setWorkflowId(this.workflowId);
        if (this.contractEntry.isPresent()) {
            ContractEntry ce = this.contractEntry.get();
            if (ce instanceof ActiveContract) {
                builder.setActiveContract(((ActiveContract)ce).toProto());
            } else if (ce instanceof IncompleteUnassigned) {
                builder.setIncompleteUnassigned(((IncompleteUnassigned)ce).toProto());
            } else if (ce instanceof IncompleteAssigned) {
                builder.setIncompleteAssigned(((IncompleteAssigned)ce).toProto());
            }
        }
        return builder.build();
    }

    public Optional<ContractEntry> getContractEntry() {
        return this.contractEntry;
    }

    @Override
    public @NonNull String getWorkflowId() {
        return this.workflowId;
    }

    public String toString() {
        return "GetActiveContractsResponse{contractEntry=" + this.contractEntry + ", workflowId=" + this.workflowId + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetActiveContractsResponse that = (GetActiveContractsResponse)o;
        return Objects.equals(this.contractEntry, that.contractEntry) && Objects.equals(this.workflowId, that.workflowId);
    }

    public int hashCode() {
        return Objects.hash(this.contractEntry, this.workflowId);
    }
}

