/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.EventQueryServiceOuterClass;
import com.daml.ledger.javaapi.data.EventFormat;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class GetEventsByContractIdRequest {
    private final @NonNull String contractId;
    private final @NonNull EventFormat eventFormat;

    public static GetEventsByContractIdRequest fromProto(EventQueryServiceOuterClass.GetEventsByContractIdRequest getEventsByContractIdRequest) {
        if (!getEventsByContractIdRequest.hasEventFormat()) {
            throw new IllegalArgumentException("eventFormat is mandatory");
        }
        return new GetEventsByContractIdRequest(getEventsByContractIdRequest.getContractId(), EventFormat.fromProto(getEventsByContractIdRequest.getEventFormat()));
    }

    public EventQueryServiceOuterClass.GetEventsByContractIdRequest toProto() {
        return EventQueryServiceOuterClass.GetEventsByContractIdRequest.newBuilder().setEventFormat(this.eventFormat.toProto()).setContractId(this.contractId).build();
    }

    public String getContractId() {
        return this.contractId;
    }

    public EventFormat getEventFormat() {
        return this.eventFormat;
    }

    public GetEventsByContractIdRequest(@NonNull String contractId, @NonNull EventFormat eventFormat) {
        this.contractId = contractId;
        this.eventFormat = eventFormat;
    }

    public String toString() {
        return "GetEventsByContractIdRequest{contractId=" + this.contractId + ", eventFormat=" + this.eventFormat + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetEventsByContractIdRequest that = (GetEventsByContractIdRequest)o;
        return Objects.equals(this.contractId, that.contractId) && Objects.equals(this.eventFormat, that.eventFormat);
    }

    public int hashCode() {
        return Objects.hash(this.contractId, this.eventFormat);
    }
}

