/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.UpdateServiceOuterClass;
import com.daml.ledger.javaapi.data.Reassignment;
import com.daml.ledger.javaapi.data.TopologyTransaction;
import com.daml.ledger.javaapi.data.Transaction;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class GetUpdateResponse {
    private final @NonNull Optional<Transaction> transaction;
    private final @NonNull Optional<Reassignment> reassignment;
    private final @NonNull Optional<TopologyTransaction> topologyTransaction;

    private GetUpdateResponse(@NonNull Optional<Transaction> transaction, @NonNull Optional<Reassignment> reassignment, @NonNull Optional<TopologyTransaction> topologyTransaction) {
        this.transaction = transaction;
        this.reassignment = reassignment;
        this.topologyTransaction = topologyTransaction;
    }

    public GetUpdateResponse(@NonNull Transaction transaction) {
        this(Optional.of(transaction), Optional.empty(), Optional.empty());
    }

    public GetUpdateResponse(@NonNull Reassignment reassignment) {
        this(Optional.empty(), Optional.of(reassignment), Optional.empty());
    }

    public GetUpdateResponse(@NonNull TopologyTransaction topologyTransaction) {
        this(Optional.empty(), Optional.empty(), Optional.of(topologyTransaction));
    }

    public @NonNull Optional<Transaction> getTransaction() {
        return this.transaction;
    }

    public @NonNull Optional<Reassignment> getReassignment() {
        return this.reassignment;
    }

    public @NonNull Optional<TopologyTransaction> getTopologyTransaction() {
        return this.topologyTransaction;
    }

    public static GetUpdateResponse fromProto(UpdateServiceOuterClass.GetUpdateResponse response) {
        return new GetUpdateResponse(response.hasTransaction() ? Optional.of(Transaction.fromProto(response.getTransaction())) : Optional.empty(), response.hasReassignment() ? Optional.of(Reassignment.fromProto(response.getReassignment())) : Optional.empty(), response.hasTopologyTransaction() ? Optional.of(TopologyTransaction.fromProto(response.getTopologyTransaction())) : Optional.empty());
    }

    public UpdateServiceOuterClass.GetUpdateResponse toProto() {
        UpdateServiceOuterClass.GetUpdateResponse.Builder builder = UpdateServiceOuterClass.GetUpdateResponse.newBuilder();
        this.transaction.ifPresent(t -> builder.setTransaction(t.toProto()));
        this.reassignment.ifPresent(r -> builder.setReassignment(r.toProto()));
        this.topologyTransaction.ifPresent(t -> builder.setTopologyTransaction(t.toProto()));
        return builder.build();
    }

    public String toString() {
        return "GetUpdatesResponse{transaction=" + this.transaction + ", reassignment=" + this.reassignment + ", topologyTransaction=" + this.topologyTransaction + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetUpdateResponse that = (GetUpdateResponse)o;
        return Objects.equals(this.transaction, that.transaction) && Objects.equals(this.reassignment, that.reassignment) && Objects.equals(this.topologyTransaction, that.topologyTransaction);
    }

    public int hashCode() {
        return Objects.hash(this.transaction, this.reassignment, this.topologyTransaction);
    }
}

