/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.UpdateServiceOuterClass;
import com.daml.ledger.javaapi.data.UpdateFormat;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class GetUpdatesRequest {
    private final @NonNull Long beginExclusive;
    private final @NonNull Optional<Long> endInclusive;
    private final @NonNull UpdateFormat updateFormat;

    public GetUpdatesRequest(@NonNull Long beginExclusive, @NonNull Optional<Long> endInclusive, @NonNull UpdateFormat updateFormat) {
        this.beginExclusive = beginExclusive;
        this.endInclusive = endInclusive;
        this.updateFormat = updateFormat;
    }

    public static GetUpdatesRequest fromProto(UpdateServiceOuterClass.GetUpdatesRequest request) {
        if (request.hasUpdateFormat()) {
            return new GetUpdatesRequest(request.getBeginExclusive(), request.hasEndInclusive() ? Optional.of(request.getEndInclusive()) : Optional.empty(), UpdateFormat.fromProto(request.getUpdateFormat()));
        }
        throw new IllegalArgumentException("Request has no updateFormat defined.");
    }

    public UpdateServiceOuterClass.GetUpdatesRequest toProto() {
        UpdateServiceOuterClass.GetUpdatesRequest.Builder builder = UpdateServiceOuterClass.GetUpdatesRequest.newBuilder().setBeginExclusive(this.beginExclusive).setUpdateFormat(this.updateFormat.toProto());
        this.endInclusive.ifPresent(builder::setEndInclusive);
        return builder.build();
    }

    public @NonNull Long getBeginExclusive() {
        return this.beginExclusive;
    }

    public @NonNull Optional<Long> getEndInclusive() {
        return this.endInclusive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetUpdatesRequest that = (GetUpdatesRequest)o;
        return Objects.equals(this.beginExclusive, that.beginExclusive) && Objects.equals(this.endInclusive, that.endInclusive) && Objects.equals(this.updateFormat, that.updateFormat);
    }

    public int hashCode() {
        return Objects.hash(this.beginExclusive, this.endInclusive, this.updateFormat);
    }

    public String toString() {
        return "GetUpdatesRequest{beginExclusive=" + this.beginExclusive + ", endInclusive=" + this.endInclusive + ", updateFormat=" + this.updateFormat + "}";
    }
}

