/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.UpdateServiceOuterClass;
import com.daml.ledger.javaapi.data.OffsetCheckpoint;
import com.daml.ledger.javaapi.data.Reassignment;
import com.daml.ledger.javaapi.data.TopologyTransaction;
import com.daml.ledger.javaapi.data.Transaction;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class GetUpdatesResponse {
    private final @NonNull Optional<Transaction> transaction;
    private final @NonNull Optional<Reassignment> reassignment;
    private final @NonNull Optional<OffsetCheckpoint> offsetCheckpoint;
    private final @NonNull Optional<TopologyTransaction> topologyTransaction;

    private GetUpdatesResponse(@NonNull Optional<Transaction> transaction, @NonNull Optional<Reassignment> reassignment, @NonNull Optional<OffsetCheckpoint> offsetCheckpoint, @NonNull Optional<TopologyTransaction> topologyTransaction) {
        this.transaction = transaction;
        this.reassignment = reassignment;
        this.offsetCheckpoint = offsetCheckpoint;
        this.topologyTransaction = topologyTransaction;
    }

    public GetUpdatesResponse(@NonNull Transaction transaction) {
        this(Optional.of(transaction), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public GetUpdatesResponse(@NonNull Reassignment reassignment) {
        this(Optional.empty(), Optional.of(reassignment), Optional.empty(), Optional.empty());
    }

    public GetUpdatesResponse(@NonNull OffsetCheckpoint offsetCheckpoint) {
        this(Optional.empty(), Optional.empty(), Optional.of(offsetCheckpoint), Optional.empty());
    }

    public GetUpdatesResponse(@NonNull TopologyTransaction topologyTransaction) {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(topologyTransaction));
    }

    public @NonNull Optional<Transaction> getTransaction() {
        return this.transaction;
    }

    public @NonNull Optional<Reassignment> getReassignment() {
        return this.reassignment;
    }

    public @NonNull Optional<OffsetCheckpoint> getOffsetCheckpoint() {
        return this.offsetCheckpoint;
    }

    public @NonNull Optional<TopologyTransaction> getTopologyTransaction() {
        return this.topologyTransaction;
    }

    public static GetUpdatesResponse fromProto(UpdateServiceOuterClass.GetUpdatesResponse response) {
        return new GetUpdatesResponse(response.hasTransaction() ? Optional.of(Transaction.fromProto(response.getTransaction())) : Optional.empty(), response.hasReassignment() ? Optional.of(Reassignment.fromProto(response.getReassignment())) : Optional.empty(), response.hasOffsetCheckpoint() ? Optional.of(OffsetCheckpoint.fromProto(response.getOffsetCheckpoint())) : Optional.empty(), response.hasTopologyTransaction() ? Optional.of(TopologyTransaction.fromProto(response.getTopologyTransaction())) : Optional.empty());
    }

    public UpdateServiceOuterClass.GetUpdatesResponse toProto() {
        UpdateServiceOuterClass.GetUpdatesResponse.Builder builder = UpdateServiceOuterClass.GetUpdatesResponse.newBuilder();
        this.transaction.ifPresent(t -> builder.setTransaction(t.toProto()));
        this.reassignment.ifPresent(r -> builder.setReassignment(r.toProto()));
        this.offsetCheckpoint.ifPresent(c -> builder.setOffsetCheckpoint(c.toProto()));
        this.topologyTransaction.ifPresent(t -> builder.setTopologyTransaction(t.toProto()));
        return builder.build();
    }

    public String toString() {
        return "GetUpdatesResponse{transaction=" + this.transaction + ", reassignment=" + this.reassignment + ", offsetCheckpoint=" + this.offsetCheckpoint + ", topologyTransaction=" + this.topologyTransaction + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetUpdatesResponse that = (GetUpdatesResponse)o;
        return Objects.equals(this.transaction, that.transaction) && Objects.equals(this.reassignment, that.reassignment) && Objects.equals(this.offsetCheckpoint, that.offsetCheckpoint) && Objects.equals(this.topologyTransaction, that.topologyTransaction);
    }

    public int hashCode() {
        return Objects.hash(this.transaction, this.reassignment, this.offsetCheckpoint, this.topologyTransaction);
    }
}

