/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.OffsetCheckpointOuterClass;
import com.daml.ledger.javaapi.data.SynchronizerTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class OffsetCheckpoint {
    private final Long offset;
    private final List<SynchronizerTime> synchronizerTimes;

    public OffsetCheckpoint(@NonNull Long offset, @NonNull List<SynchronizerTime> synchronizerTimes) {
        this.offset = offset;
        this.synchronizerTimes = synchronizerTimes;
    }

    public static OffsetCheckpoint fromProto(OffsetCheckpointOuterClass.OffsetCheckpoint offsetCheckpoint) {
        return new OffsetCheckpoint(offsetCheckpoint.getOffset(), offsetCheckpoint.getSynchronizerTimesList().stream().map(SynchronizerTime::fromProto).collect(Collectors.toList()));
    }

    public OffsetCheckpointOuterClass.OffsetCheckpoint toProto() {
        return OffsetCheckpointOuterClass.OffsetCheckpoint.newBuilder().setOffset(this.offset).addAllSynchronizerTimes(this.synchronizerTimes.stream().map(SynchronizerTime::toProto).collect(Collectors.toList())).build();
    }

    public @NonNull Long getOffset() {
        return this.offset;
    }

    public @NonNull List<@NonNull SynchronizerTime> getSynchronizerTimes() {
        return this.synchronizerTimes;
    }

    public String toString() {
        return "OffsetCheckpoint{offset=" + this.offset + ", synchronizerTimes=" + this.synchronizerTimes + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetCheckpoint that = (OffsetCheckpoint)o;
        return Objects.equals(this.offset, that.offset) && Objects.equals(this.synchronizerTimes, that.synchronizerTimes);
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.synchronizerTimes);
    }
}

