/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.TopologyTransactionOuterClass;
import com.daml.ledger.javaapi.data.TopologyEvent;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ParticipantAuthorizationRevoked
implements TopologyEvent {
    private final @NonNull String partyId;
    private final @NonNull String participantId;

    public ParticipantAuthorizationRevoked(@NonNull String partyId, @NonNull String participantId) {
        this.partyId = partyId;
        this.participantId = participantId;
    }

    public @NonNull String getPartyId() {
        return this.partyId;
    }

    @Override
    public @NonNull String getParticipantId() {
        return this.participantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParticipantAuthorizationRevoked that = (ParticipantAuthorizationRevoked)o;
        return Objects.equals(this.partyId, that.partyId) && Objects.equals(this.participantId, that.participantId);
    }

    public int hashCode() {
        return Objects.hash(this.partyId, this.participantId);
    }

    public String toString() {
        return "ParticipantAuthorizationRevoked{partyId=" + this.partyId + ", participantId='" + this.participantId + "}";
    }

    public @NonNull TopologyTransactionOuterClass.ParticipantAuthorizationRevoked toProto() {
        return TopologyTransactionOuterClass.ParticipantAuthorizationRevoked.newBuilder().setPartyId(this.getPartyId()).setParticipantId(this.getParticipantId()).build();
    }

    public static ParticipantAuthorizationRevoked fromProto(TopologyTransactionOuterClass.ParticipantAuthorizationRevoked changedEvent) {
        return new ParticipantAuthorizationRevoked(changedEvent.getPartyId(), changedEvent.getParticipantId());
    }
}

