/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.OffsetCheckpointOuterClass;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class SynchronizerTime {
    private final String synchronizerId;
    private final Instant recordTime;

    public SynchronizerTime(@NonNull String synchronizerId, @NonNull Instant recordTime) {
        this.synchronizerId = synchronizerId;
        this.recordTime = recordTime;
    }

    public static SynchronizerTime fromProto(OffsetCheckpointOuterClass.SynchronizerTime synchronizerTime) {
        return new SynchronizerTime(synchronizerTime.getSynchronizerId(), Instant.ofEpochSecond(synchronizerTime.getRecordTime().getSeconds(), synchronizerTime.getRecordTime().getNanos()));
    }

    public OffsetCheckpointOuterClass.SynchronizerTime toProto() {
        return OffsetCheckpointOuterClass.SynchronizerTime.newBuilder().setSynchronizerId(this.synchronizerId).setRecordTime(Timestamp.newBuilder().setSeconds(this.recordTime.getEpochSecond()).setNanos(this.recordTime.getNano()).build()).build();
    }

    public @NonNull String getSynchronizerId() {
        return this.synchronizerId;
    }

    public @NonNull Instant getRecordTime() {
        return this.recordTime;
    }

    public String toString() {
        return "SynchronizerTime{synchronizerId=" + this.synchronizerId + ", recordTime=" + this.recordTime + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SynchronizerTime that = (SynchronizerTime)o;
        return Objects.equals(this.synchronizerId, that.synchronizerId) && Objects.equals(this.recordTime, that.recordTime);
    }

    public int hashCode() {
        return Objects.hash(this.synchronizerId, this.recordTime);
    }
}

