/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.TopologyTransactionOuterClass;
import com.daml.ledger.javaapi.data.ParticipantAuthorizationAdded;
import com.daml.ledger.javaapi.data.ParticipantAuthorizationChanged;
import com.daml.ledger.javaapi.data.ParticipantAuthorizationRevoked;
import com.daml.ledger.javaapi.data.UnsupportedEventTypeException;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface TopologyEvent {
    public @NonNull String getParticipantId();

    default public TopologyTransactionOuterClass.TopologyEvent toProtoEvent() {
        TopologyTransactionOuterClass.TopologyEvent.Builder eventBuilder = TopologyTransactionOuterClass.TopologyEvent.newBuilder();
        if (this instanceof ParticipantAuthorizationChanged) {
            ParticipantAuthorizationChanged event = (ParticipantAuthorizationChanged)this;
            eventBuilder.setParticipantAuthorizationChanged(event.toProto());
        } else if (this instanceof ParticipantAuthorizationAdded) {
            ParticipantAuthorizationAdded event = (ParticipantAuthorizationAdded)this;
            eventBuilder.setParticipantAuthorizationAdded(event.toProto());
        } else if (this instanceof ParticipantAuthorizationRevoked) {
            ParticipantAuthorizationRevoked event = (ParticipantAuthorizationRevoked)this;
            eventBuilder.setParticipantAuthorizationRevoked(event.toProto());
        } else {
            throw new RuntimeException("this should be ParticipantAuthorizationChanged or ParticipantAuthorizationRevoked, found " + this.toString());
        }
        return eventBuilder.build();
    }

    public static TopologyEvent fromProtoEvent(TopologyTransactionOuterClass.TopologyEvent event) {
        if (event.hasParticipantAuthorizationChanged()) {
            return ParticipantAuthorizationChanged.fromProto(event.getParticipantAuthorizationChanged());
        }
        if (event.hasParticipantAuthorizationAdded()) {
            return ParticipantAuthorizationAdded.fromProto(event.getParticipantAuthorizationAdded());
        }
        if (event.hasParticipantAuthorizationRevoked()) {
            return ParticipantAuthorizationRevoked.fromProto(event.getParticipantAuthorizationRevoked());
        }
        throw new UnsupportedEventTypeException(event.toString());
    }
}

