/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.TopologyTransactionOuterClass;
import com.daml.ledger.api.v2.TraceContextOuterClass;
import com.daml.ledger.javaapi.data.TopologyEvent;
import com.daml.ledger.javaapi.data.Utils;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TopologyTransaction {
    private final @NonNull String updateId;
    private final @NonNull Long offset;
    private final @NonNull String synchronizerId;
    private final @NonNull Instant recordTime;
    private final @NonNull List<@NonNull TopologyEvent> events;
    private final @NonNull TraceContextOuterClass.TraceContext traceContext;

    public TopologyTransaction(@NonNull String updateId, @NonNull Long offset, @NonNull String synchronizerId, @NonNull Instant recordTime, @NonNull List<@NonNull TopologyEvent> events, @NonNull TraceContextOuterClass.TraceContext traceContext) {
        this.updateId = updateId;
        this.offset = offset;
        this.synchronizerId = synchronizerId;
        this.recordTime = recordTime;
        this.events = events;
        this.traceContext = traceContext;
    }

    public @NonNull String getUpdateId() {
        return this.updateId;
    }

    public @NonNull List<TopologyEvent> getEvents() {
        return this.events;
    }

    public @NonNull Long getOffset() {
        return this.offset;
    }

    public @NonNull String getSynchronizerId() {
        return this.synchronizerId;
    }

    public @NonNull TraceContextOuterClass.TraceContext getTraceContext() {
        return this.traceContext;
    }

    public @NonNull Instant getRecordTime() {
        return this.recordTime;
    }

    public static TopologyTransaction fromProto(TopologyTransactionOuterClass.TopologyTransaction topologyTransaction) {
        List<TopologyEvent> events = topologyTransaction.getEventsList().stream().map(TopologyEvent::fromProtoEvent).collect(Collectors.toList());
        return new TopologyTransaction(topologyTransaction.getUpdateId(), topologyTransaction.getOffset(), topologyTransaction.getSynchronizerId(), Utils.instantFromProto(topologyTransaction.getRecordTime()), events, topologyTransaction.getTraceContext());
    }

    public TopologyTransactionOuterClass.TopologyTransaction toProto() {
        return TopologyTransactionOuterClass.TopologyTransaction.newBuilder().setUpdateId(this.updateId).addAllEvents(this.events.stream().map(TopologyEvent::toProtoEvent).collect(Collectors.toList())).setOffset(this.offset).setSynchronizerId(this.synchronizerId).setTraceContext(this.traceContext).setRecordTime(Utils.instantToProto(this.recordTime)).build();
    }

    public String toString() {
        return "Transaction{updateId='" + this.updateId + ", events=" + this.events + ", offset='" + this.offset + "', synchronizerId='" + this.synchronizerId + "', traceContext=" + this.traceContext + ", recordTime=" + this.recordTime + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyTransaction that = (TopologyTransaction)o;
        return Objects.equals(this.updateId, that.updateId) && Objects.equals(this.events, that.events) && Objects.equals(this.offset, that.offset) && Objects.equals(this.synchronizerId, that.synchronizerId) && Objects.equals(this.traceContext, that.traceContext) && Objects.equals(this.recordTime, that.recordTime);
    }

    public int hashCode() {
        return Objects.hash(this.updateId, this.events, this.offset, this.synchronizerId, this.traceContext, this.recordTime);
    }
}

