/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.ReassignmentCommandOuterClass;
import com.daml.ledger.javaapi.data.ReassignmentCommand;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class UnassignCommand
extends ReassignmentCommand {
    private final @NonNull String contractId;
    private final @NonNull String source;
    private final @NonNull String target;

    public UnassignCommand(@NonNull String contractId, @NonNull String source, @NonNull String target) {
        this.contractId = contractId;
        this.source = source;
        this.target = target;
    }

    public @NonNull String getContractId() {
        return this.contractId;
    }

    public @NonNull String getSource() {
        return this.source;
    }

    public @NonNull String getTarget() {
        return this.target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnassignCommand that = (UnassignCommand)o;
        return Objects.equals(this.contractId, that.contractId) && Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target);
    }

    public int hashCode() {
        return Objects.hash(this.contractId, this.source, this.target);
    }

    public String toString() {
        return "UnassignCommand{contractId='" + this.contractId + "', source=" + this.source + ", target=" + this.target + "}";
    }

    public ReassignmentCommandOuterClass.UnassignCommand toProto() {
        return ReassignmentCommandOuterClass.UnassignCommand.newBuilder().setContractId(this.contractId).setSource(this.source).setTarget(this.target).build();
    }

    public static UnassignCommand fromProto(ReassignmentCommandOuterClass.UnassignCommand unassignCommand) {
        return new UnassignCommand(unassignCommand.getContractId(), unassignCommand.getSource(), unassignCommand.getTarget());
    }
}

