/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.ReassignmentOuterClass;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.ReassignmentEvent;
import com.daml.ledger.javaapi.data.Utils;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class UnassignedEvent
implements ReassignmentEvent {
    private final long offset;
    private final @NonNull String reassignmentId;
    private final @NonNull String contractId;
    private final @NonNull Identifier templateId;
    private final @NonNull String packageName;
    private final @NonNull String source;
    private final @NonNull String target;
    private final @NonNull String submitter;
    private final long reassignmentCounter;
    private final @NonNull Instant assignmentExclusivity;
    private final @NonNull List<@NonNull String> witnessParties;
    private final int nodeId;

    public UnassignedEvent(long offset, @NonNull String reassignmentId, @NonNull String contractId, @NonNull Identifier templateId, @NonNull String packageName, @NonNull String source, @NonNull String target, @NonNull String submitter, long reassignmentCounter, @NonNull Instant assignmentExclusivity, @NonNull List<@NonNull String> witnessParties, int nodeId) {
        this.offset = offset;
        this.reassignmentId = reassignmentId;
        this.contractId = contractId;
        this.templateId = templateId;
        this.packageName = packageName;
        this.source = source;
        this.target = target;
        this.submitter = submitter;
        this.reassignmentCounter = reassignmentCounter;
        this.assignmentExclusivity = assignmentExclusivity;
        this.witnessParties = List.copyOf(witnessParties);
        this.nodeId = nodeId;
    }

    public long getOffset() {
        return this.offset;
    }

    public @NonNull String getReassignmentId() {
        return this.reassignmentId;
    }

    public @NonNull String getContractId() {
        return this.contractId;
    }

    public @NonNull Identifier getTemplateId() {
        return this.templateId;
    }

    public @NonNull String getPackageName() {
        return this.packageName;
    }

    public @NonNull String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public @NonNull String getSubmitter() {
        return this.submitter;
    }

    public long getReassignmentCounter() {
        return this.reassignmentCounter;
    }

    public @NonNull Instant getAssignmentExclusivity() {
        return this.assignmentExclusivity;
    }

    public @NonNull List<@NonNull String> getWitnessParties() {
        return this.witnessParties;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnassignedEvent that = (UnassignedEvent)o;
        return Objects.equals(this.offset, that.offset) && Objects.equals(this.reassignmentId, that.reassignmentId) && Objects.equals(this.contractId, that.contractId) && Objects.equals(this.packageName, that.packageName) && Objects.equals(this.templateId, that.templateId) && Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target) && Objects.equals(this.submitter, that.submitter) && Objects.equals(this.reassignmentCounter, that.reassignmentCounter) && Objects.equals(this.assignmentExclusivity, that.assignmentExclusivity) && Objects.equals(this.witnessParties, that.witnessParties) && Objects.equals(this.nodeId, that.nodeId);
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.reassignmentId, this.contractId, this.templateId, this.packageName, this.source, this.target, this.submitter, this.reassignmentCounter, this.assignmentExclusivity, this.witnessParties, this.nodeId);
    }

    public String toString() {
        return "UnassignedEvent{offset=" + this.offset + ", reassignmentId='" + this.reassignmentId + "', contractId='" + this.contractId + "', packageName=" + this.packageName + ", templateId=" + this.templateId + ", source=" + this.source + ", target=" + this.target + ", submitter=" + this.submitter + ", reassignmentCounter=" + this.reassignmentCounter + ", assignmentExclusivity=" + this.assignmentExclusivity + ", witnessParties=" + this.witnessParties + ", nodeId=" + this.nodeId + "}";
    }

    public ReassignmentOuterClass.UnassignedEvent toProto() {
        return ReassignmentOuterClass.UnassignedEvent.newBuilder().setOffset(this.offset).setReassignmentId(this.reassignmentId).setContractId(this.contractId).setTemplateId(this.getTemplateId().toProto()).setPackageName(this.packageName).setSource(this.source).setTarget(this.target).setSubmitter(this.submitter).setReassignmentCounter(this.reassignmentCounter).setAssignmentExclusivity(Utils.instantToProto(this.assignmentExclusivity)).addAllWitnessParties(this.getWitnessParties()).setNodeId(this.getNodeId()).build();
    }

    public static UnassignedEvent fromProto(ReassignmentOuterClass.UnassignedEvent unassignedEvent) {
        return new UnassignedEvent(unassignedEvent.getOffset(), unassignedEvent.getReassignmentId(), unassignedEvent.getContractId(), Identifier.fromProto(unassignedEvent.getTemplateId()), unassignedEvent.getPackageName(), unassignedEvent.getSource(), unassignedEvent.getTarget(), unassignedEvent.getSubmitter(), unassignedEvent.getReassignmentCounter(), Instant.ofEpochSecond(unassignedEvent.getAssignmentExclusivity().getSeconds(), unassignedEvent.getAssignmentExclusivity().getNanos()), (List<String>)unassignedEvent.getWitnessPartiesList(), unassignedEvent.getNodeId());
    }
}

