/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.TransactionFilterOuterClass;
import com.daml.ledger.javaapi.data.EventFormat;
import com.daml.ledger.javaapi.data.TopologyFormat;
import com.daml.ledger.javaapi.data.TransactionFormat;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class UpdateFormat {
    private final @NonNull Optional<@NonNull TransactionFormat> includeTransactions;
    private final @NonNull Optional<@NonNull EventFormat> includeReassignments;
    private final @NonNull Optional<@NonNull TopologyFormat> includeTopologyEvents;

    public static UpdateFormat fromProto(TransactionFilterOuterClass.UpdateFormat protoFormat) {
        return new UpdateFormat(protoFormat.hasIncludeTransactions() ? Optional.of(TransactionFormat.fromProto(protoFormat.getIncludeTransactions())) : Optional.empty(), protoFormat.hasIncludeReassignments() ? Optional.of(EventFormat.fromProto(protoFormat.getIncludeReassignments())) : Optional.empty(), protoFormat.hasIncludeTopologyEvents() ? Optional.of(TopologyFormat.fromProto(protoFormat.getIncludeTopologyEvents())) : Optional.empty());
    }

    public TransactionFilterOuterClass.UpdateFormat toProto() {
        TransactionFilterOuterClass.UpdateFormat.Builder builder = TransactionFilterOuterClass.UpdateFormat.newBuilder();
        this.includeTransactions.ifPresent(transactionFormat -> builder.setIncludeTransactions(transactionFormat.toProto()));
        this.includeReassignments.ifPresent(eventFormat -> builder.setIncludeReassignments(eventFormat.toProto()));
        this.includeTopologyEvents.ifPresent(topologyFormat -> builder.setIncludeTopologyEvents(topologyFormat.toProto()));
        return builder.build();
    }

    public Optional<@NonNull TransactionFormat> getIncludeTransactions() {
        return this.includeTransactions;
    }

    public Optional<@NonNull EventFormat> getIncludeReassignments() {
        return this.includeReassignments;
    }

    public Optional<@NonNull TopologyFormat> getIncludeTopologyEvents() {
        return this.includeTopologyEvents;
    }

    public UpdateFormat(@NonNull Optional<@NonNull TransactionFormat> includeTransactions, @NonNull Optional<@NonNull EventFormat> includeReassignments, @NonNull Optional<@NonNull TopologyFormat> includeTopologyEvents) {
        this.includeTransactions = includeTransactions;
        this.includeReassignments = includeReassignments;
        this.includeTopologyEvents = includeTopologyEvents;
    }

    public String toString() {
        return "UpdateFormat{includeTransactions=" + this.includeTransactions + ", includeReassignments=" + this.includeReassignments + ", includeTopologyEvents=" + this.includeTopologyEvents + "125";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateFormat that = (UpdateFormat)o;
        return Objects.equals(this.includeTransactions, that.includeTransactions) && Objects.equals(this.includeReassignments, that.includeReassignments) && Objects.equals(this.includeTopologyEvents, that.includeTopologyEvents);
    }

    public int hashCode() {
        return Objects.hash(this.includeTransactions, this.includeReassignments, this.includeTopologyEvents);
    }
}

