/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v2.TraceContextOuterClass;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import java.time.Instant;

public class Utils {
    private Utils() {
    }

    public static Timestamp instantToProto(Instant instant) {
        return Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
    }

    public static Instant instantFromProto(Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    public static Duration durationToProto(java.time.Duration duration) {
        return Duration.newBuilder().setSeconds(duration.getSeconds()).setNanos(duration.getNano()).build();
    }

    public static java.time.Duration durationFromProto(Duration duration) {
        return java.time.Duration.ofSeconds(duration.getSeconds(), duration.getNanos());
    }

    public static TraceContextOuterClass.TraceContext newProtoTraceContext(String traceParent, String traceState) {
        return TraceContextOuterClass.TraceContext.newBuilder().setTraceparent(traceParent).setTracestate(traceState).build();
    }
}

