/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data.codegen;

import com.daml.ledger.javaapi.data.CreatedEvent;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.PackageVersion;
import com.daml.ledger.javaapi.data.codegen.Choice;
import com.daml.ledger.javaapi.data.codegen.ContractId;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class ContractTypeCompanion<Ct, Id, ContractType, Data> {
    public final Package PACKAGE;
    public final String PACKAGE_ID;
    public final String PACKAGE_NAME;
    public final PackageVersion PACKAGE_VERSION;
    public final Identifier TEMPLATE_ID;
    public final Identifier TEMPLATE_ID_WITH_PACKAGE_ID;
    final String TEMPLATE_CLASS_NAME;
    final Function<String, Id> newContractId;
    public final Map<String, Choice<ContractType, ?, ?>> choices;

    protected ContractTypeCompanion(Package packageInfo, Identifier templateId, String templateClassName, Function<String, Id> newContractId, List<Choice<ContractType, ?, ?>> choices) {
        this.PACKAGE = packageInfo;
        this.PACKAGE_ID = packageInfo.id;
        this.PACKAGE_NAME = packageInfo.name;
        this.PACKAGE_VERSION = packageInfo.version;
        this.TEMPLATE_ID = templateId;
        this.TEMPLATE_CLASS_NAME = templateClassName;
        this.TEMPLATE_ID_WITH_PACKAGE_ID = this.getTemplateIdWithPackageId();
        this.newContractId = newContractId;
        this.choices = choices.stream().collect(Collectors.toMap(choice -> choice.name, Function.identity()));
    }

    public Identifier getTemplateIdWithPackageId() {
        return new Identifier(this.PACKAGE.id, this.TEMPLATE_ID.getModuleName(), this.TEMPLATE_ID.getEntityName());
    }

    public abstract Ct fromCreatedEvent(CreatedEvent var1) throws IllegalArgumentException;

    public final Id toContractId(ContractId<ContractType> parameterizedContractId) {
        return this.newContractId.apply(parameterizedContractId.contractId);
    }

    public static class Package {
        public final String id;
        public final String name;
        public final PackageVersion version;

        public Package(String id, String name, PackageVersion version) {
            this.id = id;
            this.name = name;
            this.version = version;
        }
    }
}

