/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.codegen.backend.java.inner;

import com.daml.ledger.javaapi.data.Contract;
import com.daml.ledger.javaapi.data.CreatedEvent;
import com.daml.ledger.javaapi.data.Identifier;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import javax.lang.model.element.Modifier;
import scala.Function1;
import scala.collection.Iterable;

public final class DecoderClass$ {
    public static final DecoderClass$ MODULE$ = new DecoderClass$();
    private static final ClassName contractType = ClassName.get(Contract.class);
    private static final ParameterizedTypeName decoderFunctionType = ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(CreatedEvent.class), ClassName.get(Contract.class)});
    private static final ParameterizedTypeName decodersMapType = ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{ClassName.get(Identifier.class), MODULE$.decoderFunctionType()});
    private static final MethodSpec fromCreatedEvent = MethodSpec.methodBuilder((String)"fromCreatedEvent").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)MODULE$.contractType()).addParameter((TypeName)ClassName.get(CreatedEvent.class), "event", new Modifier[0]).addException(IllegalArgumentException.class).addCode(CodeBlock.builder().addStatement("Identifier templateId = event.getTemplateId()", new Object[0]).addStatement("$T decoderFunc = getDecoder(templateId).orElseThrow(() -> new IllegalArgumentException(\"No template found for identifier \" + templateId))", new Object[]{MODULE$.decoderFunctionType()}).addStatement("return decoderFunc.apply(event)", new Object[0]).build()).build();
    private static final MethodSpec getDecoder = MethodSpec.methodBuilder((String)"getDecoder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{MODULE$.decoderFunctionType()})).addParameter((TypeName)ClassName.get(Identifier.class), "templateId", new Modifier[0]).addStatement(CodeBlock.of((String)"return Optional.ofNullable(decoders.get(templateId))", (Object[])new Object[0])).build();
    private static final FieldSpec decodersField = FieldSpec.builder((TypeName)MODULE$.decodersMapType(), (String)"decoders", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).build();

    public TypeSpec generateCode(String simpleClassName, Iterable<ClassName> templateNames) {
        return TypeSpec.classBuilder((String)simpleClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(this.decodersField()).addMethod(this.fromCreatedEvent()).addMethod(this.getDecoder()).addStaticBlock(this.generateStaticInitializer(templateNames)).build();
    }

    private ClassName contractType() {
        return contractType;
    }

    private ParameterizedTypeName decoderFunctionType() {
        return decoderFunctionType;
    }

    private ParameterizedTypeName decodersMapType() {
        return decodersMapType;
    }

    private MethodSpec fromCreatedEvent() {
        return fromCreatedEvent;
    }

    private MethodSpec getDecoder() {
        return getDecoder;
    }

    private FieldSpec decodersField() {
        return decodersField;
    }

    public CodeBlock generateStaticInitializer(Iterable<ClassName> templateNames) {
        CodeBlock.Builder b = CodeBlock.builder();
        b.addStatement("$N = new $T()", new Object[]{this.decodersField(), this.decodersMapType()});
        templateNames.foreach((Function1 & Serializable)template -> b.addStatement("$N.put($T.TEMPLATE_ID, $T.Contract::fromCreatedEvent)", new Object[]{MODULE$.decodersField(), template, template}));
        return b.build();
    }

    private DecoderClass$() {
    }
}

