/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.codegen;

import com.daml.lf.archive.Dar;
import com.daml.lf.archive.package$;
import com.daml.lf.codegen.InterfaceTree;
import com.daml.lf.codegen.InterfaceTrees;
import com.daml.lf.codegen.NodeWithContext;
import com.daml.lf.codegen.backend.Backend;
import com.daml.lf.codegen.backend.java.JavaBackend$;
import com.daml.lf.codegen.conf.Conf;
import com.daml.lf.codegen.conf.PackageReference;
import com.daml.lf.data.ImmArray;
import com.daml.lf.iface.DefDataType;
import com.daml.lf.iface.DefTemplate;
import com.daml.lf.iface.EnvironmentInterface;
import com.daml.lf.iface.EnvironmentInterface$;
import com.daml.lf.iface.Interface;
import com.daml.lf.iface.Type;
import com.daml.lf.iface.reader.Errors;
import com.daml.lf.iface.reader.Errors$;
import com.daml.lf.iface.reader.InterfaceReader;
import com.daml.lf.iface.reader.InterfaceReader$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;

public final class CodeGenRunner$
implements StrictLogging {
    public static final CodeGenRunner$ MODULE$ = new CodeGenRunner$();
    private static final Backend backend;
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
        backend = JavaBackend$.MODULE$;
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public void run(Conf conf) {
        ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT")).setLevel(conf.verbosity());
        ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"com.daml.lf.codegen.backend.java.inner")).setLevel(conf.verbosity());
        conf.darFiles().foreach((Function1 & Serializable)x0$1 -> {
            CodeGenRunner$.$anonfun$run$1(x0$1);
            return BoxedUnit.UNIT;
        });
        this.checkAndCreateOutputDir(conf.outputDirectory());
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){
            private final AtomicInteger n;

            private AtomicInteger n() {
                return this.n;
            }

            /*
             * WARNING - void declaration
             */
            public Thread newThread(Runnable r) {
                void var2_2;
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName(new StringBuilder(13).append("java-codegen-").append(this.n().getAndIncrement()).toString());
                return var2_2;
            }
            {
                this.n = new AtomicInteger(0);
            }
        });
        ExecutionContextExecutor ec = ExecutionContext$.MODULE$.fromExecutor((Executor)executor);
        Tuple2<Seq<Interface>, Map<String, String>> tuple2 = this.collectDamlLfInterfaces(conf);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq interfaces = (Seq)tuple2._1();
        Map pkgPrefixes = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)interfaces, (Object)pkgPrefixes);
        Tuple2 tuple23 = tuple22;
        Seq interfaces2 = (Seq)tuple23._1();
        Map pkgPrefixes2 = (Map)tuple23._2();
        this.generateCode((Seq<Interface>)interfaces2, conf, (Map<String, String>)pkgPrefixes2, (ExecutionContext)ec);
        java.util.List<Runnable> list = executor.shutdownNow();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public Tuple2<Seq<Interface>, Map<String, String>> collectDamlLfInterfaces(Conf conf) {
        List interfacesAndPrefixes = conf.darFiles().toList().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            Option pkgPrefix = (Option)tuple2._2();
            File file = path.toFile();
            Dar dar = package$.MODULE$.DarParser().assertReadArchiveFromFile(file);
            List list = dar.all().map((Function1 & Serializable)archive -> {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = InterfaceReader$.MODULE$.readInterface(archive);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Errors errors = (Errors)tuple2._1();
                Interface interface_ = (Interface)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)errors, (Object)interface_);
                Tuple2 tuple23 = tuple22;
                Errors errors2 = (Errors)tuple23._1();
                interface = (Interface)tuple23._2();
                if (!errors2.equals((Object)Errors$.MODULE$.zeroErrors())) {
                    throw new RuntimeException(InterfaceReader.InterfaceReaderError$.MODULE$.treeReport(errors2).toString());
                }
                if (MODULE$.logger().underlying().isTraceEnabled()) {
                    MODULE$.logger().underlying().trace("Daml-LF Archive decoded, packageId '{}'", (Object)interface.packageId());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return new Tuple2((Object)interface, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)interface.packageId()), (Object)pkgPrefix));
            });
            return list;
        });
        List interfaces = interfacesAndPrefixes.map((Function1 & Serializable)x$4 -> (Interface)x$4._1());
        EnvironmentInterface environmentInterface = EnvironmentInterface$.MODULE$.fromReaderInterfaces((Interface)interfaces.head(), (Seq)interfaces.tail());
        Map prefixes = interfacesAndPrefixes.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Interface, Tuple2<String, Option<String>>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                Tuple2 tuple2;
                A1 A1 = x1;
                if (A1 != null && (tuple2 = (Tuple2)A1._2()) != null) {
                    String key = (String)tuple2._1();
                    Option option = (Option)tuple2._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String value = (String)some.value();
                        object = new Tuple2((Object)key, (Object)value);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Interface, Tuple2<String, Option<String>>> x1) {
                Option option;
                Tuple2 tuple2;
                Tuple2<Interface, Tuple2<String, Option<String>>> tuple22 = x1;
                boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null && (option = (Option)tuple2._2()) instanceof Some;
                return bl;
            }
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        List fullyResolvedInterfaces = interfaces.map((Function1 & Serializable)x$5 -> x$5.resolveChoicesAndFailOnUnresolvableChoices((PartialFunction)environmentInterface.astInterfaces()));
        return new Tuple2((Object)fullyResolvedInterfaces, (Object)prefixes);
    }

    public void generateFile(Path outputFile, ImmArray<DefDataType<Type, Type>> dataTypes, ImmArray<DefTemplate<Type>> templates) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Started writing file '{}' with data types {} and templates {}", new Object[]{outputFile, dataTypes.toString(), templates.toString()});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Path path = Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
        if (!Files.exists(outputFile, new LinkOption[0])) {
            Path path2 = Files.createFile(outputFile, new FileAttribute[0]);
            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
            BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
        }
        OutputStream os = Files.newOutputStream(outputFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        os.close();
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Finish writing file '{}'", (Object)outputFile);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Map<String, String> resolvePackagePrefixes(Map<String, String> pkgPrefixes, Map<PackageReference, String> modulePrefixes, Seq<Interface> interfaces) {
        Map metadata = ((IterableOnceOps)interfaces.view().flatMap((Function1 & Serializable)iface -> iface.metadata().iterator().map((Function1 & Serializable)metadata -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new PackageReference.NameVersion(metadata.name(), metadata.version())), (Object)iface.packageId())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map resolvedModulePrefixes = (Map)modulePrefixes.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            PackageReference k = (PackageReference)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CodeGenRunner$.resolveRef$1(k, metadata)), (Object)v.toLowerCase());
            return tuple22;
        });
        return ((IterableOnceOps)pkgPrefixes.keySet().union((Set)resolvedModulePrefixes.keySet()).view().map(arg_0 -> CodeGenRunner$.$anonfun$resolvePackagePrefixes$5(pkgPrefixes, resolvedModulePrefixes, arg_0))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void detectModuleCollisions(Map<String, String> pkgPrefixes, Seq<Interface> interfaces) {
        Seq allModules = (Seq)((IterableOps)interfaces.map((Function1 & Serializable)interface_ -> {
            scala.collection.immutable.Set modules = (scala.collection.immutable.Set)interface_.typeDecls().keySet().map((Function1 & Serializable)x$8 -> x$8.module());
            return new Tuple2(interface_, (Object)modules);
        })).flatMap((Function1 & Serializable)x$10 -> {
            Tuple2 tuple2 = x$10;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Interface interface_ = (Interface)tuple2._1();
            scala.collection.immutable.Set modules = (scala.collection.immutable.Set)tuple2._2();
            IterableOnce iterableOnce = (IterableOnce)((IterableOps)modules.map((Function1 & Serializable)module -> {
                Option maybePrefix = pkgPrefixes.get((Object)interface_.packageId());
                String prefixedName = (String)maybePrefix.fold((Function0 & Serializable)() -> module.toString(), (Function1 & Serializable)prefix -> new StringBuilder(1).append((String)prefix).append(".").append(module).toString());
                return new Tuple3(module, (Object)maybePrefix, (Object)prefixedName);
            })).map((Function1 & Serializable)x$9 -> {
                Tuple3 tuple3 = x$9;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                String prefixedName = (String)tuple3._3();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)prefixedName), (Object)interface_.packageId());
                return tuple2;
            });
            return iterableOnce;
        });
        allModules.groupBy((Function1 & Serializable)x$11 -> (String)x$11._1()).foreach((Function1 & Serializable)x0$1 -> {
            CodeGenRunner$.$anonfun$detectModuleCollisions$9(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void generateCode(Seq<Interface> interfaces, Conf conf, Map<String, String> pkgPrefixes, ExecutionContext ec) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Start processing packageIds '{}' in directory '{}'", new Object[]{((IterableOnceOps)interfaces.map((Function1 & Serializable)x$13 -> x$13.packageId())).mkString(", "), conf.outputDirectory()});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Map<String, String> prefixes = this.resolvePackagePrefixes(pkgPrefixes, (Map<PackageReference, String>)conf.modulePrefixes(), interfaces);
        this.detectModuleCollisions(prefixes, interfaces);
        Future<InterfaceTrees> preprocessingFuture = this.backend().preprocess(interfaces, conf, prefixes, ec);
        Future future = preprocessingFuture.flatMap((Function1 & Serializable)preprocessedInterfaceTrees -> Future$.MODULE$.traverse(preprocessedInterfaceTrees.interfaceTrees(), (Function1 & Serializable)x$14 -> MODULE$.processInterfaceTree((InterfaceTree)x$14, conf, prefixes, ec), BuildFrom$.MODULE$.buildFromIterableOps(), ec).map((Function1 & Serializable)x$15 -> {
            CodeGenRunner$.$anonfun$generateCode$4(x$15);
            return BoxedUnit.UNIT;
        }, ec), ec);
        BoxedUnit boxedUnit3 = (BoxedUnit)Await$.MODULE$.result((Awaitable)future, (Duration)Duration$.MODULE$.create(10L, TimeUnit.MINUTES));
        BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
        BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Finish processing packageIds ''{}''", (Object)((IterableOnceOps)interfaces.map((Function1 & Serializable)x$17 -> x$17.packageId())).mkString(", "));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Backend backend() {
        return backend;
    }

    public Future<BoxedUnit> processInterfaceTree(InterfaceTree interfaceTree, Conf conf, Map<String, String> packagePrefixes, ExecutionContext ec) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Start processing packageId '{}'", (Object)interfaceTree.interface().packageId());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return interfaceTree.process((Function1<NodeWithContext, Future<BoxedUnit>>)(Function1 & Serializable)x$18 -> MODULE$.backend().process((NodeWithContext)x$18, conf, packagePrefixes, ec), ec).map((Function1 & Serializable)x$19 -> {
            CodeGenRunner$.$anonfun$processInterfaceTree$2(interfaceTree, x$19);
            return BoxedUnit.UNIT;
        }, ec);
    }

    public void assertInputFileExists(Path filePath) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Checking that the file '{}' exists", (Object)filePath);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (Files.notExists(filePath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Input file '").append(filePath).append("' doesn't exist").toString());
        }
    }

    public void assertInputFileIsReadable(Path filePath) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Checking that the file '{}' is readable", (Object)filePath);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (!Files.isReadable(filePath)) {
            throw new IllegalArgumentException(new StringBuilder(29).append("Input file '").append(filePath).append("' is not readable").toString());
        }
    }

    public void checkAndCreateOutputDir(Path outputPath) {
        boolean exists = Files.exists(outputPath, new LinkOption[0]);
        if (!exists) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Output directory '{}' does not exists, creating it", (Object)outputPath);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Path path = Files.createDirectories(outputPath, new FileAttribute[0]);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else if (!Files.isDirectory(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringBuilder(52).append("Output directory '").append(outputPath).append("' exists but it is not a directory").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$run$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Path path = (Path)tuple2._1();
        MODULE$.assertInputFileExists(path);
        MODULE$.assertInputFileIsReadable(path);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final String resolveRef$1(PackageReference ref, Map metadata$1) {
        PackageReference packageReference = ref;
        if (!(packageReference instanceof PackageReference.NameVersion)) {
            throw new MatchError((Object)packageReference);
        }
        PackageReference.NameVersion nameVersion = (PackageReference.NameVersion)packageReference;
        String string = (String)metadata$1.getOrElse((Object)nameVersion, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(39).append("No package ").append(nameVersion).append(" found, available packages: ").append(metadata$1.keys().mkString(", ")).toString());
        });
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple2 $anonfun$resolvePackagePrefixes$5(Map pkgPrefixes$1, Map resolvedModulePrefixes$1, String k) {
        block5: {
            block6: {
                block4: {
                    var5_3 = new Tuple2((Object)pkgPrefixes$1.get((Object)k), (Object)resolvedModulePrefixes$1.get((Object)k));
                    if (var5_3 != null) {
                        var6_4 = (Option)var5_3._1();
                        var7_5 = (Option)var5_3._2();
                        if (None$.MODULE$.equals(var6_4) && None$.MODULE$.equals(var7_5)) {
                            throw new RuntimeException("Internal error: key in pkgPrefixes and resolvedModulePrefixes could not be found in either of them");
                        }
                    }
                    if (var5_3 == null) break block4;
                    var8_6 = (Option)var5_3._1();
                    var9_7 = (Option)var5_3._2();
                    if (!(var8_6 instanceof Some)) break block4;
                    var10_8 = (Some)var8_6;
                    a = (String)var10_8.value();
                    if (!None$.MODULE$.equals(var9_7)) break block4;
                    var3_10 = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(a), ".");
                    break block5;
                }
                if (var5_3 == null) break block6;
                var12_11 = (Option)var5_3._1();
                var13_12 = (Option)var5_3._2();
                if (!None$.MODULE$.equals(var12_11) || !(var13_12 instanceof Some)) break block6;
                var14_13 = (Some)var13_12;
                b = (String)var14_13.value();
                var3_10 = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(b), ".");
                break block5;
            }
            if (var5_3 == null) ** GOTO lbl-1000
            var16_15 = (Option)var5_3._1();
            var17_16 = (Option)var5_3._2();
            if (!(var16_15 instanceof Some)) ** GOTO lbl-1000
            var18_17 = (Some)var16_15;
            a = (String)var18_17.value();
            if (var17_16 instanceof Some) {
                var20_19 = (Some)var17_16;
                b = (String)var20_19.value();
                var3_10 = new StringBuilder(1).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(a), ".")).append(".").append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(b), ".")).toString();
            } else lbl-1000:
            // 3 sources

            {
                throw new MatchError((Object)var5_3);
            }
        }
        prefix = var3_10;
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)prefix);
    }

    public static final /* synthetic */ void $anonfun$detectModuleCollisions$9(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String m = (String)tuple2._1();
            Seq grouped = (Seq)tuple2._2();
            if (grouped.length() > 1) {
                String pkgIds = grouped.view().map((Function1 & Serializable)x$12 -> (String)x$12._2()).mkString(", ");
                throw new IllegalArgumentException(new StringBuilder(135).append("Duplicate module ").append(m).append(" found in multiple packages ").append(pkgIds).append(". To resolve the conflict rename the modules in one of the packages via `module-prefixes`.").toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$generateCode$4(List x$15) {
        List list = x$15;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$processInterfaceTree$2(InterfaceTree interfaceTree$1, BoxedUnit x$19) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2 = x$19;
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("Stop processing packageId '{}'", (Object)interfaceTree$1.interface().packageId());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit3 = boxedUnit;
    }

    private CodeGenRunner$() {
    }
}

