/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.GeneratedJavaParserConstants;
import com.github.javaparser.Range;
import com.github.javaparser.Token;
import com.github.javaparser.TokenTypes;
import com.github.javaparser.utils.LineSeparator;
import com.github.javaparser.utils.Utils;
import java.util.List;
import java.util.Optional;

public final class JavaToken {
    public static final JavaToken INVALID = new JavaToken();
    private Range range;
    private int kind;
    private String text;
    private JavaToken previousToken = null;
    private JavaToken nextToken = null;

    private JavaToken() {
        this(null, 0, "INVALID", null, null);
    }

    /*
     * WARNING - void declaration
     */
    public JavaToken(int kind, String text) {
        this(null, (int)var1_1, (String)var2_2, null, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    JavaToken(Token token, List<JavaToken> tokens) {
        void var3_3;
        Range range = Range.range(token.beginLine, token.beginColumn, token.endLine, token.endColumn);
        String text = token.image;
        if (token.kind == 150) {
            range = Range.range(token.beginLine, token.beginColumn, token.endLine, token.beginColumn);
            text = ">";
        } else if (token.kind == 149) {
            range = Range.range(token.beginLine, token.beginColumn, token.endLine, token.beginColumn + 1);
            text = ">>";
        }
        this.range = var3_3;
        this.kind = token.kind;
        this.text = text;
        if (!tokens.isEmpty()) {
            JavaToken previousToken;
            void var2_2;
            void v0 = var2_2;
            this.previousToken = previousToken = (JavaToken)v0.get(v0.size() - 1);
            var1_1.nextToken = this;
            return;
        }
        this.previousToken = null;
    }

    /*
     * WARNING - void declaration
     */
    public JavaToken(int kind) {
        void var2_2;
        void var1_1;
        int n;
        String content = GeneratedJavaParserConstants.tokenImage[kind];
        if (content.startsWith("\"")) {
            content = content.substring(1, content.length() - 1);
        }
        if (TokenTypes.getCategory(n = kind).isEndOfLine()) {
            content = LineSeparator.SYSTEM.asRawString();
        } else {
            n = kind;
            if (TokenTypes.getCategory(n).isWhitespace()) {
                content = " ";
            }
        }
        this.kind = var1_1;
        this.text = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private JavaToken(Range range, int kind, String text, JavaToken previousToken, JavaToken nextToken) {
        void var3_3;
        void var2_2;
        Utils.assertNotNull(text);
        this.range = null;
        this.kind = var2_2;
        this.text = var3_3;
        this.previousToken = null;
        this.nextToken = null;
    }

    public final Optional<Range> getRange() {
        return Optional.ofNullable(this.range);
    }

    public final boolean hasRange() {
        JavaToken javaToken = this;
        return Optional.ofNullable(javaToken.range).isPresent();
    }

    public final int getKind() {
        return this.kind;
    }

    /*
     * WARNING - void declaration
     */
    final void setKind(int kind) {
        void var1_1;
        this.kind = var1_1;
    }

    public final String getText() {
        return this.text;
    }

    public final Optional<JavaToken> getNextToken() {
        return Optional.ofNullable(this.nextToken);
    }

    public final Optional<JavaToken> getPreviousToken() {
        return Optional.ofNullable(this.previousToken);
    }

    public final String asString() {
        return this.text;
    }

    public final String toString() {
        Object object = this;
        String text = ((JavaToken)object).text.replace("\n", "\\n").replace("\r", "\\r").replace("\r\n", "\\r\\n").replace("\t", "\\t");
        Object[] objectArray = new Object[3];
        objectArray[0] = object;
        object = this;
        objectArray[1] = ((JavaToken)object).kind;
        object = this;
        objectArray[2] = Optional.ofNullable(((JavaToken)object).range).map(Range::toString).orElse("(?)-(?)");
        Object[] objectArray2 = objectArray;
        object = "\"%s\"   <%s>   %s";
        return String.format("\"%s\"   <%s>   %s", objectArray2);
    }

    public final boolean valid() {
        return !this.invalid();
    }

    public final boolean invalid() {
        return this == INVALID;
    }

    public final Category getCategory() {
        return TokenTypes.getCategory(this.kind);
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result = this.kind;
        var1_1 = var1_1 * 31 + this.text.hashCode();
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaToken javaToken = (JavaToken)o;
        if (this.kind != javaToken.kind) {
            return false;
        }
        return this.text.equals(var1_1.text);
    }

    public static final class Kind
    extends Enum<Kind> {
        private static /* enum */ Kind EOF = new Kind(0);
        public static final /* enum */ Kind SPACE = new Kind(1);
        private static /* enum */ Kind WINDOWS_EOL = new Kind(2);
        private static /* enum */ Kind UNIX_EOL = new Kind(3);
        private static /* enum */ Kind OLD_MAC_EOL = new Kind(4);
        private static /* enum */ Kind SINGLE_LINE_COMMENT = new Kind(5);
        private static /* enum */ Kind ENTER_JAVADOC_COMMENT = new Kind(6);
        private static /* enum */ Kind ENTER_MULTILINE_COMMENT = new Kind(7);
        private static /* enum */ Kind JAVADOC_COMMENT = new Kind(8);
        private static /* enum */ Kind MULTI_LINE_COMMENT = new Kind(9);
        private static /* enum */ Kind COMMENT_CONTENT = new Kind(10);
        private static /* enum */ Kind ABSTRACT = new Kind(11);
        private static /* enum */ Kind ASSERT = new Kind(12);
        private static /* enum */ Kind BOOLEAN = new Kind(13);
        private static /* enum */ Kind BREAK = new Kind(14);
        public static final /* enum */ Kind BYTE = new Kind(15);
        private static /* enum */ Kind CASE = new Kind(16);
        private static /* enum */ Kind CATCH = new Kind(17);
        public static final /* enum */ Kind CHAR = new Kind(18);
        private static /* enum */ Kind CLASS = new Kind(19);
        private static /* enum */ Kind CONST = new Kind(20);
        private static /* enum */ Kind CONTINUE = new Kind(21);
        private static /* enum */ Kind _DEFAULT = new Kind(22);
        private static /* enum */ Kind DO = new Kind(23);
        public static final /* enum */ Kind DOUBLE = new Kind(24);
        private static /* enum */ Kind ELSE = new Kind(25);
        private static /* enum */ Kind ENUM = new Kind(26);
        private static /* enum */ Kind EXTENDS = new Kind(27);
        private static /* enum */ Kind FALSE = new Kind(28);
        private static /* enum */ Kind FINAL = new Kind(29);
        private static /* enum */ Kind FINALLY = new Kind(30);
        public static final /* enum */ Kind FLOAT = new Kind(31);
        private static /* enum */ Kind FOR = new Kind(32);
        private static /* enum */ Kind GOTO = new Kind(33);
        private static /* enum */ Kind IF = new Kind(34);
        private static /* enum */ Kind IMPLEMENTS = new Kind(35);
        private static /* enum */ Kind IMPORT = new Kind(36);
        private static /* enum */ Kind INSTANCEOF = new Kind(37);
        public static final /* enum */ Kind INT = new Kind(38);
        private static /* enum */ Kind INTERFACE = new Kind(39);
        public static final /* enum */ Kind LONG = new Kind(40);
        private static /* enum */ Kind NATIVE = new Kind(41);
        private static /* enum */ Kind NEW = new Kind(42);
        private static /* enum */ Kind NON_SEALED = new Kind(43);
        private static /* enum */ Kind NULL = new Kind(44);
        private static /* enum */ Kind PACKAGE = new Kind(45);
        private static /* enum */ Kind PERMITS = new Kind(46);
        private static /* enum */ Kind PRIVATE = new Kind(47);
        private static /* enum */ Kind PROTECTED = new Kind(48);
        private static /* enum */ Kind PUBLIC = new Kind(49);
        private static /* enum */ Kind RECORD = new Kind(50);
        private static /* enum */ Kind RETURN = new Kind(51);
        private static /* enum */ Kind SEALED = new Kind(52);
        public static final /* enum */ Kind SHORT = new Kind(53);
        private static /* enum */ Kind STATIC = new Kind(54);
        private static /* enum */ Kind STRICTFP = new Kind(55);
        private static /* enum */ Kind SUPER = new Kind(56);
        private static /* enum */ Kind SWITCH = new Kind(57);
        private static /* enum */ Kind SYNCHRONIZED = new Kind(58);
        private static /* enum */ Kind THIS = new Kind(59);
        private static /* enum */ Kind THROW = new Kind(60);
        private static /* enum */ Kind THROWS = new Kind(61);
        private static /* enum */ Kind TRANSIENT = new Kind(62);
        private static /* enum */ Kind TRUE = new Kind(63);
        private static /* enum */ Kind TRY = new Kind(64);
        private static /* enum */ Kind VOID = new Kind(65);
        private static /* enum */ Kind VOLATILE = new Kind(66);
        private static /* enum */ Kind WHILE = new Kind(67);
        private static /* enum */ Kind YIELD = new Kind(68);
        private static /* enum */ Kind REQUIRES = new Kind(69);
        private static /* enum */ Kind TO = new Kind(70);
        private static /* enum */ Kind WITH = new Kind(71);
        private static /* enum */ Kind OPEN = new Kind(72);
        private static /* enum */ Kind OPENS = new Kind(73);
        private static /* enum */ Kind USES = new Kind(74);
        private static /* enum */ Kind MODULE = new Kind(75);
        private static /* enum */ Kind EXPORTS = new Kind(76);
        private static /* enum */ Kind PROVIDES = new Kind(77);
        private static /* enum */ Kind TRANSITIVE = new Kind(78);
        private static /* enum */ Kind WHEN = new Kind(79);
        private static /* enum */ Kind LONG_LITERAL = new Kind(80);
        private static /* enum */ Kind INTEGER_LITERAL = new Kind(81);
        private static /* enum */ Kind DECIMAL_LITERAL = new Kind(82);
        private static /* enum */ Kind HEX_LITERAL = new Kind(83);
        private static /* enum */ Kind OCTAL_LITERAL = new Kind(84);
        private static /* enum */ Kind BINARY_LITERAL = new Kind(85);
        private static /* enum */ Kind FLOATING_POINT_LITERAL = new Kind(86);
        private static /* enum */ Kind DECIMAL_FLOATING_POINT_LITERAL = new Kind(87);
        private static /* enum */ Kind DECIMAL_EXPONENT = new Kind(88);
        private static /* enum */ Kind HEXADECIMAL_FLOATING_POINT_LITERAL = new Kind(89);
        private static /* enum */ Kind HEXADECIMAL_EXPONENT = new Kind(90);
        private static /* enum */ Kind HEX_DIGITS = new Kind(91);
        private static /* enum */ Kind UNICODE_ESCAPE = new Kind(92);
        private static /* enum */ Kind CHARACTER_LITERAL = new Kind(93);
        private static /* enum */ Kind STRING_LITERAL = new Kind(94);
        private static /* enum */ Kind ENTER_TEXT_BLOCK = new Kind(95);
        private static /* enum */ Kind TEXT_BLOCK_LITERAL = new Kind(96);
        private static /* enum */ Kind TEXT_BLOCK_CONTENT = new Kind(97);
        private static /* enum */ Kind IDENTIFIER = new Kind(98);
        private static /* enum */ Kind LETTER = new Kind(99);
        private static /* enum */ Kind PART_LETTER = new Kind(100);
        private static /* enum */ Kind LPAREN = new Kind(101);
        private static /* enum */ Kind RPAREN = new Kind(102);
        private static /* enum */ Kind LBRACE = new Kind(103);
        private static /* enum */ Kind RBRACE = new Kind(104);
        public static final /* enum */ Kind LBRACKET = new Kind(105);
        public static final /* enum */ Kind RBRACKET = new Kind(106);
        private static /* enum */ Kind SEMICOLON = new Kind(107);
        private static /* enum */ Kind COMMA = new Kind(108);
        private static /* enum */ Kind DOT = new Kind(109);
        private static /* enum */ Kind ELLIPSIS = new Kind(110);
        private static /* enum */ Kind AT = new Kind(111);
        private static /* enum */ Kind DOUBLECOLON = new Kind(112);
        private static /* enum */ Kind ASSIGN = new Kind(113);
        public static final /* enum */ Kind LT = new Kind(114);
        private static /* enum */ Kind BANG = new Kind(115);
        private static /* enum */ Kind TILDE = new Kind(116);
        private static /* enum */ Kind HOOK = new Kind(117);
        private static /* enum */ Kind COLON = new Kind(118);
        private static /* enum */ Kind ARROW = new Kind(119);
        private static /* enum */ Kind EQ = new Kind(120);
        private static /* enum */ Kind GE = new Kind(121);
        private static /* enum */ Kind LE = new Kind(122);
        private static /* enum */ Kind NE = new Kind(123);
        private static /* enum */ Kind SC_AND = new Kind(124);
        private static /* enum */ Kind SC_OR = new Kind(125);
        private static /* enum */ Kind INCR = new Kind(126);
        private static /* enum */ Kind DECR = new Kind(127);
        private static /* enum */ Kind PLUS = new Kind(128);
        private static /* enum */ Kind MINUS = new Kind(129);
        private static /* enum */ Kind STAR = new Kind(130);
        private static /* enum */ Kind SLASH = new Kind(131);
        private static /* enum */ Kind BIT_AND = new Kind(132);
        private static /* enum */ Kind BIT_OR = new Kind(133);
        private static /* enum */ Kind XOR = new Kind(134);
        private static /* enum */ Kind REM = new Kind(135);
        private static /* enum */ Kind LSHIFT = new Kind(136);
        private static /* enum */ Kind PLUSASSIGN = new Kind(137);
        private static /* enum */ Kind MINUSASSIGN = new Kind(138);
        private static /* enum */ Kind STARASSIGN = new Kind(139);
        private static /* enum */ Kind SLASHASSIGN = new Kind(140);
        private static /* enum */ Kind ANDASSIGN = new Kind(141);
        private static /* enum */ Kind ORASSIGN = new Kind(142);
        private static /* enum */ Kind XORASSIGN = new Kind(143);
        private static /* enum */ Kind REMASSIGN = new Kind(144);
        private static /* enum */ Kind LSHIFTASSIGN = new Kind(145);
        private static /* enum */ Kind RSIGNEDSHIFTASSIGN = new Kind(146);
        private static /* enum */ Kind RUNSIGNEDSHIFTASSIGN = new Kind(147);
        private static /* enum */ Kind RUNSIGNEDSHIFT = new Kind(148);
        private static /* enum */ Kind RSIGNEDSHIFT = new Kind(149);
        public static final /* enum */ Kind GT = new Kind(150);
        private static /* enum */ Kind CTRL_Z = new Kind(151);
        private final int kind;

        /*
         * WARNING - void declaration
         */
        private Kind(int kind) {
            void var3_3;
            this.kind = var3_3;
        }

        public static Kind valueOf(int kind) {
            int n;
            switch (kind) {
                case 151: {
                    return CTRL_Z;
                }
                case 150: {
                    return GT;
                }
                case 149: {
                    return RSIGNEDSHIFT;
                }
                case 148: {
                    return RUNSIGNEDSHIFT;
                }
                case 147: {
                    return RUNSIGNEDSHIFTASSIGN;
                }
                case 146: {
                    return RSIGNEDSHIFTASSIGN;
                }
                case 145: {
                    return LSHIFTASSIGN;
                }
                case 144: {
                    return REMASSIGN;
                }
                case 143: {
                    return XORASSIGN;
                }
                case 142: {
                    return ORASSIGN;
                }
                case 141: {
                    return ANDASSIGN;
                }
                case 140: {
                    return SLASHASSIGN;
                }
                case 139: {
                    return STARASSIGN;
                }
                case 138: {
                    return MINUSASSIGN;
                }
                case 137: {
                    return PLUSASSIGN;
                }
                case 136: {
                    return LSHIFT;
                }
                case 135: {
                    return REM;
                }
                case 134: {
                    return XOR;
                }
                case 133: {
                    return BIT_OR;
                }
                case 132: {
                    return BIT_AND;
                }
                case 131: {
                    return SLASH;
                }
                case 130: {
                    return STAR;
                }
                case 129: {
                    return MINUS;
                }
                case 128: {
                    return PLUS;
                }
                case 127: {
                    return DECR;
                }
                case 126: {
                    return INCR;
                }
                case 125: {
                    return SC_OR;
                }
                case 124: {
                    return SC_AND;
                }
                case 123: {
                    return NE;
                }
                case 122: {
                    return LE;
                }
                case 121: {
                    return GE;
                }
                case 120: {
                    return EQ;
                }
                case 119: {
                    return ARROW;
                }
                case 118: {
                    return COLON;
                }
                case 117: {
                    return HOOK;
                }
                case 116: {
                    return TILDE;
                }
                case 115: {
                    return BANG;
                }
                case 114: {
                    return LT;
                }
                case 113: {
                    return ASSIGN;
                }
                case 112: {
                    return DOUBLECOLON;
                }
                case 111: {
                    return AT;
                }
                case 110: {
                    return ELLIPSIS;
                }
                case 109: {
                    return DOT;
                }
                case 108: {
                    return COMMA;
                }
                case 107: {
                    return SEMICOLON;
                }
                case 106: {
                    return RBRACKET;
                }
                case 105: {
                    return LBRACKET;
                }
                case 104: {
                    return RBRACE;
                }
                case 103: {
                    return LBRACE;
                }
                case 102: {
                    return RPAREN;
                }
                case 101: {
                    return LPAREN;
                }
                case 100: {
                    return PART_LETTER;
                }
                case 99: {
                    return LETTER;
                }
                case 98: {
                    return IDENTIFIER;
                }
                case 97: {
                    return TEXT_BLOCK_CONTENT;
                }
                case 96: {
                    return TEXT_BLOCK_LITERAL;
                }
                case 95: {
                    return ENTER_TEXT_BLOCK;
                }
                case 94: {
                    return STRING_LITERAL;
                }
                case 93: {
                    return CHARACTER_LITERAL;
                }
                case 92: {
                    return UNICODE_ESCAPE;
                }
                case 91: {
                    return HEX_DIGITS;
                }
                case 90: {
                    return HEXADECIMAL_EXPONENT;
                }
                case 89: {
                    return HEXADECIMAL_FLOATING_POINT_LITERAL;
                }
                case 88: {
                    return DECIMAL_EXPONENT;
                }
                case 87: {
                    return DECIMAL_FLOATING_POINT_LITERAL;
                }
                case 86: {
                    return FLOATING_POINT_LITERAL;
                }
                case 85: {
                    return BINARY_LITERAL;
                }
                case 84: {
                    return OCTAL_LITERAL;
                }
                case 83: {
                    return HEX_LITERAL;
                }
                case 82: {
                    return DECIMAL_LITERAL;
                }
                case 81: {
                    return INTEGER_LITERAL;
                }
                case 80: {
                    return LONG_LITERAL;
                }
                case 79: {
                    return WHEN;
                }
                case 78: {
                    return TRANSITIVE;
                }
                case 77: {
                    return PROVIDES;
                }
                case 76: {
                    return EXPORTS;
                }
                case 75: {
                    return MODULE;
                }
                case 74: {
                    return USES;
                }
                case 73: {
                    return OPENS;
                }
                case 72: {
                    return OPEN;
                }
                case 71: {
                    return WITH;
                }
                case 70: {
                    return TO;
                }
                case 69: {
                    return REQUIRES;
                }
                case 68: {
                    return YIELD;
                }
                case 67: {
                    return WHILE;
                }
                case 66: {
                    return VOLATILE;
                }
                case 65: {
                    return VOID;
                }
                case 64: {
                    return TRY;
                }
                case 63: {
                    return TRUE;
                }
                case 62: {
                    return TRANSIENT;
                }
                case 61: {
                    return THROWS;
                }
                case 60: {
                    return THROW;
                }
                case 59: {
                    return THIS;
                }
                case 58: {
                    return SYNCHRONIZED;
                }
                case 57: {
                    return SWITCH;
                }
                case 56: {
                    return SUPER;
                }
                case 55: {
                    return STRICTFP;
                }
                case 54: {
                    return STATIC;
                }
                case 53: {
                    return SHORT;
                }
                case 52: {
                    return SEALED;
                }
                case 51: {
                    return RETURN;
                }
                case 50: {
                    return RECORD;
                }
                case 49: {
                    return PUBLIC;
                }
                case 48: {
                    return PROTECTED;
                }
                case 47: {
                    return PRIVATE;
                }
                case 46: {
                    return PERMITS;
                }
                case 45: {
                    return PACKAGE;
                }
                case 44: {
                    return NULL;
                }
                case 43: {
                    return NON_SEALED;
                }
                case 42: {
                    return NEW;
                }
                case 41: {
                    return NATIVE;
                }
                case 40: {
                    return LONG;
                }
                case 39: {
                    return INTERFACE;
                }
                case 38: {
                    return INT;
                }
                case 37: {
                    return INSTANCEOF;
                }
                case 36: {
                    return IMPORT;
                }
                case 35: {
                    return IMPLEMENTS;
                }
                case 34: {
                    return IF;
                }
                case 33: {
                    return GOTO;
                }
                case 32: {
                    return FOR;
                }
                case 31: {
                    return FLOAT;
                }
                case 30: {
                    return FINALLY;
                }
                case 29: {
                    return FINAL;
                }
                case 28: {
                    return FALSE;
                }
                case 27: {
                    return EXTENDS;
                }
                case 26: {
                    return ENUM;
                }
                case 25: {
                    return ELSE;
                }
                case 24: {
                    return DOUBLE;
                }
                case 23: {
                    return DO;
                }
                case 22: {
                    return _DEFAULT;
                }
                case 21: {
                    return CONTINUE;
                }
                case 20: {
                    return CONST;
                }
                case 19: {
                    return CLASS;
                }
                case 18: {
                    return CHAR;
                }
                case 17: {
                    return CATCH;
                }
                case 16: {
                    return CASE;
                }
                case 15: {
                    return BYTE;
                }
                case 14: {
                    return BREAK;
                }
                case 13: {
                    return BOOLEAN;
                }
                case 12: {
                    return ASSERT;
                }
                case 11: {
                    return ABSTRACT;
                }
                case 10: {
                    return COMMENT_CONTENT;
                }
                case 9: {
                    return MULTI_LINE_COMMENT;
                }
                case 8: {
                    return JAVADOC_COMMENT;
                }
                case 7: {
                    return ENTER_MULTILINE_COMMENT;
                }
                case 6: {
                    return ENTER_JAVADOC_COMMENT;
                }
                case 5: {
                    return SINGLE_LINE_COMMENT;
                }
                case 4: {
                    return OLD_MAC_EOL;
                }
                case 3: {
                    return UNIX_EOL;
                }
                case 2: {
                    return WINDOWS_EOL;
                }
                case 1: {
                    return SPACE;
                }
                case 0: {
                    return EOF;
                }
            }
            Object[] objectArray = new Object[]{n};
            String string = "Token kind %i is unknown.";
            throw new IllegalArgumentException(String.format("Token kind %i is unknown.", objectArray));
        }

        public final int getKind() {
            return this.kind;
        }

        static {
            Kind[] kindArray = new Kind[]{EOF, SPACE, WINDOWS_EOL, UNIX_EOL, OLD_MAC_EOL, SINGLE_LINE_COMMENT, ENTER_JAVADOC_COMMENT, ENTER_MULTILINE_COMMENT, JAVADOC_COMMENT, MULTI_LINE_COMMENT, COMMENT_CONTENT, ABSTRACT, ASSERT, BOOLEAN, BREAK, BYTE, CASE, CATCH, CHAR, CLASS, CONST, CONTINUE, _DEFAULT, DO, DOUBLE, ELSE, ENUM, EXTENDS, FALSE, FINAL, FINALLY, FLOAT, FOR, GOTO, IF, IMPLEMENTS, IMPORT, INSTANCEOF, INT, INTERFACE, LONG, NATIVE, NEW, NON_SEALED, NULL, PACKAGE, PERMITS, PRIVATE, PROTECTED, PUBLIC, RECORD, RETURN, SEALED, SHORT, STATIC, STRICTFP, SUPER, SWITCH, SYNCHRONIZED, THIS, THROW, THROWS, TRANSIENT, TRUE, TRY, VOID, VOLATILE, WHILE, YIELD, REQUIRES, TO, WITH, OPEN, OPENS, USES, MODULE, EXPORTS, PROVIDES, TRANSITIVE, WHEN, LONG_LITERAL, INTEGER_LITERAL, DECIMAL_LITERAL, HEX_LITERAL, OCTAL_LITERAL, BINARY_LITERAL, FLOATING_POINT_LITERAL, DECIMAL_FLOATING_POINT_LITERAL, DECIMAL_EXPONENT, HEXADECIMAL_FLOATING_POINT_LITERAL, HEXADECIMAL_EXPONENT, HEX_DIGITS, UNICODE_ESCAPE, CHARACTER_LITERAL, STRING_LITERAL, ENTER_TEXT_BLOCK, TEXT_BLOCK_LITERAL, TEXT_BLOCK_CONTENT, IDENTIFIER, LETTER, PART_LETTER, LPAREN, RPAREN, LBRACE, RBRACE, LBRACKET, RBRACKET, SEMICOLON, COMMA, DOT, ELLIPSIS, AT, DOUBLECOLON, ASSIGN, LT, BANG, TILDE, HOOK, COLON, ARROW, EQ, GE, LE, NE, SC_AND, SC_OR, INCR, DECR, PLUS, MINUS, STAR, SLASH, BIT_AND, BIT_OR, XOR, REM, LSHIFT, PLUSASSIGN, MINUSASSIGN, STARASSIGN, SLASHASSIGN, ANDASSIGN, ORASSIGN, XORASSIGN, REMASSIGN, LSHIFTASSIGN, RSIGNEDSHIFTASSIGN, RUNSIGNEDSHIFTASSIGN, RUNSIGNEDSHIFT, RSIGNEDSHIFT, GT, CTRL_Z};
        }
    }

    public static final class Category
    extends Enum<Category> {
        public static final /* enum */ Category WHITESPACE_NO_EOL = new Category();
        public static final /* enum */ Category EOL = new Category();
        public static final /* enum */ Category COMMENT = new Category();
        public static final /* enum */ Category IDENTIFIER = new Category();
        public static final /* enum */ Category KEYWORD = new Category();
        public static final /* enum */ Category LITERAL = new Category();
        public static final /* enum */ Category SEPARATOR = new Category();
        public static final /* enum */ Category OPERATOR = new Category();

        public final boolean isWhitespace() {
            return this == WHITESPACE_NO_EOL || this == EOL;
        }

        public final boolean isEndOfLine() {
            return this == EOL;
        }

        public final boolean isComment() {
            return this == COMMENT;
        }

        public final boolean isWhitespaceButNotEndOfLine() {
            return this == WHITESPACE_NO_EOL;
        }

        static {
            Category[] categoryArray = new Category[]{WHITESPACE_NO_EOL, EOL, COMMENT, IDENTIFIER, KEYWORD, LITERAL, SEPARATOR, OPERATOR};
        }
    }
}

