/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.validator.language_level_validations.chunks;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.nodeTypes.NodeWithTokenRange;
import com.github.javaparser.ast.validator.ProblemReporter;
import com.github.javaparser.ast.validator.VisitorValidator;
import com.github.javaparser.utils.SeparatedItemStringBuilder;
import java.util.ArrayList;
import java.util.Arrays;

public final class ModifierValidator
extends VisitorValidator {
    private final Modifier.Keyword[] interfaceWithNothingSpecial = new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.PROTECTED, Modifier.Keyword.ABSTRACT, Modifier.Keyword.FINAL, Modifier.Keyword.SYNCHRONIZED, Modifier.Keyword.NATIVE, Modifier.Keyword.STRICTFP};
    private final Modifier.Keyword[] interfaceWithStaticAndDefault = new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.PROTECTED, Modifier.Keyword.ABSTRACT, Modifier.Keyword.STATIC, Modifier.Keyword.FINAL, Modifier.Keyword.SYNCHRONIZED, Modifier.Keyword.NATIVE, Modifier.Keyword.STRICTFP, Modifier.Keyword.DEFAULT};
    private final Modifier.Keyword[] interfaceWithStaticAndDefaultAndPrivate = new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.PROTECTED, Modifier.Keyword.PRIVATE, Modifier.Keyword.ABSTRACT, Modifier.Keyword.STATIC, Modifier.Keyword.FINAL, Modifier.Keyword.SYNCHRONIZED, Modifier.Keyword.NATIVE, Modifier.Keyword.STRICTFP, Modifier.Keyword.DEFAULT};
    private final boolean hasStrictfp;
    private final boolean hasDefaultAndStaticInterfaceMethods;
    private final boolean hasPrivateInterfaceMethods;

    /*
     * WARNING - void declaration
     */
    public ModifierValidator(boolean hasStrictfp, boolean hasDefaultAndStaticInterfaceMethods, boolean hasPrivateInterfaceMethods) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.hasStrictfp = var1_1;
        this.hasDefaultAndStaticInterfaceMethods = var2_2;
        this.hasPrivateInterfaceMethods = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private void validateInterfaceModifiers(TypeDeclaration<?> n, ProblemReporter reporter) {
        if (n.isTopLevelType()) {
            this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n, reporter, Modifier.Keyword.PUBLIC, Modifier.Keyword.ABSTRACT, Modifier.Keyword.STRICTFP, Modifier.Keyword.SEALED, Modifier.Keyword.NON_SEALED);
            return;
        }
        if (n.isNestedType()) {
            void var2_2;
            void var1_1;
            this.validateModifiers(var1_1, (ProblemReporter)var2_2, Modifier.Keyword.PUBLIC, Modifier.Keyword.PROTECTED, Modifier.Keyword.PRIVATE, Modifier.Keyword.ABSTRACT, Modifier.Keyword.STATIC, Modifier.Keyword.STRICTFP, Modifier.Keyword.SEALED, Modifier.Keyword.NON_SEALED);
        }
    }

    private <T extends NodeWithModifiers<?> & NodeWithTokenRange<?>> void validateModifiers(T n, ProblemReporter reporter, Modifier.Keyword ... allowedModifiers) {
        ModifierValidator.validateAtMostOneOf(n, reporter, new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.PROTECTED, Modifier.Keyword.PRIVATE});
        ModifierValidator.validateAtMostOneOf(n, reporter, new Modifier.Keyword[]{Modifier.Keyword.FINAL, Modifier.Keyword.ABSTRACT});
        if (this.hasStrictfp) {
            ModifierValidator.validateAtMostOneOf(n, reporter, new Modifier.Keyword[]{Modifier.Keyword.NATIVE, Modifier.Keyword.STRICTFP});
        } else {
            allowedModifiers = ModifierValidator.removeModifierFromArray(Modifier.Keyword.STRICTFP, allowedModifiers);
        }
        for (Modifier m : n.getModifiers()) {
            if (ModifierValidator.arrayContains$2fe83584(allowedModifiers, m.getKeyword())) continue;
            reporter.report((NodeWithTokenRange<?>)n, "'%s' is not allowed here.", m.getKeyword().asString());
        }
    }

    private static Modifier.Keyword[] removeModifierFromArray(Modifier.Keyword m, Modifier.Keyword[] allowedModifiers) {
        Modifier.Keyword[] keywordArray;
        Modifier.Keyword keyword;
        ArrayList<Modifier.Keyword> newModifiers = new ArrayList<Modifier.Keyword>(Arrays.asList(allowedModifiers));
        newModifiers.remove((Object)keyword);
        keywordArray = keywordArray.toArray(new Modifier.Keyword[0]);
        return keywordArray;
    }

    private static boolean arrayContains$2fe83584(Modifier.Keyword[] items, Modifier.Keyword searchItem) {
        Modifier.Keyword[] keywordArray = items;
        int n = items.length;
        for (int i = 0; i < n; ++i) {
            Modifier.Keyword keyword = keywordArray[i];
            if (keyword != searchItem) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends NodeWithModifiers<?> & NodeWithTokenRange<?>> void validateAtMostOneOf(T t, ProblemReporter reporter, Modifier.Keyword ... modifiers) {
        ArrayList<Modifier.Keyword> foundModifiers = new ArrayList<Modifier.Keyword>();
        for (Modifier.Keyword m : modifiers) {
            if (!t.hasModifier(m)) continue;
            foundModifiers.add(m);
        }
        if (foundModifiers.size() > 1) {
            void var2_2;
            T t2;
            void var1_1;
            void var3_3;
            SeparatedItemStringBuilder builder = new SeparatedItemStringBuilder("Can have only one of '", "', '", "'.");
            for (Modifier.Keyword m : var3_3) {
                builder.append(m.asString(), new Object[0]);
            }
            var1_1.report((NodeWithTokenRange<?>)t2, var2_2.toString(), new Object[0]);
        }
    }
}

