/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.utils;

import java.util.Optional;

public final class LineSeparator
extends Enum<LineSeparator> {
    public static final /* enum */ LineSeparator CR = new LineSeparator("\r", "CR (\\r)");
    public static final /* enum */ LineSeparator LF = new LineSeparator("\n", "LF (\\n)");
    public static final /* enum */ LineSeparator CRLF = new LineSeparator("\r\n", "CRLF (\\r\\n)");
    public static final /* enum */ LineSeparator SYSTEM = new LineSeparator(System.getProperty("line.separator"), "SYSTEM : (" + System.getProperty("line.separator").replace("\r", "\\r").replace("\n", "\\n") + ")");
    private static /* enum */ LineSeparator ARBITRARY = new LineSeparator("\n", "ARBITRARY (\\n)");
    private static /* enum */ LineSeparator MIXED = new LineSeparator("", "MIXED");
    private static /* enum */ LineSeparator UNKNOWN = new LineSeparator("", "UNKNOWN");
    private static /* enum */ LineSeparator NONE = new LineSeparator("", "NONE");
    private final String text;
    private final String description;

    /*
     * WARNING - void declaration
     */
    private LineSeparator(String text, String description) {
        void var3_3;
        this.text = var3_3;
        this.description = description;
    }

    /*
     * WARNING - void declaration
     */
    public static LineSeparator getLineEnding(int countCr, int countLf, int countCrLf) {
        void var2_2;
        void var1_1;
        int n;
        boolean bl = countCr == 0 && countLf == 0 && countCrLf == 0;
        if (bl) {
            return NONE;
        }
        bl = countCr > 0 && countLf == 0 && countCrLf == 0;
        if (bl) {
            return CR;
        }
        bl = countCr == 0 && countLf > 0 && countCrLf == 0;
        if (bl) {
            return LF;
        }
        if ((n = n == countLf && var1_1 == var2_2 ? 1 : 0) != 0) {
            return CRLF;
        }
        return MIXED;
    }

    public static Optional<LineSeparator> lookup(String ending) {
        String string;
        LineSeparator lineSeparator = CR;
        if (lineSeparator.text.equals(ending)) {
            return Optional.of(CR);
        }
        lineSeparator = LF;
        if (lineSeparator.text.equals(ending)) {
            return Optional.of(LF);
        }
        lineSeparator = CRLF;
        if (lineSeparator.text.equals(string)) {
            return Optional.of(CRLF);
        }
        return Optional.empty();
    }

    public static Optional<LineSeparator> lookupEscaped(String ending) {
        String string;
        if (CR.asEscapedString().equals(ending)) {
            return Optional.of(CR);
        }
        if (LF.asEscapedString().equals(ending)) {
            return Optional.of(LF);
        }
        if (CRLF.asEscapedString().equals(string)) {
            return Optional.of(CRLF);
        }
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equalsString(LineSeparator lineSeparator) {
        void var1_1;
        return this.text.equals(var1_1.text);
    }

    public final boolean isStandardEol() {
        return this.equalsString(CR) || this.equalsString(LF) || this.equalsString(CRLF);
    }

    private String asEscapedString() {
        String string = this.text.replace("\r", "\\r").replace("\n", "\\n");
        return string;
    }

    public final String asRawString() {
        return this.text;
    }

    public final String toString() {
        LineSeparator lineSeparator = this;
        return lineSeparator.text;
    }

    static {
        LineSeparator[] lineSeparatorArray = new LineSeparator[]{CR, LF, CRLF, SYSTEM, ARBITRARY, MIXED, UNKNOWN, NONE};
    }
}

