/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Strings;

public final class Preconditions {
    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            void var1_1;
            throw new IllegalArgumentException(String.valueOf(var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean expression, String errorMessageTemplate, char p1) {
        if (!expression) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, Character.valueOf((char)var2_2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean expression, String errorMessageTemplate, int p1) {
        if (!expression) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, (int)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean expression, String errorMessageTemplate, long p1) {
        if (!expression) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, (long)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean expression, String errorMessageTemplate, Object p1) {
        if (!expression) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean expression, String errorMessageTemplate, int p1, int p2) {
        if (!expression) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, (int)var2_2, (int)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkArgument(boolean expression, String errorMessageTemplate, Object p1, Object p2) {
        if (!expression) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(Strings.lenientFormat((String)var1_1, var2_2, var3_3));
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkState(boolean expression, Object errorMessage) {
        if (!expression) {
            void var1_1;
            throw new IllegalStateException(String.valueOf(var1_1));
        }
    }

    public static <T> T checkNotNull(T reference) {
        T t;
        if (reference == null) {
            throw new NullPointerException();
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T reference, Object errorMessage) {
        T t;
        if (reference == null) {
            void var1_1;
            throw new NullPointerException(String.valueOf(var1_1));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static int checkElementIndex(int index, int size) {
        void var1_1;
        String string = "index";
        int n = index;
        if (n < 0 || n >= var1_1) {
            String string2;
            if (n < 0) {
                string2 = Strings.lenientFormat("%s (%s) must not be negative", string, n);
            } else {
                if (var1_1 < 0) {
                    throw new IllegalArgumentException("negative size: " + (int)var1_1);
                }
                string2 = Strings.lenientFormat("%s (%s) must be less than size (%s)", string, n, (int)var1_1);
            }
            throw new IndexOutOfBoundsException(string2);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static int checkPositionIndex(int index, int size) {
        void var1_1;
        return Preconditions.checkPositionIndex(index, (int)var1_1, "index");
    }

    /*
     * WARNING - void declaration
     */
    private static int checkPositionIndex(int index, int size, String desc) {
        int n;
        if (index < 0 || index > size) {
            void var2_2;
            void var1_1;
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(index, (int)var1_1, (String)var2_2));
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static String badPositionIndex(int index, int size, String desc) {
        void var1_1;
        int n;
        void var2_2;
        if (index < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", desc, index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return Strings.lenientFormat("%s (%s) must not be greater than size (%s)", var2_2, n, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void checkPositionIndexes(int start, int end, int size) {
        if (start < 0 || end < start || end > size) {
            void var1_1;
            void var2_2;
            int n;
            throw new IndexOutOfBoundsException(n < 0 || n > var2_2 ? Preconditions.badPositionIndex(n, (int)var2_2, "start index") : (var1_1 < 0 || var1_1 > var2_2 ? Preconditions.badPositionIndex((int)var1_1, (int)var2_2, "end index") : Strings.lenientFormat("end index (%s) must not be less than start index (%s)", (int)var1_1, n)));
        }
    }
}

