/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultimap;
import com.google.common.collect.AbstractSetMultimap;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.Spliterator;

abstract class AbstractMapBasedMultimap<K, V>
extends AbstractMultimap<K, V>
implements Serializable {
    private transient Map<K, Collection<V>> map;
    private transient int totalSize;

    /*
     * WARNING - void declaration
     */
    protected AbstractMapBasedMultimap(Map<K, Collection<V>> map) {
        void var1_1;
        Preconditions.checkArgument(map.isEmpty());
        this.map = var1_1;
    }

    abstract Collection<V> createCollection();

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        return this.map.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean put(K key, V value) {
        void var2_2;
        void var3_3;
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            collection = this;
            if ((collection = ((AbstractMapBasedMultimap)((Object)collection)).createCollection()).add(value)) {
                void var1_1;
                ++this.totalSize;
                this.map.put(var1_1, collection);
                return true;
            }
            throw new AssertionError((Object)"New Collection violated the Collection spec");
        }
        if (var3_3.add(var2_2)) {
            ++this.totalSize;
            return true;
        }
        return false;
    }

    public void clear() {
        for (Collection<V> collection : this.map.values()) {
            collection.clear();
        }
        this.map.clear();
        this.totalSize = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<V> get(K key) {
        void var2_2;
        void var1_1;
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            collection = this;
            collection = ((AbstractMapBasedMultimap)((Object)collection)).createCollection();
        }
        return this.wrapCollection(var1_1, (Collection<V>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    Collection<V> wrapCollection(K key, Collection<V> collection) {
        void var2_2;
        void var1_1;
        return new WrappedCollection(this, var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    final List<V> wrapList$255413ae(K key, List<V> list2, WrappedCollection ancestor) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (list2 instanceof RandomAccess) {
            return new RandomAccessWrappedList(this, key, list2, ancestor);
        }
        return new WrappedList(var1_1, var2_2, (WrappedCollection)var3_3);
    }

    @Override
    final Set<K> createKeySet$6051c6a4() {
        AbstractMapBasedMultimap abstractMapBasedMultimap = this;
        return abstractMapBasedMultimap.new KeySet(abstractMapBasedMultimap.map);
    }

    @Override
    final Map<K, Collection<V>> createAsMap$604efcea() {
        AbstractMapBasedMultimap abstractMapBasedMultimap = this;
        return abstractMapBasedMultimap.new AsMap(abstractMapBasedMultimap.map);
    }

    static /* synthetic */ Iterator access$100(Collection x0) {
        Collection collection = x0;
        if (collection instanceof List) {
            return ((List)collection).listIterator();
        }
        return collection.iterator();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$212(AbstractMapBasedMultimap x0, int x1) {
        void var1_1;
        return x0.totalSize += var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$220(AbstractMapBasedMultimap x0, int x1) {
        void var1_1;
        return x0.totalSize -= var1_1;
    }

    static /* synthetic */ void access$300(AbstractMapBasedMultimap x0, Object x1) {
        Collection collection;
        AbstractMapBasedMultimap abstractMapBasedMultimap = x0;
        if ((collection = Maps.safeRemove(abstractMapBasedMultimap.map, collection)) != null) {
            int n = collection.size();
            collection.clear();
            abstractMapBasedMultimap.totalSize -= n;
        }
    }

    class WrappedCollection
    extends AbstractCollection<V> {
        final K key;
        Collection<V> delegate;
        final WrappedCollection ancestor;
        private Collection<V> ancestorDelegate;
        final /* synthetic */ AbstractMapBasedMultimap this$0;

        /*
         * WARNING - void declaration
         */
        WrappedCollection(AbstractMapBasedMultimap this$0, K key, Collection<V> delegate, WrappedCollection ancestor) {
            Collection collection;
            void var3_3;
            void var2_2;
            WrappedCollection wrappedCollection;
            this.this$0 = wrappedCollection;
            this.key = var2_2;
            this.delegate = var3_3;
            this.ancestor = ancestor;
            if (ancestor == null) {
                collection = null;
            } else {
                wrappedCollection = ancestor;
                collection = wrappedCollection.delegate;
            }
            this.ancestorDelegate = collection;
        }

        /*
         * WARNING - void declaration
         */
        final void refreshIfEmpty() {
            Collection newDelegate;
            if (this.ancestor != null) {
                this.ancestor.refreshIfEmpty();
                WrappedCollection wrappedCollection = this.ancestor;
                if (wrappedCollection.delegate != this.ancestorDelegate) {
                    throw new ConcurrentModificationException();
                }
            } else if (this.delegate.isEmpty() && (newDelegate = (Collection)this.this$0.map.get(this.key)) != null) {
                void var1_2;
                this.delegate = var1_2;
            }
        }

        final void removeIfEmpty() {
            if (this.ancestor != null) {
                this.ancestor.removeIfEmpty();
                return;
            }
            if (this.delegate.isEmpty()) {
                this.this$0.map.remove(this.key);
            }
        }

        final void addToMap() {
            if (this.ancestor != null) {
                this.ancestor.addToMap();
                return;
            }
            this.this$0.map.put(this.key, this.delegate);
        }

        @Override
        public int size() {
            this.refreshIfEmpty();
            return this.delegate.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            void var1_1;
            if (object == this) {
                return true;
            }
            this.refreshIfEmpty();
            return this.delegate.equals(var1_1);
        }

        @Override
        public int hashCode() {
            this.refreshIfEmpty();
            return this.delegate.hashCode();
        }

        @Override
        public String toString() {
            this.refreshIfEmpty();
            return this.delegate.toString();
        }

        @Override
        public Iterator<V> iterator() {
            this.refreshIfEmpty();
            return new WrappedIterator(this);
        }

        @Override
        public Spliterator<V> spliterator() {
            this.refreshIfEmpty();
            return this.delegate.spliterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean add(V value) {
            void var1_2;
            this.refreshIfEmpty();
            boolean wasEmpty = this.delegate.isEmpty();
            boolean changed = this.delegate.add(value);
            if (changed) {
                void var2_3;
                this.this$0.totalSize++;
                if (var2_3 != false) {
                    this.addToMap();
                }
            }
            return (boolean)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean addAll(Collection<? extends V> collection) {
            void var1_2;
            if (collection.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.delegate.addAll(collection);
            if (changed) {
                void var2_3;
                void var3_4;
                int newSize = this.delegate.size();
                AbstractMapBasedMultimap.access$212(this.this$0, (int)(var3_4 - oldSize));
                if (var2_3 == false) {
                    this.addToMap();
                }
            }
            return (boolean)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            this.refreshIfEmpty();
            return this.delegate.contains(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            void var1_1;
            this.refreshIfEmpty();
            return this.delegate.containsAll((Collection<?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void clear() {
            void var1_1;
            int oldSize = this.size();
            if (oldSize == 0) {
                return;
            }
            this.delegate.clear();
            AbstractMapBasedMultimap.access$220(this.this$0, (int)var1_1);
            this.removeIfEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            void var1_2;
            this.refreshIfEmpty();
            boolean changed = this.delegate.remove(o);
            if (changed) {
                this.this$0.totalSize--;
                this.removeIfEmpty();
            }
            return (boolean)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            void var1_2;
            if (c.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.delegate.removeAll(c);
            if (changed) {
                void var2_3;
                void var3_4;
                int newSize = this.delegate.size();
                AbstractMapBasedMultimap.access$212(this.this$0, (int)(var3_4 - var2_3));
                this.removeIfEmpty();
            }
            return (boolean)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            void var1_2;
            Preconditions.checkNotNull(c);
            int oldSize = this.size();
            boolean changed = this.delegate.retainAll(c);
            if (changed) {
                void var2_3;
                void var3_4;
                int newSize = this.delegate.size();
                AbstractMapBasedMultimap.access$212(this.this$0, (int)(var3_4 - var2_3));
                this.removeIfEmpty();
            }
            return (boolean)var1_2;
        }

        class WrappedIterator
        implements Iterator<V> {
            final Iterator<V> delegateIterator;
            private Collection<V> originalDelegate;
            private /* synthetic */ WrappedCollection this$1;

            /*
             * WARNING - void declaration
             */
            WrappedIterator(WrappedCollection this$1) {
                void var1_1;
                this.this$1 = this$1;
                this.originalDelegate = this.this$1.delegate;
                this.delegateIterator = AbstractMapBasedMultimap.access$100(var1_1.delegate);
            }

            /*
             * WARNING - void declaration
             */
            WrappedIterator(WrappedList this$1, Iterator<V> delegateIterator) {
                void var2_2;
                void var1_1;
                this.this$1 = var1_1;
                this.originalDelegate = this.this$1.delegate;
                this.delegateIterator = var2_2;
            }

            final void validateIterator() {
                this.this$1.refreshIfEmpty();
                if (this.this$1.delegate != this.originalDelegate) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                this.validateIterator();
                return this.delegateIterator.hasNext();
            }

            @Override
            public V next() {
                this.validateIterator();
                return this.delegateIterator.next();
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                this.this$1.this$0.totalSize--;
                this.this$1.removeIfEmpty();
            }
        }
    }

    private final class RandomAccessWrappedList
    extends WrappedList
    implements RandomAccess {
        private /* synthetic */ AbstractMapBasedMultimap this$0;

        /*
         * WARNING - void declaration
         */
        RandomAccessWrappedList(AbstractMapBasedMultimap abstractMapBasedMultimap, K key, List<V> delegate, WrappedCollection ancestor) {
            void var3_3;
            void var2_2;
            this.this$0 = abstractMapBasedMultimap;
            super(var2_2, var3_3, ancestor);
        }
    }

    class WrappedList
    extends WrappedCollection
    implements List<V> {
        /*
         * WARNING - void declaration
         */
        WrappedList(K key, List<V> delegate, WrappedCollection ancestor) {
            void var3_3;
            void var2_2;
            void var1_1;
            super((AbstractMapBasedMultimap)var1_1, var2_2, var3_3, ancestor);
        }

        final List<V> getListDelegate() {
            WrappedList wrappedList = this;
            return (List)wrappedList.delegate;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean addAll(int index, Collection<? extends V> c) {
            void var1_1;
            if (c.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.getListDelegate().addAll(index, c);
            if (changed) {
                void var3_4;
                void var2_3;
                c = this;
                int newSize = c.delegate.size();
                AbstractMapBasedMultimap.access$212(AbstractMapBasedMultimap.this, (int)(var2_3 - oldSize));
                if (var3_4 == false) {
                    this.addToMap();
                }
            }
            return (boolean)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(int index) {
            void var1_1;
            this.refreshIfEmpty();
            return this.getListDelegate().get((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V set(int index, V element) {
            void var2_2;
            void var1_1;
            this.refreshIfEmpty();
            return this.getListDelegate().set((int)var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void add(int index, V element) {
            void var3_4;
            void var2_2;
            void var1_1;
            this.refreshIfEmpty();
            WrappedList wrappedList = this;
            boolean wasEmpty = wrappedList.delegate.isEmpty();
            this.getListDelegate().add((int)var1_1, var2_2);
            AbstractMapBasedMultimap.this.totalSize++;
            if (var3_4 != false) {
                this.addToMap();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V remove(int index) {
            void var1_2;
            this.refreshIfEmpty();
            Object value = this.getListDelegate().remove(index);
            AbstractMapBasedMultimap.this.totalSize--;
            this.removeIfEmpty();
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Object o) {
            void var1_1;
            this.refreshIfEmpty();
            return this.getListDelegate().indexOf(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int lastIndexOf(Object o) {
            void var1_1;
            this.refreshIfEmpty();
            return this.getListDelegate().lastIndexOf(var1_1);
        }

        @Override
        public ListIterator<V> listIterator() {
            this.refreshIfEmpty();
            return new WrappedListIterator(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ListIterator<V> listIterator(int index) {
            void var1_1;
            this.refreshIfEmpty();
            return new WrappedListIterator(this, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<V> subList(int fromIndex, int toIndex) {
            WrappedCollection wrappedCollection;
            void var2_3;
            void var1_1;
            this.refreshIfEmpty();
            WrappedList wrappedList = this;
            Object k = wrappedList.key;
            List list2 = this.getListDelegate().subList((int)var1_1, (int)var2_3);
            WrappedList wrappedList2 = this;
            if (wrappedList2.ancestor == null) {
                wrappedCollection = this;
            } else {
                wrappedList2 = this;
                wrappedCollection = wrappedList2.ancestor;
            }
            return AbstractMapBasedMultimap.this.wrapList$255413ae(k, list2, wrappedCollection);
        }

        /*
         * Signature claims super is com.google.common.collect.AbstractMapBasedMultimap$WrappedCollection.WrappedIterator, not com.google.common.collect.AbstractMapBasedMultimap$WrappedCollection$WrappedIterator - discarding signature.
         */
        private final class WrappedListIterator
        extends WrappedCollection.WrappedIterator
        implements ListIterator {
            private /* synthetic */ WrappedList this$1;

            WrappedListIterator(WrappedList wrappedList) {
                this.this$1 = wrappedList;
                super(wrappedList);
            }

            /*
             * WARNING - void declaration
             */
            public WrappedListIterator(WrappedList wrappedList, int index) {
                void var2_2;
                this.this$1 = wrappedList;
                WrappedList wrappedList2 = wrappedList;
                super(wrappedList2, wrappedList2.getListDelegate().listIterator((int)var2_2));
            }

            private ListIterator<V> getDelegateListIterator() {
                WrappedListIterator wrappedListIterator = this;
                wrappedListIterator.validateIterator();
                return (ListIterator)wrappedListIterator.delegateIterator;
            }

            @Override
            public final boolean hasPrevious() {
                return this.getDelegateListIterator().hasPrevious();
            }

            public final V previous() {
                return this.getDelegateListIterator().previous();
            }

            @Override
            public final int nextIndex() {
                return this.getDelegateListIterator().nextIndex();
            }

            @Override
            public final int previousIndex() {
                return this.getDelegateListIterator().previousIndex();
            }

            /*
             * WARNING - void declaration
             */
            public final void set(V value) {
                void var1_1;
                this.getDelegateListIterator().set(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final void add(V value) {
                void var2_2;
                void var1_1;
                boolean wasEmpty = this.this$1.isEmpty();
                this.getDelegateListIterator().add(var1_1);
                this.this$1.AbstractMapBasedMultimap.this.totalSize++;
                if (var2_2 != false) {
                    this.this$1.addToMap();
                }
            }
        }
    }

    private final class KeySet
    extends Maps.KeySet<K, Collection<V>> {
        /*
         * WARNING - void declaration
         */
        KeySet(Map<K, Collection<V>> subMap) {
            void var2_2;
            super(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Iterator<K> iterator() {
            void var1_1;
            Iterator entryIterator = this.map().entrySet().iterator();
            return new Iterator<K>(){
                private Map.Entry<K, Collection<V>> entry;
                private /* synthetic */ Iterator val$entryIterator;
                private /* synthetic */ KeySet this$1;
                {
                    void var1_1;
                    this.val$entryIterator = iterator;
                    this.this$1 = var1_1;
                }

                @Override
                public final boolean hasNext() {
                    return this.val$entryIterator.hasNext();
                }

                @Override
                public final K next() {
                    this.entry = (Map.Entry)this.val$entryIterator.next();
                    return this.entry.getKey();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final void remove() {
                    void var1_1;
                    Preconditions.checkState(this.entry != null, "no calls to next() since the last call to remove()");
                    Collection collection = this.entry.getValue();
                    this.val$entryIterator.remove();
                    AbstractMapBasedMultimap.access$220(this.this$1.AbstractMapBasedMultimap.this, collection.size());
                    var1_1.clear();
                    this.entry = null;
                }
            };
        }

        @Override
        public final Spliterator<K> spliterator() {
            return this.map().keySet().spliterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object key) {
            void var2_2;
            int count = 0;
            Collection collection = (Collection)this.map().remove(key);
            if (collection != null) {
                void var1_1;
                count = collection.size();
                var1_1.clear();
                AbstractMapBasedMultimap.access$220(AbstractMapBasedMultimap.this, count);
            }
            return var2_2 > 0;
        }

        @Override
        public final void clear() {
            Iterators.clear(this.iterator());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsAll(Collection<?> c) {
            void var1_1;
            return this.map().keySet().containsAll((Collection<?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object object) {
            void var1_1;
            return this == object || this.map().keySet().equals(var1_1);
        }

        @Override
        public final int hashCode() {
            return this.map().keySet().hashCode();
        }
    }

    private final class AsMap
    extends Maps.ViewCachingAbstractMap<K, Collection<V>> {
        final transient Map<K, Collection<V>> submap;

        /*
         * WARNING - void declaration
         */
        AsMap(Map<K, Collection<V>> submap) {
            void var2_2;
            this.submap = var2_2;
        }

        @Override
        protected final Set<Map.Entry<K, Collection<V>>> createEntrySet$6051c6a4() {
            return new AsMapEntries(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(Object key) {
            void var1_1;
            return Maps.safeContainsKey(this.submap, var1_1);
        }

        @Override
        public final Set<K> keySet() {
            return AbstractMapBasedMultimap.this.keySet();
        }

        @Override
        public final int size() {
            return this.submap.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object object) {
            void var1_1;
            return this == object || this.submap.equals(var1_1);
        }

        @Override
        public final int hashCode() {
            return this.submap.hashCode();
        }

        @Override
        public final String toString() {
            return this.submap.toString();
        }

        @Override
        public final void clear() {
            if (this.submap == AbstractMapBasedMultimap.this.map) {
                AbstractMapBasedMultimap.this.clear();
                return;
            }
            Iterators.clear(new AsMapIterator(this));
        }

        /*
         * WARNING - void declaration
         */
        final Map.Entry<K, Collection<V>> wrapEntry(Map.Entry<K, Collection<V>> entry) {
            void var1_1;
            void var2_2;
            Object key = entry.getKey();
            return Maps.immutableEntry$5733d0c(key, AbstractMapBasedMultimap.this.wrapCollection(var2_2, (Collection)var1_1.getValue()));
        }

        final class AsMapEntries
        extends Maps.EntrySet<K, Collection<V>> {
            private /* synthetic */ AsMap this$1;

            /*
             * WARNING - void declaration
             */
            AsMapEntries(AsMap this$1) {
                void var1_1;
                this.this$1 = var1_1;
            }

            @Override
            final Map<K, Collection<V>> map() {
                return this.this$1;
            }

            @Override
            public final Iterator<Map.Entry<K, Collection<V>>> iterator() {
                return new AsMapIterator(this.this$1);
            }

            @Override
            public final Spliterator<Map.Entry<K, Collection<V>>> spliterator() {
                return CollectSpliterators.map$6379d89(this.this$1.submap.entrySet().spliterator(), this.this$1::wrapEntry);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean contains(Object o) {
                void var1_1;
                return Collections2.safeContains(this.this$1.submap.entrySet(), var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean remove(Object o) {
                void var1_1;
                if (!this.contains(o)) {
                    return false;
                }
                Map.Entry entry = Objects.requireNonNull((Map.Entry)o);
                AbstractMapBasedMultimap.access$300(this.this$1.AbstractMapBasedMultimap.this, var1_1.getKey());
                return true;
            }
        }

        final class AsMapIterator
        implements Iterator<Map.Entry<K, Collection<V>>> {
            private Iterator<Map.Entry<K, Collection<V>>> delegateIterator;
            private Collection<V> collection;
            private /* synthetic */ AsMap this$1;

            /*
             * WARNING - void declaration
             */
            AsMapIterator(AsMap this$1) {
                void var1_1;
                this.this$1 = var1_1;
                this.delegateIterator = this.this$1.submap.entrySet().iterator();
            }

            @Override
            public final boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public final void remove() {
                Preconditions.checkState(this.collection != null, "no calls to next() since the last call to remove()");
                this.delegateIterator.remove();
                AbstractMapBasedMultimap.access$220(this.this$1.AbstractMapBasedMultimap.this, this.collection.size());
                this.collection.clear();
                this.collection = null;
            }
        }
    }

    final class WrappedSet
    extends WrappedCollection
    implements Set<V> {
        private /* synthetic */ AbstractMapBasedMultimap this$0;

        /*
         * WARNING - void declaration
         */
        WrappedSet(AbstractSetMultimap this$0, K key, Set<V> delegate) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = this$0;
            super((AbstractMapBasedMultimap)var1_1, var2_2, var3_3, (WrappedCollection)null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean removeAll(Collection<?> c) {
            void var1_2;
            if (c.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = Sets.removeAllImpl((Set)this.delegate, c);
            if (changed) {
                void var2_3;
                void var3_4;
                int newSize = this.delegate.size();
                AbstractMapBasedMultimap.access$212(this.this$0, (int)(var3_4 - var2_3));
                this.removeIfEmpty();
            }
            return (boolean)var1_2;
        }
    }
}

