/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

abstract class AbstractMultiset<E>
extends AbstractCollection<E>
implements Multiset<E> {
    private transient Set<E> elementSet;
    private transient Set<Multiset.Entry<E>> entrySet;

    AbstractMultiset() {
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Object element) {
        void var1_1;
        return this.count(var1_1) > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(E element) {
        void var1_1;
        this.add(var1_1, 1);
        return true;
    }

    @Override
    public int add(E element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean remove(Object element) {
        void var1_1;
        return this.remove(var1_1, 1) > 0;
    }

    @Override
    public int remove(Object element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setCount(E element, int count) {
        AbstractMultiset abstractMultiset;
        void var2_2;
        void var3_4 = var2_2;
        void var2_3 = abstractMultiset;
        abstractMultiset = this;
        CollectPreconditions.checkNonnegative((int)var3_4, "count");
        int n = abstractMultiset.count(var2_3);
        if ((var3_4 -= n) > 0) {
            abstractMultiset.add(var2_3, (int)var3_4);
        } else if (var3_4 < 0) {
            abstractMultiset.remove(var2_3, (int)(-var3_4));
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean setCount(E element, int oldCount, int newCount) {
        AbstractMultiset abstractMultiset;
        void var2_2;
        void var3_4;
        void var4_5 = var3_4;
        var3_4 = var2_2;
        void var2_3 = abstractMultiset;
        abstractMultiset = this;
        CollectPreconditions.checkNonnegative((int)var3_4, "oldCount");
        CollectPreconditions.checkNonnegative((int)var4_5, "newCount");
        if (abstractMultiset.count(var2_3) == var3_4) {
            abstractMultiset.setCount(var2_3, (int)var4_5);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<? extends E> elementsToAdd) {
        void var1_1;
        return Multisets.addAllImpl$7e917e0f(this, (Collection)var1_1);
    }

    @Override
    public final boolean removeAll(Collection<?> elementsToRemove) {
        AbstractMultiset abstractMultiset;
        void var2_2 = abstractMultiset;
        abstractMultiset = this;
        var2_2 = var2_2 instanceof Multiset ? ((Multiset)var2_2).elementSet() : var2_2;
        return abstractMultiset.elementSet().removeAll((Collection<?>)var2_2);
    }

    @Override
    public final boolean retainAll(Collection<?> elementsToRetain) {
        AbstractMultiset abstractMultiset;
        void var2_2 = abstractMultiset;
        abstractMultiset = this;
        Preconditions.checkNotNull(var2_2);
        var2_2 = var2_2 instanceof Multiset ? ((Multiset)var2_2).elementSet() : var2_2;
        return abstractMultiset.elementSet().retainAll((Collection<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<E> elementSet() {
        void var1_1;
        Set result = this.elementSet;
        if (result == null) {
            result = this;
            this.elementSet = result = new ElementSet((AbstractMultiset)((Object)result));
        }
        return var1_1;
    }

    abstract Iterator<E> elementIterator$48db921e();

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        void var1_1;
        Set result = this.entrySet;
        if (result == null) {
            result = this;
            this.entrySet = result = new EntrySet((AbstractMultiset)((Object)result));
        }
        return var1_1;
    }

    abstract Iterator<Multiset.Entry<E>> entryIterator$48db921e();

    abstract int distinctElements();

    @Override
    public final boolean equals(Object object) {
        block5: {
            AbstractMultiset abstractMultiset;
            Object object2 = abstractMultiset;
            if (object2 == (abstractMultiset = this)) {
                return true;
            }
            if (object2 instanceof Multiset) {
                object2 = (Multiset)object2;
                if (abstractMultiset.size() != object2.size() || abstractMultiset.entrySet().size() != object2.entrySet().size()) {
                    return false;
                }
                for (Multiset.Entry entry : object2.entrySet()) {
                    if (abstractMultiset.count(entry.getElement()) == entry.getCount()) {
                        continue;
                    }
                    break block5;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public final String toString() {
        return this.entrySet().toString();
    }

    final class ElementSet
    extends Multisets.ElementSet<E> {
        private /* synthetic */ AbstractMultiset this$0;

        /*
         * WARNING - void declaration
         */
        ElementSet(AbstractMultiset this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        final Multiset<E> multiset$596af626() {
            return this.this$0;
        }

        @Override
        public final Iterator<E> iterator() {
            return this.this$0.elementIterator$48db921e();
        }
    }

    final class EntrySet
    extends Multisets.EntrySet<E> {
        private /* synthetic */ AbstractMultiset this$0;

        /*
         * WARNING - void declaration
         */
        EntrySet(AbstractMultiset this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        final Multiset<E> multiset$596af626() {
            return this.this$0;
        }

        @Override
        public final Iterator<Multiset.Entry<E>> iterator() {
            return this.this$0.entryIterator$48db921e();
        }

        @Override
        public final int size() {
            return this.this$0.distinctElements();
        }
    }
}

