/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.RegularImmutableList;
import com.google.common.collect.SingletonImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.UnmodifiableListIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;

public abstract class ImmutableList<E>
extends ImmutableCollection<E>
implements List<E>,
RandomAccess {
    public static <E> Collector<E, ?, ImmutableList<E>> toImmutableList() {
        return CollectCollectors.toImmutableList();
    }

    public static <E> ImmutableList<E> of() {
        return RegularImmutableList.EMPTY$20fdca08;
    }

    public static <E> ImmutableList<E> of$714caac3(E e1) {
        E e;
        return new SingletonImmutableList<E>(e);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> of$3de3b3a1(E e1, E e2) {
        void var1_1;
        Object object;
        Object[] objectArray = new Object[]{object, var1_1};
        object = objectArray;
        object = objectArray;
        object = ObjectArrays.checkElementsNotNull(objectArray, ((E)object).length);
        return ImmutableList.asImmutableList((Object[])object, ((E)object).length);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> of$6786c105(E e1, E e2, E e3) {
        void var2_2;
        void var1_1;
        Object object;
        Object[] objectArray = new Object[]{object, var1_1, var2_2};
        object = objectArray;
        object = objectArray;
        object = ObjectArrays.checkElementsNotNull(objectArray, ((E)object).length);
        return ImmutableList.asImmutableList((Object[])object, ((E)object).length);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> of(E e1, E e2, E e3, E e4, E e5) {
        void var3_3;
        void var2_2;
        void var1_1;
        Object object;
        Object[] objectArray = new Object[]{object, var1_1, var2_2, var3_3, e5};
        object = objectArray;
        object = objectArray;
        object = ObjectArrays.checkElementsNotNull(objectArray, ((E)object).length);
        return ImmutableList.asImmutableList((Object[])object, ((E)object).length);
    }

    public static <E> ImmutableList<E> copyOf(Iterable<? extends E> elements) {
        Iterable<E> iterable;
        Preconditions.checkNotNull(elements);
        if (elements instanceof Collection) {
            return ImmutableList.copyOf((Collection)elements);
        }
        return ImmutableList.copyOf(iterable.iterator());
    }

    public static <E> ImmutableList<E> copyOf(Collection<? extends E> elements) {
        Object object;
        if (elements instanceof ImmutableCollection) {
            Object list2 = ((ImmutableCollection)elements).asList();
            if (((ImmutableCollection)list2).isPartialView()) {
                list2 = ((ImmutableCollection)list2).toArray();
                return ImmutableList.asImmutableList((Object[])list2, ((Object)list2).length);
            }
            return object;
        }
        Object[] objectArray = object.toArray();
        object = objectArray;
        object = objectArray;
        object = ObjectArrays.checkElementsNotNull(objectArray, ((Object[])object).length);
        return ImmutableList.asImmutableList((Object[])object, ((Object)object).length);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> copyOf(Iterator<? extends E> elements) {
        Iterator<? extends E> iterator;
        void var1_1;
        if (!elements.hasNext()) {
            return RegularImmutableList.EMPTY$20fdca08;
        }
        E first = elements.next();
        if (!elements.hasNext()) {
            return ImmutableList.of$714caac3(first);
        }
        return ((Builder)((Builder)new Builder().add((Object)var1_1)).addAll((Iterator)iterator)).build();
    }

    static <E> ImmutableList<E> asImmutableList(Object[] elements) {
        return ImmutableList.asImmutableList(elements, elements.length);
    }

    /*
     * WARNING - void declaration
     */
    static <E> ImmutableList<E> asImmutableList(Object[] elements, int length) {
        Object[] objectArray;
        Object[] elementsWithoutTrailingNulls;
        void var1_1;
        switch (length) {
            case 0: {
                return RegularImmutableList.EMPTY$20fdca08;
            }
            case 1: {
                elements = Objects.requireNonNull(elements[0]);
                return ImmutableList.of$714caac3((Object)elements);
            }
        }
        elementsWithoutTrailingNulls = length < ((Object[])elements).length ? Arrays.copyOf(elements, (int)var1_1) : elementsWithoutTrailingNulls;
        return new RegularImmutableList(objectArray);
    }

    ImmutableList() {
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        ImmutableList immutableList = this;
        return immutableList.listIterator(0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        void var1_1;
        ImmutableList immutableList = this;
        return new AbstractIndexedListIterator<E>(immutableList, immutableList.size(), (int)var1_1){
            private /* synthetic */ ImmutableList this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((int)var2_2, (int)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected final E get(int index) {
                void var1_1;
                return this.this$0.get((int)var1_1);
            }
        };
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        Preconditions.checkNotNull(consumer);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            consumer.accept(this.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int indexOf(Object object) {
        void var1_1;
        if (object == null) {
            return -1;
        }
        return Lists.indexOfImpl$48b700b5(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int lastIndexOf(Object object) {
        void var1_1;
        if (object == null) {
            return -1;
        }
        return Lists.lastIndexOfImpl$48b700b5(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Object object) {
        void var1_1;
        return this.indexOf(var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        void var3_3;
        Preconditions.checkPositionIndexes(fromIndex, toIndex, this.size());
        int length = toIndex - fromIndex;
        if (length == this.size()) {
            return this;
        }
        if (length == 0) {
            return RegularImmutableList.EMPTY$20fdca08;
        }
        if (var3_3 == true) {
            return ImmutableList.of$714caac3(this.get(fromIndex));
        }
        return this.subListUnchecked((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    ImmutableList<E> subListUnchecked(int fromIndex, int toIndex) {
        void var1_1;
        void var2_2;
        return new SubList(this, fromIndex, (int)(var2_2 - var1_1));
    }

    @Override
    @Deprecated
    public final boolean addAll(int index, Collection<? extends E> newElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void replaceAll(UnaryOperator<E> operator) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void sort(Comparator<? super E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final ImmutableList<E> asList() {
        return this;
    }

    @Override
    public Spliterator<E> spliterator() {
        IntFunction<Object> intFunction = this::get;
        int n = 1296;
        int n2 = this.size();
        return CollectSpliterators.indexed$368eec41((int)n2, (int)n, intFunction, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int copyIntoArray(Object[] dst, int offset) {
        void var3_3;
        void var2_2;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            dst[offset + i] = this.get(i);
        }
        return (int)(var2_2 + var3_3);
    }

    public ImmutableList<E> reverse() {
        if (this.size() <= 1) {
            return this;
        }
        return new ReverseImmutableList(this);
    }

    @Override
    public boolean equals(Object obj) {
        block9: {
            Object object;
            Object object2 = object;
            if (object2 == Preconditions.checkNotNull(object = this)) {
                return true;
            }
            if (object2 instanceof List) {
                object2 = (List)object2;
                int n = object.size();
                if (n == object2.size()) {
                    if (object2 instanceof RandomAccess) {
                        for (int i = 0; i < n; ++i) {
                            if (com.google.common.base.Objects.equal(object.get(i), object2.get(i))) {
                                continue;
                            }
                            break block9;
                        }
                        return true;
                    }
                    object2 = object2.iterator();
                    object = object.iterator();
                    while (object.hasNext()) {
                        Object e;
                        Object e2;
                        if (object2.hasNext() && com.google.common.base.Objects.equal(e2 = object.next(), e = object2.next())) {
                            continue;
                        }
                        break block9;
                    }
                    if (!object2.hasNext()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int hashCode = 1;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            hashCode = hashCode * 31 + this.get(i).hashCode();
            hashCode = ~(~hashCode);
        }
        return (int)var1_1;
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static <E> Builder<E> builderWithExpectedSize(int expectedSize) {
        int n;
        CollectPreconditions.checkNonnegative(expectedSize, "expectedSize");
        return new Builder(n);
    }

    public static final class Builder<E>
    extends ImmutableCollection.Builder<E> {
        private Object[] contents;
        private int size;
        private boolean copyOnWrite;

        public Builder() {
            this(4);
        }

        /*
         * WARNING - void declaration
         */
        Builder(int capacity) {
            void var1_1;
            this.contents = new Object[var1_1];
            this.size = 0;
        }

        /*
         * WARNING - void declaration
         */
        private void ensureRoomFor(int newElements) {
            Object[] contents = this.contents;
            int newCapacity = Builder.expandedCapacity(this.contents.length, this.size + newElements);
            if (contents.length < newCapacity || this.copyOnWrite) {
                void var1_1;
                void var2_2;
                this.contents = Arrays.copyOf(var2_2, (int)var1_1);
                this.copyOnWrite = false;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<E> add(E element) {
            void var1_1;
            Preconditions.checkNotNull(element);
            this.ensureRoomFor(1);
            this.contents[this.size++] = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<E> addAll(Iterable<? extends E> elements) {
            void var1_1;
            Preconditions.checkNotNull(elements);
            if (elements instanceof Collection) {
                Collection collection = (Collection)elements;
                this.ensureRoomFor(collection.size());
                if (collection instanceof ImmutableCollection) {
                    void var2_2;
                    ImmutableCollection immutableCollection = (ImmutableCollection)var2_2;
                    this.size = var1_1.copyIntoArray(this.contents, this.size);
                    return this;
                }
            }
            super.addAll(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<E> addAll(Iterator<? extends E> elements) {
            void var1_1;
            super.addAll(var1_1);
            return this;
        }

        final Builder<E> combine(Builder<E> builder) {
            Builder builder2;
            Preconditions.checkNotNull(builder);
            int n = builder2.size;
            Object[] objectArray = builder.contents;
            builder2 = this;
            builder2.ensureRoomFor(n);
            System.arraycopy(objectArray, 0, builder2.contents, builder2.size, n);
            builder2.size += n;
            return this;
        }

        public final ImmutableList<E> build() {
            this.copyOnWrite = true;
            return ImmutableList.asImmutableList(this.contents, this.size);
        }
    }

    final class SubList
    extends ImmutableList<E> {
        private transient int offset;
        private transient int length;
        private /* synthetic */ ImmutableList this$0;

        /*
         * WARNING - void declaration
         */
        SubList(ImmutableList this$0, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.offset = var2_2;
            this.length = var3_3;
        }

        @Override
        public final int size() {
            return this.length;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final E get(int index) {
            void var1_1;
            Preconditions.checkElementIndex(index, this.length);
            return this.this$0.get((int)(var1_1 + this.offset));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ImmutableList<E> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            Preconditions.checkPositionIndexes(fromIndex, toIndex, this.length);
            return this.this$0.subList((int)(var1_1 + this.offset), (int)(var2_2 + this.offset));
        }

        @Override
        final boolean isPartialView() {
            return true;
        }
    }

    private static final class ReverseImmutableList<E>
    extends ImmutableList<E> {
        private final transient ImmutableList<E> forwardList;

        /*
         * WARNING - void declaration
         */
        ReverseImmutableList(ImmutableList<E> backingList) {
            void var1_1;
            this.forwardList = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private int reverseIndex(int index) {
            void var1_1;
            return this.size() - 1 - var1_1;
        }

        @Override
        public final ImmutableList<E> reverse() {
            return this.forwardList;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object object) {
            void var1_1;
            return ((ImmutableCollection)this.forwardList).contains(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int indexOf(Object object) {
            int index = this.forwardList.lastIndexOf(object);
            if (index >= 0) {
                void var1_2;
                return this.reverseIndex((int)var1_2);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int lastIndexOf(Object object) {
            int index = this.forwardList.indexOf(object);
            if (index >= 0) {
                void var1_2;
                return this.reverseIndex((int)var1_2);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ImmutableList<E> subList(int fromIndex, int toIndex) {
            void var1_1;
            void var2_2;
            Preconditions.checkPositionIndexes(fromIndex, toIndex, this.size());
            void var3_4 = var2_2;
            ReverseImmutableList reverseImmutableList = this;
            int n = reverseImmutableList.size() - var3_4;
            var3_4 = var1_1;
            reverseImmutableList = this;
            return ((ImmutableList)this.forwardList.subList(n, reverseImmutableList.size() - var3_4)).reverse();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final E get(int index) {
            void var1_1;
            Preconditions.checkElementIndex(index, this.size());
            return this.forwardList.get(this.reverseIndex((int)var1_1));
        }

        @Override
        public final int size() {
            return this.forwardList.size();
        }

        @Override
        final boolean isPartialView() {
            return this.forwardList.isPartialView();
        }
    }
}

