/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractRangeSet;
import com.google.common.collect.Cut;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.SortedLists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

public final class ImmutableRangeSet<C extends Comparable>
extends AbstractRangeSet<C>
implements Serializable {
    private static final ImmutableRangeSet<Comparable<?>> EMPTY = new ImmutableRangeSet(ImmutableList.of());
    private static final ImmutableRangeSet<Comparable<?>> ALL = new ImmutableRangeSet(ImmutableList.of$714caac3(Range.all()));
    private final transient ImmutableList<Range<C>> ranges;

    public static <C extends Comparable> ImmutableRangeSet<C> of() {
        return EMPTY;
    }

    static <C extends Comparable> ImmutableRangeSet<C> all() {
        return ALL;
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Comparable> ImmutableRangeSet<C> copyOf(RangeSet<C> rangeSet) {
        RangeSet<C> rangeSet2;
        Preconditions.checkNotNull(rangeSet);
        if (rangeSet.isEmpty()) {
            return EMPTY;
        }
        if (rangeSet.encloses(Range.all())) {
            return ALL;
        }
        if (rangeSet instanceof ImmutableRangeSet) {
            ImmutableRangeSet immutableRangeSet;
            ImmutableRangeSet immutableRangeSet2 = immutableRangeSet = (ImmutableRangeSet)rangeSet;
            if (!immutableRangeSet.ranges.isPartialView()) {
                void var1_1;
                return var1_1;
            }
        }
        return new ImmutableRangeSet<C>(ImmutableList.copyOf(rangeSet2.asRanges()));
    }

    /*
     * WARNING - void declaration
     */
    ImmutableRangeSet(ImmutableList<Range<C>> ranges) {
        void var1_1;
        this.ranges = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean encloses(Range<C> otherRange) {
        void var1_1;
        void var2_2;
        int index = SortedLists.binarySearch$53cb8e33(this.ranges, Range::lowerBound, otherRange.lowerBound, Ordering.natural$75ffd5c5(), SortedLists.KeyPresentBehavior.ANY_PRESENT$8552d4, SortedLists.KeyAbsentBehavior.NEXT_LOWER$6589c8f6);
        return index != -1 && ((Range)this.ranges.get((int)var2_2)).encloses(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Range<C> rangeContaining(C value) {
        int index = SortedLists.binarySearch$53cb8e33(this.ranges, Range::lowerBound, Cut.belowValue$6a7d55c6(value), Ordering.natural$75ffd5c5(), SortedLists.KeyPresentBehavior.ANY_PRESENT$8552d4, SortedLists.KeyAbsentBehavior.NEXT_LOWER$6589c8f6);
        if (index != -1) {
            void var1_1;
            Range range = (Range)this.ranges.get(index);
            if (range.contains(var1_1)) {
                void var2_3;
                return var2_3;
            }
            return null;
        }
        return null;
    }

    private Range<C> span() {
        if (this.ranges.isEmpty()) {
            throw new NoSuchElementException();
        }
        return Range.create(((Range)this.ranges.get((int)0)).lowerBound, ((Range)this.ranges.get((int)(this.ranges.size() - 1))).upperBound);
    }

    @Override
    public final boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    @Override
    @Deprecated
    public final void add(Range<C> range) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void addAll(RangeSet<C> other) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void addAll(Iterable<Range<C>> other) {
        throw new UnsupportedOperationException();
    }

    public static <C extends Comparable<?>> Builder<C> builder() {
        return new Builder();
    }

    public static final class Builder<C extends Comparable<?>> {
        private final List<Range<C>> ranges = new ArrayList<Range<C>>();

        /*
         * WARNING - void declaration
         */
        public final Builder<C> add(Range<C> range) {
            void var1_1;
            Preconditions.checkArgument(!range.isEmpty(), "range must not be empty, but was %s", range);
            this.ranges.add((Range<C>)var1_1);
            return this;
        }

        final Builder<C> combine(Builder<C> builder) {
            Builder builder2;
            Object object = builder2.ranges;
            builder2 = this;
            object = object.iterator();
            while (object.hasNext()) {
                Range range = (Range)object.next();
                builder2.add(range);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final ImmutableRangeSet<C> build() {
            void var3_3;
            void var1_1;
            ImmutableList.Builder mergedRangesBuilder = new ImmutableList.Builder(this.ranges.size());
            Collections.sort(this.ranges, Range.rangeLexOrdering());
            Iterators.PeekingImpl peekingItr = Iterators.peekingIterator$488b6d4d(this.ranges.iterator());
            while (peekingItr.hasNext()) {
                Range nextRange;
                Range range = (Range)peekingItr.next();
                while (peekingItr.hasNext() && range.isConnected(nextRange = (Range)peekingItr.peek())) {
                    Preconditions.checkArgument(range.intersection(nextRange).isEmpty(), "Overlapping ranges not permitted but found %s overlapping %s", range, nextRange);
                    range = range.span((Range)peekingItr.next());
                }
                mergedRangesBuilder.add(range);
            }
            ImmutableList mergedRanges = var1_1.build();
            if (mergedRanges.isEmpty()) {
                return ImmutableRangeSet.of();
            }
            if (mergedRanges.size() == 1 && ((Range)Iterables.getOnlyElement(mergedRanges)).equals(Range.all())) {
                return ImmutableRangeSet.all();
            }
            return new ImmutableRangeSet(var3_3);
        }
    }
}

