/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.UnmodifiableListIterator;
import com.google.common.primitives.Ints;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class Iterators {
    /*
     * WARNING - void declaration
     */
    public static int size(Iterator<?> iterator) {
        void var1_1;
        long count = 0L;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return Ints.saturatedCast((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean removeAll(Iterator<?> removeFrom, Collection<?> elementsToRemove) {
        void var2_2;
        Preconditions.checkNotNull(elementsToRemove);
        boolean result = false;
        while (removeFrom.hasNext()) {
            if (!elementsToRemove.contains(removeFrom.next())) continue;
            removeFrom.remove();
            result = true;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T getOnlyElement(Iterator<T> iterator) {
        void var1_1;
        Iterator<T> iterator2;
        T first = iterator.next();
        if (!iterator.hasNext()) {
            return first;
        }
        StringBuilder sb = new StringBuilder("expected one element but was: <").append(first);
        for (int i = 0; i < 4 && iterator.hasNext(); ++i) {
            sb.append(", ").append(iterator.next());
        }
        if (iterator2.hasNext()) {
            sb.append(", ...");
        }
        sb.append('>');
        throw new IllegalArgumentException(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean addAll(Collection<T> addTo, Iterator<? extends T> iterator) {
        void var2_2;
        Preconditions.checkNotNull(addTo);
        Preconditions.checkNotNull(iterator);
        boolean wasModified = false;
        while (iterator.hasNext()) {
            wasModified |= addTo.add(iterator.next());
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> UnmodifiableIterator<List<T>> partition(Iterator<T> iterator, int size) {
        void var1_3;
        boolean bl = false;
        Iterator<T> iterator2 = iterator;
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkArgument(var1_3 > 0);
        return new UnmodifiableIterator<List<T>>(iterator2, (int)var1_3, false){
            private /* synthetic */ Iterator val$iterator;
            private /* synthetic */ int val$size;
            private /* synthetic */ boolean val$pad;
            {
                this.val$iterator = iterator;
                this.val$size = n;
                this.val$pad = bl;
            }

            @Override
            public final boolean hasNext() {
                return this.val$iterator.hasNext();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T getNext(Iterator<? extends T> iterator, T defaultValue) {
        void var1_1;
        if (iterator.hasNext()) {
            Iterator<T> iterator2;
            return iterator2.next();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T getLast(Iterator<T> iterator) {
        void var1_1;
        do {
            T current = iterator.next();
        } while (iterator.hasNext());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static <T> T pollNext(Iterator<T> iterator) {
        if (iterator.hasNext()) {
            void var1_1;
            Iterator<T> iterator2;
            T result = iterator.next();
            iterator2.remove();
            return var1_1;
        }
        return null;
    }

    static void clear(Iterator<?> iterator) {
        Preconditions.checkNotNull(iterator);
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    static <T> UnmodifiableListIterator<T> forArrayWithPosition(T[] array, int position) {
        void var1_1;
        T[] TArray;
        if (array.length == 0) {
            Preconditions.checkPositionIndex(position, array.length);
            return ArrayItr.EMPTY$5e3c9ffb;
        }
        return new ArrayItr<T>(TArray, (int)var1_1);
    }

    public static <T> UnmodifiableIterator<T> singletonIterator$431e30e8(T value) {
        T t;
        return new SingletonIterator<T>(t);
    }

    public static <T> PeekingIterator<T> peekingIterator$488b6d4d(Iterator<? extends T> iterator) {
        Iterator<? extends T> iterator2;
        if (iterator instanceof PeekingImpl) {
            iterator = iterator;
            return iterator;
        }
        return new PeekingImpl<T>(iterator2);
    }

    private static final class ArrayItr<T>
    extends AbstractIndexedListIterator<T> {
        static final UnmodifiableListIterator<Object> EMPTY$5e3c9ffb = new ArrayItr<Object>(new Object[0], 0);
        private final T[] array;

        /*
         * WARNING - void declaration
         */
        ArrayItr(T[] array, int position) {
            super(array.length, (int)var2_2);
            void var1_1;
            void var2_2;
            this.array = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final T get(int index) {
            void var1_1;
            return this.array[var1_1];
        }
    }

    private static final class ConcatenatedIterator<T>
    implements Iterator<T> {
        private Iterator<? extends T> toRemove;
        private Iterator<? extends T> iterator = ArrayItr.EMPTY$5e3c9ffb;
        private Iterator<? extends Iterator<? extends T>> topMetaIterator;
        private Deque<Iterator<? extends Iterator<? extends T>>> metaIterators;

        /*
         * WARNING - void declaration
         */
        ConcatenatedIterator(Iterator<? extends Iterator<? extends T>> metaIterator) {
            void var1_1;
            this.topMetaIterator = (Iterator)Preconditions.checkNotNull(var1_1);
        }

        @Override
        public final boolean hasNext() {
            while (!Preconditions.checkNotNull(this.iterator).hasNext()) {
                ConcatenatedIterator concatenatedIterator;
                block7: {
                    Iterator<Iterator<T>> iterator;
                    concatenatedIterator = this;
                    while (concatenatedIterator.topMetaIterator == null || !concatenatedIterator.topMetaIterator.hasNext()) {
                        if (concatenatedIterator.metaIterators != null && !concatenatedIterator.metaIterators.isEmpty()) {
                            concatenatedIterator.topMetaIterator = concatenatedIterator.metaIterators.removeFirst();
                            continue;
                        }
                        iterator = null;
                        break block7;
                    }
                    iterator = this.topMetaIterator = concatenatedIterator.topMetaIterator;
                }
                if (this.topMetaIterator == null) {
                    return false;
                }
                this.iterator = this.topMetaIterator.next();
                if (!(this.iterator instanceof ConcatenatedIterator)) continue;
                ConcatenatedIterator topConcat = (ConcatenatedIterator)this.iterator;
                this.iterator = topConcat.iterator;
                if (this.metaIterators == null) {
                    this.metaIterators = new ArrayDeque<Iterator<? extends Iterator<? extends T>>>();
                }
                this.metaIterators.addFirst(this.topMetaIterator);
                if (topConcat.metaIterators != null) {
                    while (!topConcat.metaIterators.isEmpty()) {
                        this.metaIterators.addFirst(topConcat.metaIterators.removeLast());
                    }
                }
                this.topMetaIterator = concatenatedIterator.topMetaIterator;
            }
            return true;
        }

        @Override
        public final T next() {
            if (this.hasNext()) {
                this.toRemove = this.iterator;
                return this.iterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public final void remove() {
            if (this.toRemove == null) {
                throw new IllegalStateException("no calls to next() since the last call to remove()");
            }
            this.toRemove.remove();
            this.toRemove = null;
        }
    }

    private static final class SingletonIterator<T>
    extends UnmodifiableIterator<T> {
        private final T value;
        private boolean done;

        /*
         * WARNING - void declaration
         */
        SingletonIterator(T value) {
            void var1_1;
            this.value = var1_1;
        }

        @Override
        public final boolean hasNext() {
            return !this.done;
        }

        @Override
        public final T next() {
            if (this.done) {
                throw new NoSuchElementException();
            }
            this.done = true;
            return this.value;
        }
    }

    private static final class PeekingImpl<E>
    implements PeekingIterator<E> {
        private final Iterator<? extends E> iterator;
        private boolean hasPeeked;
        private E peekedElement;

        /*
         * WARNING - void declaration
         */
        public PeekingImpl(Iterator<? extends E> iterator) {
            void var1_1;
            this.iterator = (Iterator)Preconditions.checkNotNull(var1_1);
        }

        @Override
        public final boolean hasNext() {
            return this.hasPeeked || this.iterator.hasNext();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final E next() {
            void var1_1;
            if (!this.hasPeeked) {
                return this.iterator.next();
            }
            E result = this.peekedElement;
            this.hasPeeked = false;
            this.peekedElement = null;
            return var1_1;
        }

        @Override
        public final void remove() {
            Preconditions.checkState(!this.hasPeeked, "Can't remove after you've peeked at next");
            this.iterator.remove();
        }

        @Override
        public final E peek() {
            if (!this.hasPeeked) {
                this.peekedElement = this.iterator.next();
                this.hasPeeked = true;
            }
            E e = this.peekedElement;
            return e;
        }
    }
}

