/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparatorOrdering;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.NaturalOrdering;
import com.google.common.collect.ReverseOrdering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public abstract class Ordering<T>
implements Comparator<T> {
    public static <C extends Comparable> Ordering<C> natural$75ffd5c5() {
        return NaturalOrdering.INSTANCE;
    }

    public static <T> Ordering<T> from(Comparator<T> comparator) {
        Comparator<T> comparator2;
        if (comparator instanceof Ordering) {
            return (Ordering)comparator;
        }
        return new ComparatorOrdering<T>(comparator2);
    }

    protected Ordering() {
    }

    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    @Override
    public abstract int compare(T var1, T var2);

    /*
     * WARNING - void declaration
     */
    public <E extends T> E min(E a, E b) {
        void var2_2;
        if (this.compare(a, b) <= 0) {
            void var1_1;
            return var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public <E extends T> E max(E a, E b) {
        void var2_2;
        if (this.compare(a, b) >= 0) {
            void var1_1;
            return var1_1;
        }
        return var2_2;
    }

    public final <E extends T> List<E> sortedCopy(Iterable<E> elements) {
        List list2;
        Object[] array = Iterables.toArray(elements);
        Arrays.sort(array, this);
        list2 = Arrays.asList(list2);
        Preconditions.checkNotNull(list2);
        if (list2 instanceof Collection) {
            return new ArrayList(list2);
        }
        return Lists.newArrayList(list2.iterator());
    }
}

