/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.BoundType;
import com.google.common.collect.Cut;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Ordering;
import com.google.common.collect.RangeGwtSerializationDependencies;
import java.io.Serializable;

public final class Range<C extends Comparable>
extends RangeGwtSerializationDependencies
implements Predicate<C>,
Serializable {
    private static final Range<Comparable> ALL = new Range(Cut.belowAll$5559d39b(), Cut.aboveAll$5559d39b());
    final Cut<C> lowerBound;
    final Cut<C> upperBound;

    static <C extends Comparable<?>> Ordering<Range<C>> rangeLexOrdering() {
        return RangeLexOrdering.INSTANCE$2f36d1ba;
    }

    /*
     * WARNING - void declaration
     */
    static <C extends Comparable<?>> Range<C> create(Cut<C> lowerBound, Cut<C> upperBound) {
        void var1_1;
        Cut<C> cut;
        return new Range<C>(cut, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Comparable<?>> Range<C> closed(C lower, C upper) {
        void var1_1;
        return Range.create(Cut.belowValue$6a7d55c6(lower), Cut.aboveValue$6a7d55c6((Comparable)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Comparable<?>> Range<C> closedOpen(C lower, C upper) {
        void var1_1;
        return Range.create(Cut.belowValue$6a7d55c6(lower), Cut.belowValue$6a7d55c6((Comparable)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Comparable<?>> Range<C> range$74434596(C lower, BoundType lowerType, C upper, BoundType upperType) {
        void var1_1;
        Object object;
        void var2_2;
        void var3_3;
        Preconditions.checkNotNull(lowerType);
        Preconditions.checkNotNull(upperType);
        Object lowerBound = lowerType == BoundType.OPEN ? Cut.aboveValue$6a7d55c6(lower) : Cut.belowValue$6a7d55c6(lower);
        Cut upperBound = var3_3 == BoundType.OPEN ? Cut.belowValue$6a7d55c6(upper) : Cut.aboveValue$6a7d55c6((Comparable)var2_2);
        return Range.create(object, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Comparable<?>> Range<C> upTo$1ceed0e9(C endpoint, BoundType boundType) {
        void var1_1;
        switch (1.$SwitchMap$com$google$common$collect$BoundType[var1_1.ordinal()]) {
            case 1: {
                return Range.create(Cut.belowAll$5559d39b(), Cut.belowValue$6a7d55c6(endpoint));
            }
            case 2: {
                C c;
                return Range.create(Cut.belowAll$5559d39b(), Cut.aboveValue$6a7d55c6(c));
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Comparable<?>> Range<C> downTo$1ceed0e9(C endpoint, BoundType boundType) {
        void var1_1;
        switch (1.$SwitchMap$com$google$common$collect$BoundType[var1_1.ordinal()]) {
            case 1: {
                return Range.create(Cut.aboveValue$6a7d55c6(endpoint), Cut.aboveAll$5559d39b());
            }
            case 2: {
                C c;
                return Range.create(Cut.belowValue$6a7d55c6(c), Cut.aboveAll$5559d39b());
            }
        }
        throw new AssertionError();
    }

    public static <C extends Comparable<?>> Range<C> all() {
        return ALL;
    }

    public static <C extends Comparable<?>> Range<C> singleton(C value) {
        C c = value;
        return Range.closed(c, c);
    }

    /*
     * WARNING - void declaration
     */
    private Range(Cut<C> lowerBound, Cut<C> upperBound) {
        this.lowerBound = Preconditions.checkNotNull(lowerBound);
        this.upperBound = Preconditions.checkNotNull(upperBound);
        if (lowerBound.compareTo(upperBound) > 0 || lowerBound == Cut.aboveAll$5559d39b() || upperBound == Cut.belowAll$5559d39b()) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException("Invalid range: " + Range.toString(var1_1, var2_2));
        }
    }

    public final boolean hasLowerBound() {
        return this.lowerBound != Cut.belowAll$5559d39b();
    }

    public final C lowerEndpoint() {
        return this.lowerBound.endpoint();
    }

    public final boolean hasUpperBound() {
        return this.upperBound != Cut.aboveAll$5559d39b();
    }

    public final C upperEndpoint() {
        return this.upperBound.endpoint();
    }

    public final boolean isEmpty() {
        return this.lowerBound.equals(this.upperBound);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(C value) {
        void var1_1;
        Preconditions.checkNotNull(value);
        return this.lowerBound.isLessThan(value) && !this.upperBound.isLessThan(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean encloses(Range<C> other) {
        void var1_1;
        return this.lowerBound.compareTo(other.lowerBound) <= 0 && this.upperBound.compareTo(var1_1.upperBound) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isConnected(Range<C> other) {
        void var1_1;
        return this.lowerBound.compareTo(other.upperBound) <= 0 && var1_1.lowerBound.compareTo(this.upperBound) <= 0;
    }

    /*
     * WARNING - void declaration
     */
    public final Range<C> intersection(Range<C> connectedRange) {
        void var3_5;
        void var2_3;
        void var1_1;
        int lowerCmp = this.lowerBound.compareTo(connectedRange.lowerBound);
        int upperCmp = this.upperBound.compareTo(connectedRange.upperBound);
        if (lowerCmp >= 0 && upperCmp <= 0) {
            return this;
        }
        if (lowerCmp <= 0 && upperCmp >= 0) {
            return connectedRange;
        }
        Cut<C> newLower = lowerCmp >= 0 ? this.lowerBound : connectedRange.lowerBound;
        Cut<C> newUpper = upperCmp <= 0 ? this.upperBound : connectedRange.upperBound;
        Preconditions.checkArgument(newLower.compareTo(newUpper) <= 0, "intersection is undefined for disconnected ranges %s and %s", this, var1_1);
        return Range.create(var2_3, var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public final Range<C> span(Range<C> other) {
        void var1_1;
        void var2_3;
        void var3_4;
        int lowerCmp = this.lowerBound.compareTo(other.lowerBound);
        int upperCmp = this.upperBound.compareTo(other.upperBound);
        if (lowerCmp <= 0 && upperCmp >= 0) {
            return this;
        }
        if (lowerCmp >= 0 && upperCmp <= 0) {
            return other;
        }
        Cut<C> newLower = lowerCmp <= 0 ? this.lowerBound : other.lowerBound;
        Cut<C> newUpper = var3_4 >= 0 ? this.upperBound : other.upperBound;
        return Range.create(var2_3, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Range<C> canonical(DiscreteDomain<C> domain) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(domain);
        Cut<C> lower = this.lowerBound.canonical(domain);
        Cut<C> upper = this.upperBound.canonical(domain);
        if (lower == this.lowerBound && upper == this.upperBound) {
            return this;
        }
        return Range.create(var2_2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object object) {
        if (object instanceof Range) {
            void var1_1;
            Range other = (Range)object;
            return this.lowerBound.equals(other.lowerBound) && this.upperBound.equals(var1_1.upperBound);
        }
        return false;
    }

    public final int hashCode() {
        return this.lowerBound.hashCode() * 31 + this.upperBound.hashCode();
    }

    public final String toString() {
        return Range.toString(this.lowerBound, this.upperBound);
    }

    /*
     * WARNING - void declaration
     */
    private static String toString(Cut<?> lowerBound, Cut<?> upperBound) {
        void var2_2;
        void var1_1;
        Cut<?> cut;
        StringBuilder sb = new StringBuilder(16);
        cut.describeAsLowerBound(sb);
        sb.append("..");
        var1_1.describeAsUpperBound(sb);
        return var2_2.toString();
    }

    final Cut<C> lowerBound() {
        return this.lowerBound;
    }

    final Cut<C> upperBound() {
        return this.upperBound;
    }

    /*
     * WARNING - void declaration
     */
    static int compareOrThrow(Comparable left, Comparable right) {
        void var1_1;
        return left.compareTo(var1_1);
    }

    private static final class RangeLexOrdering
    extends Ordering<Range<?>>
    implements Serializable {
        static final Ordering<?> INSTANCE$2f36d1ba = new RangeLexOrdering();

        private RangeLexOrdering() {
        }
    }
}

