/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableEntry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMapEntry;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.IndexedImmutableSet;
import com.google.common.collect.JdkBackedImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    static final ImmutableMap<Object, Object> EMPTY$6c6b9e54 = new RegularImmutableMap(ImmutableMap.EMPTY_ENTRY_ARRAY, null, 0);
    final transient Map.Entry<K, V>[] entries;
    private final transient ImmutableMapEntry<K, V>[] table;
    private final transient int mask;

    /*
     * WARNING - void declaration
     */
    static <K, V> ImmutableMap<K, V> fromEntryArray(int n2, Map.Entry<K, V>[] entryArray, boolean throwIfDuplicateKeys) {
        Preconditions.checkPositionIndex(n2, entryArray.length);
        if (n2 == 0) {
            ImmutableMap<Object, Object> n2 = EMPTY$6c6b9e54;
            return n2;
        }
        try {
            int n2;
            return RegularImmutableMap.fromEntryArrayCheckingBucketOverflow(n2, entryArray, throwIfDuplicateKeys);
        }
        catch (BucketOverflowException bucketOverflowException) {
            Map.Entry entry;
            Map.Entry[] entryArray2;
            int n3;
            HashMap hashMap = Maps.newHashMapWithExpectedSize(n3);
            HashMap<Map.Entry, Object> hashMap2 = null;
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                void var2_3;
                Object v;
                Map.Entry entry2 = (Map.Entry)Objects.requireNonNull(entryArray2[i]);
                entryArray2[i] = RegularImmutableMap.makeImmutable(entry2, entry2.getKey(), entry2.getValue());
                entry2 = entryArray2[i].getKey();
                entry = hashMap.put(entry2, v = entryArray2[i].getValue());
                if (entry == null) continue;
                if (var2_3 != false) {
                    throw JdkBackedImmutableMap.conflictException("key", entryArray2[i], entryArray2[i].getKey() + "=" + entry);
                }
                if (hashMap2 == null) {
                    hashMap2 = new HashMap<Map.Entry, Object>();
                }
                hashMap2.put(entry2, v);
                ++n4;
            }
            if (hashMap2 != null) {
                Map.Entry[] entryArray3 = new Map.Entry[n3 - n4];
                int n5 = 0;
                for (int i = 0; i < n3; ++i) {
                    entry = (Map.Entry)Objects.requireNonNull(entryArray2[i]);
                    Object k = entry.getKey();
                    if (hashMap2.containsKey(k)) {
                        Object v = hashMap2.get(k);
                        if (v == null) continue;
                        entry = new ImmutableMapEntry(k, v);
                        hashMap2.put((Map.Entry)k, null);
                    }
                    entryArray3[n5++] = entry;
                }
                entryArray2 = entryArray3;
            }
            return new JdkBackedImmutableMap(hashMap, ImmutableList.asImmutableList(entryArray2, n3));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static <K, V> ImmutableMap<K, V> fromEntryArrayCheckingBucketOverflow(int n, Map.Entry<K, V>[] entryArray, boolean throwIfDuplicateKeys) throws BucketOverflowException {
        void var3_3;
        int mask;
        ImmutableMapEntry<K, V>[] table;
        while (true) {
            Map.Entry[] entries = n == entryArray.length ? entryArray : ImmutableMapEntry.createEntryArray(n);
            int tableSize = Hashing.closedTableSize(n, 1.2);
            table = ImmutableMapEntry.createEntryArray(tableSize);
            mask = tableSize - 1;
            IdentityHashMap<ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>, Boolean> duplicates = null;
            int dupCount = 0;
            for (int entryIndex = n - 1; entryIndex >= 0; --entryIndex) {
                Map.Entry<K, V> entry = Objects.requireNonNull(entryArray[entryIndex]);
                K key = entry.getKey();
                V value = entry.getValue();
                CollectPreconditions.checkEntryNotNull(key, value);
                int tableIndex = Hashing.smear(key.hashCode()) & mask;
                ImmutableMapEntry keyBucketHead = table[tableIndex];
                ImmutableMapEntry effectiveEntry = RegularImmutableMap.checkNoConflictInKeyBucket(key, value, keyBucketHead, throwIfDuplicateKeys);
                if (effectiveEntry == null) {
                    effectiveEntry = keyBucketHead == null ? RegularImmutableMap.makeImmutable(entry, key, value) : new ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>(key, value, keyBucketHead);
                    table[tableIndex] = effectiveEntry;
                } else {
                    if (duplicates == null) {
                        duplicates = new IdentityHashMap<ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>, Boolean>();
                    }
                    duplicates.put((ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>)effectiveEntry, Boolean.TRUE);
                    ++dupCount;
                    if (entries == entryArray) {
                        entries = (Map.Entry[])entries.clone();
                    }
                }
                entries[entryIndex] = effectiveEntry;
            }
            if (duplicates == null) break;
            int n2 = n;
            int n3 = Hashing.closedTableSize((entries = RegularImmutableMap.removeDuplicates$41b6c802((Map.Entry[])entries, (int)n2, (int)(n2 - dupCount), duplicates)).length, 1.2);
            if (n3 == tableSize) break;
            throwIfDuplicateKeys = true;
            entryArray = entries;
            n = entries.length;
        }
        return new RegularImmutableMap((Map.Entry<K, V>[])var3_3, table, mask);
    }

    /*
     * WARNING - void declaration
     */
    private static <K, V> Map.Entry<K, V>[] removeDuplicates$41b6c802(Map.Entry<K, V>[] entries, int n, int newN, IdentityHashMap<Map.Entry<K, V>, Boolean> duplicates) {
        void var2_3;
        ImmutableMapEntry<K, V>[] newEntries = ImmutableMapEntry.createEntryArray(newN);
        int out = 0;
        for (int in = 0; in < n; ++in) {
            Map.Entry<K, V> entry = entries[in];
            Boolean status = duplicates.get(entry);
            if (status != null) {
                if (!status.booleanValue()) continue;
                duplicates.put(entry, Boolean.FALSE);
            }
            newEntries[out++] = entry;
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private static <K, V> ImmutableMapEntry<K, V> makeImmutable(Map.Entry<K, V> entry, K key, V value) {
        void var2_2;
        void var1_1;
        boolean bl = entry instanceof ImmutableMapEntry && ((ImmutableMapEntry)entry).isReusable();
        if (bl) {
            Map.Entry<K, V> entry2;
            return (ImmutableMapEntry)entry2;
        }
        return new ImmutableMapEntry<void, void>(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private RegularImmutableMap(Map.Entry<K, V>[] entries, ImmutableMapEntry<K, V>[] table, int mask) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.entries = var1_1;
        this.table = var2_2;
        this.mask = var3_3;
    }

    private static <K, V> ImmutableMapEntry<K, V> checkNoConflictInKeyBucket(Object key2, Object newValue, ImmutableMapEntry<K, V> keyBucketHead, boolean throwIfDuplicateKeys2) throws BucketOverflowException {
        int bucketSize = 0;
        while (keyBucketHead != null) {
            if (keyBucketHead.getKey().equals(key2)) {
                if (throwIfDuplicateKeys2) {
                    String throwIfDuplicateKeys2 = key2 + "=" + newValue;
                    newValue = "key";
                    boolean key2 = false;
                    throw ImmutableMap.conflictException((String)newValue, keyBucketHead, throwIfDuplicateKeys2);
                }
                return keyBucketHead;
            }
            if (++bucketSize > 8) {
                throw new BucketOverflowException();
            }
            keyBucketHead = keyBucketHead.getNextInKeyBucket();
        }
        return null;
    }

    @Override
    public final V get(Object key) {
        int n = this.mask;
        Object object = this.table;
        Object object2 = key;
        if (object2 == null || object == null) {
            return null;
        }
        n = Hashing.smear(object2.hashCode()) & n;
        for (object = object[n]; object != null; object = ((ImmutableMapEntry)object).getNextInKeyBucket()) {
            Object k = ((ImmutableEntry)object).getKey();
            if (!object2.equals(k)) continue;
            return ((ImmutableEntry)object).getValue();
        }
        return null;
    }

    @Override
    public final void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        Map.Entry<K, V>[] entryArray = this.entries;
        int n = this.entries.length;
        for (int i = 0; i < n; ++i) {
            Map.Entry<K, V> entry = entryArray[i];
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public final int size() {
        return this.entries.length;
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    @Override
    final ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        RegularImmutableMap regularImmutableMap = this;
        return new ImmutableMapEntrySet.RegularEntrySet(regularImmutableMap, regularImmutableMap.entries);
    }

    @Override
    final ImmutableSet<K> createKeySet() {
        return new KeySet(this);
    }

    @Override
    final ImmutableCollection<V> createValues() {
        return new Values(this);
    }

    static final class BucketOverflowException
    extends Exception {
        BucketOverflowException() {
        }
    }

    private static final class KeySet<K>
    extends IndexedImmutableSet<K> {
        private final RegularImmutableMap<K, ?> map;

        /*
         * WARNING - void declaration
         */
        KeySet(RegularImmutableMap<K, ?> map) {
            void var1_1;
            this.map = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final K get(int index) {
            void var1_1;
            return this.map.entries[var1_1].getKey();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object object) {
            void var1_1;
            return this.map.containsKey(var1_1);
        }

        @Override
        final boolean isPartialView() {
            return true;
        }

        @Override
        public final int size() {
            return this.map.size();
        }
    }

    private static final class Values<K, V>
    extends ImmutableList<V> {
        private RegularImmutableMap<K, V> map;

        /*
         * WARNING - void declaration
         */
        Values(RegularImmutableMap<K, V> map) {
            void var1_1;
            this.map = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V get(int index) {
            void var1_1;
            return this.map.entries[var1_1].getValue();
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        final boolean isPartialView() {
            return true;
        }
    }
}

