/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.ImmutableEnumSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collector;

public final class Sets {
    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> ImmutableSet<E> immutableEnumSet$76e8e224(E anElement, E ... otherElements) {
        void var1_1;
        return ImmutableEnumSet.asImmutable(EnumSet.of(anElement, var1_1));
    }

    public static <E extends Enum<E>> Collector<E, ?, ImmutableSet<E>> toImmutableEnumSet() {
        return CollectCollectors.toImmutableEnumSet();
    }

    public static <E> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        int n;
        return new HashSet(Maps.capacity(n));
    }

    /*
     * WARNING - void declaration
     */
    static int hashCodeImpl(Set<?> s) {
        void var1_1;
        Iterator<?> iterator;
        int hashCode = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Object o = iterator.next();
            hashCode += o != null ? var2_2.hashCode() : 0;
            hashCode = ~(~hashCode);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static boolean equalsImpl(Set<?> s, Object object) {
        if (s == object) {
            return true;
        }
        if (object instanceof Set) {
            Set o = (Set)object;
            try {
                void var1_1;
                Set<?> set;
                return s.size() == o.size() && set.containsAll((Collection<?>)var1_1);
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static boolean removeAllImpl(Set<?> set, Iterator<?> iterator) {
        void var2_2;
        boolean changed = false;
        while (iterator.hasNext()) {
            changed |= set.remove(iterator.next());
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static boolean removeAllImpl(Set<?> set, Collection<?> collection) {
        void var1_1;
        Set<?> set2;
        Preconditions.checkNotNull(collection);
        if (collection instanceof Multiset) {
            collection = ((Multiset)collection).elementSet();
        }
        if (collection instanceof Set && collection.size() > set.size()) {
            return Iterators.removeAll(set.iterator(), collection);
        }
        return Sets.removeAllImpl(set2, var1_1.iterator());
    }

    static abstract class ImprovedAbstractSet<E>
    extends AbstractSet<E> {
        ImprovedAbstractSet() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            void var1_1;
            return Sets.removeAllImpl(this, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            void var1_1;
            return super.retainAll((Collection)Preconditions.checkNotNull(var1_1));
        }
    }
}

