/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.AbstractNavigableMap;
import com.google.common.collect.AbstractRangeSet;
import com.google.common.collect.BoundType;
import com.google.common.collect.Cut;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Ordering;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

public class TreeRangeSet<C extends Comparable<?>>
extends AbstractRangeSet<C>
implements Serializable {
    final NavigableMap<Cut<C>, Range<C>> rangesByLowerBound;
    private transient Set<Range<C>> asRanges$5a95723b;

    public static <C extends Comparable<?>> TreeRangeSet<C> create() {
        return new TreeRangeSet<C>(new TreeMap<Cut<C>, Range<C>>());
    }

    /*
     * WARNING - void declaration
     */
    private TreeRangeSet(NavigableMap<Cut<C>, Range<C>> rangesByLowerCut) {
        void var1_1;
        this.rangesByLowerBound = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Set<Range<C>> asRanges() {
        void var1_1;
        Set<Range<C>> result = this.asRanges$5a95723b;
        if (result == null) {
            TreeRangeSet treeRangeSet = this;
            this.asRanges$5a95723b = new AsRanges(treeRangeSet, treeRangeSet.rangesByLowerBound.values());
            return this.asRanges$5a95723b;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Range<C> rangeContaining(C value) {
        void var1_1;
        Preconditions.checkNotNull(value);
        Map.Entry<Cut.BelowValue, Range<C>> floorEntry = this.rangesByLowerBound.floorEntry(Cut.belowValue$6a7d55c6(value));
        if (floorEntry != null && floorEntry.getValue().contains(var1_1)) {
            void var2_2;
            return (Range)var2_2.getValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean encloses(Range<C> range) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(range);
        Map.Entry floorEntry = this.rangesByLowerBound.floorEntry(range.lowerBound);
        return floorEntry != null && ((Range)var2_2.getValue()).encloses(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(Range<C> rangeToAdd) {
        TreeRangeSet treeRangeSet;
        Range range;
        Map.Entry entryBelowUB;
        Preconditions.checkNotNull(rangeToAdd);
        if (rangeToAdd.isEmpty()) {
            return;
        }
        Cut lbToAdd = rangeToAdd.lowerBound;
        Cut ubToAdd = rangeToAdd.upperBound;
        Map.Entry entryBelowLB = this.rangesByLowerBound.lowerEntry(lbToAdd);
        if (entryBelowLB != null) {
            Range<C> rangeBelowLB = entryBelowLB.getValue();
            if (rangeBelowLB.upperBound.compareTo(lbToAdd) >= 0) {
                if (rangeBelowLB.upperBound.compareTo(ubToAdd) >= 0) {
                    ubToAdd = rangeBelowLB.upperBound;
                }
                lbToAdd = rangeBelowLB.lowerBound;
            }
        }
        if ((entryBelowUB = this.rangesByLowerBound.floorEntry(ubToAdd)) != null) {
            Range<C> rangeBelowUB = entryBelowUB.getValue();
            if (rangeBelowUB.upperBound.compareTo(ubToAdd) >= 0) {
                void var3_3;
                ubToAdd = var3_3.upperBound;
            }
        }
        this.rangesByLowerBound.subMap(lbToAdd, ubToAdd).clear();
        range = Range.create(range, treeRangeSet);
        treeRangeSet = this;
        if (range.isEmpty()) {
            treeRangeSet.rangesByLowerBound.remove(range.lowerBound);
            return;
        }
        treeRangeSet.rangesByLowerBound.put(range.lowerBound, range);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RangeSet<C> subRangeSet$f4d79cf(Range<C> view) {
        void var1_1;
        if (view.equals(Range.all())) {
            return this;
        }
        return new SubRangeSet(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ TreeRangeSet(SubRangeSetRangesByLowerBound x0) {
        this((NavigableMap<Cut<C>, Range<C>>)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Range access$600(TreeRangeSet x0, Range x1) {
        void var1_1;
        Object object = x0;
        Preconditions.checkNotNull(var1_1);
        object = ((TreeRangeSet)object).rangesByLowerBound.floorEntry(var1_1.lowerBound);
        if (object != null && ((Range)object.getValue()).encloses(var1_1)) {
            return (Range)object.getValue();
        }
        return null;
    }

    final class AsRanges
    extends ForwardingCollection<Range<C>>
    implements Set<Range<C>> {
        private Collection<Range<C>> delegate;
        private /* synthetic */ TreeRangeSet this$0;

        /*
         * WARNING - void declaration
         */
        AsRanges(TreeRangeSet this$0, Collection<Range<C>> delegate) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.delegate = var2_2;
        }

        @Override
        protected final Collection<Range<C>> delegate() {
            return this.delegate;
        }

        @Override
        public final int hashCode() {
            return Sets.hashCodeImpl(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object o) {
            void var1_1;
            return Sets.equalsImpl(this, var1_1);
        }
    }

    private final class SubRangeSet
    extends TreeRangeSet<C> {
        private final Range<C> restriction;
        private /* synthetic */ TreeRangeSet this$0;

        /*
         * WARNING - void declaration
         */
        SubRangeSet(TreeRangeSet treeRangeSet, Range<C> restriction) {
            void var2_2;
            this.this$0 = treeRangeSet;
            super(new SubRangeSetRangesByLowerBound(Range.all(), restriction, treeRangeSet.rangesByLowerBound, 0));
            this.restriction = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean encloses(Range<C> range) {
            if (!this.restriction.isEmpty() && this.restriction.encloses(range)) {
                void var1_1;
                Range enclosing = TreeRangeSet.access$600(this.this$0, range);
                return enclosing != null && !var1_1.intersection(this.restriction).isEmpty();
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Range<C> rangeContaining(C value) {
            void var1_1;
            if (!this.restriction.contains(value)) {
                return null;
            }
            Range result = this.this$0.rangeContaining(value);
            if (result == null) {
                return null;
            }
            return var1_1.intersection(this.restriction);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void add(Range<C> rangeToAdd) {
            void var1_1;
            Preconditions.checkArgument(this.restriction.encloses(rangeToAdd), "Cannot add range %s to subRangeSet(%s)", rangeToAdd, this.restriction);
            this.this$0.add(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(C value) {
            void var1_1;
            return this.restriction.contains(value) && this.this$0.contains((Comparable)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final RangeSet<C> subRangeSet$f4d79cf(Range<C> view) {
            if (view.encloses(this.restriction)) {
                return this;
            }
            if (view.isConnected(this.restriction)) {
                void var1_1;
                SubRangeSet subRangeSet = this;
                return new SubRangeSet(subRangeSet, subRangeSet.restriction.intersection((Range)var1_1));
            }
            return ImmutableRangeSet.of();
        }
    }

    private static final class SubRangeSetRangesByLowerBound<C extends Comparable<?>>
    extends AbstractNavigableMap<Cut<C>, Range<C>> {
        private final Range<Cut<C>> lowerBoundWindow;
        private final Range<C> restriction;
        private final NavigableMap<Cut<C>, Range<C>> rangesByLowerBound;
        private final NavigableMap<Cut<C>, Range<C>> rangesByUpperBound$74b560d2;

        /*
         * WARNING - void declaration
         */
        private SubRangeSetRangesByLowerBound(Range<Cut<C>> lowerBoundWindow, Range<C> restriction, NavigableMap<Cut<C>, Range<C>> rangesByLowerBound) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.lowerBoundWindow = (Range)Preconditions.checkNotNull(var1_1);
            this.restriction = (Range)Preconditions.checkNotNull(var2_2);
            this.rangesByLowerBound = Preconditions.checkNotNull(rangesByLowerBound);
            this.rangesByUpperBound$74b560d2 = new RangesByUpperBound(var3_3);
        }

        /*
         * WARNING - void declaration
         */
        private NavigableMap<Cut<C>, Range<C>> subMap(Range<Cut<C>> window) {
            void var1_1;
            if (!window.isConnected(this.lowerBoundWindow)) {
                return ImmutableSortedMap.of();
            }
            return new SubRangeSetRangesByLowerBound<C>(this.lowerBoundWindow.intersection((Range<Cut<C>>)var1_1), this.restriction, this.rangesByLowerBound);
        }

        @Override
        public final Comparator<? super Cut<C>> comparator() {
            return Ordering.natural$75ffd5c5();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(Object key) {
            void var1_1;
            return this.get(var1_1) != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        private Range<C> get(Object key) {
            if (key instanceof Cut) {
                try {
                    Range candidate;
                    Object cut = (Cut)key;
                    if (!this.lowerBoundWindow.contains((Cut<Cut>)cut) || ((Cut)cut).compareTo(this.restriction.lowerBound) < 0 || ((Cut)cut).compareTo(this.restriction.upperBound) >= 0) {
                        return null;
                    }
                    if (((Cut)cut).equals(this.restriction.lowerBound)) {
                        candidate = (cut = this.rangesByLowerBound.floorEntry((Cut<C>)cut)) == null ? null : cut.getValue();
                        if (candidate != null && candidate.upperBound.compareTo(this.restriction.lowerBound) > 0) {
                            return candidate.intersection(this.restriction);
                        }
                    } else {
                        Range result = (Range)this.rangesByLowerBound.get(candidate);
                        if (result != null) {
                            void var1_1;
                            return var1_1.intersection(this.restriction);
                        }
                    }
                }
                catch (ClassCastException classCastException) {
                    return null;
                }
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        final Iterator<Map.Entry<Cut<C>, Range<C>>> entryIterator() {
            block4: {
                if (this.restriction.isEmpty()) {
                    return Iterators.ArrayItr.EMPTY$5e3c9ffb;
                }
                if (this.lowerBoundWindow.upperBound.isLessThan(this.restriction.lowerBound)) {
                    return Iterators.ArrayItr.EMPTY$5e3c9ffb;
                }
                if (!this.lowerBoundWindow.lowerBound.isLessThan(this.restriction.lowerBound)) break block4;
                v0 = this.rangesByUpperBound$74b560d2;
                v1 = this.restriction.lowerBound;
                ** GOTO lbl-1000
            }
            v0 = this.rangesByLowerBound;
            v1 = (Cut)this.lowerBoundWindow.lowerBound.endpoint();
            var1_1 = this.lowerBoundWindow;
            if (var1_1.lowerBound.typeAsLowerBound() == BoundType.CLOSED) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            completeRangeItr = v0.tailMap(v1, v2).values().iterator();
            upperBoundOnLowerBounds = Ordering.natural$75ffd5c5().min(this.lowerBoundWindow.upperBound, Cut.belowValue$6a7d55c6(this.restriction.upperBound));
            return new AbstractIterator<Map.Entry<Cut<C>, Range<C>>>(this, var1_1, (Cut)var2_2){
                private /* synthetic */ Iterator val$completeRangeItr;
                private /* synthetic */ Cut val$upperBoundOnLowerBounds;
                private /* synthetic */ SubRangeSetRangesByLowerBound this$0;
                {
                    void var1_1;
                    this.val$completeRangeItr = iterator;
                    this.val$upperBoundOnLowerBounds = cut;
                    this.this$0 = var1_1;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Iterator<Map.Entry<Cut<C>, Range<C>>> descendingEntryIterator$48db921e() {
            void var1_1;
            if (this.restriction.isEmpty()) {
                return Iterators.ArrayItr.EMPTY$5e3c9ffb;
            }
            Cut upperBoundOnLowerBounds = Ordering.natural$75ffd5c5().min(this.lowerBoundWindow.upperBound, Cut.belowValue$6a7d55c6(this.restriction.upperBound));
            Iterator completeRangeItr = this.rangesByLowerBound.headMap((Cut)upperBoundOnLowerBounds.endpoint(), upperBoundOnLowerBounds.typeAsUpperBound() == BoundType.CLOSED).descendingMap().values().iterator();
            return new AbstractIterator<Map.Entry<Cut<C>, Range<C>>>(this, (Iterator)var1_1){
                private /* synthetic */ Iterator val$completeRangeItr;
                private /* synthetic */ SubRangeSetRangesByLowerBound this$0;
                {
                    void var1_1;
                    this.val$completeRangeItr = iterator;
                    this.this$0 = var1_1;
                }
            };
        }

        @Override
        public final int size() {
            return Iterators.size(this.entryIterator());
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ SubRangeSetRangesByLowerBound(Range x0, Range x1, NavigableMap x2, byte by) {
            this((Range<Cut<C>>)var1_1, (Range<C>)var2_2, (NavigableMap<Cut<C>, Range<C>>)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }

    static final class RangesByUpperBound<C extends Comparable<?>>
    extends AbstractNavigableMap<Cut<C>, Range<C>> {
        private final NavigableMap<Cut<C>, Range<C>> rangesByLowerBound;
        private final Range<Cut<C>> upperBoundWindow;

        /*
         * WARNING - void declaration
         */
        RangesByUpperBound(NavigableMap<Cut<C>, Range<C>> rangesByLowerBound) {
            void var1_1;
            this.rangesByLowerBound = var1_1;
            this.upperBoundWindow = Range.all();
        }

        /*
         * WARNING - void declaration
         */
        private RangesByUpperBound(NavigableMap<Cut<C>, Range<C>> rangesByLowerBound, Range<Cut<C>> upperBoundWindow) {
            void var2_2;
            void var1_1;
            this.rangesByLowerBound = var1_1;
            this.upperBoundWindow = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private NavigableMap<Cut<C>, Range<C>> subMap(Range<Cut<C>> window) {
            if (window.isConnected(this.upperBoundWindow)) {
                void var1_1;
                return new RangesByUpperBound<C>(this.rangesByLowerBound, var1_1.intersection(this.upperBoundWindow));
            }
            return ImmutableSortedMap.of();
        }

        @Override
        public final Comparator<? super Cut<C>> comparator() {
            return Ordering.natural$75ffd5c5();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(Object key) {
            void var1_1;
            return this.get(var1_1) != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        private Range<C> get(Object key) {
            if (key instanceof Cut) {
                try {
                    void var1_1;
                    Cut cut = (Cut)key;
                    if (!this.upperBoundWindow.contains(cut)) {
                        return null;
                    }
                    Map.Entry<Cut, Range<C>> candidate = this.rangesByLowerBound.lowerEntry(cut);
                    if (candidate != null && candidate.getValue().upperBound.equals(var1_1)) {
                        void var2_2;
                        return (Range)var2_2.getValue();
                    }
                }
                catch (ClassCastException classCastException) {
                    return null;
                }
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Iterator<Map.Entry<Cut<C>, Range<C>>> entryIterator() {
            void var1_1;
            Iterator backingItr;
            if (!this.upperBoundWindow.hasLowerBound()) {
                backingItr = this.rangesByLowerBound.values().iterator();
            } else {
                backingItr = this.upperBoundWindow;
                Map.Entry<Cut, Range<C>> lowerEntry = this.rangesByLowerBound.lowerEntry((Cut)((Range)((Object)backingItr)).lowerBound.endpoint());
                if (lowerEntry == null) {
                    backingItr = this.rangesByLowerBound.values().iterator();
                } else if (this.upperBoundWindow.lowerBound.isLessThan(((Range)backingItr.getValue()).upperBound)) {
                    backingItr = this.rangesByLowerBound.tailMap((Cut)backingItr.getKey(), true).values().iterator();
                } else {
                    backingItr = this.upperBoundWindow;
                    backingItr = this.rangesByLowerBound.tailMap((Cut)((Range)((Object)backingItr)).lowerBound.endpoint(), true).values().iterator();
                }
            }
            return new AbstractIterator<Map.Entry<Cut<C>, Range<C>>>(this, (Iterator)var1_1){
                private /* synthetic */ Iterator val$backingItr;
                private /* synthetic */ RangesByUpperBound this$0;
                {
                    void var1_1;
                    this.val$backingItr = iterator;
                    this.this$0 = var1_1;
                }
            };
        }

        @Override
        final Iterator<Map.Entry<Cut<C>, Range<C>>> descendingEntryIterator$48db921e() {
            Collection candidates;
            Range<Cut<C>> range;
            if (this.upperBoundWindow.hasUpperBound()) {
                range = this.upperBoundWindow;
                candidates = this.rangesByLowerBound.headMap((Cut)range.upperBound.endpoint(), false).descendingMap().values();
            } else {
                candidates = this.rangesByLowerBound.descendingMap().values();
            }
            Iterators.PeekingImpl backingItr = Iterators.peekingIterator$488b6d4d(candidates.iterator());
            if (backingItr.hasNext() && this.upperBoundWindow.upperBound.isLessThan(((Range)backingItr.peek()).upperBound)) {
                backingItr.next();
            }
            return new AbstractIterator<Map.Entry<Cut<C>, Range<C>>>(this, (PeekingIterator)range){
                private /* synthetic */ PeekingIterator val$backingItr;
                private /* synthetic */ RangesByUpperBound this$0;
                {
                    void var1_1;
                    this.val$backingItr = peekingIterator;
                    this.this$0 = var1_1;
                }
            };
        }

        @Override
        public final int size() {
            if (this.upperBoundWindow.equals(Range.all())) {
                return this.rangesByLowerBound.size();
            }
            return Iterators.size(this.entryIterator());
        }

        @Override
        public final boolean isEmpty() {
            if (this.upperBoundWindow.equals(Range.all())) {
                return this.rangesByLowerBound.isEmpty();
            }
            return !this.entryIterator().hasNext();
        }
    }
}

