/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.math.IntMath;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Objects;

public abstract class BaseEncoding {
    private static final Base16Encoding BASE16$509f4196;

    BaseEncoding() {
    }

    public abstract StandardBaseEncoding.1 encodingStream$7010ba93(Writer var1);

    public abstract boolean canDecode(CharSequence var1);

    public abstract BaseEncoding lowerCase();

    public static BaseEncoding base16() {
        return BASE16$509f4196;
    }

    static {
        new Base64Encoding("base64()", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", Character.valueOf('='));
        new Base64Encoding("base64Url()", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_", Character.valueOf('='));
        new StandardBaseEncoding("base32()", "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567", Character.valueOf('='));
        new StandardBaseEncoding("base32Hex()", "0123456789ABCDEFGHIJKLMNOPQRSTUV", Character.valueOf('='));
        BASE16$509f4196 = new Base16Encoding("base16()", "0123456789ABCDEF");
    }

    private static final class Base64Encoding
    extends StandardBaseEncoding {
        /*
         * WARNING - void declaration
         */
        Base64Encoding(String name, String alphabetChars, Character paddingChar) {
            this(new Alphabet((String)var1_1, var2_2.toCharArray()), (Character)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private Base64Encoding(Alphabet alphabet, Character paddingChar) {
            super(alphabet, (Character)var2_2);
            void var1_1;
            void var2_2;
            Preconditions.checkArgument(((Alphabet)var1_1).chars.length == 64);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final StandardBaseEncoding newInstance$5d538f32(Alphabet alphabet, Character paddingChar) {
            void var2_2;
            void var1_1;
            return new Base64Encoding((Alphabet)var1_1, (Character)var2_2);
        }
    }

    private static class StandardBaseEncoding
    extends BaseEncoding {
        final Alphabet alphabet;
        final Character paddingChar;
        private volatile BaseEncoding lowerCase;

        /*
         * WARNING - void declaration
         */
        StandardBaseEncoding(String name, String alphabetChars, Character paddingChar) {
            this(new Alphabet((String)var1_1, var2_2.toCharArray()), (Character)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        StandardBaseEncoding(Alphabet alphabet, Character paddingChar) {
            void var2_2;
            void var1_1;
            this.alphabet = Preconditions.checkNotNull(alphabet);
            Preconditions.checkArgument(paddingChar == null || !var1_1.matches(paddingChar.charValue()), "Padding character %s was already in alphabet", paddingChar);
            this.paddingChar = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final 1 encodingStream$7010ba93(Writer out) {
            void var1_1;
            Preconditions.checkNotNull(out);
            return new OutputStream(this, (Writer)var1_1){
                private int bitBuffer = 0;
                private int bitBufferLength = 0;
                private int writtenChars = 0;
                private /* synthetic */ Writer val$out;
                private /* synthetic */ StandardBaseEncoding this$0;
                {
                    void var1_1;
                    this.val$out = writer;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final void write(int b) throws IOException {
                    this.bitBuffer <<= 8;
                    this.bitBuffer |= b & 0xFF;
                    this.bitBufferLength += 8;
                    while (this.bitBufferLength >= this.this$0.alphabet.bitsPerChar) {
                        void var1_1;
                        int charIndex = this.bitBuffer >> this.bitBufferLength - this.this$0.alphabet.bitsPerChar & this.this$0.alphabet.mask;
                        this.val$out.write(this.this$0.alphabet.encode((int)var1_1));
                        ++this.writtenChars;
                        this.bitBufferLength -= this.this$0.alphabet.bitsPerChar;
                    }
                }

                @Override
                public final void flush() throws IOException {
                    this.val$out.flush();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final void close() throws IOException {
                    if (this.bitBufferLength > 0) {
                        void var1_1;
                        int charIndex = this.bitBuffer << this.this$0.alphabet.bitsPerChar - this.bitBufferLength & this.this$0.alphabet.mask;
                        this.val$out.write(this.this$0.alphabet.encode((int)var1_1));
                        ++this.writtenChars;
                        if (this.this$0.paddingChar != null) {
                            while (this.writtenChars % this.this$0.alphabet.charsPerChunk != 0) {
                                this.val$out.write(this.this$0.paddingChar.charValue());
                                ++this.writtenChars;
                            }
                        }
                    }
                    this.val$out.close();
                }
            };
        }

        @Override
        public final boolean canDecode(CharSequence chars22) {
            Object chars22;
            Object object;
            Preconditions.checkNotNull(chars22);
            CharSequence charSequence = chars22;
            chars22 = this;
            Preconditions.checkNotNull(charSequence);
            if (((StandardBaseEncoding)chars22).paddingChar == null) {
                object = charSequence;
            } else {
                int n;
                char chars22 = ((StandardBaseEncoding)chars22).paddingChar.charValue();
                for (n = charSequence.length() - 1; n >= 0 && charSequence.charAt(n) == chars22; --n) {
                }
                object = chars22 = charSequence.subSequence(0, n + 1);
            }
            if (!this.alphabet.isValidPaddingStartPosition(chars22.length())) {
                return false;
            }
            for (int i = 0; i < chars22.length(); ++i) {
                if (this.alphabet.canDecode(chars22.charAt(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public final BaseEncoding lowerCase() {
            StandardBaseEncoding standardBaseEncoding;
            BaseEncoding result = this.lowerCase;
            if (result == null) {
                Alphabet lower = this.alphabet.lowerCase();
                this.lowerCase = lower == this.alphabet ? this : this.newInstance$5d538f32((Alphabet)((Object)standardBaseEncoding), this.paddingChar);
                standardBaseEncoding = this.lowerCase;
            }
            return standardBaseEncoding;
        }

        /*
         * WARNING - void declaration
         */
        StandardBaseEncoding newInstance$5d538f32(Alphabet alphabet, Character paddingChar) {
            void var2_2;
            void var1_1;
            return new StandardBaseEncoding((Alphabet)var1_1, (Character)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            StringBuilder builder = new StringBuilder("BaseEncoding.");
            builder.append(this.alphabet);
            if (8 % this.alphabet.bitsPerChar != 0) {
                if (this.paddingChar == null) {
                    builder.append(".omitPadding()");
                } else {
                    builder.append(".withPadChar('").append(this.paddingChar).append("')");
                }
            }
            return var1_1.toString();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object other) {
            if (other instanceof StandardBaseEncoding) {
                void var1_1;
                StandardBaseEncoding that = (StandardBaseEncoding)other;
                return this.alphabet.equals(that.alphabet) && Objects.equals(this.paddingChar, var1_1.paddingChar);
            }
            return false;
        }

        public int hashCode() {
            return this.alphabet.hashCode() ^ Objects.hashCode(this.paddingChar);
        }
    }

    private static final class Base16Encoding
    extends StandardBaseEncoding {
        private char[] encoding = new char[512];

        /*
         * WARNING - void declaration
         */
        Base16Encoding(String name, String alphabetChars) {
            this(new Alphabet((String)var1_1, var2_2.toCharArray()));
            void var2_2;
            void var1_1;
        }

        private Base16Encoding(Alphabet alphabet) {
            super(alphabet, null);
            Preconditions.checkArgument(alphabet.chars.length == 16);
            for (int i = 0; i < 256; ++i) {
                this.encoding[i] = alphabet.encode(i >>> 4);
                this.encoding[i | 0x100] = alphabet.encode(i & 0xF);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final StandardBaseEncoding newInstance$5d538f32(Alphabet alphabet, Character paddingChar) {
            void var1_1;
            return new Base16Encoding((Alphabet)var1_1);
        }
    }

    static final class Alphabet {
        private final String name;
        private final char[] chars;
        final int mask;
        final int bitsPerChar;
        final int charsPerChunk;
        private int bytesPerChunk;
        private final byte[] decodabet;
        private final boolean[] validPadding;
        private final boolean ignoreCase;

        /*
         * WARNING - void declaration
         */
        Alphabet(String name, char[] chars) {
            void var1_1;
            void var2_2;
            void v0 = var2_2;
            this((String)var1_1, (char[])v0, Alphabet.decodabetFor((char[])v0), false);
        }

        /*
         * WARNING - void declaration
         */
        private Alphabet(String name, char[] chars, byte[] decodabet, boolean ignoreCase) {
            void var1_4;
            void var3_7;
            this.name = Preconditions.checkNotNull(name);
            this.chars = Preconditions.checkNotNull(chars);
            try {
                this.bitsPerChar = IntMath.log2(chars.length, RoundingMode.UNNECESSARY);
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("Illegal alphabet length " + chars.length, e);
            }
            int zeroesInBitsPerChar = Integer.numberOfTrailingZeros(this.bitsPerChar);
            this.charsPerChunk = 1 << 3 - zeroesInBitsPerChar;
            this.bytesPerChunk = this.bitsPerChar >> zeroesInBitsPerChar;
            this.mask = chars.length - 1;
            this.decodabet = var3_7;
            boolean[] validPadding = new boolean[this.charsPerChunk];
            for (int i = 0; i < this.bytesPerChunk; ++i) {
                validPadding[IntMath.divide((int)(i << 3), (int)this.bitsPerChar, (RoundingMode)RoundingMode.CEILING)] = true;
            }
            this.validPadding = var1_4;
            this.ignoreCase = ignoreCase;
        }

        /*
         * WARNING - void declaration
         */
        private static byte[] decodabetFor(char[] chars) {
            void var1_1;
            byte[] decodabet = new byte[128];
            Arrays.fill(decodabet, (byte)-1);
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                Preconditions.checkArgument(c < decodabet.length, "Non-ASCII character: %s", c);
                Preconditions.checkArgument(decodabet[c] == -1, "Duplicate character: %s", c);
                decodabet[var3_3] = (byte)i;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final char encode(int bits) {
            void var1_1;
            return this.chars[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        final boolean isValidPaddingStartPosition(int index) {
            void var1_1;
            return this.validPadding[var1_1 % this.charsPerChunk];
        }

        /*
         * WARNING - void declaration
         */
        final boolean canDecode(char ch) {
            void var1_1;
            return ch <= '\u007f' && this.decodabet[var1_1] != -1;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        final Alphabet lowerCase() {
            Alphabet alphabet;
            boolean bl;
            char c;
            char c2;
            int n;
            Alphabet alphabet2;
            block11: {
                boolean bl2;
                int n2;
                block10: {
                    alphabet2 = this;
                    char[] cArray = alphabet2.chars;
                    n2 = alphabet2.chars.length;
                    for (n = 0; n < n2; ++n) {
                        c2 = cArray[n];
                        if (!Ascii.isUpperCase(c2)) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
                if (!bl2) {
                    return this;
                }
                alphabet2 = this;
                char[] cArray = alphabet2.chars;
                n2 = alphabet2.chars.length;
                for (n = 0; n < n2; ++n) {
                    c = c2 = cArray[n];
                    if (!(c2 >= 'a' && c <= 'z')) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
            Preconditions.checkState(!bl, "Cannot call lowerCase() on a mixed-case alphabet");
            char[] cArray = new char[this.chars.length];
            for (int i = 0; i < this.chars.length; ++i) {
                char c3 = this.chars[i];
                cArray[i] = Ascii.isUpperCase(c3) ? (char)(c3 ^ 0x20) : c3;
            }
            Alphabet lowerCase22 = new Alphabet(this.name + ".lowerCase()", cArray);
            if (!this.ignoreCase) {
                void var2_8;
                alphabet = var2_8;
                return alphabet;
            }
            alphabet2 = lowerCase22;
            if (alphabet2.ignoreCase) {
                alphabet = alphabet2;
                return alphabet;
            }
            byte[] byArray = Arrays.copyOf(alphabet2.decodabet, alphabet2.decodabet.length);
            int lowerCase22 = 65;
            while (lowerCase22 <= 90) {
                n = lowerCase22 | 0x20;
                c2 = alphabet2.decodabet[lowerCase22];
                c = alphabet2.decodabet[n];
                if (c2 == '\uffffffff') {
                    byArray[lowerCase22] = c;
                } else {
                    char c4 = (char)n;
                    char c5 = (char)lowerCase22;
                    String string = "Can't ignoreCase() since '%s' and '%s' encode different values";
                    if ((c = c == '\uffffffff' ? (char)'\u0001' : '\u0000') == '\u0000') {
                        throw new IllegalStateException(Strings.lenientFormat(string, Character.valueOf(c5), Character.valueOf(c4)));
                    }
                    byArray[n] = c2;
                }
                ++lowerCase22;
            }
            return new Alphabet(alphabet2.name + ".ignoreCase()", alphabet2.chars, byArray, true);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean matches(char c) {
            void var1_1;
            return c < this.decodabet.length && this.decodabet[var1_1] != -1;
        }

        public final String toString() {
            return this.name;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            if (other instanceof Alphabet) {
                void var1_1;
                Alphabet that = (Alphabet)other;
                return this.ignoreCase == that.ignoreCase && Arrays.equals(this.chars, var1_1.chars);
            }
            return false;
        }

        public final int hashCode() {
            return Arrays.hashCode(this.chars) + (this.ignoreCase ? 1231 : 1237);
        }
    }
}

