/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.common.io.Closer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.stream.Stream;

public abstract class CharSink {
    protected CharSink() {
    }

    public abstract Writer openStream() throws IOException;

    /*
     * WARNING - void declaration
     */
    public Writer openBufferedStream() throws IOException {
        void var1_1;
        Writer writer = this.openStream();
        if (writer instanceof BufferedWriter) {
            return (BufferedWriter)writer;
        }
        return new BufferedWriter((Writer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void write(CharSequence charSequence) throws IOException {
        Preconditions.checkNotNull(charSequence);
        Closer closer = Closer.create();
        try {
            void var1_1;
            Writer out = closer.register(this.openStream());
            out.append((CharSequence)var1_1);
            out.flush();
        }
        catch (Throwable e) {
            try {
                void var3_5;
                throw closer.rethrow((Throwable)var3_5);
            }
            catch (Throwable throwable) {
                void var2_3;
                var2_3.close();
                throw throwable;
            }
        }
        closer.close();
        return;
    }

    /*
     * WARNING - void declaration
     */
    public void writeLines(Iterable<? extends CharSequence> lines) throws IOException {
        void var1_1;
        this.writeLines((Iterable<? extends CharSequence>)var1_1, System.getProperty("line.separator"));
    }

    /*
     * WARNING - void declaration
     */
    public void writeLines(Iterable<? extends CharSequence> lines, String lineSeparator) throws IOException {
        void var2_2;
        void var1_1;
        this.writeLines(var1_1.iterator(), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void writeLines(Stream<? extends CharSequence> lines) throws IOException {
        void var1_1;
        this.writeLines((Stream<? extends CharSequence>)var1_1, System.getProperty("line.separator"));
    }

    /*
     * WARNING - void declaration
     */
    public void writeLines(Stream<? extends CharSequence> lines, String lineSeparator) throws IOException {
        void var2_2;
        void var1_1;
        this.writeLines(var1_1.iterator(), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeLines(Iterator<? extends CharSequence> lines, String lineSeparator) throws IOException {
        Preconditions.checkNotNull(lineSeparator);
        Writer out = this.openBufferedStream();
        try {
            while (lines.hasNext()) {
                out.append(lines.next()).append(lineSeparator);
            }
            if (out == null) return;
        }
        catch (Throwable throwable) {
            if (out == null) throw throwable;
            try {
                void var3_5;
                var3_5.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        out.close();
    }

    /*
     * WARNING - void declaration
     */
    public long writeFrom(Readable readable) throws IOException {
        long l;
        Preconditions.checkNotNull(readable);
        Closer closer = Closer.create();
        try {
            void var1_1;
            Writer out = closer.register(this.openStream());
            long written = CharStreams.copy((Readable)var1_1, out);
            out.flush();
            l = written;
        }
        catch (Throwable e) {
            try {
                void var3_5;
                throw closer.rethrow((Throwable)var3_5);
            }
            catch (Throwable throwable) {
                void var2_3;
                var2_3.close();
                throw throwable;
            }
        }
        closer.close();
        return l;
    }
}

