/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat;

import com.google.googlejavaformat.Input;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface CommentsHelper {
    public static final Pattern PARAMETER_COMMENT = Pattern.compile("/\\*\\s*(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\Q...\\E)?)\\s*=\\s*\\*/");

    public String rewrite(Input.Tok var1, int var2, int var3);

    public static Optional<String> reformatParameterComment(Input.Tok tok) {
        Matcher matcher;
        if (!tok.isSlashStarComment()) {
            return Optional.empty();
        }
        Matcher match = PARAMETER_COMMENT.matcher(tok.getOriginalText());
        if (!match.matches()) {
            return Optional.empty();
        }
        return Optional.of(String.format("/* %s= */", matcher.group(1)));
    }
}

