/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat;

import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Range;
import com.google.googlejavaformat.CommentsHelper;
import com.google.googlejavaformat.DocBuilder;
import com.google.googlejavaformat.Indent;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.Op;
import com.google.googlejavaformat.Output;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public abstract class Doc {
    public static final int MAX_LINE_WIDTH = 1000;
    private static final Range<Integer> EMPTY_RANGE = Range.closedOpen(-1, -1);
    private static final DiscreteDomain<Integer> INTEGERS = DiscreteDomain.integers$69c50eee();
    private final Supplier<Integer> width = Suppliers.memoize(this::computeWidth);
    private final Supplier<String> flat = Suppliers.memoize(this::computeFlat);
    private final Supplier<Range<Integer>> range = Suppliers.memoize(this::computeRange);

    final int getWidth() {
        return this.width.get();
    }

    final String getFlat() {
        return this.flat.get();
    }

    final Range<Integer> range() {
        return this.range.get();
    }

    abstract int computeWidth();

    abstract String computeFlat();

    abstract Range<Integer> computeRange();

    public abstract State computeBreaks(CommentsHelper var1, int var2, State var3);

    public abstract void write(Output var1);

    static final class Tok
    extends Doc
    implements Op {
        private final Input.Tok tok;
        String text;

        /*
         * WARNING - void declaration
         */
        private Tok(Input.Tok tok) {
            void var1_1;
            this.tok = var1_1;
        }

        static Tok make(Input.Tok tok) {
            Input.Tok tok2;
            return new Tok(tok2);
        }

        @Override
        public final void add(DocBuilder builder) {
            builder.add(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int computeWidth() {
            void var1_1;
            int idx = Newlines.firstBreak(this.tok.getOriginalText());
            if (this.tok.isComment()) {
                if (idx > 0) {
                    return idx;
                }
                if (this.tok.isSlashSlashComment() && !this.tok.getOriginalText().startsWith("// ")) {
                    return this.tok.length() + 1;
                }
                return CommentsHelper.reformatParameterComment(this.tok).map(String::length).orElse(this.tok.length());
            }
            if (var1_1 != -1) {
                return 1000;
            }
            return this.tok.length();
        }

        @Override
        final String computeFlat() {
            if (this.tok.isSlashSlashComment() && !this.tok.getOriginalText().startsWith("// ")) {
                return "// " + this.tok.getOriginalText().substring(2);
            }
            return CommentsHelper.reformatParameterComment(this.tok).orElse(this.tok.getOriginalText());
        }

        @Override
        final Range<Integer> computeRange() {
            return Range.singleton(this.tok.getIndex()).canonical(INTEGERS);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final State computeBreaks(CommentsHelper commentsHelper, int maxWidth, State state) {
            void var1_2;
            void var3_4;
            void var2_3;
            this.text = commentsHelper.rewrite(this.tok, (int)var2_3, state.column);
            int firstLineLength = this.text.length() - Iterators.getLast(Newlines.lineOffsetIterator(this.text));
            void v0 = var3_4;
            return v0.withColumn(v0.column + var1_2);
        }

        @Override
        public final void write(Output output) {
            output.append(this.text, this.range());
        }

        public final String toString() {
            return MoreObjects.toStringHelper(this).add("tok", this.tok).toString();
        }
    }

    public static final class Break
    extends Doc
    implements Op {
        private final FillMode fillMode;
        private final String flat;
        private final Indent plusIndent;
        private final Optional<Output.BreakTag> optTag;
        boolean broken;
        int newIndent;

        /*
         * WARNING - void declaration
         */
        private Break(FillMode fillMode, String flat, Indent plusIndent, Optional<Output.BreakTag> optTag) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.fillMode = var1_1;
            this.flat = var2_2;
            this.plusIndent = var3_3;
            this.optTag = optTag;
        }

        /*
         * WARNING - void declaration
         */
        public static Break make(FillMode fillMode, String flat, Indent plusIndent) {
            void var2_2;
            void var1_1;
            FillMode fillMode2;
            return new Break(fillMode2, (String)var1_1, (Indent)var2_2, Optional.empty());
        }

        /*
         * WARNING - void declaration
         */
        public static Break make(FillMode fillMode, String flat, Indent plusIndent, Optional<Output.BreakTag> optTag) {
            void var3_3;
            void var2_2;
            void var1_1;
            FillMode fillMode2;
            return new Break(fillMode2, (String)var1_1, (Indent)var2_2, (Optional<Output.BreakTag>)var3_3);
        }

        public static Break makeForced() {
            return Break.make(FillMode.FORCED, "", Indent.Const.ZERO);
        }

        final int getPlusIndent() {
            return this.plusIndent.eval();
        }

        final boolean isForced() {
            return this.fillMode == FillMode.FORCED;
        }

        @Override
        public final void add(DocBuilder builder) {
            builder.breakDoc(this);
        }

        @Override
        final int computeWidth() {
            if (this.isForced()) {
                return 1000;
            }
            return this.flat.length();
        }

        @Override
        final String computeFlat() {
            return this.flat;
        }

        @Override
        final Range<Integer> computeRange() {
            return EMPTY_RANGE;
        }

        /*
         * WARNING - void declaration
         */
        public final State computeBreaks(State state, int lastIndent, boolean broken) {
            void var1_1;
            void var3_3;
            if (this.optTag.isPresent()) {
                this.optTag.get().recordBroken(broken);
            }
            if (var3_3 != false) {
                void var2_2;
                this.broken = true;
                this.newIndent = Math.max((int)(var2_2 + this.plusIndent.eval()), 0);
                return state.withColumn(this.newIndent);
            }
            this.broken = false;
            this.newIndent = -1;
            void v0 = var1_1;
            return v0.withColumn(v0.column + this.flat.length());
        }

        @Override
        public final State computeBreaks(CommentsHelper commentsHelper, int maxWidth, State state) {
            throw new UnsupportedOperationException("Did you mean computeBreaks(State, int, boolean)?");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(Output output) {
            void var1_1;
            if (this.broken) {
                output.append("\n", EMPTY_RANGE);
                output.indent(this.newIndent);
                return;
            }
            var1_1.append(this.flat, this.range());
        }

        public final String toString() {
            return MoreObjects.toStringHelper(this).add("fillMode", (Object)this.fillMode).add("flat", this.flat).add("plusIndent", this.plusIndent).add("optTag", this.optTag).toString();
        }
    }

    static final class Space
    extends Doc
    implements Op {
        private static final Space SPACE = new Space();

        private Space() {
        }

        static Space make() {
            return SPACE;
        }

        @Override
        public final void add(DocBuilder builder) {
            builder.add(this);
        }

        @Override
        final int computeWidth() {
            return 1;
        }

        @Override
        final String computeFlat() {
            return " ";
        }

        @Override
        final Range<Integer> computeRange() {
            return EMPTY_RANGE;
        }

        @Override
        public final State computeBreaks(CommentsHelper commentsHelper, int maxWidth, State state) {
            State state2 = state;
            return state2.withColumn(state2.column + 1);
        }

        @Override
        public final void write(Output output) {
            output.append(" ", this.range());
        }

        public final String toString() {
            return MoreObjects.toStringHelper(this).toString();
        }
    }

    public static final class Token
    extends Doc
    implements Op {
        private final Input.Token token;
        private final RealOrImaginary realOrImaginary;
        private final Indent plusIndentCommentsBefore;
        private final Optional<Indent> breakAndIndentTrailingComment;

        private Input.Tok tok() {
            return this.token.getTok();
        }

        /*
         * WARNING - void declaration
         */
        private Token(Input.Token token, RealOrImaginary realOrImaginary, Indent plusIndentCommentsBefore, Optional<Indent> breakAndIndentTrailingComment) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.token = var1_1;
            this.realOrImaginary = var2_2;
            this.plusIndentCommentsBefore = var3_3;
            this.breakAndIndentTrailingComment = breakAndIndentTrailingComment;
        }

        final Indent getPlusIndentCommentsBefore() {
            return this.plusIndentCommentsBefore;
        }

        final Optional<Indent> breakAndIndentTrailingComment() {
            return this.breakAndIndentTrailingComment;
        }

        /*
         * WARNING - void declaration
         */
        static Op make(Input.Token token, RealOrImaginary realOrImaginary, Indent plusIndentCommentsBefore, Optional<Indent> breakAndIndentTrailingComment) {
            void var3_3;
            void var2_2;
            void var1_1;
            Input.Token token2;
            return new Token(token2, (RealOrImaginary)var1_1, (Indent)var2_2, (Optional<Indent>)var3_3);
        }

        final Input.Token getToken() {
            return this.token;
        }

        final RealOrImaginary realOrImaginary() {
            return this.realOrImaginary;
        }

        @Override
        public final void add(DocBuilder builder) {
            builder.add(this);
        }

        @Override
        final int computeWidth() {
            int n = Newlines.firstBreak(this.tok().getOriginalText());
            if (n >= 0) {
                return 1000;
            }
            return this.tok().length();
        }

        @Override
        final String computeFlat() {
            return this.token.getTok().getOriginalText();
        }

        @Override
        final Range<Integer> computeRange() {
            return Range.singleton(this.token.getTok().getIndex()).canonical(INTEGERS);
        }

        @Override
        public final State computeBreaks(CommentsHelper commentsHelper, int maxWidth, State state) {
            State state2 = state;
            return state2.withColumn(state2.column + this.computeWidth());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(Output output) {
            void var2_2;
            void var1_1;
            String text = this.token.getTok().getOriginalText();
            var1_1.append((String)var2_2, this.range());
        }

        public final String toString() {
            return MoreObjects.toStringHelper(this).add("token", this.token).add("realOrImaginary", (Object)this.realOrImaginary).add("plusIndentCommentsBefore", this.plusIndentCommentsBefore).toString();
        }

        public static enum RealOrImaginary {
            REAL,
            IMAGINARY;


            final boolean isReal() {
                return this == REAL;
            }
        }
    }

    static final class Level
    extends Doc {
        private final Indent plusIndent;
        private final List<Doc> docs = new ArrayList<Doc>();
        boolean oneLine = false;
        List<List<Doc>> splits = new ArrayList<List<Doc>>();
        List<Break> breaks = new ArrayList<Break>();

        /*
         * WARNING - void declaration
         */
        private Level(Indent plusIndent) {
            void var1_1;
            this.plusIndent = var1_1;
        }

        static Level make(Indent plusIndent) {
            Indent indent;
            return new Level(indent);
        }

        /*
         * WARNING - void declaration
         */
        final void add(Doc doc) {
            void var1_1;
            this.docs.add((Doc)var1_1);
        }

        @Override
        final int computeWidth() {
            return Level.getWidth(this.docs);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final String computeFlat() {
            void var1_1;
            StringBuilder builder = new StringBuilder();
            for (Doc doc : this.docs) {
                void var3_3;
                builder.append(var3_3.getFlat());
            }
            return var1_1.toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Range<Integer> computeRange() {
            void var1_1;
            Range<Integer> docRange = EMPTY_RANGE;
            for (Doc doc : this.docs) {
                void var3_3;
                docRange = Level.union(docRange, var3_3.range());
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final State computeBreaks(CommentsHelper commentsHelper, int maxWidth, State state) {
            void var1_1;
            void var3_3;
            void var2_2;
            int thisWidth = this.getWidth();
            if (state.column + thisWidth <= maxWidth) {
                this.oneLine = true;
                State state2 = state;
                return state2.withColumn(state2.column + thisWidth);
            }
            State broken = this.computeBroken(commentsHelper, (int)var2_2, new State(state.indent + this.plusIndent.eval(), state.column));
            return var3_3.withColumn(var1_1.column);
        }

        /*
         * WARNING - void declaration
         */
        private static void splitByBreaks(List<Doc> docs, List<List<Doc>> splits, List<Break> breaks) {
            Iterator<Doc> iterator;
            splits.clear();
            breaks.clear();
            splits.add(new ArrayList());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                Doc doc = (Doc)iterator.next();
                if (doc instanceof Break) {
                    breaks.add((Break)doc);
                    splits.add(new ArrayList());
                    continue;
                }
                Iterables.getLast(splits).add((Doc)var3_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        private State computeBroken(CommentsHelper commentsHelper, int maxWidth, State state) {
            void var3_3;
            Level.splitByBreaks(this.docs, this.splits, this.breaks);
            state = Level.computeBreakAndSplit(commentsHelper, maxWidth, state, Optional.empty(), this.splits.get(0));
            for (int i = 0; i < this.breaks.size(); ++i) {
                state = Level.computeBreakAndSplit(commentsHelper, maxWidth, state, Optional.of(this.breaks.get(i)), this.splits.get(i + 1));
            }
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        private static State computeBreakAndSplit(CommentsHelper commentsHelper, int maxWidth, State state, Optional<Break> optBreakDoc, List<Doc> split) {
            void var2_2;
            void var3_4;
            void var1_1;
            CommentsHelper commentsHelper2;
            boolean shouldBreak;
            int breakWidth = optBreakDoc.isPresent() ? optBreakDoc.get().getWidth() : 0;
            int splitWidth = Level.getWidth(split);
            boolean bl = shouldBreak = optBreakDoc.isPresent() && optBreakDoc.get().fillMode == FillMode.UNIFIED || state.mustBreak || state.column + breakWidth + splitWidth > maxWidth;
            if (optBreakDoc.isPresent()) {
                State state2 = state;
                state = optBreakDoc.get().computeBreaks(state2, state2.lastIndent, shouldBreak);
            }
            boolean enoughRoom = state.column + splitWidth <= maxWidth;
            state = Level.computeSplit(commentsHelper2, (int)var1_1, split, state.withMustBreak(false));
            if (var3_4 == false) {
                state = state.withMustBreak(true);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private static State computeSplit(CommentsHelper commentsHelper, int maxWidth, List<Doc> docs, State state) {
            void var3_3;
            for (Doc doc : docs) {
                state = doc.computeBreaks(commentsHelper, maxWidth, state);
            }
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(Output output) {
            void var1_1;
            if (this.oneLine) {
                output.append(this.getFlat(), this.range());
                return;
            }
            this.writeFilled((Output)var1_1);
        }

        private void writeFilled(Output output) {
            for (Doc object : this.splits.get(0)) {
                object.write(output);
            }
            for (int i = 0; i < this.breaks.size(); ++i) {
                ((Doc)this.breaks.get(i)).write(output);
                for (Doc doc : this.splits.get(i + 1)) {
                    doc.write(output);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        static int getWidth(List<Doc> docs) {
            void var1_1;
            Iterator<Doc> iterator;
            int width = 0;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Doc doc = (Doc)iterator.next();
                if ((width += var2_2.getWidth()) < 1000) continue;
                return 1000;
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private static Range<Integer> union(Range<Integer> x, Range<Integer> y) {
            void var1_1;
            Range<Integer> range;
            if (x.isEmpty()) {
                return y;
            }
            if (y.isEmpty()) {
                return x;
            }
            return range.span((Range<Integer>)var1_1).canonical(INTEGERS);
        }

        public final String toString() {
            return MoreObjects.toStringHelper(this).add("plusIndent", this.plusIndent).add("docs", this.docs).toString();
        }
    }

    public static final class State {
        final int lastIndent;
        final int indent;
        final int column;
        final boolean mustBreak;

        /*
         * WARNING - void declaration
         */
        State(int lastIndent, int indent, int column, boolean mustBreak) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.lastIndent = var1_1;
            this.indent = var2_2;
            this.column = var3_3;
            this.mustBreak = mustBreak;
        }

        /*
         * WARNING - void declaration
         */
        public State(int indent0, int column0) {
            void var2_2;
            void var1_1;
            void v0 = var1_1;
            this((int)v0, (int)v0, (int)var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        final State withColumn(int column) {
            void var1_1;
            return new State(this.lastIndent, this.indent, (int)var1_1, this.mustBreak);
        }

        /*
         * WARNING - void declaration
         */
        final State withMustBreak(boolean mustBreak) {
            void var1_1;
            return new State(this.lastIndent, this.indent, this.column, (boolean)var1_1);
        }

        public final String toString() {
            return MoreObjects.toStringHelper(this).add("lastIndent", this.lastIndent).add("indent", this.indent).add("column", this.column).add("mustBreak", this.mustBreak).toString();
        }
    }

    public static enum FillMode {
        UNIFIED,
        INDEPENDENT,
        FORCED;

    }
}

