/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat;

import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class InputOutput {
    private ImmutableList<String> lines = ImmutableList.of();
    protected static final Range<Integer> EMPTY_RANGE = Range.closedOpen(-1, -1);
    private static final DiscreteDomain<Integer> INTEGERS = DiscreteDomain.integers$69c50eee();
    protected final List<Range<Integer>> ranges = new ArrayList<Range<Integer>>();

    /*
     * WARNING - void declaration
     */
    protected final void setLines(ImmutableList<String> lines) {
        void var1_1;
        this.lines = var1_1;
    }

    public final int getLineCount() {
        return this.lines.size();
    }

    /*
     * WARNING - void declaration
     */
    public final String getLine(int lineI) {
        void var1_1;
        return (String)this.lines.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void addToRanges(List<Range<Integer>> ranges, int i, int k) {
        void var2_2;
        void var3_3;
        void var1_1;
        List<Range<Integer>> list2;
        while (ranges.size() <= i) {
            ranges.add(EMPTY_RANGE);
        }
        Range<Integer> oldValue = ranges.get(i);
        list2.set((int)var1_1, Range.closedOpen(oldValue.isEmpty() ? k : (Integer)var3_3.lowerEndpoint(), (int)(var2_2 + true)));
    }

    protected final void computeRanges(List<? extends Input.Tok> toks) {
        Iterator iterator;
        int lineI = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Input.Tok tok = (Input.Tok)iterator.next();
            String txt = tok.getOriginalText();
            int lineI0 = lineI;
            lineI += Newlines.count(txt);
            int k = tok.getIndex();
            if (k < 0) continue;
            for (int i = lineI0; i <= lineI; ++i) {
                InputOutput.addToRanges(this.ranges, i, k);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Map<Integer, Range<Integer>> makeKToIJ(InputOutput put) {
        void var1_1;
        HashMap<Integer, Range<Integer>> map = new HashMap<Integer, Range<Integer>>();
        int ijN = put.getLineCount();
        for (int ij = 0; ij <= ijN; ++ij) {
            Range<Integer> range = put.getRanges(ij).canonical(INTEGERS);
            for (int k = range.lowerEndpoint().intValue(); k < range.upperEndpoint(); ++k) {
                if (map.containsKey(k)) {
                    map.put(k, Range.closedOpen((Integer)((Range)map.get(k)).lowerEndpoint(), ij + 1));
                    continue;
                }
                map.put(k, Range.closedOpen(ij, ij + 1));
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Range<Integer> getRanges(int lineI) {
        if (lineI >= 0 && lineI < this.ranges.size()) {
            void var1_1;
            return this.ranges.get((int)var1_1);
        }
        return EMPTY_RANGE;
    }

    public String toString() {
        return "InputOutput{lines=" + String.valueOf(this.lines) + ", ranges=" + String.valueOf(this.ranges) + "}";
    }
}

