/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.googlejavaformat.CommentsHelper;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.Output;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.Replacement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class JavaOutput
extends Output {
    private final String lineSeparator;
    private final Input javaInput;
    private final CommentsHelper commentsHelper;
    private final Map<Integer, OpsBuilder.BlankLineWanted> blankLines = new HashMap<Integer, OpsBuilder.BlankLineWanted>();
    private final RangeSet<Integer> partialFormatRanges = TreeRangeSet.create();
    private final List<String> mutableLines = new ArrayList<String>();
    private final int kN;
    private int iLine = 0;
    private int lastK = -1;
    private int newlinesPending = 0;
    private StringBuilder lineBuilder = new StringBuilder();
    private StringBuilder spacesPending = new StringBuilder();

    /*
     * WARNING - void declaration
     */
    public JavaOutput(String lineSeparator, Input javaInput, CommentsHelper commentsHelper) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.lineSeparator = var1_1;
        this.javaInput = javaInput;
        this.commentsHelper = var3_3;
        this.kN = var2_2.getkN();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void blankLine(int k, OpsBuilder.BlankLineWanted wanted) {
        void var2_2;
        void var1_1;
        if (this.blankLines.containsKey(k)) {
            this.blankLines.put(k, this.blankLines.get(k).merge(wanted));
            return;
        }
        this.blankLines.put((int)var1_1, (OpsBuilder.BlankLineWanted)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void markForPartialFormat(Input.Token start, Input.Token end) {
        void var2_4;
        void var1_2;
        int lo = JavaOutput.startTok(start).getIndex();
        int hi = JavaOutput.endTok(end).getIndex();
        this.partialFormatRanges.add(Range.closed((int)var1_2, (int)var2_4));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void append(String text, Range<Integer> range) {
        if (!range.isEmpty()) {
            boolean sawNewlines = false;
            int iN = this.javaInput.getLineCount();
            while (this.iLine < iN && (this.javaInput.getRanges(this.iLine).isEmpty() || this.javaInput.getRanges(this.iLine).upperEndpoint() <= range.lowerEndpoint())) {
                if (this.javaInput.getRanges(this.iLine).isEmpty()) {
                    sawNewlines = true;
                }
                ++this.iLine;
            }
            OpsBuilder.BlankLineWanted wanted = this.blankLines.getOrDefault(this.lastK, OpsBuilder.BlankLineWanted.NO);
            if (sawNewlines && this.isComment(text) || wanted.wanted().orElse(sawNewlines).booleanValue()) {
                ++this.newlinesPending;
            }
        }
        if (Newlines.isNewline(text)) {
            if (this.newlinesPending == 0) {
                ++this.newlinesPending;
            }
            this.spacesPending = new StringBuilder();
        } else {
            boolean rangesSet = false;
            int textN = text.length();
            block7: for (int i = 0; i < textN; ++i) {
                char c = text.charAt(i);
                switch (c) {
                    case ' ': {
                        this.spacesPending.append(' ');
                        continue block7;
                    }
                    case '\t': {
                        this.spacesPending.append('\t');
                        continue block7;
                    }
                    case '\r': {
                        if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                            ++i;
                        }
                    }
                    case '\n': {
                        this.spacesPending = new StringBuilder();
                        ++this.newlinesPending;
                        continue block7;
                    }
                    default: {
                        while (this.newlinesPending > 0) {
                            if (!this.mutableLines.isEmpty() || this.lineBuilder.length() > 0) {
                                this.mutableLines.add(this.lineBuilder.toString());
                            }
                            this.lineBuilder = new StringBuilder();
                            rangesSet = false;
                            --this.newlinesPending;
                        }
                        if (this.spacesPending.length() > 0) {
                            this.lineBuilder.append((CharSequence)this.spacesPending);
                            this.spacesPending = new StringBuilder();
                        }
                        this.lineBuilder.append(c);
                        if (range.isEmpty() || rangesSet) continue block7;
                        while (this.ranges.size() <= this.mutableLines.size()) {
                            this.ranges.add(Formatter.EMPTY_RANGE);
                        }
                        this.ranges.set(this.mutableLines.size(), JavaOutput.union(this.ranges.get(this.mutableLines.size()), range));
                        rangesSet = true;
                    }
                }
            }
        }
        if (!range.isEmpty()) {
            void var2_2;
            this.lastK = (Integer)var2_2.upperEndpoint();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void indent(int indent) {
        void var1_1;
        this.spacesPending.append(Strings.repeat(" ", (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void flush() {
        void var2_3;
        String lastLine = this.lineBuilder.toString();
        if (!CharMatcher.whitespace().matchesAllOf(lastLine)) {
            this.mutableLines.add(lastLine);
        }
        int jN = this.mutableLines.size();
        Range<Integer> eofRange = Range.closedOpen(this.kN, this.kN + 1);
        while (this.ranges.size() < jN) {
            this.ranges.add(Formatter.EMPTY_RANGE);
        }
        this.ranges.add((Range<Integer>)var2_3);
        JavaOutput javaOutput = this;
        javaOutput.setLines(ImmutableList.copyOf(javaOutput.mutableLines));
    }

    @Override
    public final CommentsHelper getCommentsHelper() {
        return this.commentsHelper;
    }

    /*
     * WARNING - void declaration
     */
    public final ImmutableList<Replacement> getFormatReplacements(RangeSet<Integer> iRangeSet0) {
        void var2_2;
        Iterator iterator;
        ImmutableList.Builder result = ImmutableList.builder();
        Map<Integer, Range<Integer>> kToJ = JavaOutput.makeKToIJ(this);
        TreeRangeSet<Integer> breakableRanges = TreeRangeSet.create();
        iterator = iterator.subRangeSet$f4d79cf(Range.closed(0, this.javaInput.getkN()));
        for (Range range : iterator.asRanges()) {
            Range<Integer> range2 = this.expandToBreakableRegions(range.canonical(DiscreteDomain.integers$69c50eee()));
            if (range2.equals(EMPTY_RANGE)) continue;
            breakableRanges.add(range2);
        }
        for (Range range : breakableRanges.asRanges()) {
            int i;
            int replaceFrom;
            Input.Tok startTok = JavaOutput.startTok(this.javaInput.getToken((Integer)range.lowerEndpoint()));
            Input.Tok endTok = JavaOutput.endTok(this.javaInput.getToken((Integer)range.upperEndpoint() - 1));
            StringBuilder stringBuilder = new StringBuilder();
            for (replaceFrom = startTok.getPosition(); replaceFrom > 0; --replaceFrom) {
                char previous = this.javaInput.getText().charAt(replaceFrom - 1);
                if (!CharMatcher.whitespace().matches(previous)) break;
            }
            for (i = kToJ.get(startTok.getIndex()).lowerEndpoint().intValue(); i > 0 && this.getLine(i - 1).isEmpty(); --i) {
            }
            while (i < kToJ.get(endTok.getIndex()).upperEndpoint()) {
                if (i < this.getLineCount()) {
                    if (i > 0) {
                        stringBuilder.append(this.lineSeparator);
                    }
                    stringBuilder.append(this.getLine(i));
                }
                ++i;
            }
            int replaceTo = Math.min(endTok.getPosition() + endTok.length(), this.javaInput.getText().length());
            if (endTok.getIndex() == this.javaInput.getkN() - 1) {
                replaceTo = this.javaInput.getText().length();
            }
            int newline = -1;
            while (replaceTo < this.javaInput.getText().length()) {
                char next = this.javaInput.getText().charAt(replaceTo);
                if (!CharMatcher.whitespace().matches(next)) break;
                int newlineLength = Newlines.hasNewlineAt(this.javaInput.getText(), replaceTo);
                if (newlineLength != -1) {
                    newline = replaceTo;
                    replaceTo += newlineLength;
                    continue;
                }
                ++replaceTo;
            }
            if (newline != -1) {
                replaceTo = newline;
            }
            if (newline == -1) {
                stringBuilder.append(this.lineSeparator);
            }
            while (i < this.getLineCount()) {
                String after = this.getLine(i);
                int idx = CharMatcher.whitespace().negate().indexIn(after);
                if (idx != -1) {
                    if (newline != -1) break;
                    stringBuilder.append(after, 0, idx);
                    break;
                }
                stringBuilder.append(this.lineSeparator);
                ++i;
            }
            result.add(Replacement.create(replaceFrom, replaceTo, stringBuilder.toString()));
        }
        return var2_2.build();
    }

    /*
     * WARNING - void declaration
     */
    private Range<Integer> expandToBreakableRegions(Range<Integer> iRange) {
        void var1_2;
        void var2_3;
        int loTok = iRange.lowerEndpoint();
        int hiTok = iRange.upperEndpoint() - 1;
        if (!this.partialFormatRanges.contains(loTok) || !this.partialFormatRanges.contains(hiTok)) {
            return EMPTY_RANGE;
        }
        loTok = this.partialFormatRanges.rangeContaining(loTok).lowerEndpoint();
        hiTok = this.partialFormatRanges.rangeContaining(hiTok).upperEndpoint();
        return Range.closedOpen((int)var2_3, (int)(var1_2 + true));
    }

    /*
     * WARNING - void declaration
     */
    public static String applyReplacements(String input, List<Replacement> replacements) {
        CharSequence charSequence;
        Iterator iterator;
        replacements = new ArrayList<Replacement>(replacements);
        replacements.sort(Comparator.comparing(r -> r.getReplaceRange().lowerEndpoint()).reversed());
        CharSequence writer = new StringBuilder(input);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Replacement replacement = (Replacement)iterator.next();
            ((StringBuilder)writer).replace(replacement.getReplaceRange().lowerEndpoint(), replacement.getReplaceRange().upperEndpoint(), var2_2.getReplacementString());
        }
        return ((StringBuilder)charSequence).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static int startPosition(Input.Token token) {
        void var1_1;
        Object object;
        int min = token.getTok().getPosition();
        for (Input.Tok tok : object.getToksBefore()) {
            min = Math.min(min, tok.getPosition());
        }
        return (int)var1_1;
    }

    public static Input.Tok startTok(Input.Token token) {
        Input.Token token2;
        for (Input.Tok tok : token.getToksBefore()) {
            if (tok.getIndex() < 0) continue;
            return tok;
        }
        return token2.getTok();
    }

    /*
     * WARNING - void declaration
     */
    public static Input.Tok endTok(Input.Token token) {
        Input.Token token2;
        for (int i = token.getToksAfter().size() - 1; i >= 0; --i) {
            void var2_2;
            Input.Tok tok = (Input.Tok)token.getToksAfter().get(i);
            if (tok.getIndex() < 0) continue;
            return var2_2;
        }
        return token2.getTok();
    }

    /*
     * WARNING - void declaration
     */
    private boolean isComment(String text) {
        void var1_1;
        return text.startsWith("//") || var1_1.startsWith("/*");
    }

    /*
     * WARNING - void declaration
     */
    private static Range<Integer> union(Range<Integer> x, Range<Integer> y) {
        void var1_1;
        Range<Integer> range;
        if (x.isEmpty()) {
            return y;
        }
        if (y.isEmpty()) {
            return x;
        }
        return range.span((Range<Integer>)var1_1).canonical(DiscreteDomain.integers$69c50eee());
    }

    @Override
    public final String toString() {
        return MoreObjects.toStringHelper(this).add("iLine", this.iLine).add("lastK", this.lastK).add("spacesPending", this.spacesPending.toString().replace("\t", "\\t")).add("newlinesPending", this.newlinesPending).add("blankLines", this.blankLines).add("super", super.toString()).toString();
    }
}

