/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeMap;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Position;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import org.jspecify.annotations.Nullable;

public final class StringWrapper {
    private static final Method STRIP_INDENT = StringWrapper.getStripIndent();
    public static final CharMatcher STRING_CONCAT_DELIMITER = CharMatcher.whitespace().or(CharMatcher.anyOf("\"+"));

    /*
     * WARNING - void declaration
     */
    public static String wrap(String input, Formatter formatter) throws FormatterException {
        void var1_1;
        String string;
        return StringWrapper.wrap(100, string, (Formatter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static String wrap(int columnLimit, String input, Formatter formatter) throws FormatterException {
        void var0_1;
        String actual;
        void var3_4;
        if (!StringWrapper.needWrapping(columnLimit, input)) {
            return input;
        }
        TreeRangeMap<Integer, String> replacements = StringWrapper.getReflowReplacements(columnLimit, input);
        String firstPass = formatter.formatSource(input, replacements.asMapOfRanges().keySet());
        if (!firstPass.equals(input)) {
            input = firstPass;
            replacements = StringWrapper.getReflowReplacements(columnLimit, input);
        }
        String result = StringWrapper.applyReplacements(input, (TreeRangeMap<Integer, String>)var3_4);
        String expected = StringWrapper.parse(input, true).toString();
        if (!expected.equals(actual = StringWrapper.parse(result, true).toString())) {
            void var1_2;
            void var2_3;
            throw new FormatterException(String.format("Something has gone terribly wrong. We planned to make the below formatting change, but have aborted because it would unexpectedly change the AST.\nPlease file a bug: https://github.com/google/google-java-format/issues/new\n\n=== Actual: ===\n%s\n=== Expected: ===\n%s\n", var2_3, var1_2));
        }
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    private static TreeRangeMap<Integer, String> getReflowReplacements(int columnLimit, String input) throws FormatterException {
        void var1_1;
        int n;
        return new Reflower(n, (String)var1_1).getReflowReplacements();
    }

    /*
     * WARNING - void declaration
     */
    private static @Nullable Method getStripIndent() {
        if (Runtime.version().feature() < 15) {
            return null;
        }
        try {
            return String.class.getMethod("stripIndent", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            void var0;
            throw new LinkageError(e.getMessage(), (Throwable)var0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String stripIndent(String input) {
        if (STRIP_INDENT == null) {
            return input;
        }
        try {
            return (String)STRIP_INDENT.invoke((Object)input, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            void var0_1;
            throw new LinkageError(e.getMessage(), (Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ImmutableList<String> stringComponents(String input, JCTree.JCCompilationUnit unit, List<Tree> flat) {
        void var3_3;
        Iterator iterator;
        ImmutableList.Builder result = ImmutableList.builder();
        StringBuilder piece = new StringBuilder();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Tree tree = (Tree)iterator.next();
            String text = input.substring(StringWrapper.getStartPosition(tree) + 1, StringWrapper.getEndPosition(unit, tree) - 1);
            int start = 0;
            for (int idx = 0; idx < text.length(); ++idx) {
                if (!CharMatcher.whitespace().matches(text.charAt(idx)) && StringWrapper.hasEscapedWhitespaceAt(text, idx) == -1) {
                    int length;
                    if (StringWrapper.hasEscapedNewlineAt(text, idx) == -1) continue;
                    while ((length = StringWrapper.hasEscapedNewlineAt(text, idx)) != -1) {
                        idx += length;
                    }
                }
                piece.append(text, start, idx);
                result.add(piece.toString());
                piece = new StringBuilder();
                start = idx;
            }
            if (piece.length() > 0) {
                result.add(piece.toString());
                piece = new StringBuilder();
            }
            if (start >= text.length()) continue;
            piece.append(text, start, text.length());
        }
        if (piece.length() > 0) {
            result.add(piece.toString());
        }
        return var3_3.build();
    }

    /*
     * WARNING - void declaration
     */
    static int hasEscapedWhitespaceAt(String input, int idx) {
        void var1_1;
        String string;
        return Stream.of("\\t").mapToInt(arg_0 -> StringWrapper.lambda$hasEscapedWhitespaceAt$0(string, (int)var1_1, arg_0)).filter(x -> x != -1).findFirst().orElse(-1);
    }

    /*
     * WARNING - void declaration
     */
    static int hasEscapedNewlineAt(String input, int idx) {
        void var1_1;
        String string;
        return Stream.of("\\r\\n", "\\r", "\\n").mapToInt(arg_0 -> StringWrapper.lambda$hasEscapedNewlineAt$2(string, (int)var1_1, arg_0)).filter(x -> x != -1).findFirst().orElse(-1);
    }

    /*
     * WARNING - void declaration
     */
    private static String reflow(String separator, int columnLimit, int startColumn, int trailing, ImmutableList<String> components, boolean first0) {
        void var2_2;
        String string;
        int width = columnLimit - startColumn - 2;
        ArrayDeque<String> input = new ArrayDeque<String>(components);
        ArrayList<String> lines = new ArrayList<String>();
        boolean first = first0;
        while (!input.isEmpty()) {
            int length = 0;
            ArrayList<String> line = new ArrayList<String>();
            if (input.stream().mapToInt(String::length).sum() <= width) {
                width -= trailing;
            }
            while (!(input.isEmpty() || length > 4 && length + ((String)input.peekFirst()).length() > width)) {
                String text = (String)input.removeFirst();
                line.add(text);
                length += text.length();
                if (!text.endsWith("\\n") && !text.endsWith("\\r")) continue;
            }
            if (line.isEmpty()) {
                line.add((String)input.removeFirst());
            }
            lines.add(String.join((CharSequence)"", line));
            if (!first) continue;
            width -= 6;
            first = false;
        }
        return lines.stream().collect(Collectors.joining("\"" + string + Strings.repeat(" ", (int)(var2_2 + (first0 ? 4 : -2))) + "+ \"", "\"", "\""));
    }

    /*
     * WARNING - void declaration
     */
    private static List<Tree> flatten(String input, JCTree.JCCompilationUnit unit, TreePath path, TreePath parent, AtomicBoolean firstInChain) {
        void var2_3;
        int startIdx;
        void var3_5;
        ArrayList<Tree> flat = new ArrayList<Tree>();
        ArrayDeque<Tree> todo = new ArrayDeque<Tree>();
        todo.add(parent.getLeaf());
        while (!todo.isEmpty()) {
            Tree first = (Tree)todo.removeFirst();
            if (first.getKind() == Tree.Kind.PLUS) {
                BinaryTree bt = (BinaryTree)first;
                todo.addFirst(bt.getRightOperand());
                todo.addFirst(bt.getLeftOperand());
                continue;
            }
            flat.add(first);
        }
        int idx = flat.indexOf(path.getLeaf());
        Verify.verify(idx != -1);
        void endIdx = var3_5 + true;
        for (startIdx = idx; startIdx > 0 && ((Tree)flat.get(startIdx - 1)).getKind() == Tree.Kind.STRING_LITERAL && StringWrapper.noComments(input, unit, (Tree)flat.get(startIdx - 1), (Tree)flat.get(startIdx)); --startIdx) {
        }
        while (endIdx < flat.size() && ((Tree)flat.get((int)endIdx)).getKind() == Tree.Kind.STRING_LITERAL && StringWrapper.noComments(input, unit, (Tree)flat.get((int)(endIdx - true)), (Tree)flat.get((int)endIdx))) {
            ++endIdx;
        }
        firstInChain.set(startIdx == 0);
        return ImmutableList.copyOf(flat.subList(startIdx, (int)var2_3));
    }

    /*
     * WARNING - void declaration
     */
    private static boolean noComments(String input, JCTree.JCCompilationUnit unit, Tree one, Tree two) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        return STRING_CONCAT_DELIMITER.matchesAllOf(string.subSequence(StringWrapper.getEndPosition((JCTree.JCCompilationUnit)var1_1, (Tree)var2_2), StringWrapper.getStartPosition((Tree)var3_3)));
    }

    private static int getEndPosition(JCTree.JCCompilationUnit unit, Tree tree) {
        JCTree.JCCompilationUnit jCCompilationUnit;
        return ((JCTree)tree).getEndPosition(jCCompilationUnit.endPositions);
    }

    private static int getStartPosition(Tree tree) {
        return ((JCTree)tree).getStartPosition();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean needWrapping(int columnLimit, String input) {
        Iterator<String> it = Newlines.lineIterator(input);
        while (it.hasNext()) {
            void var2_2;
            String line = it.next();
            if (line.length() <= columnLimit && !var2_2.contains("\"\"\"")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static JCTree.JCCompilationUnit parse(String source, boolean allowStringFolding) throws FormatterException {
        JCTree.JCCompilationUnit jCCompilationUnit;
        void var2_4;
        ParserFactory parserFactory;
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        Context context = new Context();
        context.put(DiagnosticListener.class, diagnostics);
        Options.instance(context).put("--enable-preview", "true");
        Options.instance(context).put("allowStringFolding", Boolean.toString(allowStringFolding));
        JavacFileManager fileManager = new JavacFileManager(context, true, StandardCharsets.UTF_8);
        try {
            fileManager.setLocation(StandardLocation.PLATFORM_CLASS_PATH, ImmutableList.of());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        SimpleJavaFileObject sjfo = new SimpleJavaFileObject(URI.create("source"), JavaFileObject.Kind.SOURCE, (String)source){
            final /* synthetic */ String val$source;
            {
                void var2_2;
                void var1_1;
                this.val$source = string;
                super((URI)var1_1, (JavaFileObject.Kind)var2_2);
            }

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) {
                return this.val$source;
            }
        };
        Log.instance(context).useSource(sjfo);
        parserFactory = ParserFactory.instance((Context)((Object)parserFactory));
        source = parserFactory.newParser((CharSequence)source, true, true, true);
        JCTree.JCCompilationUnit unit = ((JavacParser)source).parseCompilationUnit();
        ((JavacParser)source).parseCompilationUnit().sourcefile = sjfo;
        Iterables.4 errorDiagnostics = Iterables.filter$73b06d87(var2_4.getDiagnostics(), Formatter::errorDiagnostic);
        if (!Iterables.isEmpty(errorDiagnostics)) {
            void var1_2;
            throw FormatterException.fromJavacDiagnostics((Iterable<Diagnostic<? extends JavaFileObject>>)var1_2);
        }
        return jCCompilationUnit;
    }

    /*
     * WARNING - void declaration
     */
    private static String applyReplacements(String javaInput, TreeRangeMap<Integer, String> replacementMap) throws FormatterException {
        CharSequence charSequence;
        Iterator iterator;
        TreeRangeMap.AsMapOfRanges ranges = replacementMap.asDescendingMapOfRanges$604efcea();
        if (ranges.isEmpty()) {
            return javaInput;
        }
        CharSequence sb = new StringBuilder(javaInput);
        for (Map.Entry entry : iterator.entrySet()) {
            void var2_2;
            void var3_3;
            Range range = (Range)entry.getKey();
            ((StringBuilder)sb).replace((Integer)range.lowerEndpoint(), (Integer)var3_3.upperEndpoint(), (String)var2_2.getValue());
        }
        return ((StringBuilder)charSequence).toString();
    }

    private StringWrapper() {
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ int lambda$hasEscapedNewlineAt$2(String input, int idx, String x) {
        void var1_1;
        if (input.startsWith(x, (int)var1_1)) {
            void var2_2;
            return var2_2.length();
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ int lambda$hasEscapedWhitespaceAt$0(String input, int idx, String x) {
        void var1_1;
        if (input.startsWith(x, (int)var1_1)) {
            void var2_2;
            return var2_2.length();
        }
        return -1;
    }

    private static class Reflower {
        private final String input;
        private final int columnLimit;
        private final String separator;
        private final JCTree.JCCompilationUnit unit;
        private final Position.LineMap lineMap;

        /*
         * WARNING - void declaration
         */
        Reflower(int columnLimit, String input) throws FormatterException {
            void var2_2;
            void var1_1;
            this.columnLimit = var1_1;
            this.input = input;
            this.separator = Newlines.guessLineSeparator(input);
            this.unit = StringWrapper.parse((String)var2_2, false);
            this.lineMap = this.unit.getLineMap();
        }

        /*
         * WARNING - void declaration
         */
        TreeRangeMap<Integer, String> getReflowReplacements() {
            void var3_3;
            void var1_1;
            void var2_2;
            ArrayList<TreePath> longStringLiterals = new ArrayList<TreePath>();
            ArrayList<Tree> textBlocks = new ArrayList<Tree>();
            new LongStringsAndTextBlockScanner(longStringLiterals, textBlocks).scan(new TreePath(this.unit), null);
            TreeRangeMap<Integer, String> replacements = TreeRangeMap.create();
            this.indentTextBlocks(replacements, (List<Tree>)var2_2);
            this.wrapLongStrings(replacements, (List<TreePath>)var1_1);
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        private void indentTextBlocks(TreeRangeMap<Integer, String> replacements, List<Tree> textBlocks) {
            for (Tree tree : textBlocks) {
                void var3_3;
                int startPosition = StringWrapper.getStartPosition(tree);
                int endPosition = StringWrapper.getEndPosition(this.unit, tree);
                String string = this.input.substring(startPosition, endPosition);
                ImmutableList initialLines = string.lines().collect(ImmutableList.toImmutableList());
                String string2 = StringWrapper.stripIndent(initialLines.stream().skip(1L).collect(Collectors.joining(this.separator)));
                ImmutableList lines = string2.lines().collect(ImmutableList.toImmutableList());
                int deindent = ((String)initialLines.get(1)).stripTrailing().length() - ((String)lines.get(0)).stripTrailing().length();
                int startColumn = this.lineMap.getColumnNumber(startPosition);
                String prefix = deindent == 0 || lines.stream().anyMatch(x -> {
                    void var1_1;
                    return x.length() + var1_1 > this.columnLimit;
                }) ? "" : " ".repeat(startColumn - 1);
                StringBuilder output = new StringBuilder("\"\"\"");
                for (int i = 0; i < lines.size(); ++i) {
                    String line = (String)lines.get(i);
                    String trimmed = line.stripLeading().stripTrailing();
                    output.append(this.separator);
                    if (!trimmed.isEmpty()) {
                        output.append(prefix);
                    }
                    if (i == lines.size() - 1 && trimmed.equals("\"\"\"")) {
                        output.append("\"\"\"");
                        continue;
                    }
                    output.append(line);
                }
                replacements.put(Range.closedOpen(startPosition, (int)var3_3), output.toString());
            }
        }

        /*
         * WARNING - void declaration
         */
        private void wrapLongStrings(TreeRangeMap<Integer, String> replacements, List<TreePath> longStringLiterals) {
            Iterator<TreePath> iterator = longStringLiterals.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                int end;
                TreePath path;
                TreePath enclosing = path = iterator.next();
                while (enclosing.getParentPath().getLeaf().getKind() == Tree.Kind.PLUS) {
                    enclosing = enclosing.getParentPath();
                }
                AtomicBoolean first = new AtomicBoolean(false);
                List<Tree> flat = StringWrapper.flatten(this.input, this.unit, path, enclosing, first);
                int startColumn = this.lineMap.getColumnNumber(StringWrapper.getStartPosition(flat.get(0))) - 1;
                int lineEnd = end = StringWrapper.getEndPosition(this.unit, Iterables.getLast(flat));
                while (Newlines.hasNewlineAt(this.input, lineEnd) == -1) {
                    ++lineEnd;
                }
                int trailing = lineEnd - end;
                ImmutableList<String> components = StringWrapper.stringComponents(this.input, this.unit, flat);
                replacements.put(Range.closedOpen(StringWrapper.getStartPosition(flat.get(0)), StringWrapper.getEndPosition(this.unit, (Tree)Iterables.getLast(var3_3))), StringWrapper.reflow(this.separator, this.columnLimit, startColumn, trailing, components, first.get()));
            }
        }

        private class LongStringsAndTextBlockScanner
        extends TreePathScanner<Void, Void> {
            private final List<TreePath> longStringLiterals;
            private final List<Tree> textBlocks;

            /*
             * WARNING - void declaration
             */
            LongStringsAndTextBlockScanner(List<TreePath> longStringLiterals, List<Tree> textBlocks) {
                void var3_3;
                void var2_2;
                this.longStringLiterals = var2_2;
                this.textBlocks = var3_3;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Void visitLiteral(LiteralTree literalTree, Void aVoid) {
                void var1_2;
                void var2_5;
                if (literalTree.getKind() != Tree.Kind.STRING_LITERAL) {
                    return null;
                }
                int pos = StringWrapper.getStartPosition(literalTree);
                if (Reflower.this.input.substring(pos, Math.min(Reflower.this.input.length(), pos + 3)).equals("\"\"\"")) {
                    this.textBlocks.add(literalTree);
                    return null;
                }
                Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                if (parent instanceof MemberSelectTree && ((MemberSelectTree)var2_5).getExpression().equals(literalTree)) {
                    return null;
                }
                int lineEnd = StringWrapper.getEndPosition(Reflower.this.unit, literalTree);
                while (Newlines.hasNewlineAt(Reflower.this.input, lineEnd) == -1) {
                    ++lineEnd;
                }
                if (Reflower.this.lineMap.getColumnNumber((int)var1_2) - 1 <= Reflower.this.columnLimit) {
                    return null;
                }
                this.longStringLiterals.add(this.getCurrentPath());
                return null;
            }
        }
    }
}

