/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java.javadoc;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.googlejavaformat.java.javadoc.CharStream;
import com.google.googlejavaformat.java.javadoc.NestingCounter;
import com.google.googlejavaformat.java.javadoc.Token;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

final class JavadocLexer {
    private static final Pattern NON_UNIX_LINE_ENDING = Pattern.compile("\r\n?");
    private final CharStream input;
    private final NestingCounter braceDepth = new NestingCounter();
    private final NestingCounter preDepth = new NestingCounter();
    private final NestingCounter codeDepth = new NestingCounter();
    private final NestingCounter tableDepth = new NestingCounter();
    private boolean somethingSinceNewline;
    private static final CharMatcher NEWLINE = CharMatcher.is$8d21c63('\n');
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("^[ \t]*\n[ \t]*[*]?[ \t]?");
    private static final Pattern FOOTER_TAG_PATTERN = Pattern.compile("^@(param\\s+<\\w+>|[a-z]\\w*)");
    private static final Pattern MOE_BEGIN_STRIP_COMMENT_PATTERN = Pattern.compile("^<!--\\s*MOE:begin_intracomment_strip\\s*-->");
    private static final Pattern MOE_END_STRIP_COMMENT_PATTERN = Pattern.compile("^<!--\\s*MOE:end_intracomment_strip\\s*-->");
    private static final Pattern HTML_COMMENT_PATTERN = JavadocLexer.fullCommentPattern();
    private static final Pattern PRE_OPEN_PATTERN = JavadocLexer.openTagPattern("pre");
    private static final Pattern PRE_CLOSE_PATTERN = JavadocLexer.closeTagPattern("pre");
    private static final Pattern CODE_OPEN_PATTERN = JavadocLexer.openTagPattern("code");
    private static final Pattern CODE_CLOSE_PATTERN = JavadocLexer.closeTagPattern("code");
    private static final Pattern TABLE_OPEN_PATTERN = JavadocLexer.openTagPattern("table");
    private static final Pattern TABLE_CLOSE_PATTERN = JavadocLexer.closeTagPattern("table");
    private static final Pattern LIST_OPEN_PATTERN = JavadocLexer.openTagPattern("ul|ol|dl");
    private static final Pattern LIST_CLOSE_PATTERN = JavadocLexer.closeTagPattern("ul|ol|dl");
    private static final Pattern LIST_ITEM_OPEN_PATTERN = JavadocLexer.openTagPattern("li|dt|dd");
    private static final Pattern LIST_ITEM_CLOSE_PATTERN = JavadocLexer.closeTagPattern("li|dt|dd");
    private static final Pattern HEADER_OPEN_PATTERN = JavadocLexer.openTagPattern("h[1-6]");
    private static final Pattern HEADER_CLOSE_PATTERN = JavadocLexer.closeTagPattern("h[1-6]");
    private static final Pattern PARAGRAPH_OPEN_PATTERN = JavadocLexer.openTagPattern("p");
    private static final Pattern PARAGRAPH_CLOSE_PATTERN = JavadocLexer.closeTagPattern("p");
    private static final Pattern BLOCKQUOTE_OPEN_PATTERN = JavadocLexer.openTagPattern("blockquote");
    private static final Pattern BLOCKQUOTE_CLOSE_PATTERN = JavadocLexer.closeTagPattern("blockquote");
    private static final Pattern BR_PATTERN = JavadocLexer.openTagPattern("br");
    private static final Pattern INLINE_TAG_OPEN_PATTERN = Pattern.compile("^[{]@\\w*");
    private static final Pattern LITERAL_PATTERN = Pattern.compile("^.[^ \t\n@<{}*]*", 32);

    static ImmutableList<Token> lex(String input) throws LexException {
        String string;
        input = JavadocLexer.stripJavadocBeginAndEnd(input);
        input = JavadocLexer.normalizeLineEndings(input);
        return new JavadocLexer(new CharStream(string)).generateTokens();
    }

    private static String normalizeLineEndings(String input) {
        String string;
        return NON_UNIX_LINE_ENDING.matcher(string).replaceAll("\n");
    }

    private static String stripJavadocBeginAndEnd(String input) {
        String string;
        Preconditions.checkArgument(input.startsWith("/**"), "Missing /**: %s", input);
        Preconditions.checkArgument(input.endsWith("*/") && input.length() > 4, "Missing */: %s", input);
        return input.substring(3, string.length() - 2);
    }

    /*
     * WARNING - void declaration
     */
    private JavadocLexer(CharStream input) {
        void var1_1;
        this.input = (CharStream)Preconditions.checkNotNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableList<Token> generateTokens() throws LexException {
        ImmutableList<Token> immutableList;
        void var2_2;
        ImmutableList.Builder tokens = ImmutableList.builder();
        Token token = new Token(Token.Type.BEGIN_JAVADOC, "/**");
        tokens.add(token);
        while (!this.input.isExhausted()) {
            token = this.readToken();
            tokens.add(token);
        }
        this.checkMatchingTags();
        token = new Token(Token.Type.END_JAVADOC, "*/");
        tokens.add((Object)var2_2);
        immutableList = ((ImmutableList.Builder)((Object)immutableList)).build();
        immutableList = JavadocLexer.joinAdjacentLiteralsAndAdjacentWhitespace(immutableList);
        immutableList = JavadocLexer.inferParagraphTags(immutableList);
        immutableList = JavadocLexer.optionalizeSpacesAfterLinks(immutableList);
        immutableList = JavadocLexer.deindentPreCodeBlocks(immutableList);
        return immutableList;
    }

    /*
     * WARNING - void declaration
     */
    private Token readToken() throws LexException {
        void var2_2;
        void var1_1;
        Token.Type type = this.consumeToken();
        String value = this.input.readAndResetRecorded();
        return new Token((Token.Type)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Token.Type consumeToken() throws LexException {
        void var1_1;
        boolean preserveExistingFormatting = this.preserveExistingFormatting();
        if (this.input.tryConsumeRegex(NEWLINE_PATTERN)) {
            this.somethingSinceNewline = false;
            if (preserveExistingFormatting) {
                return Token.Type.FORCED_NEWLINE;
            }
            return Token.Type.WHITESPACE;
        }
        if (this.input.tryConsume(" ") || this.input.tryConsume("\t")) {
            if (preserveExistingFormatting) {
                return Token.Type.LITERAL;
            }
            return Token.Type.WHITESPACE;
        }
        if (!this.somethingSinceNewline && this.input.tryConsumeRegex(FOOTER_TAG_PATTERN)) {
            this.checkMatchingTags();
            this.somethingSinceNewline = true;
            return Token.Type.FOOTER_JAVADOC_TAG_START;
        }
        this.somethingSinceNewline = true;
        if (this.input.tryConsumeRegex(INLINE_TAG_OPEN_PATTERN)) {
            this.braceDepth.increment();
            return Token.Type.LITERAL;
        }
        if (this.input.tryConsume("{")) {
            this.braceDepth.incrementIfPositive();
            return Token.Type.LITERAL;
        }
        if (this.input.tryConsume("}")) {
            this.braceDepth.decrementIfPositive();
            return Token.Type.LITERAL;
        }
        if (this.braceDepth.isPositive()) {
            Verify.verify(this.input.tryConsumeRegex(LITERAL_PATTERN));
            return Token.Type.LITERAL;
        }
        if (this.input.tryConsumeRegex(PRE_OPEN_PATTERN)) {
            this.preDepth.increment();
            if (preserveExistingFormatting) {
                return Token.Type.LITERAL;
            }
            return Token.Type.PRE_OPEN_TAG;
        }
        if (this.input.tryConsumeRegex(PRE_CLOSE_PATTERN)) {
            this.preDepth.decrementIfPositive();
            if (this.preserveExistingFormatting()) {
                return Token.Type.LITERAL;
            }
            return Token.Type.PRE_CLOSE_TAG;
        }
        if (this.input.tryConsumeRegex(CODE_OPEN_PATTERN)) {
            this.codeDepth.increment();
            if (preserveExistingFormatting) {
                return Token.Type.LITERAL;
            }
            return Token.Type.CODE_OPEN_TAG;
        }
        if (this.input.tryConsumeRegex(CODE_CLOSE_PATTERN)) {
            this.codeDepth.decrementIfPositive();
            if (this.preserveExistingFormatting()) {
                return Token.Type.LITERAL;
            }
            return Token.Type.CODE_CLOSE_TAG;
        }
        if (this.input.tryConsumeRegex(TABLE_OPEN_PATTERN)) {
            this.tableDepth.increment();
            if (preserveExistingFormatting) {
                return Token.Type.LITERAL;
            }
            return Token.Type.TABLE_OPEN_TAG;
        }
        if (this.input.tryConsumeRegex(TABLE_CLOSE_PATTERN)) {
            this.tableDepth.decrementIfPositive();
            if (this.preserveExistingFormatting()) {
                return Token.Type.LITERAL;
            }
            return Token.Type.TABLE_CLOSE_TAG;
        }
        if (var1_1 != false) {
            Verify.verify(this.input.tryConsumeRegex(LITERAL_PATTERN));
            return Token.Type.LITERAL;
        }
        if (this.input.tryConsumeRegex(PARAGRAPH_OPEN_PATTERN)) {
            return Token.Type.PARAGRAPH_OPEN_TAG;
        }
        if (this.input.tryConsumeRegex(PARAGRAPH_CLOSE_PATTERN)) {
            return Token.Type.PARAGRAPH_CLOSE_TAG;
        }
        if (this.input.tryConsumeRegex(LIST_OPEN_PATTERN)) {
            return Token.Type.LIST_OPEN_TAG;
        }
        if (this.input.tryConsumeRegex(LIST_CLOSE_PATTERN)) {
            return Token.Type.LIST_CLOSE_TAG;
        }
        if (this.input.tryConsumeRegex(LIST_ITEM_OPEN_PATTERN)) {
            return Token.Type.LIST_ITEM_OPEN_TAG;
        }
        if (this.input.tryConsumeRegex(LIST_ITEM_CLOSE_PATTERN)) {
            return Token.Type.LIST_ITEM_CLOSE_TAG;
        }
        if (this.input.tryConsumeRegex(BLOCKQUOTE_OPEN_PATTERN)) {
            return Token.Type.BLOCKQUOTE_OPEN_TAG;
        }
        if (this.input.tryConsumeRegex(BLOCKQUOTE_CLOSE_PATTERN)) {
            return Token.Type.BLOCKQUOTE_CLOSE_TAG;
        }
        if (this.input.tryConsumeRegex(HEADER_OPEN_PATTERN)) {
            return Token.Type.HEADER_OPEN_TAG;
        }
        if (this.input.tryConsumeRegex(HEADER_CLOSE_PATTERN)) {
            return Token.Type.HEADER_CLOSE_TAG;
        }
        if (this.input.tryConsumeRegex(BR_PATTERN)) {
            return Token.Type.BR_TAG;
        }
        if (this.input.tryConsumeRegex(MOE_BEGIN_STRIP_COMMENT_PATTERN)) {
            return Token.Type.MOE_BEGIN_STRIP_COMMENT;
        }
        if (this.input.tryConsumeRegex(MOE_END_STRIP_COMMENT_PATTERN)) {
            return Token.Type.MOE_END_STRIP_COMMENT;
        }
        if (this.input.tryConsumeRegex(HTML_COMMENT_PATTERN)) {
            return Token.Type.HTML_COMMENT;
        }
        if (this.input.tryConsumeRegex(LITERAL_PATTERN)) {
            return Token.Type.LITERAL;
        }
        throw new AssertionError();
    }

    private boolean preserveExistingFormatting() {
        return this.preDepth.isPositive() || this.tableDepth.isPositive() || this.codeDepth.isPositive();
    }

    private void checkMatchingTags() throws LexException {
        if (this.braceDepth.isPositive() || this.preDepth.isPositive() || this.tableDepth.isPositive() || this.codeDepth.isPositive()) {
            throw new LexException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ImmutableList<Token> joinAdjacentLiteralsAndAdjacentWhitespace(List<Token> input) {
        void var1_1;
        ImmutableList.Builder output = ImmutableList.builder();
        StringBuilder accumulated = new StringBuilder();
        Iterators.PeekingImpl tokens = Iterators.peekingIterator$488b6d4d(input.iterator());
        while (tokens.hasNext()) {
            void var3_3;
            if (((Token)tokens.peek()).getType() == Token.Type.LITERAL) {
                accumulated.append(((Token)tokens.peek()).getValue());
                tokens.next();
                continue;
            }
            if (accumulated.length() == 0) {
                output.add((Token)tokens.peek());
                tokens.next();
                continue;
            }
            StringBuilder seenWhitespace = new StringBuilder();
            while (((Token)tokens.peek()).getType() == Token.Type.WHITESPACE) {
                seenWhitespace.append(((Token)tokens.next()).getValue());
            }
            if (((Token)tokens.peek()).getType() == Token.Type.LITERAL && ((Token)tokens.peek()).getValue().startsWith("@")) {
                accumulated.append(" ");
                accumulated.append(((Token)tokens.peek()).getValue());
                tokens.next();
                continue;
            }
            output.add(new Token(Token.Type.LITERAL, accumulated.toString()));
            accumulated.setLength(0);
            if (seenWhitespace.length() <= 0) continue;
            output.add(new Token(Token.Type.WHITESPACE, var3_3.toString()));
        }
        return var1_1.build();
    }

    /*
     * WARNING - void declaration
     */
    private static ImmutableList<Token> inferParagraphTags(List<Token> input) {
        void var1_1;
        ImmutableList.Builder output = ImmutableList.builder();
        Iterators.PeekingImpl tokens = Iterators.peekingIterator$488b6d4d(input.iterator());
        while (tokens.hasNext()) {
            if (((Token)tokens.peek()).getType() == Token.Type.LITERAL) {
                output.add((Token)tokens.next());
                if (((Token)tokens.peek()).getType() != Token.Type.WHITESPACE || !JavadocLexer.hasMultipleNewlines(((Token)tokens.peek()).getValue())) continue;
                output.add((Token)tokens.next());
                if (((Token)tokens.peek()).getType() != Token.Type.LITERAL) continue;
                output.add(new Token(Token.Type.PARAGRAPH_OPEN_TAG, "<p>"));
                continue;
            }
            output.add((Token)tokens.next());
        }
        return var1_1.build();
    }

    /*
     * WARNING - void declaration
     */
    private static ImmutableList<Token> optionalizeSpacesAfterLinks(List<Token> input) {
        void var1_1;
        ImmutableList.Builder output = ImmutableList.builder();
        Iterators.PeekingImpl tokens = Iterators.peekingIterator$488b6d4d(input.iterator());
        while (tokens.hasNext()) {
            if (((Token)tokens.peek()).getType() == Token.Type.LITERAL && ((Token)tokens.peek()).getValue().matches("^href=[^>]*>")) {
                output.add((Token)tokens.next());
                if (((Token)tokens.peek()).getType() != Token.Type.WHITESPACE) continue;
                output.add(new Token(Token.Type.OPTIONAL_LINE_BREAK, ((Token)tokens.next()).getValue()));
                continue;
            }
            output.add((Token)tokens.next());
        }
        return var1_1.build();
    }

    /*
     * WARNING - void declaration
     */
    private static ImmutableList<Token> deindentPreCodeBlocks(List<Token> input) {
        void var1_1;
        ImmutableList.Builder<Token> output = ImmutableList.builder();
        Iterators.PeekingImpl tokens = Iterators.peekingIterator$488b6d4d(input.iterator());
        while (tokens.hasNext()) {
            if (((Token)tokens.peek()).getType() != Token.Type.PRE_OPEN_TAG) {
                output.add((Object)((Token)tokens.next()));
                continue;
            }
            output.add((Object)((Token)tokens.next()));
            ArrayList<Token> initialNewlines = new ArrayList<Token>();
            while (tokens.hasNext() && ((Token)tokens.peek()).getType() == Token.Type.FORCED_NEWLINE) {
                initialNewlines.add((Token)tokens.next());
            }
            if (((Token)tokens.peek()).getType() != Token.Type.LITERAL || !((Token)tokens.peek()).getValue().matches("[ \t]*[{]@code")) {
                void var2_2;
                output.addAll((Iterable)var2_2);
                output.add((Object)((Token)tokens.next()));
                continue;
            }
            JavadocLexer.deindentPreCodeBlock(output, tokens);
        }
        return var1_1.build();
    }

    /*
     * WARNING - void declaration
     */
    private static void deindentPreCodeBlock(ImmutableList.Builder<Token> output, PeekingIterator<Token> tokens) {
        ImmutableList.Builder<Token> builder;
        void var1_2;
        void var2_3;
        ArrayDeque<Token> saved = new ArrayDeque<Token>();
        output.add((Object)new Token(Token.Type.LITERAL, tokens.next().getValue().trim()));
        while (tokens.hasNext() && tokens.peek().getType() != Token.Type.PRE_CLOSE_TAG) {
            Token token = tokens.next();
            saved.addLast(token);
        }
        while (!saved.isEmpty() && ((Token)saved.peekFirst()).getType() == Token.Type.FORCED_NEWLINE) {
            saved.removeFirst();
        }
        while (!saved.isEmpty() && ((Token)saved.peekLast()).getType() == Token.Type.FORCED_NEWLINE) {
            saved.removeLast();
        }
        if (saved.isEmpty()) {
            return;
        }
        Token last = (Token)saved.peekLast();
        boolean trailingBrace = false;
        if (last.getType() == Token.Type.LITERAL && last.getValue().endsWith("}")) {
            saved.removeLast();
            if (last.length() > 1) {
                saved.addLast(new Token(Token.Type.LITERAL, last.getValue().substring(0, last.getValue().length() - 1)));
                saved.addLast(new Token(Token.Type.FORCED_NEWLINE, null));
            }
            trailingBrace = true;
        }
        int trim = -1;
        for (Token token : saved) {
            int idx;
            if (token.getType() != Token.Type.LITERAL || (idx = CharMatcher.isNot$8d21c63(' ').indexIn(token.getValue())) == -1 || trim != -1 && idx >= trim) continue;
            trim = idx;
        }
        output.add((Object)new Token(Token.Type.FORCED_NEWLINE, "\n"));
        for (Token token : var2_3) {
            if (token.getType() == Token.Type.LITERAL) {
                output.add((Object)new Token(Token.Type.LITERAL, trim > 0 && token.length() > trim ? token.getValue().substring(trim) : token.getValue()));
                continue;
            }
            output.add((Object)token);
        }
        if (var1_2 != false) {
            output.add((Object)new Token(Token.Type.LITERAL, "}"));
            return;
        }
        builder.add((Object)new Token(Token.Type.FORCED_NEWLINE, "\n"));
    }

    private static boolean hasMultipleNewlines(String s) {
        String string;
        return NEWLINE.countIn(string) > 1;
    }

    private static Pattern fullCommentPattern() {
        return Pattern.compile("^<!--.*?-->", 32);
    }

    private static Pattern openTagPattern(String namePattern) {
        String string;
        return Pattern.compile(String.format("^<(?:%s)\\b[^>]*>", string), 2);
    }

    private static Pattern closeTagPattern(String namePattern) {
        String string;
        return Pattern.compile(String.format("^</(?:%s)\\b[^>]*>", string), 2);
    }

    static class LexException
    extends Exception {
        LexException() {
        }
    }
}

