/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.IterableByteBufferInputStream;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UnsafeUtil;
import com.google.protobuf.Utf8;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class CodedInputStream {
    private static volatile int defaultRecursionLimit = 100;
    int recursionDepth;
    private int recursionLimit = defaultRecursionLimit;
    int sizeLimit = Integer.MAX_VALUE;
    private boolean shouldDiscardUnknownFields = false;

    static CodedInputStream newInstance(Iterable<ByteBuffer> bufs, boolean bufferIsImmutable) {
        IterableByteBufferInputStream iterableByteBufferInputStream;
        int n;
        int n2;
        int flag = 0;
        int totalSize = 0;
        for (ByteBuffer buf : bufs) {
            totalSize += buf.remaining();
            if (buf.hasArray()) {
                flag |= 1;
                continue;
            }
            if (buf.isDirect()) {
                flag |= 2;
                continue;
            }
            flag |= 4;
        }
        if (n2 == 2) {
            return new IterableDirectByteBufferDecoder(bufs, n, true, 0);
        }
        iterableByteBufferInputStream = new IterableByteBufferInputStream((Iterable<ByteBuffer>)((Object)iterableByteBufferInputStream));
        int n3 = 4096;
        Object object = iterableByteBufferInputStream;
        if (iterableByteBufferInputStream == null) {
            object = Internal.EMPTY_BYTE_ARRAY;
            n = ((Object)object).length;
            n2 = 0;
            object = Internal.EMPTY_BYTE_ARRAY;
            return CodedInputStream.newInstance$35ce18fe(Internal.EMPTY_BYTE_ARRAY, n2, n, false);
        }
        return new StreamDecoder((InputStream)object, 4096, 0);
    }

    public static CodedInputStream newInstance(byte[] buf) {
        byte[] byArray;
        int n = byArray.length;
        int n2 = 0;
        byArray = buf;
        return CodedInputStream.newInstance$35ce18fe(buf, n2, n, false);
    }

    /*
     * WARNING - void declaration
     */
    public static CodedInputStream newInstance(byte[] buf, int off, int len) {
        void var2_2;
        void var1_1;
        return CodedInputStream.newInstance$35ce18fe(buf, (int)var1_1, (int)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    static ArrayDecoder newInstance$35ce18fe(byte[] buf, int off, int len, boolean bufferIsImmutable) {
        Object object;
        void var3_4;
        void var1_2;
        Object result = new ArrayDecoder(buf, (int)var1_2, len, (boolean)var3_4, 0);
        try {
            void var2_3;
            ((CodedInputStream)result).pushLimit((int)var2_3);
        }
        catch (InvalidProtocolBufferException ex) {
            void var0_1;
            throw new IllegalArgumentException((Throwable)var0_1);
        }
        return object;
    }

    public static CodedInputStream newInstance(ByteBuffer buf) {
        return CodedInputStream.newInstance(buf, false);
    }

    /*
     * WARNING - void declaration
     */
    static CodedInputStream newInstance(ByteBuffer buf, boolean bufferIsImmutable) {
        void var1_2;
        ByteBuffer byteBuffer;
        if (buf.hasArray()) {
            return CodedInputStream.newInstance$35ce18fe(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), bufferIsImmutable);
        }
        if (buf.isDirect() && UnsafeUtil.hasUnsafeByteBufferOperations()) {
            return new UnsafeDirectNioDecoder(buf, bufferIsImmutable, 0);
        }
        byte[] buffer = new byte[buf.remaining()];
        byteBuffer.duplicate().get(buffer);
        return CodedInputStream.newInstance$35ce18fe(buffer, 0, ((void)var1_2).length, true);
    }

    public final void checkRecursionLimit() throws InvalidProtocolBufferException {
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
    }

    private CodedInputStream() {
    }

    public abstract int readTag() throws IOException;

    public abstract void checkLastTagWas(int var1) throws InvalidProtocolBufferException;

    public abstract boolean skipField(int var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void skipMessage() throws IOException {
        void var1_1;
        do {
            int tag;
            if ((tag = this.readTag()) == 0) {
                return;
            }
            this.checkRecursionLimit();
            ++this.recursionDepth;
            boolean fieldSkipped = this.skipField(tag);
            --this.recursionDepth;
        } while (var1_1 != false);
    }

    public abstract double readDouble() throws IOException;

    public abstract float readFloat() throws IOException;

    public abstract long readUInt64() throws IOException;

    public abstract long readInt64() throws IOException;

    public abstract int readInt32() throws IOException;

    public abstract long readFixed64() throws IOException;

    public abstract int readFixed32() throws IOException;

    public abstract boolean readBool() throws IOException;

    public abstract String readString() throws IOException;

    public abstract String readStringRequireUtf8() throws IOException;

    public abstract void readGroup(int var1, MessageLite.Builder var2, ExtensionRegistryLite var3) throws IOException;

    public abstract void readMessage(MessageLite.Builder var1, ExtensionRegistryLite var2) throws IOException;

    public abstract <T extends MessageLite> T readMessage(Parser<T> var1, ExtensionRegistryLite var2) throws IOException;

    public abstract ByteString readBytes() throws IOException;

    public abstract int readUInt32() throws IOException;

    public abstract int readEnum() throws IOException;

    public abstract int readSFixed32() throws IOException;

    public abstract long readSFixed64() throws IOException;

    public abstract int readSInt32() throws IOException;

    public abstract long readSInt64() throws IOException;

    public abstract int readRawVarint32() throws IOException;

    abstract long readRawVarint64SlowPath() throws IOException;

    /*
     * WARNING - void declaration
     */
    public final int setRecursionLimit(int limit) {
        void var2_2;
        void var1_1;
        if (limit < 0) {
            throw new IllegalArgumentException("Recursion limit cannot be negative: " + limit);
        }
        int oldLimit = this.recursionLimit;
        this.recursionLimit = var1_1;
        return (int)var2_2;
    }

    final boolean shouldDiscardUnknownFields() {
        return this.shouldDiscardUnknownFields;
    }

    public abstract int pushLimit(int var1) throws InvalidProtocolBufferException;

    public abstract void popLimit(int var1);

    public abstract int getBytesUntilLimit();

    public static int decodeZigZag32(int n) {
        int n2;
        return n >>> 1 ^ -(n2 & 1);
    }

    public static long decodeZigZag64(long n) {
        long l;
        return n >>> 1 ^ -(l & 1L);
    }

    /* synthetic */ CodedInputStream(byte by) {
        this();
    }

    private static final class IterableDirectByteBufferDecoder
    extends CodedInputStream {
        private final Iterable<ByteBuffer> input;
        private final Iterator<ByteBuffer> iterator;
        private ByteBuffer currentByteBuffer;
        private final boolean immutable;
        private boolean enableAliasing;
        private int totalBufferSize;
        private int bufferSizeAfterCurrentLimit;
        private int currentLimit = Integer.MAX_VALUE;
        private int lastTag;
        private int totalBytesRead;
        private int startOffset;
        private long currentByteBufferPos;
        private long currentByteBufferStartPos;
        private long currentAddress;
        private long currentByteBufferLimit;

        /*
         * WARNING - void declaration
         */
        private IterableDirectByteBufferDecoder(Iterable<ByteBuffer> inputBufs, int size, boolean immutableFlag) {
            super((byte)0);
            void var2_2;
            void var3_3;
            void var1_1;
            this.totalBufferSize = size;
            this.input = var1_1;
            this.iterator = this.input.iterator();
            this.immutable = var3_3;
            IterableDirectByteBufferDecoder iterableDirectByteBufferDecoder = this;
            iterableDirectByteBufferDecoder.totalBytesRead = 0;
            iterableDirectByteBufferDecoder.startOffset = 0;
            if (var2_2 == false) {
                this.currentByteBuffer = Internal.EMPTY_BYTE_BUFFER;
                this.currentByteBufferPos = 0L;
                this.currentByteBufferStartPos = 0L;
                this.currentByteBufferLimit = 0L;
                this.currentAddress = 0L;
                return;
            }
            this.tryGetNextByteBuffer();
        }

        private void getNextByteBuffer() throws InvalidProtocolBufferException {
            if (!this.iterator.hasNext()) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.tryGetNextByteBuffer();
        }

        private void tryGetNextByteBuffer() {
            this.currentByteBuffer = this.iterator.next();
            this.totalBytesRead += (int)(this.currentByteBufferPos - this.currentByteBufferStartPos);
            this.currentByteBufferStartPos = this.currentByteBufferPos = (long)this.currentByteBuffer.position();
            this.currentByteBufferLimit = this.currentByteBuffer.limit();
            this.currentAddress = UnsafeUtil.addressOffset(this.currentByteBuffer);
            this.currentByteBufferPos += this.currentAddress;
            this.currentByteBufferStartPos += this.currentAddress;
            this.currentByteBufferLimit += this.currentAddress;
        }

        @Override
        public final int readTag() throws IOException {
            IterableDirectByteBufferDecoder iterableDirectByteBufferDecoder = this;
            if ((long)iterableDirectByteBufferDecoder.totalBytesRead + iterableDirectByteBufferDecoder.currentByteBufferPos - iterableDirectByteBufferDecoder.currentByteBufferStartPos == (long)iterableDirectByteBufferDecoder.totalBufferSize) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = ((CodedInputStream)this).readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void checkLastTagWas(int value) throws InvalidProtocolBufferException {
            void var1_1;
            if (this.lastTag != var1_1) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final boolean skipField(int tag2) throws IOException {
            switch (WireFormat.getTagWireType(tag2)) {
                case 0: {
                    IterableDirectByteBufferDecoder tag2 = this;
                    for (int i = 0; i < 10; ++i) {
                        if (tag2.readRawByte() >= 0) return true;
                    }
                    throw InvalidProtocolBufferException.malformedVarint();
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    IterableDirectByteBufferDecoder iterableDirectByteBufferDecoder = this;
                    iterableDirectByteBufferDecoder.skipRawBytes(((CodedInputStream)iterableDirectByteBufferDecoder).readRawVarint32());
                    return true;
                }
                case 3: {
                    void var1_1;
                    this.skipMessage();
                    ((CodedInputStream)this).checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber((int)var1_1), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public final double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public final float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public final long readUInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final long readInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final int readInt32() throws IOException {
            return ((CodedInputStream)this).readRawVarint32();
        }

        @Override
        public final long readFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final boolean readBool() throws IOException {
            return this.readRawVarint64() != 0L;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String readString() throws IOException {
            void var1_1;
            int size = ((CodedInputStream)this).readRawVarint32();
            if (size > 0 && (long)size <= this.currentByteBufferLimit - this.currentByteBufferPos) {
                byte[] bytes = new byte[size];
                UnsafeUtil.copyMemory(this.currentByteBufferPos, bytes, 0L, size);
                String result = new String(bytes, Internal.UTF_8);
                this.currentByteBufferPos += (long)size;
                return result;
            }
            if (size > 0 && size <= this.remaining()) {
                String string;
                byte[] bytes = new byte[size];
                this.readRawBytesTo(bytes, 0, size);
                string = new String((byte[])string, Internal.UTF_8);
                return string;
            }
            if (size == 0) {
                return "";
            }
            if (var1_1 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String readStringRequireUtf8() throws IOException {
            void var1_1;
            int size = ((CodedInputStream)this).readRawVarint32();
            if (size > 0 && (long)size <= this.currentByteBufferLimit - this.currentByteBufferPos) {
                int bufferPos = (int)(this.currentByteBufferPos - this.currentByteBufferStartPos);
                String result = Utf8.decodeUtf8(this.currentByteBuffer, bufferPos, size);
                this.currentByteBufferPos += (long)size;
                return result;
            }
            if (size >= 0 && size <= this.remaining()) {
                void var2_4;
                byte[] bytes = new byte[size];
                this.readRawBytesTo(bytes, 0, size);
                return Utf8.decodeUtf8((byte[])var2_4, 0, size);
            }
            if (size == 0) {
                return "";
            }
            if (var1_1 <= 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readGroup(int fieldNumber, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var1_1;
            void var3_3;
            void var2_2;
            this.checkRecursionLimit();
            ++this.recursionDepth;
            var2_2.mergeFrom(this, (ExtensionRegistryLite)var3_3);
            ((CodedInputStream)this).checkLastTagWas(WireFormat.makeTag((int)var1_1, 4));
            --this.recursionDepth;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            int length = ((CodedInputStream)this).readRawVarint32();
            this.checkRecursionLimit();
            int oldLimit = ((CodedInputStream)this).pushLimit(length);
            ++this.recursionDepth;
            var1_1.mergeFrom(this, (ExtensionRegistryLite)var2_2);
            ((CodedInputStream)this).checkLastTagWas(0);
            --this.recursionDepth;
            if (((CodedInputStream)this).getBytesUntilLimit() != 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            ((CodedInputStream)this).popLimit((int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var1_1;
            void var3_3;
            void var2_2;
            int length = ((CodedInputStream)this).readRawVarint32();
            this.checkRecursionLimit();
            int oldLimit = ((CodedInputStream)this).pushLimit(length);
            ++this.recursionDepth;
            MessageLite result = (MessageLite)parser.parsePartialFrom$74833874(this, (ExtensionRegistryLite)var2_2);
            ((CodedInputStream)this).checkLastTagWas(0);
            --this.recursionDepth;
            if (((CodedInputStream)this).getBytesUntilLimit() != 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            ((CodedInputStream)this).popLimit((int)var3_3);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteString readBytes() throws IOException {
            void var1_1;
            int size = ((CodedInputStream)this).readRawVarint32();
            if (size > 0 && (long)size <= this.currentByteBufferLimit - this.currentByteBufferPos) {
                if (this.immutable) {
                }
                byte[] bytes = new byte[size];
                UnsafeUtil.copyMemory(this.currentByteBufferPos, bytes, 0L, size);
                this.currentByteBufferPos += (long)size;
                return ByteString.wrap$e5dd4d4(bytes);
            }
            if (size > 0 && size <= this.remaining()) {
                void var2_3;
                if (this.immutable) {
                }
                byte[] temp = new byte[size];
                this.readRawBytesTo(temp, 0, size);
                return ByteString.wrap$e5dd4d4((byte[])var2_3);
            }
            if (size == 0) {
                return ByteString.EMPTY$6bb3303a;
            }
            if (var1_1 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public final int readUInt32() throws IOException {
            return ((CodedInputStream)this).readRawVarint32();
        }

        @Override
        public final int readEnum() throws IOException {
            return ((CodedInputStream)this).readRawVarint32();
        }

        @Override
        public final int readSFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final long readSFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readSInt32() throws IOException {
            return IterableDirectByteBufferDecoder.decodeZigZag32(((CodedInputStream)this).readRawVarint32());
        }

        @Override
        public final long readSInt64() throws IOException {
            return IterableDirectByteBufferDecoder.decodeZigZag64(this.readRawVarint64());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int readRawVarint32() throws IOException {
            block4: {
                void var3_2;
                void var1_1;
                block6: {
                    long tempPos;
                    block8: {
                        block7: {
                            block5: {
                                int x;
                                tempPos = this.currentByteBufferPos;
                                if (this.currentByteBufferLimit == this.currentByteBufferPos) break block4;
                                if ((x = UnsafeUtil.getByte(tempPos++)) >= 0) {
                                    ++this.currentByteBufferPos;
                                    return x;
                                }
                                if (this.currentByteBufferLimit - this.currentByteBufferPos < 10L) break block4;
                                if ((x ^= UnsafeUtil.getByte(tempPos++) << 7) >= 0) break block5;
                                x ^= 0xFFFFFF80;
                                break block6;
                            }
                            if ((x ^= UnsafeUtil.getByte(tempPos++) << 14) < 0) break block7;
                            x ^= 0x3F80;
                            break block6;
                        }
                        if ((x ^= UnsafeUtil.getByte(tempPos++) << 21) >= 0) break block8;
                        x ^= 0xFFE03F80;
                        break block6;
                    }
                    byte y = UnsafeUtil.getByte(tempPos++);
                    x ^= y << 28;
                    x ^= 0xFE03F80;
                    if (y < 0 && UnsafeUtil.getByte(tempPos++) < 0 && UnsafeUtil.getByte(tempPos++) < 0 && UnsafeUtil.getByte(tempPos++) < 0 && UnsafeUtil.getByte(tempPos++) < 0 && UnsafeUtil.getByte(tempPos++) < 0) break block4;
                }
                this.currentByteBufferPos = var1_1;
                return (int)var3_2;
            }
            return (int)this.readRawVarint64SlowPath();
        }

        /*
         * WARNING - void declaration
         */
        private long readRawVarint64() throws IOException {
            block4: {
                void var3_3;
                void var1_1;
                block6: {
                    long tempPos;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    long x32;
                                    block8: {
                                        int x32;
                                        block7: {
                                            block5: {
                                                int y;
                                                tempPos = this.currentByteBufferPos;
                                                if (this.currentByteBufferLimit == this.currentByteBufferPos) break block4;
                                                if ((y = UnsafeUtil.getByte(tempPos++)) >= 0) {
                                                    ++this.currentByteBufferPos;
                                                    return y;
                                                }
                                                if (this.currentByteBufferLimit - this.currentByteBufferPos < 10L) break block4;
                                                if ((y ^= UnsafeUtil.getByte(tempPos++) << 7) >= 0) break block5;
                                                x32 = y ^ 0xFFFFFF80;
                                                break block6;
                                            }
                                            if ((x32 ^= UnsafeUtil.getByte(tempPos++) << 14) < 0) break block7;
                                            x32 = x32 ^ 0x3F80;
                                            break block6;
                                        }
                                        if ((x32 ^= UnsafeUtil.getByte(tempPos++) << 21) >= 0) break block8;
                                        x32 = x32 ^ 0xFFE03F80;
                                        break block6;
                                    }
                                    if ((x32 = (long)x32 ^ (long)UnsafeUtil.getByte(tempPos++) << 28) < 0L) break block9;
                                    x32 ^= 0xFE03F80L;
                                    break block6;
                                }
                                if ((x32 ^= (long)UnsafeUtil.getByte(tempPos++) << 35) >= 0L) break block10;
                                x32 ^= 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((x32 ^= (long)UnsafeUtil.getByte(tempPos++) << 42) < 0L) break block11;
                            x32 ^= 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((x32 ^= (long)UnsafeUtil.getByte(tempPos++) << 49) >= 0L) break block12;
                        x32 ^= 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    x32 ^= (long)UnsafeUtil.getByte(tempPos++) << 56;
                    if ((x32 ^= 0xFE03F80FE03F80L) < 0L && (long)UnsafeUtil.getByte(tempPos++) < 0L) break block4;
                }
                this.currentByteBufferPos = var1_1;
                return (long)var3_3;
            }
            return this.readRawVarint64SlowPath();
        }

        @Override
        final long readRawVarint64SlowPath() throws IOException {
            long result = 0L;
            for (int shift = 0; shift < 64; shift += 7) {
                byte b = this.readRawByte();
                result |= (long)(b & 0x7F) << shift;
                if ((b & 0x80) != 0) continue;
                return result;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        /*
         * WARNING - void declaration
         */
        private int readRawLittleEndian32() throws IOException {
            if (this.currentRemaining() >= 4L) {
                void var1_1;
                long tempPos = this.currentByteBufferPos;
                this.currentByteBufferPos += 4L;
                return UnsafeUtil.getByte(tempPos) & 0xFF | (UnsafeUtil.getByte(tempPos + 1L) & 0xFF) << 8 | (UnsafeUtil.getByte(tempPos + 2L) & 0xFF) << 16 | (UnsafeUtil.getByte((long)(var1_1 + 3L)) & 0xFF) << 24;
            }
            return this.readRawByte() & 0xFF | (this.readRawByte() & 0xFF) << 8 | (this.readRawByte() & 0xFF) << 16 | (this.readRawByte() & 0xFF) << 24;
        }

        /*
         * WARNING - void declaration
         */
        private long readRawLittleEndian64() throws IOException {
            if (this.currentRemaining() >= 8L) {
                void var1_1;
                long tempPos = this.currentByteBufferPos;
                this.currentByteBufferPos += 8L;
                return (long)UnsafeUtil.getByte(tempPos) & 0xFFL | ((long)UnsafeUtil.getByte(tempPos + 1L) & 0xFFL) << 8 | ((long)UnsafeUtil.getByte(tempPos + 2L) & 0xFFL) << 16 | ((long)UnsafeUtil.getByte(tempPos + 3L) & 0xFFL) << 24 | ((long)UnsafeUtil.getByte(tempPos + 4L) & 0xFFL) << 32 | ((long)UnsafeUtil.getByte(tempPos + 5L) & 0xFFL) << 40 | ((long)UnsafeUtil.getByte(tempPos + 6L) & 0xFFL) << 48 | ((long)UnsafeUtil.getByte((long)(var1_1 + 7L)) & 0xFFL) << 56;
            }
            return (long)this.readRawByte() & 0xFFL | ((long)this.readRawByte() & 0xFFL) << 8 | ((long)this.readRawByte() & 0xFFL) << 16 | ((long)this.readRawByte() & 0xFFL) << 24 | ((long)this.readRawByte() & 0xFFL) << 32 | ((long)this.readRawByte() & 0xFFL) << 40 | ((long)this.readRawByte() & 0xFFL) << 48 | ((long)this.readRawByte() & 0xFFL) << 56;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int pushLimit(int byteLimit) throws InvalidProtocolBufferException {
            void var2_2;
            void var1_1;
            int oldLimit;
            if (byteLimit < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if ((byteLimit += this.getTotalBytesRead()) > (oldLimit = this.currentLimit)) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = var1_1;
            this.recomputeBufferSizeAfterLimit();
            return (int)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private void recomputeBufferSizeAfterLimit() {
            this.totalBufferSize += this.bufferSizeAfterCurrentLimit;
            int bufferEnd = this.totalBufferSize - this.startOffset;
            if (bufferEnd > this.currentLimit) {
                void var1_1;
                this.bufferSizeAfterCurrentLimit = var1_1 - this.currentLimit;
                this.totalBufferSize -= this.bufferSizeAfterCurrentLimit;
                return;
            }
            this.bufferSizeAfterCurrentLimit = 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void popLimit(int oldLimit) {
            void var1_1;
            this.currentLimit = var1_1;
            this.recomputeBufferSizeAfterLimit();
        }

        @Override
        public final int getBytesUntilLimit() {
            if (this.currentLimit == Integer.MAX_VALUE) {
                return -1;
            }
            return this.currentLimit - this.getTotalBytesRead();
        }

        private int getTotalBytesRead() {
            return (int)((long)(this.totalBytesRead - this.startOffset) + this.currentByteBufferPos - this.currentByteBufferStartPos);
        }

        private byte readRawByte() throws IOException {
            if (this.currentRemaining() == 0L) {
                this.getNextByteBuffer();
            }
            return UnsafeUtil.getByte(this.currentByteBufferPos++);
        }

        /*
         * WARNING - void declaration
         */
        private void readRawBytesTo(byte[] bytes, int offset, int length) throws IOException {
            if (length >= 0 && length <= this.remaining()) {
                int l = length;
                while (l > 0) {
                    if (this.currentRemaining() == 0L) {
                        this.getNextByteBuffer();
                    }
                    int bytesToCopy = Math.min(l, (int)this.currentRemaining());
                    UnsafeUtil.copyMemory(this.currentByteBufferPos, bytes, length - l, bytesToCopy);
                    l -= bytesToCopy;
                    this.currentByteBufferPos += (long)bytesToCopy;
                }
                return;
            }
            if (length <= 0) {
                void var3_3;
                if (var3_3 == false) {
                    return;
                }
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        /*
         * WARNING - void declaration
         */
        private void skipRawBytes(int length) throws IOException {
            void var1_1;
            if (length >= 0 && (long)length <= (long)(this.totalBufferSize - this.totalBytesRead) - this.currentByteBufferPos + this.currentByteBufferStartPos) {
                void l;
                while (l > 0) {
                    void var2_2;
                    if (this.currentRemaining() == 0L) {
                        this.getNextByteBuffer();
                    }
                    int rl = Math.min((int)l, (int)this.currentRemaining());
                    l -= rl;
                    this.currentByteBufferPos += (long)var2_2;
                }
                return;
            }
            if (var1_1 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        private int remaining() {
            return (int)((long)(this.totalBufferSize - this.totalBytesRead) - this.currentByteBufferPos + this.currentByteBufferStartPos);
        }

        private long currentRemaining() {
            return this.currentByteBufferLimit - this.currentByteBufferPos;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ IterableDirectByteBufferDecoder(Iterable x0, int x1, boolean x2, byte by) {
            this((Iterable<ByteBuffer>)var1_1, (int)var2_2, (boolean)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }

    private static final class StreamDecoder
    extends CodedInputStream {
        private final InputStream input;
        private final byte[] buffer;
        private int bufferSize;
        private int bufferSizeAfterLimit;
        private int pos;
        private int lastTag;
        private int totalBytesRetired;
        private int currentLimit = Integer.MAX_VALUE;
        private RefillCallback refillCallback = null;

        /*
         * WARNING - void declaration
         */
        private StreamDecoder(InputStream input, int bufferSize) {
            super((byte)0);
            void var2_2;
            void var1_1;
            Internal.checkNotNull(input, "input");
            this.input = var1_1;
            this.buffer = new byte[var2_2];
            this.bufferSize = 0;
            this.pos = 0;
            this.totalBytesRetired = 0;
        }

        /*
         * WARNING - void declaration
         */
        private static int read(InputStream input, byte[] data, int offset, int length) throws IOException {
            try {
                void var3_3;
                void var2_2;
                void var1_1;
                return input.read((byte[])var1_1, (int)var2_2, (int)var3_3);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                InvalidProtocolBufferException invalidProtocolBufferException2 = invalidProtocolBufferException;
                throw invalidProtocolBufferException;
            }
        }

        /*
         * WARNING - void declaration
         */
        private static long skip(InputStream input, long length) throws IOException {
            try {
                void var1_1;
                return input.skip((long)var1_1);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                InvalidProtocolBufferException invalidProtocolBufferException2 = invalidProtocolBufferException;
                throw invalidProtocolBufferException;
            }
        }

        private static int available(InputStream input) throws IOException {
            try {
                return input.available();
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                InvalidProtocolBufferException invalidProtocolBufferException2 = invalidProtocolBufferException;
                throw invalidProtocolBufferException;
            }
        }

        @Override
        public final int readTag() throws IOException {
            StreamDecoder streamDecoder = this;
            if (streamDecoder.pos == streamDecoder.bufferSize && !streamDecoder.tryRefillBuffer(1)) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = ((CodedInputStream)this).readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void checkLastTagWas(int value) throws InvalidProtocolBufferException {
            void var1_1;
            if (this.lastTag != var1_1) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final boolean skipField(int tag2) throws IOException {
            switch (WireFormat.getTagWireType(tag2)) {
                case 0: {
                    StreamDecoder tag2 = this;
                    if (tag2.bufferSize - tag2.pos >= 10) {
                        for (int i = 0; i < 10; ++i) {
                            if (tag2.buffer[tag2.pos++] >= 0) return true;
                        }
                        throw InvalidProtocolBufferException.malformedVarint();
                    }
                    for (int i = 0; i < 10; ++i) {
                        if (tag2.readRawByte() >= 0) return true;
                    }
                    throw InvalidProtocolBufferException.malformedVarint();
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    StreamDecoder streamDecoder = this;
                    streamDecoder.skipRawBytes(((CodedInputStream)streamDecoder).readRawVarint32());
                    return true;
                }
                case 3: {
                    void var1_1;
                    this.skipMessage();
                    ((CodedInputStream)this).checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber((int)var1_1), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public final double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public final float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public final long readUInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final long readInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final int readInt32() throws IOException {
            return ((CodedInputStream)this).readRawVarint32();
        }

        @Override
        public final long readFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final boolean readBool() throws IOException {
            return this.readRawVarint64() != 0L;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String readString() throws IOException {
            void var1_1;
            int size = ((CodedInputStream)this).readRawVarint32();
            if (size > 0 && size <= this.bufferSize - this.pos) {
                String result = new String(this.buffer, this.pos, size, Internal.UTF_8);
                this.pos += size;
                return result;
            }
            if (size == 0) {
                return "";
            }
            if (size < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (size <= this.bufferSize) {
                void var2_3;
                this.refillBuffer(size);
                String result = new String(this.buffer, this.pos, size, Internal.UTF_8);
                this.pos += size;
                return var2_3;
            }
            return new String(this.readRawBytesSlowPath((int)var1_1, false), Internal.UTF_8);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String readStringRequireUtf8() throws IOException {
            void var1_1;
            void var3_2;
            void var2_3;
            byte[] bytes;
            int oldPos;
            int size = ((CodedInputStream)this).readRawVarint32();
            if (size <= this.bufferSize - (oldPos = this.pos) && size > 0) {
                bytes = this.buffer;
                this.pos = oldPos + size;
            } else {
                boolean tempPos;
                if (size == 0) {
                    return "";
                }
                if (size < 0) {
                    throw InvalidProtocolBufferException.negativeSize();
                }
                if (size <= this.bufferSize) {
                    this.refillBuffer(size);
                    bytes = this.buffer;
                    tempPos = false;
                    this.pos = size + 0;
                } else {
                    bytes = this.readRawBytesSlowPath(size, false);
                    tempPos = false;
                }
            }
            return Utf8.decodeUtf8((byte[])var2_3, (int)var3_2, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readGroup(int fieldNumber, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var1_1;
            void var3_3;
            void var2_2;
            this.checkRecursionLimit();
            ++this.recursionDepth;
            var2_2.mergeFrom(this, (ExtensionRegistryLite)var3_3);
            ((CodedInputStream)this).checkLastTagWas(WireFormat.makeTag((int)var1_1, 4));
            --this.recursionDepth;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            int length = ((CodedInputStream)this).readRawVarint32();
            this.checkRecursionLimit();
            int oldLimit = ((CodedInputStream)this).pushLimit(length);
            ++this.recursionDepth;
            var1_1.mergeFrom(this, (ExtensionRegistryLite)var2_2);
            ((CodedInputStream)this).checkLastTagWas(0);
            --this.recursionDepth;
            if (((CodedInputStream)this).getBytesUntilLimit() != 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            ((CodedInputStream)this).popLimit((int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var1_1;
            void var3_3;
            void var2_2;
            int length = ((CodedInputStream)this).readRawVarint32();
            this.checkRecursionLimit();
            int oldLimit = ((CodedInputStream)this).pushLimit(length);
            ++this.recursionDepth;
            MessageLite result = (MessageLite)parser.parsePartialFrom$74833874(this, (ExtensionRegistryLite)var2_2);
            ((CodedInputStream)this).checkLastTagWas(0);
            --this.recursionDepth;
            if (((CodedInputStream)this).getBytesUntilLimit() != 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            ((CodedInputStream)this).popLimit((int)var3_3);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteString readBytes() throws IOException {
            void var1_1;
            int size = ((CodedInputStream)this).readRawVarint32();
            if (size <= this.bufferSize - this.pos && size > 0) {
                void var2_4;
                ByteString.LiteralByteString result = ByteString.copyFrom$7efb1774(this.buffer, this.pos, size);
                this.pos += size;
                return var2_4;
            }
            if (size == 0) {
                return ByteString.EMPTY$6bb3303a;
            }
            if (size < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            StreamDecoder streamDecoder = this;
            void var2_5 = var1_1;
            byte[] byArray = streamDecoder.readRawBytesSlowPathOneChunk((int)var2_5);
            if (byArray != null) {
                return ByteString.copyFrom(byArray);
            }
            int n = streamDecoder.pos;
            int n2 = streamDecoder.bufferSize - streamDecoder.pos;
            streamDecoder.totalBytesRetired += streamDecoder.bufferSize;
            streamDecoder.pos = 0;
            streamDecoder.bufferSize = 0;
            void var5_12 = var2_5 - n2;
            List<byte[]> list2 = streamDecoder.readRawBytesSlowPathRemainingChunks((int)var5_12);
            byte[] byArray2 = new byte[var2_5];
            System.arraycopy(streamDecoder.buffer, n, byArray2, 0, n2);
            int n3 = n2;
            for (byte[] byArray3 : list2) {
                System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
                n3 += byArray3.length;
            }
            return ByteString.wrap$e5dd4d4(byArray2);
        }

        @Override
        public final int readUInt32() throws IOException {
            return ((CodedInputStream)this).readRawVarint32();
        }

        @Override
        public final int readEnum() throws IOException {
            return ((CodedInputStream)this).readRawVarint32();
        }

        @Override
        public final int readSFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final long readSFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readSInt32() throws IOException {
            return StreamDecoder.decodeZigZag32(((CodedInputStream)this).readRawVarint32());
        }

        @Override
        public final long readSInt64() throws IOException {
            return StreamDecoder.decodeZigZag64(this.readRawVarint64());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int readRawVarint32() throws IOException {
            block4: {
                void var3_3;
                void var1_1;
                block6: {
                    void var2_2;
                    byte[] buffer;
                    int tempPos;
                    block8: {
                        block7: {
                            block5: {
                                int x;
                                tempPos = this.pos;
                                if (this.bufferSize == tempPos) break block4;
                                buffer = this.buffer;
                                if ((x = this.buffer[tempPos++]) >= 0) {
                                    this.pos = tempPos;
                                    return x;
                                }
                                if (this.bufferSize - tempPos < 9) break block4;
                                if ((x ^= buffer[tempPos++] << 7) >= 0) break block5;
                                x ^= 0xFFFFFF80;
                                break block6;
                            }
                            if ((x ^= buffer[tempPos++] << 14) < 0) break block7;
                            x ^= 0x3F80;
                            break block6;
                        }
                        if ((x ^= buffer[tempPos++] << 21) >= 0) break block8;
                        x ^= 0xFFE03F80;
                        break block6;
                    }
                    byte y = buffer[tempPos++];
                    x ^= y << 28;
                    x ^= 0xFE03F80;
                    if (y < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && var2_2[tempPos++] < 0) break block4;
                }
                this.pos = var1_1;
                return (int)var3_3;
            }
            return (int)this.readRawVarint64SlowPath();
        }

        /*
         * WARNING - void declaration
         */
        private long readRawVarint64() throws IOException {
            block4: {
                void var3_4;
                void var1_1;
                block6: {
                    void var2_2;
                    byte[] buffer;
                    int tempPos;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    long x32;
                                    block8: {
                                        int x32;
                                        block7: {
                                            block5: {
                                                int y;
                                                tempPos = this.pos;
                                                if (this.bufferSize == tempPos) break block4;
                                                buffer = this.buffer;
                                                if ((y = this.buffer[tempPos++]) >= 0) {
                                                    this.pos = tempPos;
                                                    return y;
                                                }
                                                if (this.bufferSize - tempPos < 9) break block4;
                                                if ((y ^= buffer[tempPos++] << 7) >= 0) break block5;
                                                x32 = y ^ 0xFFFFFF80;
                                                break block6;
                                            }
                                            if ((x32 ^= buffer[tempPos++] << 14) < 0) break block7;
                                            x32 = x32 ^ 0x3F80;
                                            break block6;
                                        }
                                        if ((x32 ^= buffer[tempPos++] << 21) >= 0) break block8;
                                        x32 = x32 ^ 0xFFE03F80;
                                        break block6;
                                    }
                                    if ((x32 = (long)x32 ^ (long)buffer[tempPos++] << 28) < 0L) break block9;
                                    x32 ^= 0xFE03F80L;
                                    break block6;
                                }
                                if ((x32 ^= (long)buffer[tempPos++] << 35) >= 0L) break block10;
                                x32 ^= 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((x32 ^= (long)buffer[tempPos++] << 42) < 0L) break block11;
                            x32 ^= 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((x32 ^= (long)buffer[tempPos++] << 49) >= 0L) break block12;
                        x32 ^= 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    x32 ^= (long)buffer[tempPos++] << 56;
                    if ((x32 ^= 0xFE03F80FE03F80L) < 0L && (long)var2_2[tempPos++] < 0L) break block4;
                }
                this.pos = var1_1;
                return (long)var3_4;
            }
            return this.readRawVarint64SlowPath();
        }

        @Override
        final long readRawVarint64SlowPath() throws IOException {
            long result = 0L;
            for (int shift = 0; shift < 64; shift += 7) {
                byte b = this.readRawByte();
                result |= (long)(b & 0x7F) << shift;
                if ((b & 0x80) != 0) continue;
                return result;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        /*
         * WARNING - void declaration
         */
        private int readRawLittleEndian32() throws IOException {
            void var1_1;
            void var2_2;
            int tempPos = this.pos;
            if (this.bufferSize - tempPos < 4) {
                this.refillBuffer(4);
                tempPos = this.pos;
            }
            byte[] buffer = this.buffer;
            this.pos = tempPos + 4;
            return buffer[tempPos] & 0xFF | (buffer[tempPos + 1] & 0xFF) << 8 | (buffer[tempPos + 2] & 0xFF) << 16 | (var2_2[var1_1 + 3] & 0xFF) << 24;
        }

        /*
         * WARNING - void declaration
         */
        private long readRawLittleEndian64() throws IOException {
            void var1_1;
            void var2_2;
            int tempPos = this.pos;
            if (this.bufferSize - tempPos < 8) {
                this.refillBuffer(8);
                tempPos = this.pos;
            }
            byte[] buffer = this.buffer;
            this.pos = tempPos + 8;
            return (long)buffer[tempPos] & 0xFFL | ((long)buffer[tempPos + 1] & 0xFFL) << 8 | ((long)buffer[tempPos + 2] & 0xFFL) << 16 | ((long)buffer[tempPos + 3] & 0xFFL) << 24 | ((long)buffer[tempPos + 4] & 0xFFL) << 32 | ((long)buffer[tempPos + 5] & 0xFFL) << 40 | ((long)buffer[tempPos + 6] & 0xFFL) << 48 | ((long)var2_2[var1_1 + 7] & 0xFFL) << 56;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int pushLimit(int byteLimit) throws InvalidProtocolBufferException {
            void var2_2;
            void var1_1;
            if (byteLimit < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            int oldLimit = this.currentLimit;
            if ((byteLimit += this.totalBytesRetired + this.pos) > oldLimit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = var1_1;
            this.recomputeBufferSizeAfterLimit();
            return (int)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private void recomputeBufferSizeAfterLimit() {
            this.bufferSize += this.bufferSizeAfterLimit;
            int bufferEnd = this.totalBytesRetired + this.bufferSize;
            if (bufferEnd > this.currentLimit) {
                void var1_1;
                this.bufferSizeAfterLimit = var1_1 - this.currentLimit;
                this.bufferSize -= this.bufferSizeAfterLimit;
                return;
            }
            this.bufferSizeAfterLimit = 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void popLimit(int oldLimit) {
            void var1_1;
            this.currentLimit = var1_1;
            this.recomputeBufferSizeAfterLimit();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int getBytesUntilLimit() {
            void var1_1;
            if (this.currentLimit == Integer.MAX_VALUE) {
                return -1;
            }
            int currentAbsolutePosition = this.totalBytesRetired + this.pos;
            return this.currentLimit - var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void refillBuffer(int n) throws IOException {
            if (!this.tryRefillBuffer(n)) {
                void var1_1;
                if (var1_1 > this.sizeLimit - this.totalBytesRetired - this.pos) {
                    throw InvalidProtocolBufferException.sizeLimitExceeded();
                }
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }

        /*
         * WARNING - void declaration
         */
        private boolean tryRefillBuffer(int n) throws IOException {
            while (true) {
                void var2_2;
                int bytesRead;
                if (this.pos + n <= this.bufferSize) {
                    throw new IllegalStateException("refillBuffer() called when " + n + " bytes were already available in buffer");
                }
                if (n > this.sizeLimit - this.totalBytesRetired - this.pos) {
                    return false;
                }
                if (this.totalBytesRetired + this.pos + n > this.currentLimit) {
                    return false;
                }
                int tempPos = this.pos;
                if (tempPos > 0) {
                    if (this.bufferSize > tempPos) {
                        System.arraycopy(this.buffer, tempPos, this.buffer, 0, this.bufferSize - tempPos);
                    }
                    this.totalBytesRetired += tempPos;
                    this.bufferSize -= tempPos;
                    this.pos = 0;
                }
                if ((bytesRead = StreamDecoder.read(this.input, this.buffer, this.bufferSize, Math.min(this.buffer.length - this.bufferSize, this.sizeLimit - this.totalBytesRetired - this.bufferSize))) == 0 || bytesRead < -1 || bytesRead > this.buffer.length) {
                    throw new IllegalStateException(this.input.getClass() + "#read(byte[]) returned invalid result: " + bytesRead + "\nThe InputStream implementation is buggy.");
                }
                if (bytesRead <= 0) break;
                this.bufferSize += var2_2;
                this.recomputeBufferSizeAfterLimit();
                if (this.bufferSize < n) continue;
                return true;
            }
            return false;
        }

        private byte readRawByte() throws IOException {
            if (this.pos == this.bufferSize) {
                this.refillBuffer(1);
            }
            return this.buffer[this.pos++];
        }

        /*
         * WARNING - void declaration
         */
        private byte[] readRawBytesSlowPath(int size, boolean ensureNoLeakedReferences) throws IOException {
            void var1_2;
            void var3_6;
            byte[] result = this.readRawBytesSlowPathOneChunk(size);
            if (result != null) {
                return result;
            }
            int originalBufferPos = this.pos;
            int bufferedBytes = this.bufferSize - this.pos;
            this.totalBytesRetired += this.bufferSize;
            this.pos = 0;
            this.bufferSize = 0;
            int sizeLeft = size - bufferedBytes;
            List<byte[]> chunks = this.readRawBytesSlowPathRemainingChunks(sizeLeft);
            byte[] bytes = new byte[size];
            System.arraycopy(this.buffer, originalBufferPos, bytes, 0, bufferedBytes);
            void tempPos = var3_6;
            for (byte[] chunk : chunks) {
                System.arraycopy(chunk, 0, bytes, (int)tempPos, chunk.length);
                tempPos += chunk.length;
            }
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        private byte[] readRawBytesSlowPathOneChunk(int size) throws IOException {
            if (size == 0) {
                return Internal.EMPTY_BYTE_ARRAY;
            }
            if (size < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            int currentMessageSize = this.totalBytesRetired + this.pos + size;
            if (currentMessageSize - this.sizeLimit > 0) {
                throw InvalidProtocolBufferException.sizeLimitExceeded();
            }
            if (currentMessageSize > this.currentLimit) {
                StreamDecoder streamDecoder = this;
                streamDecoder.skipRawBytes(streamDecoder.currentLimit - this.totalBytesRetired - this.pos);
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            int bufferedBytes = this.bufferSize - this.pos;
            int sizeLeft = size - bufferedBytes;
            if (sizeLeft < 4096 || sizeLeft <= StreamDecoder.available(this.input)) {
                void var3_4;
                void tempPos;
                byte[] bytes = new byte[size];
                System.arraycopy(this.buffer, this.pos, bytes, 0, bufferedBytes);
                this.totalBytesRetired += this.bufferSize;
                this.pos = 0;
                this.bufferSize = 0;
                while (tempPos < bytes.length) {
                    int n = StreamDecoder.read(this.input, bytes, (int)tempPos, size - tempPos);
                    if (n == -1) {
                        throw InvalidProtocolBufferException.truncatedMessage();
                    }
                    this.totalBytesRetired += n;
                    tempPos += n;
                }
                return var3_4;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private List<byte[]> readRawBytesSlowPathRemainingChunks(int sizeLeft) throws IOException {
            void var2_2;
            ArrayList<void> chunks = new ArrayList<void>();
            while (sizeLeft > 0) {
                void var3_3;
                int n;
                byte[] chunk = new byte[Math.min(sizeLeft, 4096)];
                for (int tempPos = 0; tempPos < chunk.length; tempPos += n) {
                    n = this.input.read(chunk, tempPos, chunk.length - tempPos);
                    if (n == -1) {
                        throw InvalidProtocolBufferException.truncatedMessage();
                    }
                    this.totalBytesRetired += n;
                }
                sizeLeft -= chunk.length;
                chunks.add(var3_3);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private void skipRawBytes(int size) throws IOException {
            void var1_1;
            if (size <= this.bufferSize - this.pos && size >= 0) {
                this.pos += size;
                return;
            }
            this.skipRawBytesSlowPath((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void skipRawBytesSlowPath(int size) throws IOException {
            int totalSkipped;
            if (size < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (this.totalBytesRetired + this.pos + size > this.currentLimit) {
                StreamDecoder streamDecoder = this;
                streamDecoder.skipRawBytes(streamDecoder.currentLimit - this.totalBytesRetired - this.pos);
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            int n = 0;
            this.totalBytesRetired += this.pos;
            this.bufferSize = 0;
            this.pos = 0;
            try {
                long skipped;
                for (totalSkipped = this.bufferSize - this.pos; totalSkipped < size; totalSkipped += (int)skipped) {
                    int toSkip = size - totalSkipped;
                    skipped = StreamDecoder.skip(this.input, toSkip);
                    if (skipped < 0L || skipped > (long)toSkip) {
                        throw new IllegalStateException(this.input.getClass() + "#skip returned invalid result: " + skipped + "\nThe InputStream implementation is buggy.");
                    }
                    if (skipped != 0L) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.totalBytesRetired += totalSkipped;
                this.recomputeBufferSizeAfterLimit();
            }
            if (n < size) {
                void var3_4;
                void var1_1;
                int tempPos = this.bufferSize - this.pos;
                this.pos = this.bufferSize;
                this.refillBuffer(1);
                while (size - tempPos > this.bufferSize) {
                    tempPos += this.bufferSize;
                    this.pos = this.bufferSize;
                    this.refillBuffer(1);
                }
                this.pos = var1_1 - var3_4;
            }
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ StreamDecoder(InputStream x0, int x1, byte by) {
            this((InputStream)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        private static interface RefillCallback {
        }
    }

    private static final class UnsafeDirectNioDecoder
    extends CodedInputStream {
        private final ByteBuffer buffer;
        private final boolean immutable;
        private final long address;
        private long limit;
        private long pos;
        private long startPos;
        private int bufferSizeAfterLimit;
        private int lastTag;
        private boolean enableAliasing;
        private int currentLimit = Integer.MAX_VALUE;

        /*
         * WARNING - void declaration
         */
        private UnsafeDirectNioDecoder(ByteBuffer buffer, boolean immutable) {
            super((byte)0);
            void var2_2;
            void var1_1;
            this.buffer = buffer;
            this.address = UnsafeUtil.addressOffset(buffer);
            this.limit = this.address + (long)buffer.limit();
            this.startPos = this.pos = this.address + (long)var1_1.position();
            this.immutable = var2_2;
        }

        @Override
        public final int readTag() throws IOException {
            UnsafeDirectNioDecoder unsafeDirectNioDecoder = this;
            if (unsafeDirectNioDecoder.pos == unsafeDirectNioDecoder.limit) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = ((CodedInputStream)this).readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void checkLastTagWas(int value) throws InvalidProtocolBufferException {
            void var1_1;
            if (this.lastTag != var1_1) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final boolean skipField(int tag2) throws IOException {
            switch (WireFormat.getTagWireType(tag2)) {
                case 0: {
                    UnsafeDirectNioDecoder tag2 = this;
                    if (tag2.remaining() >= 10) {
                        for (int i = 0; i < 10; ++i) {
                            if (UnsafeUtil.getByte(tag2.pos++) >= 0) return true;
                        }
                        throw InvalidProtocolBufferException.malformedVarint();
                    }
                    for (int i = 0; i < 10; ++i) {
                        if (tag2.readRawByte() >= 0) return true;
                    }
                    throw InvalidProtocolBufferException.malformedVarint();
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    UnsafeDirectNioDecoder unsafeDirectNioDecoder = this;
                    unsafeDirectNioDecoder.skipRawBytes(((CodedInputStream)unsafeDirectNioDecoder).readRawVarint32());
                    return true;
                }
                case 3: {
                    void var1_1;
                    this.skipMessage();
                    ((CodedInputStream)this).checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber((int)var1_1), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public final double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public final float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public final long readUInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final long readInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final int readInt32() throws IOException {
            return ((CodedInputStream)this).readRawVarint32();
        }

        @Override
        public final long readFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final boolean readBool() throws IOException {
            return this.readRawVarint64() != 0L;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String readString() throws IOException {
            void var1_1;
            int size = ((CodedInputStream)this).readRawVarint32();
            if (size > 0 && size <= this.remaining()) {
                void var2_2;
                byte[] bytes = new byte[size];
                UnsafeUtil.copyMemory(this.pos, bytes, 0L, size);
                String result = new String(bytes, Internal.UTF_8);
                this.pos += (long)size;
                return var2_2;
            }
            if (size == 0) {
                return "";
            }
            if (var1_1 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String readStringRequireUtf8() throws IOException {
            void var1_1;
            int size = ((CodedInputStream)this).readRawVarint32();
            if (size > 0 && size <= this.remaining()) {
                void var2_5;
                UnsafeDirectNioDecoder unsafeDirectNioDecoder = this;
                long l = unsafeDirectNioDecoder.pos;
                UnsafeDirectNioDecoder unsafeDirectNioDecoder2 = unsafeDirectNioDecoder;
                int bufferPos = (int)(l - unsafeDirectNioDecoder2.address);
                String result = Utf8.decodeUtf8(this.buffer, bufferPos, size);
                this.pos += (long)size;
                return var2_5;
            }
            if (size == 0) {
                return "";
            }
            if (var1_1 <= 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readGroup(int fieldNumber, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var1_1;
            void var3_3;
            void var2_2;
            this.checkRecursionLimit();
            ++this.recursionDepth;
            var2_2.mergeFrom(this, (ExtensionRegistryLite)var3_3);
            ((CodedInputStream)this).checkLastTagWas(WireFormat.makeTag((int)var1_1, 4));
            --this.recursionDepth;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            int length = ((CodedInputStream)this).readRawVarint32();
            this.checkRecursionLimit();
            int oldLimit = ((CodedInputStream)this).pushLimit(length);
            ++this.recursionDepth;
            var1_1.mergeFrom(this, (ExtensionRegistryLite)var2_2);
            ((CodedInputStream)this).checkLastTagWas(0);
            --this.recursionDepth;
            if (((CodedInputStream)this).getBytesUntilLimit() != 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            ((CodedInputStream)this).popLimit((int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var1_1;
            void var3_3;
            void var2_2;
            int length = ((CodedInputStream)this).readRawVarint32();
            this.checkRecursionLimit();
            int oldLimit = ((CodedInputStream)this).pushLimit(length);
            ++this.recursionDepth;
            MessageLite result = (MessageLite)parser.parsePartialFrom$74833874(this, (ExtensionRegistryLite)var2_2);
            ((CodedInputStream)this).checkLastTagWas(0);
            --this.recursionDepth;
            if (((CodedInputStream)this).getBytesUntilLimit() != 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            ((CodedInputStream)this).popLimit((int)var3_3);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteString readBytes() throws IOException {
            void var1_1;
            int size = ((CodedInputStream)this).readRawVarint32();
            if (size > 0 && size <= this.remaining()) {
                void var2_2;
                if (this.immutable) {
                }
                byte[] bytes = new byte[size];
                UnsafeUtil.copyMemory(this.pos, bytes, 0L, size);
                this.pos += (long)size;
                return ByteString.wrap$e5dd4d4((byte[])var2_2);
            }
            if (size == 0) {
                return ByteString.EMPTY$6bb3303a;
            }
            if (var1_1 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public final int readUInt32() throws IOException {
            return ((CodedInputStream)this).readRawVarint32();
        }

        @Override
        public final int readEnum() throws IOException {
            return ((CodedInputStream)this).readRawVarint32();
        }

        @Override
        public final int readSFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final long readSFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readSInt32() throws IOException {
            return UnsafeDirectNioDecoder.decodeZigZag32(((CodedInputStream)this).readRawVarint32());
        }

        @Override
        public final long readSInt64() throws IOException {
            return UnsafeDirectNioDecoder.decodeZigZag64(this.readRawVarint64());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int readRawVarint32() throws IOException {
            block4: {
                void var3_2;
                void var1_1;
                block6: {
                    long tempPos;
                    block8: {
                        block7: {
                            block5: {
                                int x;
                                tempPos = this.pos;
                                if (this.limit == tempPos) break block4;
                                if ((x = UnsafeUtil.getByte(tempPos++)) >= 0) {
                                    this.pos = tempPos;
                                    return x;
                                }
                                if (this.limit - tempPos < 9L) break block4;
                                if ((x ^= UnsafeUtil.getByte(tempPos++) << 7) >= 0) break block5;
                                x ^= 0xFFFFFF80;
                                break block6;
                            }
                            if ((x ^= UnsafeUtil.getByte(tempPos++) << 14) < 0) break block7;
                            x ^= 0x3F80;
                            break block6;
                        }
                        if ((x ^= UnsafeUtil.getByte(tempPos++) << 21) >= 0) break block8;
                        x ^= 0xFFE03F80;
                        break block6;
                    }
                    byte y = UnsafeUtil.getByte(tempPos++);
                    x ^= y << 28;
                    x ^= 0xFE03F80;
                    if (y < 0 && UnsafeUtil.getByte(tempPos++) < 0 && UnsafeUtil.getByte(tempPos++) < 0 && UnsafeUtil.getByte(tempPos++) < 0 && UnsafeUtil.getByte(tempPos++) < 0 && UnsafeUtil.getByte(tempPos++) < 0) break block4;
                }
                this.pos = var1_1;
                return (int)var3_2;
            }
            return (int)this.readRawVarint64SlowPath();
        }

        /*
         * WARNING - void declaration
         */
        private long readRawVarint64() throws IOException {
            block4: {
                void var3_3;
                void var1_1;
                block6: {
                    long tempPos;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    long x32;
                                    block8: {
                                        int x32;
                                        block7: {
                                            block5: {
                                                int y;
                                                tempPos = this.pos;
                                                if (this.limit == tempPos) break block4;
                                                if ((y = UnsafeUtil.getByte(tempPos++)) >= 0) {
                                                    this.pos = tempPos;
                                                    return y;
                                                }
                                                if (this.limit - tempPos < 9L) break block4;
                                                if ((y ^= UnsafeUtil.getByte(tempPos++) << 7) >= 0) break block5;
                                                x32 = y ^ 0xFFFFFF80;
                                                break block6;
                                            }
                                            if ((x32 ^= UnsafeUtil.getByte(tempPos++) << 14) < 0) break block7;
                                            x32 = x32 ^ 0x3F80;
                                            break block6;
                                        }
                                        if ((x32 ^= UnsafeUtil.getByte(tempPos++) << 21) >= 0) break block8;
                                        x32 = x32 ^ 0xFFE03F80;
                                        break block6;
                                    }
                                    if ((x32 = (long)x32 ^ (long)UnsafeUtil.getByte(tempPos++) << 28) < 0L) break block9;
                                    x32 ^= 0xFE03F80L;
                                    break block6;
                                }
                                if ((x32 ^= (long)UnsafeUtil.getByte(tempPos++) << 35) >= 0L) break block10;
                                x32 ^= 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((x32 ^= (long)UnsafeUtil.getByte(tempPos++) << 42) < 0L) break block11;
                            x32 ^= 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((x32 ^= (long)UnsafeUtil.getByte(tempPos++) << 49) >= 0L) break block12;
                        x32 ^= 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    x32 ^= (long)UnsafeUtil.getByte(tempPos++) << 56;
                    if ((x32 ^= 0xFE03F80FE03F80L) < 0L && (long)UnsafeUtil.getByte(tempPos++) < 0L) break block4;
                }
                this.pos = var1_1;
                return (long)var3_3;
            }
            return this.readRawVarint64SlowPath();
        }

        @Override
        final long readRawVarint64SlowPath() throws IOException {
            long result = 0L;
            for (int shift = 0; shift < 64; shift += 7) {
                byte b = this.readRawByte();
                result |= (long)(b & 0x7F) << shift;
                if ((b & 0x80) != 0) continue;
                return result;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        /*
         * WARNING - void declaration
         */
        private int readRawLittleEndian32() throws IOException {
            void var1_1;
            long tempPos = this.pos;
            if (this.limit - tempPos < 4L) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.pos = tempPos + 4L;
            return UnsafeUtil.getByte(tempPos) & 0xFF | (UnsafeUtil.getByte(tempPos + 1L) & 0xFF) << 8 | (UnsafeUtil.getByte(tempPos + 2L) & 0xFF) << 16 | (UnsafeUtil.getByte((long)(var1_1 + 3L)) & 0xFF) << 24;
        }

        /*
         * WARNING - void declaration
         */
        private long readRawLittleEndian64() throws IOException {
            void var1_1;
            long tempPos = this.pos;
            if (this.limit - tempPos < 8L) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.pos = tempPos + 8L;
            return (long)UnsafeUtil.getByte(tempPos) & 0xFFL | ((long)UnsafeUtil.getByte(tempPos + 1L) & 0xFFL) << 8 | ((long)UnsafeUtil.getByte(tempPos + 2L) & 0xFFL) << 16 | ((long)UnsafeUtil.getByte(tempPos + 3L) & 0xFFL) << 24 | ((long)UnsafeUtil.getByte(tempPos + 4L) & 0xFFL) << 32 | ((long)UnsafeUtil.getByte(tempPos + 5L) & 0xFFL) << 40 | ((long)UnsafeUtil.getByte(tempPos + 6L) & 0xFFL) << 48 | ((long)UnsafeUtil.getByte((long)(var1_1 + 7L)) & 0xFFL) << 56;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int pushLimit(int byteLimit) throws InvalidProtocolBufferException {
            void var2_2;
            void var1_1;
            int oldLimit;
            if (byteLimit < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if ((byteLimit += this.getTotalBytesRead()) > (oldLimit = this.currentLimit)) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = var1_1;
            this.recomputeBufferSizeAfterLimit();
            return (int)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void popLimit(int oldLimit) {
            void var1_1;
            this.currentLimit = var1_1;
            this.recomputeBufferSizeAfterLimit();
        }

        @Override
        public final int getBytesUntilLimit() {
            if (this.currentLimit == Integer.MAX_VALUE) {
                return -1;
            }
            return this.currentLimit - this.getTotalBytesRead();
        }

        private int getTotalBytesRead() {
            return (int)(this.pos - this.startPos);
        }

        private byte readRawByte() throws IOException {
            if (this.pos == this.limit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return UnsafeUtil.getByte(this.pos++);
        }

        /*
         * WARNING - void declaration
         */
        private void skipRawBytes(int length) throws IOException {
            void var1_1;
            if (length >= 0 && length <= this.remaining()) {
                this.pos += (long)length;
                return;
            }
            if (var1_1 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        /*
         * WARNING - void declaration
         */
        private void recomputeBufferSizeAfterLimit() {
            this.limit += (long)this.bufferSizeAfterLimit;
            int bufferEnd = (int)(this.limit - this.startPos);
            if (bufferEnd > this.currentLimit) {
                void var1_1;
                this.bufferSizeAfterLimit = var1_1 - this.currentLimit;
                this.limit -= (long)this.bufferSizeAfterLimit;
                return;
            }
            this.bufferSizeAfterLimit = 0;
        }

        private int remaining() {
            return (int)(this.limit - this.pos);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ UnsafeDirectNioDecoder(ByteBuffer x0, boolean x1, byte by) {
            this((ByteBuffer)var1_1, (boolean)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    private static final class ArrayDecoder
    extends CodedInputStream {
        private final byte[] buffer;
        private final boolean immutable;
        private int limit;
        private int bufferSizeAfterLimit;
        private int pos;
        private int startPos;
        private int lastTag;
        private boolean enableAliasing;
        private int currentLimit = Integer.MAX_VALUE;

        /*
         * WARNING - void declaration
         */
        private ArrayDecoder(byte[] buffer, int offset, int len, boolean immutable) {
            super((byte)0);
            void var2_2;
            void var3_3;
            void var1_1;
            this.buffer = var1_1;
            this.limit = offset + var3_3;
            this.startPos = this.pos = var2_2;
            this.immutable = immutable;
        }

        @Override
        public final int readTag() throws IOException {
            ArrayDecoder arrayDecoder = this;
            if (arrayDecoder.pos == arrayDecoder.limit) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = ((CodedInputStream)this).readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void checkLastTagWas(int value) throws InvalidProtocolBufferException {
            void var1_1;
            if (this.lastTag != var1_1) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final boolean skipField(int tag2) throws IOException {
            switch (WireFormat.getTagWireType(tag2)) {
                case 0: {
                    ArrayDecoder tag2 = this;
                    if (tag2.limit - tag2.pos >= 10) {
                        for (int i = 0; i < 10; ++i) {
                            if (tag2.buffer[tag2.pos++] >= 0) return true;
                        }
                        throw InvalidProtocolBufferException.malformedVarint();
                    }
                    for (int i = 0; i < 10; ++i) {
                        if (tag2.readRawByte() >= 0) return true;
                    }
                    throw InvalidProtocolBufferException.malformedVarint();
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    ArrayDecoder arrayDecoder = this;
                    arrayDecoder.skipRawBytes(((CodedInputStream)arrayDecoder).readRawVarint32());
                    return true;
                }
                case 3: {
                    void var1_1;
                    this.skipMessage();
                    ((CodedInputStream)this).checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber((int)var1_1), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public final double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public final float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public final long readUInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final long readInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final int readInt32() throws IOException {
            return ((CodedInputStream)this).readRawVarint32();
        }

        @Override
        public final long readFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final boolean readBool() throws IOException {
            return this.readRawVarint64() != 0L;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String readString() throws IOException {
            void var1_1;
            int size = ((CodedInputStream)this).readRawVarint32();
            if (size > 0 && size <= this.limit - this.pos) {
                void var2_2;
                String result = new String(this.buffer, this.pos, size, Internal.UTF_8);
                this.pos += size;
                return var2_2;
            }
            if (size == 0) {
                return "";
            }
            if (var1_1 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String readStringRequireUtf8() throws IOException {
            void var1_1;
            int size = ((CodedInputStream)this).readRawVarint32();
            if (size > 0 && size <= this.limit - this.pos) {
                void var2_2;
                String result = Utf8.decodeUtf8(this.buffer, this.pos, size);
                this.pos += size;
                return var2_2;
            }
            if (size == 0) {
                return "";
            }
            if (var1_1 <= 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readGroup(int fieldNumber, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var1_1;
            void var3_3;
            void var2_2;
            this.checkRecursionLimit();
            ++this.recursionDepth;
            var2_2.mergeFrom(this, (ExtensionRegistryLite)var3_3);
            ((CodedInputStream)this).checkLastTagWas(WireFormat.makeTag((int)var1_1, 4));
            --this.recursionDepth;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            int length = ((CodedInputStream)this).readRawVarint32();
            this.checkRecursionLimit();
            int oldLimit = ((CodedInputStream)this).pushLimit(length);
            ++this.recursionDepth;
            var1_1.mergeFrom(this, (ExtensionRegistryLite)var2_2);
            ((CodedInputStream)this).checkLastTagWas(0);
            --this.recursionDepth;
            if (((CodedInputStream)this).getBytesUntilLimit() != 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            ((CodedInputStream)this).popLimit((int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var1_1;
            void var3_3;
            void var2_2;
            int length = ((CodedInputStream)this).readRawVarint32();
            this.checkRecursionLimit();
            int oldLimit = ((CodedInputStream)this).pushLimit(length);
            ++this.recursionDepth;
            MessageLite result = (MessageLite)parser.parsePartialFrom$74833874(this, (ExtensionRegistryLite)var2_2);
            ((CodedInputStream)this).checkLastTagWas(0);
            --this.recursionDepth;
            if (((CodedInputStream)this).getBytesUntilLimit() != 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            ((CodedInputStream)this).popLimit((int)var3_3);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final ByteString readBytes() throws IOException {
            byte[] byArray;
            void var1_1;
            int size = ((CodedInputStream)this).readRawVarint32();
            if (size > 0 && size <= this.limit - this.pos) {
                void var2_3;
                if (this.immutable) {
                }
                ByteString.LiteralByteString result = ByteString.copyFrom$7efb1774(this.buffer, this.pos, size);
                this.pos += size;
                return var2_3;
            }
            if (size == 0) {
                return ByteString.EMPTY$6bb3303a;
            }
            void var2_4 = var1_1;
            ArrayDecoder arrayDecoder = this;
            if (var2_4 > 0 && var2_4 <= arrayDecoder.limit - arrayDecoder.pos) {
                int n = arrayDecoder.pos;
                arrayDecoder.pos += var2_4;
                byArray = Arrays.copyOfRange(arrayDecoder.buffer, n, arrayDecoder.pos);
                return ByteString.wrap$e5dd4d4(byArray);
            } else {
                if (var2_4 > 0) throw InvalidProtocolBufferException.truncatedMessage();
                if (var2_4 != false) throw InvalidProtocolBufferException.negativeSize();
                byArray = Internal.EMPTY_BYTE_ARRAY;
            }
            return ByteString.wrap$e5dd4d4(byArray);
        }

        @Override
        public final int readUInt32() throws IOException {
            return ((CodedInputStream)this).readRawVarint32();
        }

        @Override
        public final int readEnum() throws IOException {
            return ((CodedInputStream)this).readRawVarint32();
        }

        @Override
        public final int readSFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final long readSFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readSInt32() throws IOException {
            return ArrayDecoder.decodeZigZag32(((CodedInputStream)this).readRawVarint32());
        }

        @Override
        public final long readSInt64() throws IOException {
            return ArrayDecoder.decodeZigZag64(this.readRawVarint64());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int readRawVarint32() throws IOException {
            block4: {
                void var3_3;
                void var1_1;
                block6: {
                    void var2_2;
                    byte[] buffer;
                    int tempPos;
                    block8: {
                        block7: {
                            block5: {
                                int x;
                                tempPos = this.pos;
                                if (this.limit == tempPos) break block4;
                                buffer = this.buffer;
                                if ((x = this.buffer[tempPos++]) >= 0) {
                                    this.pos = tempPos;
                                    return x;
                                }
                                if (this.limit - tempPos < 9) break block4;
                                if ((x ^= buffer[tempPos++] << 7) >= 0) break block5;
                                x ^= 0xFFFFFF80;
                                break block6;
                            }
                            if ((x ^= buffer[tempPos++] << 14) < 0) break block7;
                            x ^= 0x3F80;
                            break block6;
                        }
                        if ((x ^= buffer[tempPos++] << 21) >= 0) break block8;
                        x ^= 0xFFE03F80;
                        break block6;
                    }
                    byte y = buffer[tempPos++];
                    x ^= y << 28;
                    x ^= 0xFE03F80;
                    if (y < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && var2_2[tempPos++] < 0) break block4;
                }
                this.pos = var1_1;
                return (int)var3_3;
            }
            return (int)this.readRawVarint64SlowPath();
        }

        /*
         * WARNING - void declaration
         */
        private long readRawVarint64() throws IOException {
            block4: {
                void var3_4;
                void var1_1;
                block6: {
                    void var2_2;
                    byte[] buffer;
                    int tempPos;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    long x32;
                                    block8: {
                                        int x32;
                                        block7: {
                                            block5: {
                                                int y;
                                                tempPos = this.pos;
                                                if (this.limit == tempPos) break block4;
                                                buffer = this.buffer;
                                                if ((y = this.buffer[tempPos++]) >= 0) {
                                                    this.pos = tempPos;
                                                    return y;
                                                }
                                                if (this.limit - tempPos < 9) break block4;
                                                if ((y ^= buffer[tempPos++] << 7) >= 0) break block5;
                                                x32 = y ^ 0xFFFFFF80;
                                                break block6;
                                            }
                                            if ((x32 ^= buffer[tempPos++] << 14) < 0) break block7;
                                            x32 = x32 ^ 0x3F80;
                                            break block6;
                                        }
                                        if ((x32 ^= buffer[tempPos++] << 21) >= 0) break block8;
                                        x32 = x32 ^ 0xFFE03F80;
                                        break block6;
                                    }
                                    if ((x32 = (long)x32 ^ (long)buffer[tempPos++] << 28) < 0L) break block9;
                                    x32 ^= 0xFE03F80L;
                                    break block6;
                                }
                                if ((x32 ^= (long)buffer[tempPos++] << 35) >= 0L) break block10;
                                x32 ^= 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((x32 ^= (long)buffer[tempPos++] << 42) < 0L) break block11;
                            x32 ^= 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((x32 ^= (long)buffer[tempPos++] << 49) >= 0L) break block12;
                        x32 ^= 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    x32 ^= (long)buffer[tempPos++] << 56;
                    if ((x32 ^= 0xFE03F80FE03F80L) < 0L && (long)var2_2[tempPos++] < 0L) break block4;
                }
                this.pos = var1_1;
                return (long)var3_4;
            }
            return this.readRawVarint64SlowPath();
        }

        @Override
        final long readRawVarint64SlowPath() throws IOException {
            long result = 0L;
            for (int shift = 0; shift < 64; shift += 7) {
                byte b = this.readRawByte();
                result |= (long)(b & 0x7F) << shift;
                if ((b & 0x80) != 0) continue;
                return result;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        /*
         * WARNING - void declaration
         */
        private int readRawLittleEndian32() throws IOException {
            void var1_1;
            void var2_2;
            int tempPos = this.pos;
            if (this.limit - tempPos < 4) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] buffer = this.buffer;
            this.pos = tempPos + 4;
            return buffer[tempPos] & 0xFF | (buffer[tempPos + 1] & 0xFF) << 8 | (buffer[tempPos + 2] & 0xFF) << 16 | (var2_2[var1_1 + 3] & 0xFF) << 24;
        }

        /*
         * WARNING - void declaration
         */
        private long readRawLittleEndian64() throws IOException {
            void var1_1;
            void var2_2;
            int tempPos = this.pos;
            if (this.limit - tempPos < 8) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] buffer = this.buffer;
            this.pos = tempPos + 8;
            return (long)buffer[tempPos] & 0xFFL | ((long)buffer[tempPos + 1] & 0xFFL) << 8 | ((long)buffer[tempPos + 2] & 0xFFL) << 16 | ((long)buffer[tempPos + 3] & 0xFFL) << 24 | ((long)buffer[tempPos + 4] & 0xFFL) << 32 | ((long)buffer[tempPos + 5] & 0xFFL) << 40 | ((long)buffer[tempPos + 6] & 0xFFL) << 48 | ((long)var2_2[var1_1 + 7] & 0xFFL) << 56;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int pushLimit(int byteLimit) throws InvalidProtocolBufferException {
            void var2_2;
            void var1_1;
            if (byteLimit < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if ((byteLimit += this.getTotalBytesRead()) < 0) {
                throw InvalidProtocolBufferException.parseFailure();
            }
            int oldLimit = this.currentLimit;
            if (byteLimit > oldLimit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = var1_1;
            this.recomputeBufferSizeAfterLimit();
            return (int)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private void recomputeBufferSizeAfterLimit() {
            this.limit += this.bufferSizeAfterLimit;
            int bufferEnd = this.limit - this.startPos;
            if (bufferEnd > this.currentLimit) {
                void var1_1;
                this.bufferSizeAfterLimit = var1_1 - this.currentLimit;
                this.limit -= this.bufferSizeAfterLimit;
                return;
            }
            this.bufferSizeAfterLimit = 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void popLimit(int oldLimit) {
            void var1_1;
            this.currentLimit = var1_1;
            this.recomputeBufferSizeAfterLimit();
        }

        @Override
        public final int getBytesUntilLimit() {
            if (this.currentLimit == Integer.MAX_VALUE) {
                return -1;
            }
            return this.currentLimit - this.getTotalBytesRead();
        }

        private int getTotalBytesRead() {
            return this.pos - this.startPos;
        }

        private byte readRawByte() throws IOException {
            if (this.pos == this.limit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return this.buffer[this.pos++];
        }

        /*
         * WARNING - void declaration
         */
        private void skipRawBytes(int length) throws IOException {
            void var1_1;
            if (length >= 0 && length <= this.limit - this.pos) {
                this.pos += length;
                return;
            }
            if (var1_1 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ArrayDecoder(byte[] x0, int x1, int x2, boolean x3, byte by) {
            this((byte[])var1_1, (int)var2_2, (int)var3_3, x3);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }
}

