/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.FieldInfo;
import com.google.protobuf.FieldType;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.Message;
import com.google.protobuf.MessageInfo;
import com.google.protobuf.MessageInfoFactory;
import com.google.protobuf.OneofInfo;
import com.google.protobuf.ProtoSyntax;
import com.google.protobuf.SchemaUtil;
import com.google.protobuf.StructuralMessageInfo;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;

final class DescriptorMessageInfoFactory
implements MessageInfoFactory {
    private static final DescriptorMessageInfoFactory instance = new DescriptorMessageInfoFactory();
    private static final Set<String> specialFieldNames = new HashSet<String>(Arrays.asList("Class", "DefaultInstanceForType", "ParserForType", "SerializedSize", "AllFields", "DescriptorForType", "InitializationErrorString", "UnknownFields", "CachedSize"));
    private static IsInitializedCheckAnalyzer isInitializedCheckAnalyzer = new IsInitializedCheckAnalyzer();

    private DescriptorMessageInfoFactory() {
    }

    public static DescriptorMessageInfoFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isSupported(Class<?> messageType) {
        void var1_1;
        return GeneratedMessageV3.class.isAssignableFrom((Class<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final MessageInfo messageInfoFor(Class<?> messageType) {
        ProtoSyntax protoSyntax;
        void var1_1;
        if (!GeneratedMessageV3.class.isAssignableFrom(messageType)) {
            throw new IllegalArgumentException("Unsupported message type: " + messageType.getName());
        }
        Object object = DescriptorMessageInfoFactory.getDefaultInstance(var1_1).getDescriptorForType();
        List<Descriptors.FieldDescriptor> list2 = ((Descriptors.Descriptor)object).getFields();
        int n = list2.size();
        StructuralMessageInfo.Builder builder = new StructuralMessageInfo.Builder(n);
        builder.withDefaultInstance$5d527811(DescriptorMessageInfoFactory.getDefaultInstance(var1_1));
        Object object2 = ((Descriptors.GenericDescriptor)object).getFile().getSyntax();
        switch (object2) {
            case PROTO2: {
                protoSyntax = ProtoSyntax.PROTO2;
                break;
            }
            case PROTO3: {
                protoSyntax = ProtoSyntax.PROTO3;
                break;
            }
            case EDITIONS: {
                protoSyntax = ProtoSyntax.EDITIONS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported syntax: " + (Object)object2);
            }
        }
        builder.withSyntax(protoSyntax);
        builder.withMessageSetWireFormat(((Descriptors.Descriptor)object).getOptions().getMessageSetWireFormat());
        object = new OneofState(0);
        int n2 = 0;
        int n3 = 1;
        Field field = null;
        for (int i = 0; i < list2.size(); ++i) {
            Object object3;
            Object object4;
            Object object5;
            Object object6 = list2.get(i);
            boolean bl = ((Descriptors.FieldDescriptor)object6).needsUtf8Check();
            Object object7 = null;
            if (((Descriptors.FieldDescriptor)object6).getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM && ((Descriptors.FieldDescriptor)object6).legacyEnumFieldTreatedAsClosed()) {
                object7 = new Internal.EnumVerifier((Descriptors.FieldDescriptor)object6){
                    private /* synthetic */ Descriptors.FieldDescriptor val$fd;
                    {
                        this.val$fd = fieldDescriptor;
                    }
                };
            }
            if (((Descriptors.FieldDescriptor)object6).getRealContainingOneof() != null) {
                Class clazz;
                object5 = object7;
                boolean n4 = bl;
                object4 = object;
                Descriptors.FieldDescriptor n5 = object6;
                object2 = var1_1;
                object4 = ((OneofState)object4).getOneof((Class<?>)object2, n5.getContainingOneof());
                object3 = DescriptorMessageInfoFactory.getFieldType(n5);
                object7 = object3;
                Descriptors.FieldDescriptor fieldDescriptor2 = n5;
                object6 = object2;
                switch (((FieldType)((Object)object7)).getJavaType()) {
                    case BOOLEAN: {
                        clazz = Boolean.class;
                        break;
                    }
                    case BYTE_STRING: {
                        clazz = ByteString.class;
                        break;
                    }
                    case DOUBLE: {
                        clazz = Double.class;
                        break;
                    }
                    case FLOAT: {
                        clazz = Float.class;
                        break;
                    }
                    case ENUM: 
                    case INT: {
                        clazz = Integer.class;
                        break;
                    }
                    case LONG: {
                        clazz = Long.class;
                        break;
                    }
                    case STRING: {
                        clazz = String.class;
                        break;
                    }
                    case MESSAGE: {
                        clazz = DescriptorMessageInfoFactory.getOneofStoredTypeForMessage(object6, fieldDescriptor2);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid type for oneof: " + object7);
                    }
                }
                object6 = clazz;
                builder.withField(FieldInfo.forOneofMemberField(n5.getNumber(), (FieldType)((Object)object3), (OneofInfo)object4, object6, n4, (Internal.EnumVerifier)object5));
                continue;
            }
            Descriptors.FieldDescriptor fieldDescriptor = object6;
            object2 = var1_1;
            object4 = fieldDescriptor;
            String string = ((Descriptors.FieldDescriptor)object4).getType() == Descriptors.FieldDescriptor.Type.GROUP ? ((Descriptors.GenericDescriptor)((Descriptors.FieldDescriptor)object4).getMessageType()).getName() : ((Descriptors.GenericDescriptor)object4).getName();
            object3 = string;
            object5 = DescriptorMessageInfoFactory.snakeCaseToCamelCase(string, true);
            object4 = specialFieldNames.contains(object5) ? "__" : "_";
            String string2 = string;
            object4 = DescriptorMessageInfoFactory.field(object2, DescriptorMessageInfoFactory.snakeCaseToCamelCase(string2, false) + (String)object4);
            int n4 = ((Descriptors.FieldDescriptor)object6).getNumber();
            object5 = DescriptorMessageInfoFactory.getFieldType((Descriptors.FieldDescriptor)object6);
            if (!((Descriptors.FieldDescriptor)object6).hasPresence()) {
                if (((Descriptors.FieldDescriptor)object6).isMapField()) {
                    Descriptors.FieldDescriptor fieldDescriptor3 = ((Descriptors.FieldDescriptor)object6).getMessageType().findFieldByNumber(2);
                    if (fieldDescriptor3.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM && fieldDescriptor3.legacyEnumFieldTreatedAsClosed()) {
                        object7 = new Internal.EnumVerifier(fieldDescriptor3){
                            private /* synthetic */ Descriptors.FieldDescriptor val$valueField;
                            {
                                this.val$valueField = fieldDescriptor;
                            }
                        };
                    }
                    object6 = FieldInfo.forMapField((Field)object4, n4, SchemaUtil.getMapDefaultEntry(var1_1, ((Descriptors.GenericDescriptor)object6).getName()), (Internal.EnumVerifier)object7);
                } else {
                    object6 = ((Descriptors.FieldDescriptor)object6).isRepeated() && ((Descriptors.FieldDescriptor)object6).getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? FieldInfo.forRepeatedMessageField((Field)object4, n4, (FieldType)((Object)object5), DescriptorMessageInfoFactory.getTypeForRepeatedMessageField(var1_1, (Descriptors.FieldDescriptor)object6)) : (((Descriptors.FieldDescriptor)object6).isPacked() ? (object7 != null ? FieldInfo.forPackedFieldWithEnumVerifier$43b989af((Field)object4, n4, (FieldType)((Object)object5), object7, DescriptorMessageInfoFactory.cachedSizeField(var1_1, (Descriptors.FieldDescriptor)object6)) : FieldInfo.forPackedField((Field)object4, n4, (FieldType)((Object)object5), DescriptorMessageInfoFactory.cachedSizeField(var1_1, (Descriptors.FieldDescriptor)object6))) : (object7 != null ? FieldInfo.forFieldWithEnumVerifier$18c6fda6((Field)object4, n4, (FieldType)((Object)object5), object7) : FieldInfo.forField((Field)object4, n4, (FieldType)((Object)object5), bl)));
                }
                builder.withField((FieldInfo)object6);
                continue;
            }
            if (field == null) {
                int n5 = n2;
                object2 = var1_1;
                field = DescriptorMessageInfoFactory.field(object2, "bitField" + n5 + "_");
            }
            object6 = ((Descriptors.FieldDescriptor)object6).isRequired() ? FieldInfo.forLegacyRequiredField$c52ec9c((Field)object4, n4, (FieldType)((Object)object5), field, n3, bl, object7) : FieldInfo.forExplicitPresenceField$c52ec9c((Field)object4, n4, (FieldType)((Object)object5), field, n3, bl, object7);
            builder.withField((FieldInfo)object6);
            if ((n3 <<= 1) != 0) continue;
            field = null;
            n3 = 1;
            ++n2;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < list2.size(); ++i) {
            Descriptors.FieldDescriptor fieldDescriptor = list2.get(i);
            if (!fieldDescriptor.isRequired() && (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE || !isInitializedCheckAnalyzer.needsIsInitializedCheck((Descriptors.Descriptor)(object2 = fieldDescriptor.getMessageType())))) continue;
            arrayList.add(fieldDescriptor.getNumber());
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        if (nArray.length > 0) {
            builder.withCheckInitialized(nArray);
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static Message getDefaultInstance(Class<?> messageType) {
        try {
            Method method = messageType.getDeclaredMethod("getDefaultInstance", new Class[0]);
            return (Message)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            void var1_2;
            Class<?> clazz;
            throw new IllegalArgumentException("Unable to get default instance for message class " + clazz.getName(), (Throwable)var1_2);
        }
    }

    private static FieldType getFieldType(Descriptors.FieldDescriptor fd) {
        Descriptors.FieldDescriptor fieldDescriptor;
        switch (fd.getType()) {
            case BOOL: {
                if (!fd.isRepeated()) {
                    return FieldType.BOOL;
                }
                if (fd.isPacked()) {
                    return FieldType.BOOL_LIST_PACKED;
                }
                return FieldType.BOOL_LIST;
            }
            case BYTES: {
                if (fd.isRepeated()) {
                    return FieldType.BYTES_LIST;
                }
                return FieldType.BYTES;
            }
            case DOUBLE: {
                if (!fd.isRepeated()) {
                    return FieldType.DOUBLE;
                }
                if (fd.isPacked()) {
                    return FieldType.DOUBLE_LIST_PACKED;
                }
                return FieldType.DOUBLE_LIST;
            }
            case ENUM: {
                if (!fd.isRepeated()) {
                    return FieldType.ENUM;
                }
                if (fd.isPacked()) {
                    return FieldType.ENUM_LIST_PACKED;
                }
                return FieldType.ENUM_LIST;
            }
            case FIXED32: {
                if (!fd.isRepeated()) {
                    return FieldType.FIXED32;
                }
                if (fd.isPacked()) {
                    return FieldType.FIXED32_LIST_PACKED;
                }
                return FieldType.FIXED32_LIST;
            }
            case FIXED64: {
                if (!fd.isRepeated()) {
                    return FieldType.FIXED64;
                }
                if (fd.isPacked()) {
                    return FieldType.FIXED64_LIST_PACKED;
                }
                return FieldType.FIXED64_LIST;
            }
            case FLOAT: {
                if (!fd.isRepeated()) {
                    return FieldType.FLOAT;
                }
                if (fd.isPacked()) {
                    return FieldType.FLOAT_LIST_PACKED;
                }
                return FieldType.FLOAT_LIST;
            }
            case GROUP: {
                if (fd.isRepeated()) {
                    return FieldType.GROUP_LIST;
                }
                return FieldType.GROUP;
            }
            case INT32: {
                if (!fd.isRepeated()) {
                    return FieldType.INT32;
                }
                if (fd.isPacked()) {
                    return FieldType.INT32_LIST_PACKED;
                }
                return FieldType.INT32_LIST;
            }
            case INT64: {
                if (!fd.isRepeated()) {
                    return FieldType.INT64;
                }
                if (fd.isPacked()) {
                    return FieldType.INT64_LIST_PACKED;
                }
                return FieldType.INT64_LIST;
            }
            case MESSAGE: {
                if (fd.isMapField()) {
                    return FieldType.MAP;
                }
                if (fd.isRepeated()) {
                    return FieldType.MESSAGE_LIST;
                }
                return FieldType.MESSAGE;
            }
            case SFIXED32: {
                if (!fd.isRepeated()) {
                    return FieldType.SFIXED32;
                }
                if (fd.isPacked()) {
                    return FieldType.SFIXED32_LIST_PACKED;
                }
                return FieldType.SFIXED32_LIST;
            }
            case SFIXED64: {
                if (!fd.isRepeated()) {
                    return FieldType.SFIXED64;
                }
                if (fd.isPacked()) {
                    return FieldType.SFIXED64_LIST_PACKED;
                }
                return FieldType.SFIXED64_LIST;
            }
            case SINT32: {
                if (!fd.isRepeated()) {
                    return FieldType.SINT32;
                }
                if (fd.isPacked()) {
                    return FieldType.SINT32_LIST_PACKED;
                }
                return FieldType.SINT32_LIST;
            }
            case SINT64: {
                if (!fd.isRepeated()) {
                    return FieldType.SINT64;
                }
                if (fd.isPacked()) {
                    return FieldType.SINT64_LIST_PACKED;
                }
                return FieldType.SINT64_LIST;
            }
            case STRING: {
                if (fd.isRepeated()) {
                    return FieldType.STRING_LIST;
                }
                return FieldType.STRING;
            }
            case UINT32: {
                if (!fd.isRepeated()) {
                    return FieldType.UINT32;
                }
                if (fd.isPacked()) {
                    return FieldType.UINT32_LIST_PACKED;
                }
                return FieldType.UINT32_LIST;
            }
            case UINT64: {
                if (!fd.isRepeated()) {
                    return FieldType.UINT64;
                }
                if (fd.isPacked()) {
                    return FieldType.UINT64_LIST_PACKED;
                }
                return FieldType.UINT64_LIST;
            }
        }
        throw new IllegalArgumentException("Unsupported field type: " + (Object)((Object)fieldDescriptor.getType()));
    }

    /*
     * WARNING - void declaration
     */
    private static Field cachedSizeField(Class<?> messageType, Descriptors.FieldDescriptor fd) {
        void var1_1;
        return DescriptorMessageInfoFactory.field(messageType, DescriptorMessageInfoFactory.getCachedSizeFieldName((Descriptors.FieldDescriptor)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static Field field(Class<?> messageType, String fieldName) {
        try {
            return messageType.getDeclaredField(fieldName);
        }
        catch (Exception exception) {
            Class<?> clazz;
            void var1_1;
            throw new IllegalArgumentException("Unable to find field " + (String)var1_1 + " in message class " + clazz.getName());
        }
    }

    private static String getCachedSizeFieldName(Descriptors.FieldDescriptor fd) {
        String string;
        string = ((Descriptors.GenericDescriptor)((Object)string)).getName();
        return DescriptorMessageInfoFactory.snakeCaseToCamelCase(string, false) + "MemoizedSerializedSize";
    }

    /*
     * WARNING - void declaration
     */
    private static String snakeCaseToCamelCase(String snakeCase, boolean capFirst) {
        void var2_2;
        StringBuilder sb = new StringBuilder(snakeCase.length() + 1);
        for (int ctr = 0; ctr < snakeCase.length(); ++ctr) {
            boolean capNext;
            char next = snakeCase.charAt(ctr);
            if (next == '_') {
                capNext = true;
                continue;
            }
            if (Character.isDigit(next)) {
                sb.append(next);
                capNext = true;
                continue;
            }
            if (capNext) {
                sb.append(Character.toUpperCase(next));
                capNext = false;
                continue;
            }
            if (ctr == 0) {
                sb.append(Character.toLowerCase(next));
                continue;
            }
            sb.append(next);
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static Class<?> getOneofStoredTypeForMessage(Class<?> messageType, Descriptors.FieldDescriptor fd) {
        try {
            GenericDeclaration genericDeclaration;
            String name = fd.getType() == Descriptors.FieldDescriptor.Type.GROUP ? ((Descriptors.GenericDescriptor)fd.getMessageType()).getName() : ((Descriptors.GenericDescriptor)fd).getName();
            genericDeclaration = genericDeclaration.getDeclaredMethod(DescriptorMessageInfoFactory.getterForField(name), new Class[0]);
            return ((Method)genericDeclaration).getReturnType();
        }
        catch (Exception e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Class<?> getTypeForRepeatedMessageField(Class<?> messageType, Descriptors.FieldDescriptor fd) {
        try {
            GenericDeclaration genericDeclaration;
            String name = fd.getType() == Descriptors.FieldDescriptor.Type.GROUP ? ((Descriptors.GenericDescriptor)fd.getMessageType()).getName() : ((Descriptors.GenericDescriptor)fd).getName();
            genericDeclaration = genericDeclaration.getDeclaredMethod(DescriptorMessageInfoFactory.getterForField(name), Integer.TYPE);
            return ((Method)genericDeclaration).getReturnType();
        }
        catch (Exception e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String getterForField(String snakeCase) {
        void var1_1;
        String string;
        String camelCase = DescriptorMessageInfoFactory.snakeCaseToCamelCase(snakeCase, false);
        StringBuilder builder = new StringBuilder("get");
        builder.append(Character.toUpperCase(camelCase.charAt(0)));
        builder.append(camelCase.substring(1, string.length()));
        return var1_1.toString();
    }

    static /* synthetic */ String access$200(String x0) {
        String string = x0;
        return DescriptorMessageInfoFactory.snakeCaseToCamelCase(string, false);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Field access$300(Class x0, String x1) {
        void var1_1;
        return DescriptorMessageInfoFactory.field(x0, (String)var1_1);
    }

    private static final class OneofState {
        private OneofInfo[] oneofs = new OneofInfo[2];

        private OneofState() {
        }

        /*
         * WARNING - void declaration
         */
        final OneofInfo getOneof(Class<?> messageType, Descriptors.OneofDescriptor desc) {
            Object info;
            int index = desc.getIndex();
            if (index >= this.oneofs.length) {
                this.oneofs = Arrays.copyOf(this.oneofs, index << 1);
            }
            if ((info = this.oneofs[index]) == null) {
                void var1_1;
                void var2_2;
                info = DescriptorMessageInfoFactory.access$200(var2_2.getName());
                String string = (String)info + "_";
                info = (String)info + "Case_";
                this.oneofs[var3_3] = info = new OneofInfo(var2_2.getIndex(), DescriptorMessageInfoFactory.access$300((Class)var1_1, (String)info), DescriptorMessageInfoFactory.access$300((Class)var1_1, string));
            }
            return info;
        }

        /* synthetic */ OneofState(byte by) {
            this();
        }
    }

    static final class IsInitializedCheckAnalyzer {
        private final Map<Descriptors.Descriptor, Boolean> resultCache = new ConcurrentHashMap<Descriptors.Descriptor, Boolean>();
        private int index = 0;
        private final Stack<Node> stack = new Stack();
        private final Map<Descriptors.Descriptor, Node> nodeCache = new HashMap<Descriptors.Descriptor, Node>();

        IsInitializedCheckAnalyzer() {
        }

        /*
         * WARNING - void declaration
         */
        public final boolean needsIsInitializedCheck(Descriptors.Descriptor descriptor) {
            Boolean cachedValue = this.resultCache.get(descriptor);
            if (cachedValue != null) {
                return cachedValue;
            }
            IsInitializedCheckAnalyzer isInitializedCheckAnalyzer = this;
            synchronized (isInitializedCheckAnalyzer) {
                void var1_1;
                cachedValue = this.resultCache.get(descriptor);
                if (cachedValue != null) {
                    void var2_3;
                    return var2_3.booleanValue();
                }
                return this.dfs((Descriptors.Descriptor)var1_1).component.needsIsInitializedCheck;
            }
        }

        /*
         * WARNING - void declaration
         */
        private Node dfs(Descriptors.Descriptor descriptor) {
            void var2_2;
            Node result = new Node((Descriptors.Descriptor)descriptor, this.index++);
            this.stack.push(result);
            this.nodeCache.put((Descriptors.Descriptor)descriptor, result);
            for (Descriptors.FieldDescriptor field : ((Descriptors.Descriptor)descriptor).getFields()) {
                if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
                Node child = this.nodeCache.get(field.getMessageType());
                if (child == null) {
                    child = this.dfs(field.getMessageType());
                    result.lowLink = Math.min(result.lowLink, child.lowLink);
                    continue;
                }
                if (child.component != null) continue;
                result.lowLink = Math.min(result.lowLink, child.lowLink);
            }
            if (result.index == result.lowLink) {
                void var1_1;
                void var3_3;
                StronglyConnectedComponent component = new StronglyConnectedComponent(0);
                do {
                    Node node = this.stack.pop();
                    this.stack.pop().component = component;
                    component.messages.add(node.descriptor);
                } while (var3_3 != result);
                this.analyze((StronglyConnectedComponent)var1_1);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private void analyze(StronglyConnectedComponent component) {
            void var2_2;
            boolean needsIsInitializedCheck = false;
            block0: for (Descriptors.Descriptor descriptor : component.messages) {
                if (descriptor.isExtendable()) {
                    needsIsInitializedCheck = true;
                    break;
                }
                for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
                    if (field.isRequired()) {
                        needsIsInitializedCheck = true;
                        break block0;
                    }
                    if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
                    Node node = this.nodeCache.get(field.getMessageType());
                    if (node.component == component || !node.component.needsIsInitializedCheck) continue;
                    needsIsInitializedCheck = true;
                    break block0;
                }
            }
            component.needsIsInitializedCheck = var2_2;
            for (Descriptors.Descriptor descriptor : component.messages) {
                this.resultCache.put(descriptor, component.needsIsInitializedCheck);
            }
        }

        private static final class StronglyConnectedComponent {
            final List<Descriptors.Descriptor> messages = new ArrayList<Descriptors.Descriptor>();
            boolean needsIsInitializedCheck = false;

            private StronglyConnectedComponent() {
            }

            /* synthetic */ StronglyConnectedComponent(byte by) {
                this();
            }
        }

        private static final class Node {
            final Descriptors.Descriptor descriptor;
            final int index;
            int lowLink;
            StronglyConnectedComponent component;

            /*
             * WARNING - void declaration
             */
            Node(Descriptors.Descriptor descriptor, int index) {
                void var2_2;
                void var1_1;
                this.descriptor = var1_1;
                this.index = index;
                this.lowLink = var2_2;
                this.component = null;
            }
        }
    }
}

