/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.DescriptorMessageInfoFactory;
import com.google.protobuf.FieldType;
import com.google.protobuf.Internal;
import com.google.protobuf.OneofInfo;
import java.lang.reflect.Field;

final class FieldInfo
implements Comparable<FieldInfo> {
    private final Field field;
    private final FieldType type;
    private final Class<?> messageClass;
    private final int fieldNumber;
    private final Field presenceField;
    private final int presenceMask;
    private final boolean required;
    private final boolean enforceUtf8;
    private final OneofInfo oneof;
    private final Field cachedSizeField;
    private final Class<?> oneofStoredType;
    private final Object mapDefaultEntry;
    private final Internal.EnumVerifier enumVerifier;

    /*
     * WARNING - void declaration
     */
    public static FieldInfo forField(Field field, int fieldNumber, FieldType fieldType, boolean enforceUtf8) {
        void var3_3;
        void var2_2;
        void var1_1;
        Field field2;
        FieldInfo.checkFieldNumber(fieldNumber);
        Internal.checkNotNull(field, "field");
        Internal.checkNotNull(fieldType, "fieldType");
        if (fieldType == FieldType.MESSAGE_LIST || fieldType == FieldType.GROUP_LIST) {
            throw new IllegalStateException("Shouldn't be called for repeated message fields.");
        }
        return new FieldInfo(field2, (int)var1_1, (FieldType)var2_2, null, null, 0, false, (boolean)var3_3, null, null, null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static FieldInfo forPackedField(Field field, int fieldNumber, FieldType fieldType, Field cachedSizeField) {
        void var3_3;
        void var2_2;
        void var1_1;
        Field field2;
        FieldInfo.checkFieldNumber(fieldNumber);
        Internal.checkNotNull(field, "field");
        Internal.checkNotNull(fieldType, "fieldType");
        if (fieldType == FieldType.MESSAGE_LIST || fieldType == FieldType.GROUP_LIST) {
            throw new IllegalStateException("Shouldn't be called for repeated message fields.");
        }
        return new FieldInfo(field2, (int)var1_1, (FieldType)var2_2, null, null, 0, false, false, null, null, null, null, (Field)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static FieldInfo forRepeatedMessageField(Field field, int fieldNumber, FieldType fieldType, Class<?> messageClass) {
        void var3_3;
        void var2_2;
        void var1_1;
        Field field2;
        FieldInfo.checkFieldNumber(fieldNumber);
        Internal.checkNotNull(field, "field");
        Internal.checkNotNull(fieldType, "fieldType");
        Internal.checkNotNull(messageClass, "messageClass");
        return new FieldInfo(field2, (int)var1_1, (FieldType)var2_2, (Class<?>)var3_3, null, 0, false, false, null, null, null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static FieldInfo forFieldWithEnumVerifier$18c6fda6(Field field, int fieldNumber, FieldType fieldType, DescriptorMessageInfoFactory.1 enumVerifier) {
        void var3_3;
        void var2_2;
        void var1_1;
        Field field2;
        FieldInfo.checkFieldNumber(fieldNumber);
        Internal.checkNotNull(field, "field");
        return new FieldInfo(field2, (int)var1_1, (FieldType)var2_2, null, null, 0, false, false, null, null, null, (Internal.EnumVerifier)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public static FieldInfo forPackedFieldWithEnumVerifier$43b989af(Field field, int fieldNumber, FieldType fieldType, DescriptorMessageInfoFactory.1 enumVerifier, Field cachedSizeField) {
        void var3_3;
        void var2_2;
        void var1_1;
        Field field2;
        FieldInfo.checkFieldNumber(fieldNumber);
        Internal.checkNotNull(field, "field");
        return new FieldInfo(field2, (int)var1_1, (FieldType)var2_2, null, null, 0, false, false, null, null, null, (Internal.EnumVerifier)var3_3, cachedSizeField);
    }

    /*
     * WARNING - void declaration
     */
    public static FieldInfo forExplicitPresenceField$c52ec9c(Field field, int fieldNumber, FieldType fieldType, Field presenceField, int presenceMask, boolean enforceUtf8, DescriptorMessageInfoFactory.1 enumVerifier) {
        void var3_3;
        void var2_2;
        void var1_1;
        Field field2;
        FieldInfo.checkFieldNumber(fieldNumber);
        Internal.checkNotNull(field, "field");
        Internal.checkNotNull(fieldType, "fieldType");
        Internal.checkNotNull(presenceField, "presenceField");
        if (presenceField != null && !FieldInfo.isExactlyOneBitSet(presenceMask)) {
            throw new IllegalArgumentException("presenceMask must have exactly one bit set: " + presenceMask);
        }
        return new FieldInfo(field2, (int)var1_1, (FieldType)var2_2, null, (Field)var3_3, presenceMask, false, enforceUtf8, null, null, null, enumVerifier, null);
    }

    /*
     * WARNING - void declaration
     */
    public static FieldInfo forOneofMemberField(int fieldNumber, FieldType fieldType, OneofInfo oneof, Class<?> oneofStoredType, boolean enforceUtf8, Internal.EnumVerifier enumVerifier) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        FieldInfo.checkFieldNumber(fieldNumber);
        Internal.checkNotNull(fieldType, "fieldType");
        Internal.checkNotNull(oneof, "oneof");
        Internal.checkNotNull(oneofStoredType, "oneofStoredType");
        if (!fieldType.isScalar()) {
            throw new IllegalArgumentException("Oneof is only supported for scalar fields. Field " + fieldNumber + " is of type " + (Object)((Object)fieldType));
        }
        return new FieldInfo(null, n, (FieldType)var1_1, null, null, 0, false, enforceUtf8, (OneofInfo)var2_2, (Class<?>)var3_3, null, enumVerifier, null);
    }

    private static void checkFieldNumber(int fieldNumber) {
        if (fieldNumber <= 0) {
            int n;
            throw new IllegalArgumentException("fieldNumber must be positive: " + n);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static FieldInfo forLegacyRequiredField$c52ec9c(Field field, int fieldNumber, FieldType fieldType, Field presenceField, int presenceMask, boolean enforceUtf8, DescriptorMessageInfoFactory.1 enumVerifier) {
        void var3_3;
        void var2_2;
        void var1_1;
        Field field2;
        FieldInfo.checkFieldNumber(fieldNumber);
        Internal.checkNotNull(field, "field");
        Internal.checkNotNull(fieldType, "fieldType");
        Internal.checkNotNull(presenceField, "presenceField");
        if (presenceField != null && !FieldInfo.isExactlyOneBitSet(presenceMask)) {
            throw new IllegalArgumentException("presenceMask must have exactly one bit set: " + presenceMask);
        }
        return new FieldInfo(field2, (int)var1_1, (FieldType)var2_2, null, (Field)var3_3, presenceMask, true, enforceUtf8, null, null, null, enumVerifier, null);
    }

    /*
     * WARNING - void declaration
     */
    public static FieldInfo forMapField(Field field, int fieldNumber, Object mapDefaultEntry, Internal.EnumVerifier enumVerifier) {
        void var3_3;
        void var2_2;
        void var1_1;
        Field field2;
        Internal.checkNotNull(mapDefaultEntry, "mapDefaultEntry");
        FieldInfo.checkFieldNumber(fieldNumber);
        Internal.checkNotNull(field, "field");
        return new FieldInfo(field2, (int)var1_1, FieldType.MAP, null, null, 0, false, true, null, null, var2_2, (Internal.EnumVerifier)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    private FieldInfo(Field field, int fieldNumber, FieldType type, Class<?> messageClass, Field presenceField, int presenceMask, boolean required, boolean enforceUtf8, OneofInfo oneof, Class<?> oneofStoredType, Object mapDefaultEntry, Internal.EnumVerifier enumVerifier, Field cachedSizeField) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.field = var1_1;
        this.type = var3_3;
        this.messageClass = messageClass;
        this.fieldNumber = var2_2;
        this.presenceField = presenceField;
        this.presenceMask = presenceMask;
        this.required = required;
        this.enforceUtf8 = enforceUtf8;
        this.oneof = oneof;
        this.oneofStoredType = oneofStoredType;
        this.mapDefaultEntry = mapDefaultEntry;
        this.enumVerifier = enumVerifier;
        this.cachedSizeField = cachedSizeField;
    }

    public final int getFieldNumber() {
        return this.fieldNumber;
    }

    public final Field getField() {
        return this.field;
    }

    public final FieldType getType() {
        return this.type;
    }

    public final OneofInfo getOneof() {
        return this.oneof;
    }

    public final Internal.EnumVerifier getEnumVerifier() {
        return this.enumVerifier;
    }

    public final Field getPresenceField() {
        return this.presenceField;
    }

    public final Object getMapDefaultEntry() {
        return this.mapDefaultEntry;
    }

    public final int getPresenceMask() {
        return this.presenceMask;
    }

    public final boolean isRequired() {
        return this.required;
    }

    public final boolean isEnforceUtf8() {
        return this.enforceUtf8;
    }

    public final Field getCachedSizeField() {
        return this.cachedSizeField;
    }

    public final Class<?> getMessageFieldClass() {
        switch (this.type) {
            case MESSAGE: 
            case GROUP: {
                if (this.field != null) {
                    return this.field.getType();
                }
                return this.oneofStoredType;
            }
            case MESSAGE_LIST: 
            case GROUP_LIST: {
                return this.messageClass;
            }
        }
        return null;
    }

    private static boolean isExactlyOneBitSet(int value) {
        if (value != 0) {
            int n;
            int n2 = n;
            if ((n2 & n2 - 1) == 0) {
                return true;
            }
        }
        return false;
    }
}

