/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.Internal;
import com.google.protobuf.LazyField;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageLiteOrBuilder;
import com.google.protobuf.SmallSortedMap;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class FieldSet<T extends FieldDescriptorLite<T>> {
    private final SmallSortedMap<T, Object> fields;
    private boolean isImmutable;
    private boolean hasLazyField;
    private static final FieldSet DEFAULT_INSTANCE = new FieldSet(0);

    private FieldSet() {
        this.fields = SmallSortedMap.newFieldMap$670e6a63((int)16);
    }

    private FieldSet(byte by) {
        this(SmallSortedMap.newFieldMap$670e6a63((int)0));
        this.makeImmutable();
    }

    /*
     * WARNING - void declaration
     */
    private FieldSet(SmallSortedMap<T, Object> fields) {
        void var1_1;
        this.fields = var1_1;
        this.makeImmutable();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> newFieldSet() {
        return new FieldSet<T>();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> emptySet() {
        return DEFAULT_INSTANCE;
    }

    public static <T extends FieldDescriptorLite<T>> Builder<T> newBuilder() {
        return new Builder(0);
    }

    /*
     * WARNING - void declaration
     */
    public final void makeImmutable() {
        if (this.isImmutable) {
            return;
        }
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            void var2_2;
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            if (!(entry.getValue() instanceof GeneratedMessageLite)) continue;
            ((GeneratedMessageLite)var2_2.getValue()).makeImmutable();
        }
        this.fields.makeImmutable();
        this.isImmutable = true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldSet)) {
            return false;
        }
        FieldSet other = (FieldSet)o;
        return this.fields.equals(var1_1.fields);
    }

    public final int hashCode() {
        return this.fields.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public final FieldSet<T> clone() {
        void var1_1;
        FieldSet<FieldDescriptorLite> clone = new FieldSet<FieldDescriptorLite>();
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            clone.setField((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            void var3_4;
            clone.setField((FieldDescriptorLite)entry.getKey(), var3_4.getValue());
        }
        clone.hasLazyField = this.hasLazyField;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Map<T, Object> getAllFields() {
        if (this.hasLazyField) {
            void var1_1;
            SmallSortedMap<T, Object> result = FieldSet.cloneAllFieldsMap(this.fields, false);
            if (this.fields.isImmutable()) {
                result.makeImmutable();
            }
            return var1_1;
        }
        if (this.fields.isImmutable()) {
            return this.fields;
        }
        return Collections.unmodifiableMap(this.fields);
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends FieldDescriptorLite<T>> SmallSortedMap<T, Object> cloneAllFieldsMap(SmallSortedMap<T, Object> fields, boolean copyList) {
        void var2_4;
        SmallSortedMap.1 result = SmallSortedMap.newFieldMap$670e6a63((int)16);
        for (int i = 0; i < fields.getNumArrayEntries(); ++i) {
            FieldSet.cloneFieldEntry$796c1333(result, fields.getArrayEntryAt(i), (boolean)copyList);
        }
        for (Map.Entry<T, Object> entry : fields.getOverflowEntries()) {
            void var0_2;
            FieldSet.cloneFieldEntry$796c1333(result, (Map.Entry)var0_2, (boolean)copyList);
        }
        return var2_4;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     * WARNING - void declaration
     */
    private static void cloneFieldEntry$796c1333(SmallSortedMap map, Map.Entry entry, boolean copyList) {
        void var1_1;
        void var3_3;
        SmallSortedMap smallSortedMap;
        void var2_2;
        FieldDescriptorLite key = (FieldDescriptorLite)entry.getKey();
        Object value = entry.getValue();
        if (value instanceof LazyField) {
            map.put(key, ((LazyField)value).getValue());
            return;
        }
        if (var2_2 != false && value instanceof List) {
            map.put(key, new ArrayList((List)value));
            return;
        }
        smallSortedMap.put(var3_3, var1_1);
    }

    public final Iterator<Map.Entry<T, Object>> iterator() {
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.entrySet().iterator());
        }
        return this.fields.entrySet().iterator();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasField$921ae91(T descriptor) {
        void var1_1;
        if (descriptor.isRepeated()) {
            throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
        }
        return this.fields.get(var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    public final Object getField(T descriptor) {
        void var1_1;
        Object o = this.fields.get(descriptor);
        if (o instanceof LazyField) {
            return ((LazyField)o).getValue();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void setField(T descriptor, Object value) {
        void var2_2;
        void var1_1;
        if (descriptor.isRepeated()) {
            void var3_3;
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
            ArrayList newList = new ArrayList();
            newList.addAll((List)((Object)value));
            for (Object element : newList) {
                FieldSet.verifyType(descriptor, element);
            }
            value = var3_3;
        } else {
            FieldSet.verifyType(descriptor, value);
        }
        if (value instanceof LazyField) {
            this.hasLazyField = true;
        }
        this.fields.put(var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void verifyType(T descriptor, Object value) {
        if (!FieldSet.isValidType(descriptor.getLiteType(), value)) {
            void var1_1;
            Object t;
            throw new IllegalArgumentException(String.format("Wrong object type used with protocol message reflection.\nField number: %d, field java type: %s, value type: %s\n", new Object[]{descriptor.getNumber(), t.getLiteType().getJavaType(), var1_1.getClass().getName()}));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isValidType(WireFormat.FieldType type, Object value) {
        WireFormat.FieldType fieldType;
        Internal.checkNotNull(value);
        switch (fieldType.getJavaType()) {
            case INT: {
                return value instanceof Integer;
            }
            case LONG: {
                return value instanceof Long;
            }
            case FLOAT: {
                return value instanceof Float;
            }
            case DOUBLE: {
                return value instanceof Double;
            }
            case BOOLEAN: {
                return value instanceof Boolean;
            }
            case STRING: {
                return value instanceof String;
            }
            case BYTE_STRING: {
                return value instanceof ByteString || value instanceof byte[];
            }
            case ENUM: {
                return value instanceof Integer || value instanceof Internal.EnumLite;
            }
            case MESSAGE: {
                void var1_1;
                return value instanceof MessageLite || var1_1 instanceof LazyField;
            }
        }
        return false;
    }

    public final boolean isInitialized() {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            if (FieldSet.isInitialized(this.fields.getArrayEntryAt(i))) continue;
            return false;
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            if (FieldSet.isInitialized(entry)) continue;
            return false;
        }
        return true;
    }

    private static <T extends FieldDescriptorLite<T>> boolean isInitialized(Map.Entry<T, Object> entry) {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            Object e2;
            if (e2.isRepeated()) {
                for (Object e2 : (List)entry.getValue()) {
                    if (FieldSet.isMessageFieldValueInitialized(e2)) continue;
                    return false;
                }
            } else {
                Map.Entry<T, Object> entry2;
                return FieldSet.isMessageFieldValueInitialized(entry2.getValue());
            }
        }
        return true;
    }

    private static boolean isMessageFieldValueInitialized(Object value) {
        Object object;
        if (value instanceof MessageLiteOrBuilder) {
            return ((MessageLiteOrBuilder)value).isInitialized();
        }
        if (object instanceof LazyField) {
            return true;
        }
        throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
    }

    static int getWireFormatForFieldType(WireFormat.FieldType type, boolean isPacked) {
        WireFormat.FieldType fieldType;
        if (isPacked) {
            return 2;
        }
        return fieldType.getWireType();
    }

    /*
     * WARNING - void declaration
     */
    private static Object cloneIfMutable(Object value) {
        Object object;
        if (value instanceof byte[]) {
            void var1_1;
            byte[] byArray = (byte[])value;
            Object bytes = byArray;
            byte[] copy = new byte[byArray.length];
            System.arraycopy(bytes, 0, copy, 0, ((Object)object).length);
            return var1_1;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeTo(CodedOutputStream output) throws IOException {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), output);
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            void var3_4;
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), var3_4.getValue(), output);
        }
    }

    public final void writeMessageSetTo(CodedOutputStream output) throws IOException {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            FieldSet.writeMessageSetTo(this.fields.getArrayEntryAt(i), output);
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            FieldSet.writeMessageSetTo(entry, output);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static void writeMessageSetTo(Map.Entry<T, Object> entry, CodedOutputStream output) throws IOException {
        void var1_1;
        Map.Entry entry2;
        void var2_2;
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !descriptor.isRepeated() && !descriptor.isPacked()) {
            Object value = entry.getValue();
            if (value instanceof LazyField) {
                ByteString valueBytes = ((LazyField)value).toByteString();
                output.writeRawMessageSetExtension(((FieldDescriptorLite)entry.getKey()).getNumber(), (ByteString)var2_2);
                return;
            }
            output.writeMessageSetExtension(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)var2_2);
            return;
        }
        FieldSet.writeField(var2_2, entry2.getValue(), (CodedOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void writeElement(CodedOutputStream output, WireFormat.FieldType type, int number, Object value) throws IOException {
        void var3_3;
        void var1_1;
        CodedOutputStream codedOutputStream;
        void var2_2;
        if (type == WireFormat.FieldType.GROUP$41339999) {
            output.writeGroup(number, (MessageLite)value);
            return;
        }
        output.writeTag((int)var2_2, FieldSet.getWireFormatForFieldType(type, false));
        FieldSet.writeElementNoTag(codedOutputStream, (WireFormat.FieldType)var1_1, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void writeElementNoTag(CodedOutputStream output, WireFormat.FieldType type, Object value) throws IOException {
        void var1_1;
        switch (1.$SwitchMap$com$google$protobuf$WireFormat$FieldType[var1_1.ordinal()]) {
            case 1: {
                output.writeDoubleNoTag((Double)value);
                return;
            }
            case 2: {
                output.writeFloatNoTag(((Float)value).floatValue());
                return;
            }
            case 3: {
                long l = (Long)value;
                output.writeUInt64NoTag(l);
                return;
            }
            case 4: {
                output.writeUInt64NoTag((Long)value);
                return;
            }
            case 5: {
                output.writeInt32NoTag((Integer)value);
                return;
            }
            case 6: {
                output.writeFixed64NoTag((Long)value);
                return;
            }
            case 7: {
                output.writeFixed32NoTag((Integer)value);
                return;
            }
            case 8: {
                output.writeBoolNoTag((Boolean)value);
                return;
            }
            case 9: {
                MessageLite messageLite = (MessageLite)value;
                messageLite.writeTo(output);
                return;
            }
            case 10: {
                output.writeMessageNoTag((MessageLite)value);
                return;
            }
            case 11: {
                if (value instanceof ByteString) {
                    output.writeBytesNoTag((ByteString)value);
                    return;
                }
                output.writeStringNoTag((String)value);
                return;
            }
            case 12: {
                if (value instanceof ByteString) {
                    output.writeBytesNoTag((ByteString)value);
                    return;
                }
                output.writeByteArrayNoTag((byte[])value);
                return;
            }
            case 13: {
                output.writeUInt32NoTag((Integer)value);
                return;
            }
            case 14: {
                int n = (Integer)value;
                output.writeFixed32NoTag(n);
                return;
            }
            case 15: {
                long l = (Long)value;
                output.writeFixed64NoTag(l);
                return;
            }
            case 16: {
                output.writeSInt32NoTag((Integer)value);
                return;
            }
            case 17: {
                output.writeSInt64NoTag((Long)value);
                return;
            }
            case 18: {
                CodedOutputStream codedOutputStream;
                void var2_2;
                if (value instanceof Internal.EnumLite) {
                    int n = ((Internal.EnumLite)value).getNumber();
                    output.writeInt32NoTag(n);
                    return;
                }
                int n = (Integer)var2_2;
                codedOutputStream.writeInt32NoTag(n);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static void writeField(FieldDescriptorLite<?> descriptor, Object value, CodedOutputStream output) throws IOException {
        void var3_4;
        void var2_3;
        void var4_5;
        void var1_2;
        WireFormat.FieldType type = descriptor.getLiteType();
        int number = descriptor.getNumber();
        if (descriptor.isRepeated()) {
            List valueList = (List)value;
            if (descriptor.isPacked()) {
                void var0_1;
                if (valueList.isEmpty()) {
                    return;
                }
                output.writeTag(number, 2);
                int dataSize = 0;
                for (Object element : valueList) {
                    dataSize += FieldSet.computeElementSizeNoTag(type, element);
                }
                output.writeUInt32NoTag((int)var0_1);
                for (Object element : valueList) {
                    FieldSet.writeElementNoTag(output, type, element);
                }
                return;
            } else {
                Iterator iterator = var1_2.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return;
                    }
                    Object element = iterator.next();
                    FieldSet.writeElement(output, type, (int)var4_5, element);
                }
            }
        }
        if (var1_2 instanceof LazyField) {
            FieldSet.writeElement(output, type, (int)var4_5, ((LazyField)var1_2).getValue());
            return;
        }
        FieldSet.writeElement((CodedOutputStream)var2_3, (WireFormat.FieldType)var3_4, (int)var4_5, var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final int getSerializedSize() {
        void var1_1;
        int size = 0;
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            size += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            void var3_4;
            size += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), var3_4.getValue());
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final int getMessageSetSerializedSize() {
        void var1_1;
        int size = 0;
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            size += FieldSet.getMessageSetSerializedSize(this.fields.getArrayEntryAt(i));
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            void var3_4;
            size += FieldSet.getMessageSetSerializedSize(var3_4);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int getMessageSetSerializedSize(Map.Entry<T, Object> entry) {
        void var2_2;
        void var1_1;
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        Object value = entry.getValue();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !descriptor.isRepeated() && !descriptor.isPacked()) {
            Map.Entry entry2;
            if (value instanceof LazyField) {
                return CodedOutputStream.computeLazyFieldMessageSetExtensionSize$11c10712(((FieldDescriptorLite)entry.getKey()).getNumber(), (LazyField)value);
            }
            return CodedOutputStream.computeMessageSetExtensionSize(((FieldDescriptorLite)entry2.getKey()).getNumber(), (MessageLite)value);
        }
        return FieldSet.computeFieldSize(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static int computeElementSize(WireFormat.FieldType type, int number, Object value) {
        void var2_2;
        WireFormat.FieldType fieldType;
        void var1_1;
        int tagSize = CodedOutputStream.computeTagSize(number);
        if (type == WireFormat.FieldType.GROUP$41339999) {
            tagSize <<= 1;
        }
        return (int)(var1_1 + FieldSet.computeElementSizeNoTag(fieldType, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private static int computeElementSizeNoTag(WireFormat.FieldType type, Object value) {
        WireFormat.FieldType fieldType;
        switch (1.$SwitchMap$com$google$protobuf$WireFormat$FieldType[fieldType.ordinal()]) {
            case 1: {
                ((Double)value).doubleValue();
                return CodedOutputStream.computeDoubleSizeNoTag$13335c();
            }
            case 2: {
                ((Float)value).floatValue();
                return CodedOutputStream.computeFloatSizeNoTag$133ade();
            }
            case 3: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)value);
            }
            case 4: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)value);
            }
            case 5: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)value);
            }
            case 6: {
                ((Long)value).longValue();
                return CodedOutputStream.computeFixed64SizeNoTag$1349e2();
            }
            case 7: {
                ((Integer)value).intValue();
                return CodedOutputStream.computeFixed32SizeNoTag$134621();
            }
            case 8: {
                ((Boolean)value).booleanValue();
                return CodedOutputStream.computeBoolSizeNoTag$1385f2();
            }
            case 9: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)value);
            }
            case 12: {
                if (value instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value);
                }
                return CodedOutputStream.computeByteArraySizeNoTag((byte[])value);
            }
            case 11: {
                if (value instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value);
                }
                return CodedOutputStream.computeStringSizeNoTag((String)value);
            }
            case 13: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)value);
            }
            case 14: {
                ((Integer)value).intValue();
                return CodedOutputStream.computeSFixed32SizeNoTag$134621();
            }
            case 15: {
                ((Long)value).longValue();
                return CodedOutputStream.computeSFixed64SizeNoTag$1349e2();
            }
            case 16: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)value);
            }
            case 17: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)value);
            }
            case 10: {
                if (value instanceof LazyField) {
                    return CodedOutputStream.computeLazyFieldSizeNoTag((LazyField)value);
                }
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)value);
            }
            case 18: {
                void var1_1;
                if (value instanceof Internal.EnumLite) {
                    return CodedOutputStream.computeEnumSizeNoTag(((Internal.EnumLite)value).getNumber());
                }
                return CodedOutputStream.computeEnumSizeNoTag((Integer)var1_1);
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    /*
     * WARNING - void declaration
     */
    public static int computeFieldSize(FieldDescriptorLite<?> descriptor, Object value) {
        void var3_5;
        void var2_4;
        Iterator iterator;
        WireFormat.FieldType type = descriptor.getLiteType();
        int number = descriptor.getNumber();
        if (descriptor.isRepeated()) {
            void var0_2;
            Object valueList = (List)value;
            if (descriptor.isPacked()) {
                if (valueList.isEmpty()) {
                    return 0;
                }
                int dataSize = 0;
                valueList = valueList.iterator();
                while (valueList.hasNext()) {
                    Object element = valueList.next();
                    dataSize += FieldSet.computeElementSizeNoTag(type, element);
                }
                return dataSize + CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeUInt32SizeNoTag(dataSize);
            }
            int size = 0;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                size += FieldSet.computeElementSize(type, number, element);
            }
            return (int)var0_2;
        }
        return FieldSet.computeElementSize((WireFormat.FieldType)var2_4, (int)var3_5, iterator);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SmallSortedMap access$100(SmallSortedMap x0, boolean x1) {
        void var1_1;
        return FieldSet.cloneAllFieldsMap(x0, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ FieldSet(SmallSortedMap x0, byte by) {
        this((SmallSortedMap<T, Object>)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$302(FieldSet x0, boolean x1) {
        void var1_1;
        x0.hasLazyField = var1_1;
        return x0.hasLazyField;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$500(WireFormat.FieldType x0, Object x1) {
        void var1_1;
        return FieldSet.isValidType(x0, var1_1);
    }

    static final class Builder<T extends FieldDescriptorLite<T>> {
        private SmallSortedMap<T, Object> fields;
        private boolean hasLazyField;
        private boolean isMutable;
        private boolean hasNestedBuilders;

        private Builder() {
            this(SmallSortedMap.newFieldMap$670e6a63((int)16));
        }

        /*
         * WARNING - void declaration
         */
        private Builder(SmallSortedMap<T, Object> fields) {
            void var1_1;
            this.fields = var1_1;
            this.isMutable = true;
        }

        public final FieldSet<T> build() {
            return this.buildImpl(false);
        }

        public final FieldSet<T> buildPartial() {
            return this.buildImpl(true);
        }

        /*
         * WARNING - void declaration
         */
        private FieldSet<T> buildImpl(boolean partial) {
            void var1_2;
            void var2_3;
            if (this.fields.isEmpty()) {
                return FieldSet.emptySet();
            }
            this.isMutable = false;
            SmallSortedMap fieldsForBuild = this.fields;
            if (this.hasNestedBuilders) {
                fieldsForBuild = FieldSet.access$100(this.fields, false);
                Builder.replaceBuilders(fieldsForBuild, partial);
            }
            FieldSet fieldSet = new FieldSet((SmallSortedMap)var2_3, 0);
            FieldSet.access$302(fieldSet, this.hasLazyField);
            return var1_2;
        }

        private static <T extends FieldDescriptorLite<T>> void replaceBuilders(SmallSortedMap<T, Object> fieldMap, boolean partial) {
            SmallSortedMap<T, Object> object;
            for (int i = 0; i < fieldMap.getNumArrayEntries(); ++i) {
                Builder.replaceBuilders(fieldMap.getArrayEntryAt(i), (boolean)partial);
            }
            for (Map.Entry<T, Object> entry : object.getOverflowEntries()) {
                Builder.replaceBuilders(entry, (boolean)partial);
            }
        }

        /*
         * WARNING - void declaration
         */
        private static <T extends FieldDescriptorLite<T>> void replaceBuilders(Map.Entry<T, Object> entry, boolean partial) {
            void var1_1;
            Map.Entry<T, Object> entry2;
            Map.Entry<T, Object> entry3 = entry;
            entry3.setValue(Builder.replaceBuilders((FieldDescriptorLite)entry3.getKey(), entry2.getValue(), (boolean)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        private static <T extends FieldDescriptorLite<T>> Object replaceBuilders(T descriptor, Object value, boolean partial) {
            void var1_1;
            if (value == null) {
                return value;
            }
            if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
                void var2_2;
                if (descriptor.isRepeated()) {
                    Object object;
                    if (!(value instanceof List)) {
                        throw new IllegalStateException("Repeated field should contains a List but actually contains type: " + value.getClass());
                    }
                    Object list2 = (List)value;
                    for (int i = 0; i < list2.size(); ++i) {
                        Object oldElement = list2.get(i);
                        Object newElement = Builder.replaceBuilder(oldElement, partial);
                        if (newElement == oldElement) continue;
                        if (list2 == value) {
                            list2 = new ArrayList(list2);
                        }
                        list2.set(i, newElement);
                    }
                    return object;
                }
                return Builder.replaceBuilder(value, (boolean)var2_2);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private static Object replaceBuilder(Object value, boolean partial) {
            Object object;
            void var1_1;
            if (!(value instanceof MessageLite.Builder)) {
                return value;
            }
            Object builder = (MessageLite.Builder)value;
            if (var1_1 != false) {
                return builder.buildPartial();
            }
            return object.build();
        }

        /*
         * WARNING - void declaration
         */
        public final Map<T, Object> getAllFields() {
            if (this.hasLazyField) {
                void var1_1;
                SmallSortedMap result = FieldSet.access$100(this.fields, false);
                if (this.fields.isImmutable()) {
                    result.makeImmutable();
                } else {
                    Builder.replaceBuilders(result, true);
                }
                return var1_1;
            }
            if (this.fields.isImmutable()) {
                return this.fields;
            }
            return Collections.unmodifiableMap(this.fields);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean hasField$921ae91(T descriptor) {
            void var1_1;
            if (descriptor.isRepeated()) {
                throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
            }
            return this.fields.get(var1_1) != null;
        }

        /*
         * WARNING - void declaration
         */
        public final Object getField$7f4bbb(T descriptor) {
            void var2_2;
            void var1_1;
            Object value = this.getFieldAllowBuilders(descriptor);
            return Builder.replaceBuilders(var1_1, var2_2, true);
        }

        /*
         * WARNING - void declaration
         */
        final Object getFieldAllowBuilders(T descriptor) {
            void var1_1;
            Object o = this.fields.get(descriptor);
            if (o instanceof LazyField) {
                return ((LazyField)o).getValue();
            }
            return var1_1;
        }

        private void ensureIsMutable() {
            if (!this.isMutable) {
                this.fields = FieldSet.access$100(this.fields, true);
                this.isMutable = true;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void setField$52920ad7(T descriptor, Object value) {
            void var1_1;
            void var2_2;
            this.ensureIsMutable();
            if (descriptor.isRepeated()) {
                if (!(value instanceof List)) {
                    throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                }
                ArrayList newList = new ArrayList((List)value);
                for (Object element : newList) {
                    Builder.verifyType(descriptor, element);
                    this.hasNestedBuilders = this.hasNestedBuilders || element instanceof MessageLite.Builder;
                }
            } else {
                Builder.verifyType(descriptor, var2_2);
            }
            if (var2_2 instanceof LazyField) {
                this.hasLazyField = true;
            }
            this.hasNestedBuilders = this.hasNestedBuilders || var2_2 instanceof MessageLite.Builder;
            this.fields.put(var1_1, (Object)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final void clearField$921ae8d(T descriptor) {
            void var1_1;
            this.ensureIsMutable();
            this.fields.remove(var1_1);
            if (this.fields.isEmpty()) {
                this.hasLazyField = false;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void addRepeatedField$52920ad7(T descriptor, Object value) {
            void var2_2;
            void var3_3;
            ArrayList list2;
            this.ensureIsMutable();
            if (!descriptor.isRepeated()) {
                throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
            }
            this.hasNestedBuilders = this.hasNestedBuilders || value instanceof MessageLite.Builder;
            Builder.verifyType(descriptor, value);
            Object existingValue = this.getFieldAllowBuilders(descriptor);
            if (existingValue == null) {
                void var1_1;
                list2 = new ArrayList();
                this.fields.put(var1_1, (Object)list2);
            } else {
                list2 = list2;
            }
            var3_3.add(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private static void verifyType(T descriptor, Object value) {
            if (!FieldSet.access$500(descriptor.getLiteType(), value)) {
                void var1_1;
                Object t;
                if (descriptor.getLiteType().getJavaType() == WireFormat.JavaType.MESSAGE && value instanceof MessageLite.Builder) {
                    return;
                }
                throw new IllegalArgumentException(String.format("Wrong object type used with protocol message reflection.\nField number: %d, field java type: %s, value type: %s\n", new Object[]{descriptor.getNumber(), t.getLiteType().getJavaType(), var1_1.getClass().getName()}));
            }
        }

        public final boolean isInitialized() {
            for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
                if (FieldSet.isInitialized(this.fields.getArrayEntryAt(i))) continue;
                return false;
            }
            for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
                if (FieldSet.isInitialized(entry)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public final void mergeFrom(FieldSet<T> other) {
            this.ensureIsMutable();
            for (int i = 0; i < ((FieldSet)other).fields.getNumArrayEntries(); ++i) {
                this.mergeFromField(((FieldSet)other).fields.getArrayEntryAt(i));
            }
            for (Map.Entry entry : ((FieldSet)other).fields.getOverflowEntries()) {
                void var1_1;
                this.mergeFromField((Map.Entry<T, Object>)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private void mergeFromField(Map.Entry<T, Object> entry) {
            void var3_4;
            void var2_2;
            FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
            Iterator otherValue = entry.getValue();
            if (otherValue instanceof LazyField) {
                otherValue = ((LazyField)((Object)otherValue)).getValue();
            }
            if (descriptor.isRepeated()) {
                ArrayList<Object> value = (ArrayList<Object>)this.getFieldAllowBuilders(descriptor);
                if (value == null) {
                    value = new ArrayList<Object>();
                    this.fields.put((T)descriptor, (Object)value);
                }
                otherValue = ((List)((Object)otherValue)).iterator();
                while (otherValue.hasNext()) {
                    Object element = otherValue.next();
                    value.add(FieldSet.cloneIfMutable(var2_2));
                }
                return;
            }
            if (var2_2.getLiteJavaType() != WireFormat.JavaType.MESSAGE) {
                void var1_1;
                this.fields.put(var2_2, FieldSet.cloneIfMutable(var1_1));
                return;
            }
            Object value = this.getFieldAllowBuilders(var2_2);
            if (value == null) {
                this.fields.put(var2_2, FieldSet.cloneIfMutable(otherValue));
                return;
            }
            if (value instanceof MessageLite.Builder) {
                var2_2.internalMergeFrom((MessageLite.Builder)value, (MessageLite)((Object)otherValue));
                return;
            }
            value = var2_2.internalMergeFrom(((MessageLite)value).toBuilder(), (MessageLite)((Object)otherValue)).build();
            this.fields.put(var2_2, (Object)var3_4);
        }

        /* synthetic */ Builder(byte by) {
            this();
        }
    }

    public static interface FieldDescriptorLite<T extends FieldDescriptorLite<T>>
    extends Comparable<T> {
        public int getNumber();

        public WireFormat.FieldType getLiteType();

        public WireFormat.JavaType getLiteJavaType();

        public boolean isRepeated();

        public boolean isPacked();

        public MessageLite.Builder internalMergeFrom(MessageLite.Builder var1, MessageLite var2);
    }
}

