/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractProtobufList;
import com.google.protobuf.Internal;
import com.google.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class IntArrayList
extends AbstractProtobufList<Integer>
implements Internal.IntList,
PrimitiveNonBoxingCollection,
RandomAccess {
    private static final IntArrayList EMPTY_LIST = new IntArrayList(new int[0], 0, false);
    private int[] array;
    private int size;

    public static IntArrayList emptyList() {
        return EMPTY_LIST;
    }

    IntArrayList() {
        this(new int[10], 0, true);
    }

    /*
     * WARNING - void declaration
     */
    private IntArrayList(int[] other, int size, boolean isMutable) {
        super((boolean)var3_3);
        void var2_2;
        void var1_1;
        void var3_3;
        this.array = var1_1;
        this.size = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void removeRange(int fromIndex, int toIndex) {
        void var1_1;
        void var2_2;
        this.ensureIsMutable();
        if (toIndex < fromIndex) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, toIndex, this.array, fromIndex, this.size - toIndex);
        this.size -= var2_2 - var1_1;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntArrayList)) {
            return super.equals(o);
        }
        IntArrayList other = (IntArrayList)o;
        if (this.size != other.size) {
            return false;
        }
        int[] arr2 = other.array;
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == arr2[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int hashCode() {
        void var1_1;
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            result = result * 31 + this.array[i];
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final IntArrayList mutableCopyWithCapacity$3f369615(int capacity) {
        void var1_1;
        if (capacity < this.size) {
            throw new IllegalArgumentException();
        }
        return new IntArrayList(Arrays.copyOf(this.array, (int)var1_1), this.size, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getInt(int index) {
        void var1_1;
        this.ensureIndexInRange(index);
        return this.array[var1_1];
    }

    @Override
    public final int indexOf(Object element) {
        if (!(element instanceof Integer)) {
            return -1;
        }
        int unboxedElement = (Integer)element;
        int numElems = this.size();
        for (int i = 0; i < numElems; ++i) {
            if (this.array[i] != unboxedElement) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object element) {
        void var1_1;
        return this.indexOf(var1_1) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addInt(int element) {
        void var1_1;
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            void var2_3;
            int n = this.size * 3 / 2 + 1;
            int[] newArray = new int[n];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = var2_3;
        }
        this.array[this.size++] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        void var1_1;
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof IntArrayList)) {
            return super.addAll(collection);
        }
        IntArrayList list2 = (IntArrayList)collection;
        if (list2.size == 0) {
            return false;
        }
        int n = Integer.MAX_VALUE - this.size;
        if (n < list2.size) {
            throw new OutOfMemoryError();
        }
        int newSize = this.size + list2.size;
        if (newSize > this.array.length) {
            this.array = Arrays.copyOf(this.array, newSize);
        }
        System.arraycopy(list2.array, 0, this.array, this.size, var1_1.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureIndexInRange(int index) {
        if (index < 0 || index >= this.size) {
            void var1_1;
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage((int)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private String makeOutOfBoundsExceptionMessage(int index) {
        void var1_1;
        return "Index:" + (int)var1_1 + ", Size:" + this.size;
    }
}

