/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.MessageLite;
import com.google.protobuf.TextFormatEscaper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

final class MessageLiteToString {
    private static final char[] INDENT_BUFFER = new char[80];

    /*
     * WARNING - void declaration
     */
    static String toString$491ca223(GeneratedMessageLite messageLite, String commentString) {
        void var2_2;
        GeneratedMessageLite generatedMessageLite;
        void var1_1;
        StringBuilder buffer = new StringBuilder();
        buffer.append("# ").append((String)var1_1);
        MessageLiteToString.reflectivePrintWithIndent(generatedMessageLite, buffer, 0);
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void reflectivePrintWithIndent(MessageLite messageLite, StringBuilder buffer, int indent) {
        Iterator<Map.Entry<GeneratedMessageLite.ExtensionDescriptor, Object>> iter;
        HashSet<String> setters = new HashSet<String>();
        HashMap<String, Method> hazzers = new HashMap<String, Method>();
        TreeMap<String, Method> getters = new TreeMap<String, Method>();
        for (Method method : messageLite.getClass().getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getName().length() < 3) continue;
            if (method.getName().startsWith("set")) {
                setters.add(method.getName());
                continue;
            }
            if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
            if (method.getName().startsWith("has")) {
                hazzers.put(method.getName(), method);
                continue;
            }
            if (!method.getName().startsWith("get")) continue;
            getters.put(method.getName(), method);
        }
        for (Map.Entry entry : getters.entrySet()) {
            boolean bl;
            Method mapMethod;
            Method listMethod;
            String suffix = ((String)entry.getKey()).substring(3);
            if (suffix.endsWith("List") && !suffix.endsWith("OrBuilderList") && !suffix.equals("List") && (listMethod = (Method)entry.getValue()) != null && listMethod.getReturnType().equals(List.class)) {
                MessageLiteToString.printField(buffer, indent, suffix.substring(0, suffix.length() - 4), GeneratedMessageLite.invokeOrDie$37ab4766(listMethod, messageLite, new Object[0]));
                continue;
            }
            if (suffix.endsWith("Map") && !suffix.equals("Map") && (mapMethod = (Method)entry.getValue()) != null && mapMethod.getReturnType().equals(Map.class) && !mapMethod.isAnnotationPresent(Deprecated.class) && Modifier.isPublic(mapMethod.getModifiers())) {
                MessageLiteToString.printField(buffer, indent, suffix.substring(0, suffix.length() - 3), GeneratedMessageLite.invokeOrDie$37ab4766(mapMethod, messageLite, new Object[0]));
                continue;
            }
            if (!setters.contains("set" + suffix) || suffix.endsWith("Bytes") && getters.containsKey("get" + suffix.substring(0, suffix.length() - 5))) continue;
            Method getMethod = (Method)entry.getValue();
            Method method = (Method)hazzers.get("has" + suffix);
            if (getMethod == null) continue;
            Object value = GeneratedMessageLite.invokeOrDie$37ab4766(getMethod, messageLite, new Object[0]);
            boolean bl2 = method == null ? !MessageLiteToString.isDefaultValue(value) : (bl = ((Boolean)GeneratedMessageLite.invokeOrDie$37ab4766(method, messageLite, new Object[0])).booleanValue());
            if (!bl2) continue;
            MessageLiteToString.printField(buffer, indent, suffix, value);
        }
        if (messageLite instanceof GeneratedMessageLite.ExtendableMessage && (iter = ((GeneratedMessageLite.ExtendableMessage)messageLite).extensions.iterator()).hasNext()) {
            Map.Entry<GeneratedMessageLite.ExtensionDescriptor, Object> entry = iter.next();
            StringBuilder stringBuilder = buffer;
            int n = indent;
            StringBuilder stringBuilder2 = new StringBuilder("[");
            GeneratedMessageLite.ExtensionDescriptor extensionDescriptor = entry.getKey();
            throw null;
        }
        if (((GeneratedMessageLite)messageLite).unknownFields != null) {
            void var2_2;
            void var1_1;
            MessageLite messageLite2;
            ((GeneratedMessageLite)messageLite2).unknownFields.printWithIndent((StringBuilder)var1_1, (int)var2_2);
        }
    }

    private static boolean isDefaultValue(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o == false;
        }
        if (o instanceof Integer) {
            return (Integer)o == 0;
        }
        if (o instanceof Float) {
            return Float.floatToRawIntBits(((Float)o).floatValue()) == 0;
        }
        if (o instanceof Double) {
            return Double.doubleToRawLongBits((Double)o) == 0L;
        }
        if (o instanceof String) {
            return o.equals("");
        }
        if (o instanceof ByteString) {
            return o.equals(ByteString.EMPTY$6bb3303a);
        }
        if (o instanceof MessageLite) {
            Object object = o;
            return object == ((MessageLite)object).getDefaultInstanceForType();
        }
        if (o instanceof Enum) {
            Object object;
            return ((Enum)object).ordinal() == 0;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static void printField(StringBuilder buffer, int indent, String name, Object object) {
        StringBuilder stringBuilder;
        void var3_3;
        void var2_2;
        if (object instanceof List) {
            object = (List)((Object)object);
            object = object.iterator();
            while (object.hasNext()) {
                Map.Entry entry = object.next();
                MessageLiteToString.printField((StringBuilder)buffer, indent, name, entry);
            }
            return;
        }
        if (object instanceof Map) {
            object = (Map)((Object)object);
            for (Map.Entry entry : object.entrySet()) {
                MessageLiteToString.printField((StringBuilder)buffer, indent, name, entry);
            }
            return;
        }
        ((StringBuilder)buffer).append('\n');
        MessageLiteToString.indent(indent, (StringBuilder)buffer);
        ((StringBuilder)buffer).append(MessageLiteToString.pascalCaseToSnakeCase((String)var2_2));
        if (object instanceof String) {
            StringBuilder stringBuilder2 = ((StringBuilder)buffer).append(": \"");
            buffer = (String)((Object)object);
            stringBuilder2.append(TextFormatEscaper.escapeBytes(ByteString.copyFromUtf8$6a838971((String)buffer))).append('\"');
            return;
        }
        if (object instanceof ByteString) {
            ((StringBuilder)buffer).append(": \"").append(TextFormatEscaper.escapeBytes((ByteString)((Object)object))).append('\"');
            return;
        }
        if (object instanceof GeneratedMessageLite) {
            ((StringBuilder)buffer).append(" {");
            MessageLiteToString.reflectivePrintWithIndent((GeneratedMessageLite)((Object)object), (StringBuilder)buffer, indent + 2);
            ((StringBuilder)buffer).append("\n");
            MessageLiteToString.indent(indent, (StringBuilder)buffer);
            ((StringBuilder)buffer).append("}");
            return;
        }
        if (object instanceof Map.Entry) {
            void var1_1;
            ((StringBuilder)buffer).append(" {");
            Map.Entry entry = (Map.Entry)((Object)object);
            MessageLiteToString.printField((StringBuilder)buffer, indent + 2, "key", entry.getKey());
            MessageLiteToString.printField((StringBuilder)buffer, indent + 2, "value", var3_3.getValue());
            ((StringBuilder)buffer).append("\n");
            MessageLiteToString.indent((int)var1_1, (StringBuilder)buffer);
            ((StringBuilder)buffer).append("}");
            return;
        }
        stringBuilder.append(": ").append(var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void indent(int indent, StringBuilder buffer) {
        while (indent > 0) {
            void var2_2;
            int partialIndent = indent;
            if (partialIndent > INDENT_BUFFER.length) {
                partialIndent = INDENT_BUFFER.length;
            }
            buffer.append(INDENT_BUFFER, 0, partialIndent);
            indent -= var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String pascalCaseToSnakeCase(String pascalCase) {
        void var1_1;
        if (pascalCase.isEmpty()) {
            return pascalCase;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(Character.toLowerCase(pascalCase.charAt(0)));
        for (int i = 1; i < pascalCase.length(); ++i) {
            void var3_3;
            char ch = pascalCase.charAt(i);
            if (Character.isUpperCase(ch)) {
                builder.append("_");
            }
            builder.append(Character.toLowerCase((char)var3_3));
        }
        return var1_1.toString();
    }

    static {
        Arrays.fill(INDENT_BUFFER, ' ');
    }
}

